/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Controller;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractResource;
import gate.creole.ControllerAwarePR;
import gate.creole.ExecutionException;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.event.ControllerEvent;
import gate.event.ControllerListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.util.Benchmark;
import gate.util.Benchmarkable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

@CreoleResource(icon="application")
public abstract class AbstractController
extends AbstractResource
implements Controller,
ProcessingResource,
Benchmarkable {
    private static final long serialVersionUID = 6466829205468662382L;
    protected String benchmarkID;
    protected Map<Object, Object> benchmarkFeatures = new HashMap<Object, Object>();
    private transient Vector<StatusListener> statusListeners;
    private transient Vector<ProgressListener> progressListeners;
    private transient Vector<ControllerListener> controllerListeners;
    protected boolean interrupted = false;
    protected boolean controllerCallbacksEnabled = true;

    @Override
    public void execute() throws ExecutionException {
        if (this.controllerCallbacksEnabled) {
            this.invokeControllerExecutionStarted();
        }
        Throwable thrown = null;
        try {
            if (Benchmark.isBenchmarkingEnabled()) {
                Benchmark.startPoint(this.getBenchmarkId());
            }
            this.executeImpl();
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            if (thrown == null) {
                if (this.controllerCallbacksEnabled) {
                    this.invokeControllerExecutionFinished();
                }
            } else {
                if (this.controllerCallbacksEnabled) {
                    this.invokeControllerExecutionAborted(thrown);
                }
                if (thrown instanceof Error) {
                    throw (Error)thrown;
                }
                if (thrown instanceof RuntimeException) {
                    throw (RuntimeException)thrown;
                }
                if (thrown instanceof ExecutionException) {
                    throw (ExecutionException)thrown;
                }
                throw new UndeclaredThrowableException(thrown);
            }
        }
    }

    protected Set<ControllerAwarePR> getControllerAwarePRs() {
        HashSet<ControllerAwarePR> returnSet = null;
        for (ProcessingResource pr : this.getPRs()) {
            if (!(pr instanceof ControllerAwarePR)) continue;
            if (returnSet == null) {
                returnSet = new HashSet<ControllerAwarePR>();
            }
            returnSet.add((ControllerAwarePR)pr);
        }
        if (returnSet == null) {
            return Collections.emptySet();
        }
        return returnSet;
    }

    protected void executeImpl() throws ExecutionException {
        throw new ExecutionException("Controller " + this.getClass() + " hasn't overriden the executeImpl() method");
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    @Override
    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void setPRs(Collection<? extends ProcessingResource> PRs) {
    }

    @Override
    public synchronized void interrupt() {
        this.interrupted = true;
        Iterator<ProcessingResource> prIter = this.getPRs().iterator();
        while (prIter.hasNext()) {
            prIter.next().interrupt();
        }
    }

    @Override
    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    protected void fireStatusChanged(String e) {
        if (this.statusListeners != null) {
            Vector<StatusListener> listeners = this.statusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).statusChanged(e);
            }
        }
    }

    public synchronized void addProgressListener(ProgressListener l) {
        Vector v;
        Vector vector = v = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.progressListeners = v;
        }
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        if (this.progressListeners != null && this.progressListeners.contains(l)) {
            Vector v = (Vector)this.progressListeners.clone();
            v.removeElement(l);
            this.progressListeners = v;
        }
    }

    protected void fireProgressChanged(int e) {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).progressChanged(e);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).processFinished();
            }
        }
    }

    public List<ProcessingResource> getOffendingPocessingResources() throws ResourceInstantiationException {
        ArrayList<ProcessingResource> badPRs = new ArrayList<ProcessingResource>(this.getPRs());
        for (ProcessingResource pr : this.getPRs()) {
            ResourceData rData;
            if (!AbstractResource.checkParameterValues(pr, (rData = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName())).getParameterList().getRuntimeParameters())) continue;
            badPRs.remove(pr);
        }
        return badPRs.isEmpty() ? null : badPRs;
    }

    public synchronized void removeControllerListener(ControllerListener l) {
        if (this.controllerListeners != null && this.controllerListeners.contains(l)) {
            Vector v = (Vector)this.controllerListeners.clone();
            v.removeElement(l);
            this.controllerListeners = v;
        }
    }

    public synchronized void addControllerListener(ControllerListener l) {
        Vector v;
        Vector vector = v = this.controllerListeners == null ? new Vector(2) : (Vector)this.controllerListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.controllerListeners = v;
        }
    }

    protected void fireResourceAdded(ControllerEvent e) {
        if (this.controllerListeners != null) {
            Vector<ControllerListener> listeners = this.controllerListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceAdded(e);
            }
        }
    }

    protected void fireResourceRemoved(ControllerEvent e) {
        if (this.controllerListeners != null) {
            Vector<ControllerListener> listeners = this.controllerListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).resourceRemoved(e);
            }
        }
    }

    @Override
    public void setBenchmarkId(String benchmarkID) {
        this.benchmarkID = benchmarkID;
    }

    @Override
    public String getBenchmarkId() {
        if (this.benchmarkID == null) {
            this.benchmarkID = this.getName().replaceAll("[ ]+", "_");
        }
        return this.benchmarkID;
    }

    public void invokeControllerExecutionStarted() throws ExecutionException {
        for (ControllerAwarePR pr : this.getControllerAwarePRs()) {
            pr.controllerExecutionStarted(this);
        }
    }

    public void invokeControllerExecutionFinished() throws ExecutionException {
        for (ControllerAwarePR pr : this.getControllerAwarePRs()) {
            pr.controllerExecutionFinished(this);
        }
    }

    public void invokeControllerExecutionAborted(Throwable thrown) throws ExecutionException {
        for (ControllerAwarePR pr : this.getControllerAwarePRs()) {
            pr.controllerExecutionAborted(this, thrown);
        }
    }

    public void setControllerCallbacksEnabled(boolean flag) {
        this.controllerCallbacksEnabled = flag;
    }

    protected class InternalStatusListener
    implements StatusListener {
        protected InternalStatusListener() {
        }

        @Override
        public void statusChanged(String message) {
            AbstractController.this.fireStatusChanged(message);
        }
    }

    protected class IntervalProgressListener
    implements ProgressListener {
        int start;
        int end;

        public IntervalProgressListener(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void progressChanged(int i) {
            AbstractController.this.fireProgressChanged(this.start + (this.end - this.start) * i / 100);
        }

        @Override
        public void processFinished() {
            AbstractController.this.fireProgressChanged(this.end);
        }
    }
}

