/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.AnnotationSet;
import gate.DataStore;
import gate.Document;
import gate.DocumentFormat;
import gate.Factory;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.util.DocumentFormatException;
import gate.util.InvalidOffsetException;
import java.io.IOException;

@CreoleResource(name="GATE Textual Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class TextualDocumentFormat
extends DocumentFormat {
    private static final long serialVersionUID = -5630380244338599927L;

    @Override
    public Resource init() throws ResourceInstantiationException {
        MimeType mime = new MimeType("text", "plain");
        mimeString2ClassHandlerMap.put(mime.getType() + "/" + mime.getSubtype(), this);
        mimeString2mimeTypeMap.put(mime.getType() + "/" + mime.getSubtype(), mime);
        suffixes2mimeTypeMap.put("txt", mime);
        suffixes2mimeTypeMap.put("text", mime);
        this.setMimeType(mime);
        return this;
    }

    @Override
    public void unpackMarkup(Document doc) throws DocumentFormatException {
        if (doc == null || doc.getContent() == null) {
            return;
        }
        this.setNewLineProperty(doc);
        int endOffset = doc.getContent().toString().length();
        int startOffset = 0;
        this.annotateParagraphs(doc, startOffset, endOffset, "Original markups");
    }

    @Override
    public void unpackMarkup(Document doc, RepositioningInfo repInfo, RepositioningInfo ampCodingInfo) throws DocumentFormatException {
        this.unpackMarkup(doc);
    }

    protected static boolean hasContentButNoValidUrl(Document doc) throws DocumentFormatException {
        try {
            if (doc.getSourceUrl() == null && doc.getContent() != null) {
                return true;
            }
            doc.getSourceUrl().openConnection();
        }
        catch (IOException ex1) {
            if (doc.getContent() == null) {
                throw new DocumentFormatException("The document doesn't have a valid URL and also no content");
            }
            return true;
        }
        return false;
    }

    protected void setNewLineProperty(Document doc) {
        String content = doc.getContent().toString();
        String newLineType = "";
        int ch = 32;
        int lastch = 32;
        for (int i = 0; i < content.length(); ++i) {
            ch = content.charAt(i);
            if (lastch == 13) {
                if (ch == 10) {
                    newLineType = "CRLF";
                    break;
                }
                newLineType = "CR";
                break;
            }
            if (lastch == 10) {
                if (ch == 13) {
                    newLineType = "LFCR";
                    break;
                }
                newLineType = "LF";
                break;
            }
            lastch = ch;
        }
        doc.getFeatures().put("docNewLineType", newLineType);
    }

    private void removeExtraNewLine(Document doc) {
        String content = doc.getContent().toString();
        StringBuffer buff = new StringBuffer(content);
        int ch = 32;
        int lastch = 32;
        for (int i = content.length() - 1; i > -1; --i) {
            ch = content.charAt(i);
            if (ch == 10 && lastch == 13) {
                buff.deleteCharAt(i + 1);
            }
            if (ch == 13 && lastch == 10) {
                buff.deleteCharAt(i);
                ch = lastch;
            }
            lastch = ch;
        }
        doc.setContent(new DocumentContentImpl(buff.toString()));
    }

    public void annotateParagraphs(Document aDoc, int startOffset, int endOffset, String annotSetName) throws DocumentFormatException {
        int index;
        if (aDoc == null || aDoc.getContent() == null) {
            return;
        }
        if (startOffset > endOffset) {
            return;
        }
        AnnotationSet annotSet = null;
        annotSet = annotSetName == null ? aDoc.getAnnotations() : aDoc.getAnnotations(annotSetName);
        String content = aDoc.getContent().toString();
        int startOffsetPara = startOffset;
        int endOffsetPara = endOffset;
        int state = 1;
        boolean readBR = false;
        block9: for (index = startOffset; index < endOffset; ++index) {
            char ch = content.charAt(index);
            if (ch == '\n') {
                readBR = true;
                while (index + 1 < endOffset && content.charAt(index + 1) == '\r') {
                    ++index;
                }
            }
            switch (state) {
                case 1: {
                    if (Character.isWhitespace(ch)) continue block9;
                    state = 2;
                    startOffsetPara = index;
                    continue block9;
                }
                case 2: {
                    if (!readBR) continue block9;
                    readBR = false;
                    endOffsetPara = index;
                    state = 3;
                    continue block9;
                }
                case 3: {
                    if (readBR) {
                        readBR = false;
                        state = 1;
                        try {
                            annotSet.add(Long.valueOf(startOffsetPara), Long.valueOf(endOffsetPara), "paragraph", Factory.newFeatureMap());
                            continue block9;
                        }
                        catch (InvalidOffsetException ioe) {
                            throw new DocumentFormatException("Coudn't create a paragraph annotation", ioe);
                        }
                    }
                    state = 2;
                }
            }
        }
        endOffsetPara = index;
        if (state == 2 || state == 3) {
            try {
                annotSet.add(Long.valueOf(startOffsetPara), Long.valueOf(endOffsetPara), "paragraph", Factory.newFeatureMap());
            }
            catch (InvalidOffsetException ioe) {
                throw new DocumentFormatException("Coudn't create a paragraph annotation", ioe);
            }
        }
    }

    @Override
    public DataStore getDataStore() {
        return null;
    }
}

