/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.FeatureMap;
import gate.Node;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.event.FeatureMapListener;
import gate.util.AbstractFeatureBearer;
import java.io.Serializable;
import java.util.Set;
import java.util.Vector;

public class AnnotationImpl
extends AbstractFeatureBearer
implements Annotation {
    static final long serialVersionUID = -5658993256574857725L;
    private transient Vector<AnnotationListener> annotationListeners;
    protected EventsHandler eventHandler;
    Integer id;
    String type;
    protected Node start;
    protected Node end;

    protected AnnotationImpl(Integer id, Node start, Node end, String type, FeatureMap features) {
        this.id = id;
        this.start = start;
        this.end = end;
        this.type = type;
        this.features = features;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Node getStartNode() {
        return this.start;
    }

    @Override
    public Node getEndNode() {
        return this.end;
    }

    public String toString() {
        return "AnnotationImpl: id=" + this.id + "; type=" + this.type + "; features=" + this.features + "; start=" + this.start + "; end=" + this.end + System.getProperty("line.separator");
    }

    @Override
    public int compareTo(Object o) throws ClassCastException {
        Annotation other = (Annotation)o;
        return this.id.compareTo(other.getId());
    }

    public int hashCode() {
        int hashCodeRes = 17;
        hashCodeRes = 31 * hashCodeRes + (this.type == null ? 0 : this.type.hashCode());
        hashCodeRes = 31 * hashCodeRes + (this.id == null ? 0 : this.id.hashCode());
        return hashCodeRes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationImpl)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (this.type == null ^ other.getType() == null) {
            return false;
        }
        if (this.type != null && !this.type.equals(other.getType())) {
            return false;
        }
        if (this.id == null ^ other.getId() == null) {
            return false;
        }
        if (this.id != null && !this.id.equals(other.getId())) {
            return false;
        }
        if (this.start == null ^ other.getStartNode() == null) {
            return false;
        }
        if (this.start != null) {
            if (this.start.getOffset() == null ^ other.getStartNode().getOffset() == null) {
                return false;
            }
            if (this.start.getOffset() != null && !this.start.getOffset().equals(other.getStartNode().getOffset())) {
                return false;
            }
        }
        if (this.end == null ^ other.getEndNode() == null) {
            return false;
        }
        if (this.end != null) {
            if (this.end.getOffset() == null ^ other.getEndNode().getOffset() == null) {
                return false;
            }
            if (this.end.getOffset() != null && !this.end.getOffset().equals(other.getEndNode().getOffset())) {
                return false;
            }
        }
        if (this.features == null ^ other.getFeatures() == null) {
            return false;
        }
        return this.features == null || this.features.equals(other.getFeatures());
    }

    @Override
    public void setFeatures(FeatureMap features) {
        if (this.eventHandler != null) {
            this.features.removeFeatureMapListener(this.eventHandler);
        }
        this.features = features;
        if (this.annotationListeners != null && !this.annotationListeners.isEmpty()) {
            this.features.addFeatureMapListener(this.eventHandler);
        }
        this.fireAnnotationUpdated(new AnnotationEvent(this, 701));
    }

    @Override
    public boolean isCompatible(Annotation anAnnot) {
        if (anAnnot == null) {
            return false;
        }
        if (this.coextensive(anAnnot)) {
            if (anAnnot.getFeatures() == null) {
                return true;
            }
            if (anAnnot.getFeatures().subsumes(this.getFeatures())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatible(Annotation anAnnot, Set<? extends Object> aFeatureNamesSet) {
        if (aFeatureNamesSet == null) {
            return this.isCompatible(anAnnot);
        }
        if (anAnnot == null) {
            return false;
        }
        if (this.coextensive(anAnnot)) {
            if (anAnnot.getFeatures() == null) {
                return true;
            }
            if (anAnnot.getFeatures().subsumes(this.getFeatures(), aFeatureNamesSet)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPartiallyCompatible(Annotation anAnnot) {
        if (anAnnot == null) {
            return false;
        }
        if (this.overlaps(anAnnot)) {
            if (anAnnot.getFeatures() == null) {
                return true;
            }
            if (anAnnot.getFeatures().subsumes(this.getFeatures())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPartiallyCompatible(Annotation anAnnot, Set<? extends Object> aFeatureNamesSet) {
        if (aFeatureNamesSet == null) {
            return this.isPartiallyCompatible(anAnnot);
        }
        if (anAnnot == null) {
            return false;
        }
        if (this.overlaps(anAnnot)) {
            if (anAnnot.getFeatures() == null) {
                return true;
            }
            if (anAnnot.getFeatures().subsumes(this.getFeatures(), aFeatureNamesSet)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean coextensive(Annotation anAnnot) {
        if (anAnnot.getStartNode() == null ^ this.getStartNode() == null) {
            return false;
        }
        if (anAnnot.getStartNode() != null) {
            if (anAnnot.getStartNode().getOffset() == null ^ this.getStartNode().getOffset() == null) {
                return false;
            }
            if (anAnnot.getStartNode().getOffset() != null && !anAnnot.getStartNode().getOffset().equals(this.getStartNode().getOffset())) {
                return false;
            }
        }
        if (anAnnot.getEndNode() == null ^ this.getEndNode() == null) {
            return false;
        }
        if (anAnnot.getEndNode() != null) {
            if (anAnnot.getEndNode().getOffset() == null ^ this.getEndNode().getOffset() == null) {
                return false;
            }
            if (anAnnot.getEndNode().getOffset() != null && !anAnnot.getEndNode().getOffset().equals(this.getEndNode().getOffset())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean overlaps(Annotation aAnnot) {
        if (aAnnot == null) {
            return false;
        }
        if (aAnnot.getStartNode() == null || aAnnot.getEndNode() == null || aAnnot.getStartNode().getOffset() == null || aAnnot.getEndNode().getOffset() == null) {
            return false;
        }
        if (aAnnot.getEndNode().getOffset() <= this.getStartNode().getOffset()) {
            return false;
        }
        return aAnnot.getStartNode().getOffset() < this.getEndNode().getOffset();
    }

    @Override
    public boolean withinSpanOf(Annotation aAnnot) {
        if (aAnnot == null) {
            return false;
        }
        if (aAnnot.getStartNode() == null || aAnnot.getEndNode() == null || aAnnot.getStartNode().getOffset() == null || aAnnot.getEndNode().getOffset() == null) {
            return false;
        }
        return aAnnot.getEndNode().getOffset() >= this.getEndNode().getOffset() && aAnnot.getStartNode().getOffset() <= this.getStartNode().getOffset();
    }

    @Override
    public synchronized void removeAnnotationListener(AnnotationListener l) {
        if (this.annotationListeners != null && this.annotationListeners.contains(l)) {
            Vector v = (Vector)this.annotationListeners.clone();
            v.removeElement(l);
            this.annotationListeners = v;
        }
    }

    @Override
    public synchronized void addAnnotationListener(AnnotationListener l) {
        Vector v;
        Vector vector = v = this.annotationListeners == null ? new Vector(2) : (Vector)this.annotationListeners.clone();
        if (v.isEmpty()) {
            FeatureMap features = this.getFeatures();
            if (this.eventHandler == null) {
                this.eventHandler = new EventsHandler();
            }
            features.addFeatureMapListener(this.eventHandler);
        }
        if (!v.contains(l)) {
            v.addElement(l);
            this.annotationListeners = v;
        }
    }

    protected void fireAnnotationUpdated(AnnotationEvent e) {
        if (this.annotationListeners != null) {
            Vector<AnnotationListener> listeners = this.annotationListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).annotationUpdated(e);
            }
        }
    }

    class EventsHandler
    implements FeatureMapListener,
    Serializable {
        static final long serialVersionUID = 2608156420244752907L;

        EventsHandler() {
        }

        @Override
        public void featureMapUpdated() {
            AnnotationImpl.this.fireAnnotationUpdated(new AnnotationEvent(AnnotationImpl.this, 701));
        }
    }
}

