/*
 * Decompiled with CFR 0.152.
 */
package gate.util.reporting;

import gate.util.reporting.BenchmarkReportable;
import gate.util.reporting.FileWatcher;
import gate.util.reporting.ValueComparator;
import gate.util.reporting.exceptions.BenchmarkReportExecutionException;
import gate.util.reporting.exceptions.BenchmarkReportFileAccessException;
import gate.util.reporting.exceptions.BenchmarkReportInputFileFormatException;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class DocTimeReporter
implements BenchmarkReportable {
    private File benchmarkFile = new File("benchmark.txt");
    private String printMedia = "html";
    private int maxDocumentInReport = 10;
    private String PRMatchingRegex = "all_prs";
    private String logicalStart = null;
    private File reportFile;
    private HashSet<String> allDocs = new HashSet();
    private HashSet<String> matchingPRs = new HashSet();
    private float globalTotal = 0.0f;
    private LinkedHashMap<String, String> docContainer = new LinkedHashMap();
    private File temporaryDirectory;
    private String pipelineName = "";
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_ERROR = 1;
    private static final int FILE_CHUNK_SIZE = 2000;
    private static final String NL = System.getProperty("line.separator");
    public int validEntries = 0;
    public static final String MEDIA_TEXT = "text";
    public static final String MEDIA_HTML = "html";
    public static final int ALL_DOCS = -1;
    public static final String MATCH_ALL_PR_REGEX = "all_prs";

    public DocTimeReporter() {
        this.initTmpDir();
    }

    DocTimeReporter(String[] args) {
        this.initTmpDir();
        this.parseArguments(args);
    }

    private void initTmpDir() {
        try {
            this.temporaryDirectory = File.createTempFile("benchmark-reports", "", null);
            if (!this.temporaryDirectory.delete() || !this.temporaryDirectory.mkdir()) {
                throw new IOException("Unable to create temporary directory.\n" + this.temporaryDirectory.getCanonicalPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object calculate(Object reportContainer) {
        return this.sortHashMapByValues(this.doTotal((LinkedHashMap)reportContainer));
    }

    private LinkedHashMap<?, ?> sortHashMapByValues(LinkedHashMap<String, String> passedMap) {
        ArrayList<String> mapKeys = new ArrayList<String>(passedMap.keySet());
        ArrayList<String> mapValues = new ArrayList<String>(passedMap.values());
        Collections.sort(mapValues, new ValueComparator());
        Collections.sort(mapKeys);
        Collections.reverse(mapValues);
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        block0: for (String val : mapValues) {
            for (String key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put(key, val);
                continue block0;
            }
        }
        return sortedMap;
    }

    private LinkedHashMap<String, String> doTotal(LinkedHashMap<String, Object> reportContainer) {
        LinkedHashMap<String, Object> myHash = reportContainer;
        for (String key : myHash.keySet()) {
            if (myHash.get(key) instanceof LinkedHashMap) {
                this.docContainer = this.doTotal((LinkedHashMap)myHash.get(key));
                continue;
            }
            if (this.docContainer.get(key) == null) {
                this.docContainer.put(key, (String)myHash.get(key));
                continue;
            }
            int val = Integer.parseInt(this.docContainer.get(key)) + Integer.parseInt((String)myHash.get(key));
            this.docContainer.put(key, Integer.toString(val));
        }
        return this.docContainer;
    }

    @Override
    public void printReport(Object reportSource, File outputFile) {
        if (this.printMedia.equalsIgnoreCase(MEDIA_TEXT)) {
            this.printToText(reportSource, outputFile);
        } else if (this.printMedia.equalsIgnoreCase(MEDIA_HTML)) {
            this.printToHTML((LinkedHashMap)reportSource, outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printToText(Object reportContainer, File outputFile) {
        ArrayList<String> printLines = new ArrayList<String>();
        LinkedHashMap rcHash = (LinkedHashMap)reportContainer;
        String docs = "";
        docs = this.maxDocumentInReport != -1 ? (this.allDocs.size() < this.maxDocumentInReport ? Integer.toString(this.allDocs.size()) : Integer.toString(this.maxDocumentInReport)) : "All";
        printLines.add("=============================================================" + NL);
        if (this.PRMatchingRegex.equals(MATCH_ALL_PR_REGEX)) {
            printLines.add("Top " + docs + " expensive documents matching All PRs in " + this.pipelineName + NL);
        } else if (this.matchingPRs.size() > 0) {
            printLines.add("Top " + docs + " expensive documents matching following PRs in " + this.pipelineName + NL);
            for (String pr : this.matchingPRs) {
                printLines.add("\t" + pr + NL);
            }
        } else {
            printLines.add("No PRs matched to search string \"" + this.getPRMatchingRegex() + "\" in " + this.pipelineName);
            printLines.add(NL);
            printLines.add("=============================================================" + NL);
        }
        if (this.allDocs.size() > 0) {
            printLines.add("=============================================================" + NL);
            printLines.add("Document Name\tTime (in seconds)\t%" + NL);
            printLines.add("-------------------------------------------------------------" + NL);
        }
        Iterator i = rcHash.keySet().iterator();
        int count = 0;
        while (i.hasNext()) {
            Object key = i.next();
            if (!((String)key).equals("total")) {
                int value = Integer.parseInt((String)rcHash.get(key));
                if (this.maxDocumentInReport == -1) {
                    printLines.add(key + "\t" + (double)value / 1000.0 + "\t" + (double)Math.round((float)value / this.globalTotal * 100.0f * 10.0f) / 10.0 + NL);
                } else if (count < this.maxDocumentInReport) {
                    printLines.add(key + "\t" + (double)value / 1000.0 + "\t" + (double)Math.round((float)value / this.globalTotal * 100.0f * 10.0f) / 10.0 + NL);
                }
            }
            ++count;
        }
        if (this.allDocs.size() > 0) {
            printLines.add("-------------------------------------------------------------" + NL);
            printLines.add("Pipeline Total\t" + (double)this.globalTotal / 1000.0 + "\t" + 100 + NL + NL + NL);
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputFile, true));
            for (String line : printLines) {
                out.write(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object store(File inputFile) throws BenchmarkReportInputFileFormatException {
        String[] temp = inputFile.getAbsolutePath().split("\\" + File.separator);
        this.pipelineName = temp[temp.length - 1].replace("_benchmark.txt", "");
        LinkedHashMap<String, Object> globalStore = new LinkedHashMap<String, Object>();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(inputFile));
            String docName = null;
            String matchedPR = null;
            String startToken = null;
            Pattern pattern = Pattern.compile("(\\d+) (\\d+) (.*) (.*) \\{(.*)\\}");
            Pattern patternDocName = Pattern.compile(".*documentName=(.*?)[,|}].*");
            while ((str = in.readLine()) != null) {
                if (str.matches(".*START.*")) {
                    String[] splittedStartEntry = str.split("\\s");
                    if (splittedStartEntry.length > 2) {
                        startToken = splittedStartEntry[2];
                    } else {
                        throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile() + " is invalid.");
                    }
                }
                Matcher matcher = pattern.matcher(str);
                Matcher matcherDocName = patternDocName.matcher(str);
                Pattern patternDocEnd = Pattern.compile("(\\d+) (\\d+) " + Pattern.quote(startToken) + " (.*) \\{(.*)\\}.*");
                Matcher matcherDocEnd = patternDocEnd.matcher(str);
                if (matcherDocName != null && matcherDocName.matches()) {
                    docName = matcherDocName.group(1);
                }
                if (matcherDocEnd != null && matcherDocEnd.matches()) {
                    this.globalTotal += (float)Integer.parseInt(matcherDocEnd.group(2));
                }
                if (matcher == null || !matcher.matches()) continue;
                String benchmarkIDs = matcher.group(3).replaceFirst(Pattern.quote(startToken) + ".", "").replaceFirst("doc_" + Pattern.quote(docName) + ".", "");
                String[] splittedBenchmarkIDs = benchmarkIDs.split("\\.");
                if (this.PRMatchingRegex.equals(MATCH_ALL_PR_REGEX)) {
                    if (splittedBenchmarkIDs.length > 0) {
                        matchedPR = splittedBenchmarkIDs[0];
                    }
                    if (matchedPR.equalsIgnoreCase(startToken)) continue;
                    this.organizeEntries(globalStore, matchedPR, matcher.group(2), docName);
                    continue;
                }
                if (!this.isPRMatched(benchmarkIDs, this.PRMatchingRegex)) continue;
                if (splittedBenchmarkIDs.length > 0) {
                    matchedPR = splittedBenchmarkIDs[0];
                }
                if (matchedPR != null) {
                    this.matchingPRs.add(matchedPR);
                }
                this.organizeEntries(globalStore, matchedPR, matcher.group(2), docName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            globalStore = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                globalStore = null;
            }
        }
        return globalStore;
    }

    private void organizeEntries(LinkedHashMap<String, Object> store, String matchedPR, String bTime, String docName) {
        this.allDocs.add(docName);
        if (store.containsKey(matchedPR)) {
            ((LinkedHashMap)store.get(matchedPR)).put(docName, bTime);
        } else {
            LinkedHashMap<String, String> tempLHM = new LinkedHashMap<String, String>();
            tempLHM.put(docName, bTime);
            store.put(matchedPR, tempLHM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printToHTML(LinkedHashMap<String, Object> reportSource, File outputFile) {
        String hTrace;
        String htmlReport = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"" + NL + "\"http://www.w3.org/TR/html4/loose.dtd\">" + NL + "<html><head><title>Benchmarking Report</title>" + NL + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + NL + "<style type=\"text/css\">" + NL + "div { font-size:12px; margin-top: 4; }" + NL + "</style>" + NL + "</head>" + NL + "<body style=\"font-family:Verdana; color:navy;\">" + NL;
        String reportTitle = hTrace = "<div style=\"right: 0pt; border-top:1px solid #C9D7F1; font-size:1px;\" ></div>" + NL;
        String docs = "";
        docs = this.maxDocumentInReport != -1 ? (this.allDocs.size() < this.maxDocumentInReport ? Integer.toString(this.allDocs.size()) : Integer.toString(this.maxDocumentInReport)) : "All";
        if (this.PRMatchingRegex.equals(MATCH_ALL_PR_REGEX)) {
            reportTitle = reportTitle + "<div style=\"font-size:15px;font-family:Verdana; color:navy;\">Top " + docs + " expensive documents matching All PRs in <b>" + this.pipelineName + "</b></div>" + NL;
        } else if (this.matchingPRs.size() > 0) {
            reportTitle = reportTitle + "<div style=\"font-size:15px;font-family:Verdana; color:navy;\">Top " + docs + " expensive documents matching following PRs in <b>" + this.pipelineName + "</b> <ul>" + NL;
            for (String pr : this.matchingPRs) {
                reportTitle = reportTitle + "<li>" + pr + "</li>";
            }
            reportTitle = reportTitle + "</ul></div>";
        } else {
            reportTitle = reportTitle + "<div style=\"font-size:15px;font-family:Verdana; color:navy;\">No PRs matched to search string \"" + this.getPRMatchingRegex() + " \" in " + this.pipelineName + "</div>";
        }
        reportTitle = reportTitle + hTrace;
        if (this.allDocs.size() > 0) {
            String htmlReportTitle = reportTitle + "<table><tr bgcolor=\"#eeeeff\"><td><b>Document Name</b></td><td><b>Time in seconds</b></td><td><b>% Time taken</b></td></tr><tr>" + NL;
            String documentNameHTMLString = "<td rowspan = '112' width = '550'>";
            String timeTakenHTMLString = "<td width = '100'>";
            String timeInPercentHTMLString = "<td width = '100'>";
            LinkedHashMap<String, Object> rcHash = reportSource;
            rcHash.remove("total");
            Iterator<String> i = rcHash.keySet().iterator();
            int count = 0;
            while (i.hasNext()) {
                String key = i.next();
                if (!key.equals("total")) {
                    int value = Integer.parseInt((String)rcHash.get(key));
                    if (this.maxDocumentInReport == -1) {
                        documentNameHTMLString = documentNameHTMLString + "<div>" + key + "</div>";
                        timeTakenHTMLString = timeTakenHTMLString + "<div>" + (double)value / 1000.0 + "</div>";
                        timeInPercentHTMLString = timeInPercentHTMLString + "<div>" + (double)Math.round((float)value / this.globalTotal * 100.0f * 10.0f) / 10.0 + "</div>" + NL;
                    } else if (count < this.maxDocumentInReport) {
                        documentNameHTMLString = documentNameHTMLString + "<div>" + key + "</div>";
                        timeTakenHTMLString = timeTakenHTMLString + "<div>" + (double)value / 1000.0 + "</div>";
                        timeInPercentHTMLString = timeInPercentHTMLString + "<div>" + (double)Math.round((float)value / this.globalTotal * 100.0f * 10.0f) / 10.0 + "</div>" + NL;
                    }
                }
                ++count;
            }
            documentNameHTMLString = documentNameHTMLString + "<div bgcolor=\"#eeeeff\" style = \"font-size:15px;margin-left:400px;\"><b>Total</b></div></td>" + NL;
            timeTakenHTMLString = timeTakenHTMLString + "<div bgcolor=\"#eeeeff\" style = \"font-size:15px;\"><b>" + (double)this.globalTotal / 1000.0 + "</b></div></td>" + NL;
            timeInPercentHTMLString = timeInPercentHTMLString + "<div bgcolor=\"#eeeeff\" style = \"font-size:15px;\"><b>100</b></div></td>" + NL;
            htmlReport = !outputFile.exists() ? htmlReport + htmlReportTitle + documentNameHTMLString + timeTakenHTMLString + timeInPercentHTMLString + "</tr></table>" : "<br/><br/>" + htmlReportTitle + documentNameHTMLString + timeTakenHTMLString + timeInPercentHTMLString + "</tr></table></body></html>";
        } else {
            htmlReport = htmlReport + reportTitle + "</body></html>";
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputFile));
            out.write(htmlReport);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean validateLogEntry(String benchmarkIDChain, ArrayList<String> startTokens) {
        String startTokenRegExp = "(";
        for (int i = 0; i < startTokens.size(); ++i) {
            if (benchmarkIDChain.split("\\.").length == 1 && benchmarkIDChain.equals(startTokens.get(i))) {
                ++this.validEntries;
                return true;
            }
            startTokenRegExp = startTokenRegExp + startTokens.get(i) + "|";
        }
        if (startTokenRegExp.length() > 1) {
            startTokenRegExp = startTokenRegExp.substring(0, startTokenRegExp.length() - 1);
        }
        if (benchmarkIDChain.matches((startTokenRegExp = startTokenRegExp + ")") + "\\.doc_.*?\\.pr_.*")) {
            ++this.validEntries;
            return true;
        }
        return false;
    }

    @Override
    public void parseArguments(String[] args) {
        int c;
        Getopt g = new Getopt("gate.util.reporting.DocTimeReporter", args, "i:m:d:p:o:l:h");
        String argNoOfDocs = null;
        block11: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 105: {
                    String argInPath = g.getOptarg();
                    if (argInPath == null) continue block11;
                    this.setBenchmarkFile(new File(argInPath));
                    continue block11;
                }
                case 109: {
                    String argPrintMedia = g.getOptarg();
                    if (argPrintMedia == null) continue block11;
                    this.setPrintMedia(argPrintMedia);
                    continue block11;
                }
                case 100: {
                    argNoOfDocs = g.getOptarg();
                    if (argNoOfDocs != null) continue block11;
                    this.setMaxDocumentInReport(this.maxDocumentInReport);
                    continue block11;
                }
                case 112: {
                    String argPrName = g.getOptarg();
                    if (argPrName != null) {
                        this.setPRMatchingRegex(argPrName);
                        continue block11;
                    }
                    this.setPRMatchingRegex(this.PRMatchingRegex);
                    continue block11;
                }
                case 111: {
                    String argOutPath = g.getOptarg();
                    if (argOutPath == null) continue block11;
                    this.setReportFile(new File(argOutPath));
                    continue block11;
                }
                case 108: {
                    String argLogicalStart = g.getOptarg();
                    if (argLogicalStart == null) continue block11;
                    this.setLogicalStart(argLogicalStart);
                    continue block11;
                }
                case 63: 
                case 104: {
                    DocTimeReporter.usage();
                    System.exit(0);
                    continue block11;
                }
            }
            DocTimeReporter.usage();
            System.exit(1);
        }
        if (argNoOfDocs != null) {
            try {
                this.setMaxDocumentInReport(Integer.parseInt(argNoOfDocs));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                DocTimeReporter.usage();
                System.exit(1);
            }
        }
    }

    public String getPrintMedia() {
        return this.printMedia;
    }

    public void setPrintMedia(String printMedia) {
        if (!printMedia.equals(MEDIA_HTML) && !printMedia.equals(MEDIA_TEXT)) {
            throw new IllegalArgumentException("Illegal argument: " + printMedia);
        }
        this.printMedia = printMedia.trim();
    }

    private boolean isPRMatched(String benchmarkIDs, String searchString) {
        String prName = benchmarkIDs.split("\\.")[0];
        searchString = searchString.trim();
        searchString = searchString.replaceAll("^(pr|pr_)", "");
        searchString = searchString.replaceAll("_", " ");
        searchString = searchString.replaceAll("\\s+", " ");
        searchString = searchString.trim();
        String processedPRName = prName.replaceAll("^pr_", "");
        processedPRName = processedPRName.replaceAll("_", " ");
        if (prName.startsWith("pr_")) {
            return processedPRName.matches("(?i).*" + searchString + ".*");
        }
        return false;
    }

    private void deleteFile(File fileToBeDeleted) throws BenchmarkReportFileAccessException {
        if (fileToBeDeleted.isFile() && !fileToBeDeleted.delete()) {
            throw new BenchmarkReportFileAccessException("Could not delete " + fileToBeDeleted.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitBenchmarkFile(File benchmarkFile, File report) throws BenchmarkReportFileAccessException, BenchmarkReportInputFileFormatException {
        File dir = this.temporaryDirectory;
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int count = 0; count < files.length; ++count) {
                if (files[count].delete()) continue;
                throw new BenchmarkReportFileAccessException("Could not delete files in the folder \"" + this.temporaryDirectory + "\"");
            }
        } else if (!dir.mkdir()) {
            throw new BenchmarkReportFileAccessException("Could not create  temporary folder \"" + this.temporaryDirectory + "\"");
        }
        if (this.getPrintMedia().equalsIgnoreCase(MEDIA_TEXT)) {
            this.deleteFile(new File(report.getAbsolutePath() + ".txt"));
        } else if (this.getPrintMedia().equalsIgnoreCase(MEDIA_HTML)) {
            this.deleteFile(new File(report.getAbsolutePath() + ".html"));
        }
        RandomAccessFile in = null;
        BufferedWriter out = null;
        try {
            String logEntry = "";
            long fromPos = 0L;
            if (this.getLogicalStart() != null) {
                fromPos = this.tail(benchmarkFile, 2000);
            }
            in = new RandomAccessFile(benchmarkFile, "r");
            if (this.getLogicalStart() != null) {
                in.seek(fromPos);
            }
            ArrayList<String> startTokens = new ArrayList<String>();
            String lastStart = "";
            Pattern pattern = Pattern.compile("(\\d+) (\\d+) (.*) (.*) \\{(.*)\\}");
            Matcher matcher = null;
            File benchmarkFileName = null;
            while ((logEntry = in.readLine()) != null) {
                matcher = pattern.matcher(logEntry);
                String startToken = "";
                if (logEntry.matches(".*START.*")) {
                    String[] splittedStartEntry = logEntry.split("\\s");
                    if (splittedStartEntry.length <= 2) {
                        throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile() + " is invalid.");
                    }
                    startToken = splittedStartEntry[2];
                    if (startToken.endsWith("Start")) continue;
                    if (!startTokens.contains(startToken)) {
                        startTokens.add(startToken);
                        benchmarkFileName = new File(this.temporaryDirectory, startToken + "_benchmark.txt");
                        if (!benchmarkFileName.createNewFile()) {
                            throw new BenchmarkReportFileAccessException("Could not create \"" + startToken + "_benchmark.txt\" in directory named \"" + this.temporaryDirectory + "\"");
                        }
                        out = new BufferedWriter(new FileWriter(benchmarkFileName));
                        out.write(logEntry);
                        out.newLine();
                    }
                }
                if (matcher == null || !matcher.matches() || !this.validateLogEntry(matcher.group(3), startTokens) && !logEntry.matches(".*documentLoaded.*")) continue;
                startToken = matcher.group(3).split("\\.")[0];
                if (!lastStart.equals(startToken)) {
                    if (out != null) {
                        out.close();
                    }
                    benchmarkFileName = new File(this.temporaryDirectory, startToken + "_benchmark.txt");
                    out = new BufferedWriter(new FileWriter(benchmarkFileName, true));
                }
                if (out != null) {
                    out.write(logEntry);
                    out.newLine();
                }
                lastStart = startToken;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long tail(File fileToBeRead, int chunkSize) throws BenchmarkReportInputFileFormatException {
        long l;
        RandomAccessFile raf = null;
        try {
            long fromPos;
            raf = new RandomAccessFile(fileToBeRead, "r");
            Vector<String> lastNlines = new Vector<String>();
            int delta = 0;
            long curPos = 0L;
            curPos = raf.length() - 1L;
            while (true) {
                byte[] bytearray;
                if ((fromPos = curPos - (long)chunkSize) <= 0L) {
                    raf.seek(0L);
                    bytearray = new byte[(int)curPos];
                    raf.readFully(bytearray);
                    if (!this.parseLinesFromLast(bytearray, lastNlines, fromPos) || fromPos >= 0L) break;
                    fromPos = 0L;
                    break;
                }
                raf.seek(fromPos);
                bytearray = new byte[chunkSize];
                raf.readFully(bytearray);
                if (this.parseLinesFromLast(bytearray, lastNlines, fromPos)) break;
                delta = lastNlines.get(lastNlines.size() - 1).length();
                lastNlines.remove(lastNlines.size() - 1);
                curPos = fromPos + (long)delta;
            }
            if (fromPos < 0L) {
                throw new BenchmarkReportInputFileFormatException(this.getBenchmarkFile() + " does not contain a marker named " + this.getLogicalStart() + " indicating logical start of a run.");
            }
            l = fromPos;
        }
        catch (IOException e) {
            long l2;
            try {
                e.printStackTrace();
                l2 = -1L;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(raf);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)raf);
            return l2;
        }
        IOUtils.closeQuietly((Closeable)raf);
        return l;
    }

    private boolean parseLinesFromLast(byte[] bytearray, Vector<String> lastNlines, long fromPos) {
        String lastNChars = new String(bytearray);
        StringBuffer sb = new StringBuffer(lastNChars);
        lastNChars = sb.reverse().toString();
        StringTokenizer tokens = new StringTokenizer(lastNChars, NL);
        while (tokens.hasMoreTokens()) {
            StringBuffer sbLine = new StringBuffer(tokens.nextToken());
            lastNlines.add(sbLine.reverse().toString());
            if (!lastNlines.get(lastNlines.size() - 1).trim().endsWith(this.getLogicalStart())) continue;
            return true;
        }
        return false;
    }

    public static void usage() {
        System.out.println("Usage: java gate.util.reporting.DocTimeReporter [Options]" + NL + "\t Options:" + NL + "\t -i input file path (default: benchmark.txt in the execution directory)" + NL + "\t -m print media - html/text (default: html)" + NL + "\t -d number of docs, use -1 for all docs (default: 10 docs)" + NL + "\t -p processing resource name to be matched (default: all_prs)" + NL + "\t -o output file path (default: report.html/txt in the system temporary directory)" + NL + "\t -l logical start (not set by default)" + NL + "\t -h show help" + NL);
    }

    public static void main(String[] args) throws BenchmarkReportInputFileFormatException, BenchmarkReportFileAccessException {
        DocTimeReporter reportTwo = new DocTimeReporter(args);
        reportTwo.generateReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReport() throws BenchmarkReportInputFileFormatException, BenchmarkReportFileAccessException {
        Timer timer = null;
        try {
            FileWatcher task = new FileWatcher(this.getBenchmarkFile()){

                @Override
                protected void onChange(File file) {
                    throw new BenchmarkReportExecutionException(DocTimeReporter.this.getBenchmarkFile() + " file has been modified while generating the report.");
                }
            };
            timer = new Timer();
            timer.schedule((TimerTask)task, new Date(), 1000L);
            if (this.reportFile == null) {
                this.reportFile = new File(System.getProperty("java.io.tmpdir"), "report." + (this.printMedia.equals(MEDIA_HTML) ? MEDIA_HTML : "txt"));
            }
            this.splitBenchmarkFile(this.getBenchmarkFile(), this.reportFile);
            if (this.validEntries == 0) {
                if (this.logicalStart != null) {
                    throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile() + " does not contain a marker named " + this.logicalStart + ".");
                }
                throw new BenchmarkReportInputFileFormatException("No valid log entries present in " + this.getBenchmarkFile().getAbsolutePath());
            }
            File dir = this.temporaryDirectory;
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                for (int count = 0; count < files.length; ++count) {
                    File inFile = files[count];
                    Object report2Container1 = this.store(inFile);
                    Object report2Container2 = this.calculate(report2Container1);
                    this.printReport(report2Container2, this.reportFile);
                }
                if (files.length > 0 && files[0].exists() && !files[0].delete()) {
                    System.err.println(files[0] + " was not possible to delete.");
                }
            }
        }
        finally {
            if (timer != null) {
                timer.cancel();
            }
        }
    }

    @Override
    public void executeReport() throws BenchmarkReportInputFileFormatException, BenchmarkReportFileAccessException {
        this.generateReport();
    }

    public String getLogicalStart() {
        return this.logicalStart;
    }

    public void setLogicalStart(String logicalStart) {
        this.logicalStart = logicalStart;
    }

    public File getBenchmarkFile() {
        return this.benchmarkFile;
    }

    public void setBenchmarkFile(File benchmarkFile) {
        this.benchmarkFile = benchmarkFile;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    public int getMaxDocumentInReport() {
        return this.maxDocumentInReport;
    }

    public void setMaxDocumentInReport(int maxDocumentInReport) {
        if (maxDocumentInReport <= 0 && maxDocumentInReport != -1) {
            throw new IllegalArgumentException("Illegal argument: " + maxDocumentInReport);
        }
        this.maxDocumentInReport = maxDocumentInReport;
    }

    public String getPRMatchingRegex() {
        return this.PRMatchingRegex;
    }

    public void setPRMatchingRegex(String matchingRegex) {
        this.PRMatchingRegex = matchingRegex;
    }
}

