/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class XJTextPane
extends JTextPane {
    public XJTextPane() {
        this.initListeners();
        this.updateStyle();
    }

    public XJTextPane(StyledDocument doc) {
        super(doc);
        this.initListeners();
        this.updateStyle();
    }

    protected void initListeners() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("UI")) {
                    XJTextPane.this.updateStyle();
                } else if (e.getPropertyName().equals("document")) {
                    XJTextPane.this.updateStyle();
                }
            }
        });
    }

    protected void updateStyle() {
        Font newFont = UIManager.getFont("TextPane.font");
        Style defaultStyle = this.getStyle("default");
        StyleConstants.setFontFamily(defaultStyle, newFont.getFamily());
        StyleConstants.setFontSize(defaultStyle, newFont.getSize());
        StyleConstants.setItalic(defaultStyle, newFont.isItalic());
        StyleConstants.setBold(defaultStyle, newFont.isBold());
        this.repaint();
    }
}

