/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.Gate;
import gate.gui.MainFrame;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class XJFileChooser
extends JFileChooser {
    private String resource;
    private String fileName;
    private boolean isFileSelected = false;
    private Map<String, String> locations;

    public XJFileChooser() {
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L && !XJFileChooser.this.isDisplayable()) {
                    XJFileChooser.this.resource = null;
                    XJFileChooser.this.fileName = null;
                    XJFileChooser.this.isFileSelected = false;
                    XJFileChooser.this.resetChoosableFileFilters();
                }
            }
        });
        this.locations = this.getLocations();
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        this.setSelectedFileFromPreferences();
        return super.showDialog(parent != null ? parent : (MainFrame.getFileChooser() != null ? MainFrame.getInstance() : null), approveButtonText);
    }

    public void setSelectedFileFromPreferences() {
        File file;
        String lastUsedPath = this.getLocationForResource(this.resource);
        String specifiedDefaultDir = System.getProperty("gate.user.filechooser.defaultdir");
        if (this.isFileSelected) {
            return;
        }
        if (lastUsedPath != null && this.fileName != null) {
            file = new File(lastUsedPath);
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            file = new File(file, this.fileName);
        } else if (lastUsedPath != null) {
            file = new File(lastUsedPath);
        } else if (this.fileName != null) {
            file = specifiedDefaultDir != null ? new File(specifiedDefaultDir, this.fileName) : new File(System.getProperty("user.home"), this.fileName);
        } else {
            if (specifiedDefaultDir != null) {
                this.setCurrentDirectory(new File(specifiedDefaultDir));
            }
            return;
        }
        this.setSelectedFile(file);
        this.ensureFileIsVisible(file);
    }

    public String getLocationForResource(String resource) {
        this.locations = this.getLocations();
        return resource == null ? null : this.locations.get(resource);
    }

    public Map<String, String> getLocations() {
        return Gate.getUserConfig().getMap(XJFileChooser.class.getName());
    }

    public void setLocations(Map<String, String> locations) {
        Gate.getUserConfig().put((Object)XJFileChooser.class.getName(), locations);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void approveSelection() {
        if (this.resource != null && this.getSelectedFile() != null) {
            String filePath = this.getSelectedFile().getAbsolutePath();
            this.locations.put(this.resource, filePath);
            this.setLocations(this.locations);
        }
        super.approveSelection();
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    @Override
    public void ensureFileIsVisible(File f) {
        if (f != null && f.exists()) {
            super.ensureFileIsVisible(f);
        }
    }

    @Override
    public void setSelectedFile(File file) {
        if (file != null) {
            if (file.exists() || file.getParentFile() != null && file.getParentFile().exists()) {
                super.setSelectedFile(file);
            }
            this.isFileSelected = true;
        }
    }

    @Override
    public void addChoosableFileFilter(FileFilter filterToAdd) {
        for (FileFilter filter : this.getChoosableFileFilters()) {
            if (!filter.getDescription().equals(filterToAdd.getDescription())) continue;
            this.setFileFilter(filter);
            return;
        }
        super.addChoosableFileFilter(filterToAdd);
    }
}

