/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class PinIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.0f, -0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(0.09134901f, 0.0f, 0.0f, 0.09134901f, 0.15568939f, 0.74999285f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = PinIcon.getColor(163, 28, 9, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(505.605, 190.556);
        shape.curveTo(491.816, 204.345, 438.718, 173.607, 387.006, 121.895);
        shape.curveTo(335.294, 70.183, 304.556, 17.085, 318.345, 3.296);
        shape.curveTo(332.134, -10.493, 385.232, 20.244999, 436.944, 71.957);
        shape.curveTo(488.656, 123.66901, 519.394, 176.768, 505.605, 190.556);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 9.24269f, -5.336719f));
        paint = PinIcon.getColor(217, 219, 232, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(112.358, 346.605);
        shape.lineTo(162.295, 396.543);
        shape.lineTo(0.0, 508.9);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = PinIcon.getColor(206, 57, 41, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(387.007, 121.894);
        shape.curveTo(335.295, 70.182, 304.557, 17.084, 318.346, 3.295);
        shape.curveTo(268.355, 53.286003, 279.116, 126.36, 330.828, 178.07199);
        shape.curveTo(382.54, 229.784, 452.499, 243.66098, 502.47998, 193.67899);
        shape.lineTo(501.69397, 192.85799);
        shape.curveTo(483.62497, 199.43498, 434.76398, 169.65099, 387.00696, 121.89399);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = PinIcon.getColor(163, 28, 9, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(342.08, 279.177);
        shape.lineTo(400.68597, 220.571);
        shape.curveTo(376.09198, 213.844, 351.93997, 199.182, 330.83298, 178.075);
        shape.curveTo(309.71698, 156.959, 295.576, 132.286, 289.46698, 107.084);
        shape.lineTo(229.73997, 166.80301);
        shape.lineTo(181.02097, 215.522);
        shape.curveTo(187.13896, 240.73401, 203.60196, 263.076, 224.71796, 284.183);
        shape.curveTo(245.82495, 305.299, 268.78497, 321.153, 293.37897, 327.88);
        shape.lineTo(342.07996, 279.177);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = PinIcon.getColor(163, 28, 9, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(342.08, 279.177);
        shape.lineTo(400.68597, 220.571);
        shape.curveTo(376.09198, 213.844, 351.93997, 199.182, 330.83298, 178.075);
        shape.curveTo(309.71698, 156.959, 295.576, 132.286, 289.46698, 107.084);
        shape.lineTo(229.73997, 166.80301);
        shape.lineTo(181.02097, 215.522);
        shape.curveTo(187.13896, 240.73401, 203.60196, 263.076, 224.71796, 284.183);
        shape.curveTo(245.82495, 305.299, 268.78497, 321.153, 293.37897, 327.88);
        shape.lineTo(342.07996, 279.177);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        float alpha__0_0_5 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_5 = g.getClip();
        AffineTransform defaultTransform__0_0_5 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = PinIcon.getColor(206, 57, 41, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(311.324, 389.978);
        shape.curveTo(313.672, 368.492, 309.717, 345.75198, 299.495, 321.758);
        shape.lineTo(293.37698, 327.884);
        shape.curveTo(268.783, 321.149, 245.823, 305.294, 224.716, 284.187);
        shape.curveTo(203.6, 263.08, 187.137, 240.729, 181.019, 215.526);
        shape.lineTo(187.26, 209.285);
        shape.lineTo(186.986, 209.003);
        shape.curveTo(162.84299, 198.65701, 139.97, 194.658, 118.35999, 197.024);
        shape.curveTo(78.20299, 201.40201, 54.288994, 242.901, 70.726, 279.80902);
        shape.curveTo(83.235, 307.881, 106.292, 340.54303, 137.048, 371.29803);
        shape.curveTo(167.794, 402.04504, 200.465, 425.11102, 228.537, 437.61102);
        shape.curveTo(265.438, 454.04803, 306.937, 430.13403, 311.324, 389.97803);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_5;
        g.setTransform(defaultTransform__0_0_5);
        g.setClip(clip__0_0_5);
        float alpha__0_0_6 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_6 = g.getClip();
        AffineTransform defaultTransform__0_0_6 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_6;
        g.setTransform(defaultTransform__0_0_6);
        g.setClip(clip__0_0_6);
        float alpha__0_0_7 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_7 = g.getClip();
        AffineTransform defaultTransform__0_0_7 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_7;
        g.setTransform(defaultTransform__0_0_7);
        g.setClip(clip__0_0_7);
        float alpha__0_0_8 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_8 = g.getClip();
        AffineTransform defaultTransform__0_0_8 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_8;
        g.setTransform(defaultTransform__0_0_8);
        g.setClip(clip__0_0_8);
        float alpha__0_0_9 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_9 = g.getClip();
        AffineTransform defaultTransform__0_0_9 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_9;
        g.setTransform(defaultTransform__0_0_9);
        g.setClip(clip__0_0_9);
        float alpha__0_0_10 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_10 = g.getClip();
        AffineTransform defaultTransform__0_0_10 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_10;
        g.setTransform(defaultTransform__0_0_10);
        g.setClip(clip__0_0_10);
        float alpha__0_0_11 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_11 = g.getClip();
        AffineTransform defaultTransform__0_0_11 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_11;
        g.setTransform(defaultTransform__0_0_11);
        g.setClip(clip__0_0_11);
        float alpha__0_0_12 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_12 = g.getClip();
        AffineTransform defaultTransform__0_0_12 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_12;
        g.setTransform(defaultTransform__0_0_12);
        g.setClip(clip__0_0_12);
        float alpha__0_0_13 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_13 = g.getClip();
        AffineTransform defaultTransform__0_0_13 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_13;
        g.setTransform(defaultTransform__0_0_13);
        g.setClip(clip__0_0_13);
        float alpha__0_0_14 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_14 = g.getClip();
        AffineTransform defaultTransform__0_0_14 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_14;
        g.setTransform(defaultTransform__0_0_14);
        g.setClip(clip__0_0_14);
        float alpha__0_0_15 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_15 = g.getClip();
        AffineTransform defaultTransform__0_0_15 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_15;
        g.setTransform(defaultTransform__0_0_15);
        g.setClip(clip__0_0_15);
        float alpha__0_0_16 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_16 = g.getClip();
        AffineTransform defaultTransform__0_0_16 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_16;
        g.setTransform(defaultTransform__0_0_16);
        g.setClip(clip__0_0_16);
        float alpha__0_0_17 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_17 = g.getClip();
        AffineTransform defaultTransform__0_0_17 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_17;
        g.setTransform(defaultTransform__0_0_17);
        g.setClip(clip__0_0_17);
        float alpha__0_0_18 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_18 = g.getClip();
        AffineTransform defaultTransform__0_0_18 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_18;
        g.setTransform(defaultTransform__0_0_18);
        g.setClip(clip__0_0_18);
        float alpha__0_0_19 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_19 = g.getClip();
        AffineTransform defaultTransform__0_0_19 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_19;
        g.setTransform(defaultTransform__0_0_19);
        g.setClip(clip__0_0_19);
        float alpha__0_0_20 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_20 = g.getClip();
        AffineTransform defaultTransform__0_0_20 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_0_20;
        g.setTransform(defaultTransform__0_0_20);
        g.setClip(clip__0_0_20);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 1;
    }

    public static int getOrigY() {
        return 0;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public PinIcon() {
        this(PinIcon.getOrigWidth(), PinIcon.getOrigHeight(), false);
    }

    public PinIcon(boolean disabled) {
        this(PinIcon.getOrigWidth(), PinIcon.getOrigHeight(), disabled);
    }

    public PinIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public PinIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public PinIcon(int width, int height) {
        this(width, height, false);
    }

    public PinIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)PinIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)PinIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        PinIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

