/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SingleConcatenatedFileInputDialog
extends JPanel {
    JTextField urlTextField;
    JButton filerBtn;
    JTextField encodingTextField;
    JTextField documentRootElementTextField;
    JTextField documentNamePrefixTextField;
    JTextField documentMimeTypeTextField;
    JTextField numOfDocumentsToFetchTextField;
    JCheckBox chkIncludeRoot;

    public SingleConcatenatedFileInputDialog() {
        this.initGUIComponents();
        this.initListeners();
    }

    protected void initGUIComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("File URL:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 5;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 10);
        this.urlTextField = new JTextField(40);
        this.add((Component)this.urlTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        this.filerBtn = new JButton(MainFrame.getIcon("open-file"));
        this.add((Component)this.filerBtn, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Encoding:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 1;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.encodingTextField = new JTextField(40);
        this.add((Component)this.encodingTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Root Element:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 2;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.documentRootElementTextField = new JTextField("DOC", 40);
        this.add((Component)this.documentRootElementTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Include Root Element:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 3;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.chkIncludeRoot = new JCheckBox();
        this.add((Component)this.chkIncludeRoot, constraints);
        this.chkIncludeRoot.setSelected(true);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Document Mime Type:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 4;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.documentMimeTypeTextField = new JTextField("text/html", 40);
        this.add((Component)this.documentMimeTypeTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("No. of Docs:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 5;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.numOfDocumentsToFetchTextField = new JTextField("-1", 40);
        this.add((Component)this.numOfDocumentsToFetchTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 6;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Prefix for documents:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 6;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.documentNamePrefixTextField = new JTextField("Document", 40);
        this.add((Component)this.documentNamePrefixTextField, constraints);
    }

    protected void initListeners() {
        this.filerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XJFileChooser filer = MainFrame.getFileChooser();
                filer.setFileSelectionMode(0);
                filer.setDialogTitle("Select a file");
                filer.resetChoosableFileFilters();
                filer.setAcceptAllFileFilterUsed(true);
                filer.setFileFilter(filer.getAcceptAllFileFilter());
                int res = filer.showOpenDialog(SingleConcatenatedFileInputDialog.this);
                if (res == 0) {
                    try {
                        SingleConcatenatedFileInputDialog.this.urlTextField.setText(filer.getSelectedFile().toURI().toURL().toExternalForm());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setUrlString(String urlString) {
        this.urlTextField.setText(urlString);
    }

    public String getUrlString() {
        return this.urlTextField.getText();
    }

    public String getEncoding() {
        return this.encodingTextField.getText();
    }

    public void setEncoding(String enc) {
        this.encodingTextField.setText(enc);
    }

    public String getDocumentRootElement() {
        return this.documentRootElementTextField.getText();
    }

    public void setDocumentRootElement(String documentRootElement) {
        this.documentRootElementTextField.setText(documentRootElement);
    }

    public String getDocumentNamePrefix() {
        return this.documentNamePrefixTextField.getText();
    }

    public void setDocumentNamePrefix(String documentNamePrefix) {
        this.documentNamePrefixTextField.setText(documentNamePrefix);
    }

    public String getDocumentMimeType() {
        return this.documentMimeTypeTextField.getText();
    }

    public void setDocumentMimeType(String mimeType) {
        this.documentMimeTypeTextField.setText(mimeType);
    }

    public boolean includeRootElement() {
        return this.chkIncludeRoot.isSelected();
    }

    public int getNumOfDocumentsToFetch() {
        if (this.numOfDocumentsToFetchTextField.getText().trim().length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(this.numOfDocumentsToFetchTextField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public void setNumOfDocumentsToFetch(int numOfDocumentsToFetch) {
        this.numOfDocumentsToFetchTextField.setText("" + numOfDocumentsToFetch);
    }

    public void reset() {
        this.setEncoding("");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Gate.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("Foo");
        SingleConcatenatedFileInputDialog comp = new SingleConcatenatedFileInputDialog();
        frame.getContentPane().add(comp);
        frame.pack();
        frame.setResizable(false);
        frame.setVisible(true);
    }
}

