/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Controller;
import gate.CreoleRegister;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.Gate;
import gate.LanguageResource;
import gate.Main;
import gate.ProcessingResource;
import gate.Resource;
import gate.VisualResource;
import gate.creole.ANNIEConstants;
import gate.creole.ConditionalSerialAnalyserController;
import gate.creole.PackagedController;
import gate.creole.Plugin;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.PluginListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.ActionsPublisher;
import gate.gui.AnnotationDiffGUI;
import gate.gui.Handle;
import gate.gui.ListEditorDialog;
import gate.gui.LogArea;
import gate.gui.NameBearerHandle;
import gate.gui.NewResourceDialog;
import gate.gui.OptionsDialog;
import gate.gui.Splash;
import gate.gui.TabHighlighter;
import gate.gui.creole.manager.PluginUpdateManager;
import gate.persist.PersistenceException;
import gate.resources.img.svg.AvailableIcon;
import gate.resources.img.svg.GATEIcon;
import gate.resources.img.svg.GATEVersionIcon;
import gate.resources.img.svg.ReadyMadeIcon;
import gate.swing.JMenuButton;
import gate.swing.ResourceReferenceChooser;
import gate.swing.XJFileChooser;
import gate.swing.XJMenu;
import gate.swing.XJMenuItem;
import gate.swing.XJPopupMenu;
import gate.swing.XJTabbedPane;
import gate.util.Benchmark;
import gate.util.CorpusBenchmarkTool;
import gate.util.Files;
import gate.util.GateClassLoader;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.NameBearer;
import gate.util.OptionsMap;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import gate.util.persistence.UpgradeXGAPP;
import gate.util.reporting.DocTimeReporter;
import gate.util.reporting.PRTimeReporter;
import gate.util.reporting.exceptions.BenchmarkReportException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.cache.CacheStorage;
import org.codehaus.httpcache4j.cache.FilePersistentCacheStorage;
import org.codehaus.httpcache4j.cache.HTTPCache;
import org.codehaus.httpcache4j.cache.NullCacheStorage;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.resolver.JavaNetResponseResolver;
import org.codehaus.httpcache4j.resolver.ResponseResolver;

public class MainFrame
extends JFrame
implements ProgressListener,
StatusListener,
CreoleListener,
PluginListener {
    protected static final Logger log = Logger.getLogger(MainFrame.class);
    public static final Dimension ICON_DIMENSION = new Dimension(24, 24);
    protected JMenuBar menuBar;
    protected JSplitPane mainSplit;
    protected JSplitPane leftSplit;
    protected JLabel statusBar;
    protected JProgressBar progressBar;
    protected JProgressBar globalProgressBar;
    protected XJTabbedPane mainTabbedPane;
    protected JScrollPane lowerScroll;
    protected JPopupMenu appsPopup;
    protected JPopupMenu dssPopup;
    protected JPopupMenu lrsPopup;
    protected JPopupMenu prsPopup;
    protected JCheckBoxMenuItem verboseModeItem;
    protected JTree resourcesTree;
    protected JScrollPane resourcesTreeScroll;
    protected DefaultTreeModel resourcesTreeModel;
    protected DefaultMutableTreeNode resourcesTreeRoot;
    protected DefaultMutableTreeNode applicationsRoot;
    protected DefaultMutableTreeNode languageResourcesRoot;
    protected DefaultMutableTreeNode processingResourcesRoot;
    protected DefaultMutableTreeNode datastoresRoot;
    protected Splash splash;
    protected PluginUpdateManager pluginManager;
    protected LogArea logArea;
    protected JToolBar toolbar;
    protected static XJFileChooser fileChooser;
    protected static ResourceReferenceChooser resourceReferenceChooser;
    private static MainFrame instance;
    protected OptionsDialog optionsDialog;
    protected CartoonMinder animator;
    protected TabHighlighter logHighlighter;
    protected NewResourceDialog newResourceDialog;
    protected volatile HTTPCache httpCache;
    private static final Map<String, Icon> iconByName;
    private static final Collection<Component> guiRoots;
    protected static final String[] ICON_EXTENSIONS;
    private static JDialog guiLock;
    private static final Pattern START_RUNNING_PATTERN;
    private boolean titleChangable = false;

    public static Icon getIcon(String baseName) {
        return MainFrame.getIcon(baseName, Gate.getClassLoader());
    }

    public static Icon getIcon(String baseName, ClassLoader classloader) {
        String[] svgNames;
        Icon result = iconByName.get(baseName);
        if (result != null) {
            return result;
        }
        for (String svgName : svgNames = new String[]{baseName, String.format(baseName.replaceAll("^(.)", "%S").replaceAll("\\-(.)", "%S"), (baseName.charAt(0) + "-" + baseName).replaceAll("[^-]*-(.)[^-]*", "$1-").split("-")), baseName.toUpperCase()}) {
            try {
                Class<?> clazz = Class.forName("gate.resources.img.svg." + svgName + "Icon", true, classloader);
                Constructor<?> con = clazz.getConstructor(Dimension.class);
                result = (Icon)con.newInstance(ICON_DIMENSION);
                iconByName.put(baseName, result);
                return result;
            }
            catch (Exception exception) {
            }
        }
        for (int i = 0; i < ICON_EXTENSIONS.length; ++i) {
            String extension = ICON_EXTENSIONS[i];
            String fileName = baseName + extension;
            URL iconURL = fileName.charAt(0) == '/' ? classloader.getResource(fileName.substring(1)) : classloader.getResource("gate/resources/img/" + fileName);
            if (iconURL == null) continue;
            result = new ImageIcon(iconURL);
            iconByName.put(baseName, result);
            return result;
        }
        return null;
    }

    public static MainFrame getInstance() {
        return MainFrame.getInstance(null);
    }

    public static synchronized MainFrame getInstance(GraphicsConfiguration gc) {
        if (instance == null) {
            instance = new MainFrame(gc);
        }
        return instance;
    }

    public static XJFileChooser getFileChooser() {
        return fileChooser;
    }

    public static ResourceReferenceChooser getResourceReferenceChooser() {
        return resourceReferenceChooser;
    }

    public PrintStream getOriginalOut() {
        return this.logArea.getOriginalOut();
    }

    public PrintStream getOriginalErr() {
        return this.logArea.getOriginalErr();
    }

    protected Handle findHandleForResource(Resource res) {
        Handle handle = null;
        Enumeration<TreeNode> nodesEnum = this.resourcesTreeRoot.breadthFirstEnumeration();
        while (nodesEnum.hasMoreElements() && handle == null) {
            DefaultMutableTreeNode dmtNode;
            TreeNode node = nodesEnum.nextElement();
            if (!(node instanceof DefaultMutableTreeNode) || !((dmtNode = (DefaultMutableTreeNode)node).getUserObject() instanceof Handle) || ((Handle)dmtNode.getUserObject()).getTarget() != res) continue;
            handle = (Handle)dmtNode.getUserObject();
        }
        return handle;
    }

    public Handle select(Resource res) {
        Handle handle = this.findHandleForResource(res);
        if (handle != null) {
            this.select(handle);
        }
        return handle;
    }

    protected void select(Handle handle) {
        JComponent smallView;
        final JComponent largeView = handle.getLargeView();
        if (handle.viewsBuilt() && this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
            if (largeView != null) {
                this.mainTabbedPane.setSelectedComponent(largeView);
            }
        } else if (largeView != null) {
            this.mainTabbedPane.addTab(handle.getTitle(), handle.getIcon(), largeView, handle.getTooltipText());
            this.mainTabbedPane.setSelectedComponent(handle.getLargeView());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (largeView != null) {
                        if (largeView instanceof JTabbedPane && ((JTabbedPane)largeView).getSelectedComponent() != null) {
                            ((JTabbedPane)largeView).getSelectedComponent().requestFocus();
                        } else {
                            largeView.requestFocus();
                        }
                    }
                }
            });
        }
        if ((smallView = handle.getSmallView()) != null) {
            this.lowerScroll.getViewport().setView(smallView);
        } else {
            this.lowerScroll.getViewport().setView(null);
        }
    }

    private MainFrame(GraphicsConfiguration gc) {
        super(gc);
        instance = this;
        PluginUpdateManager.loadDefaultPlugins();
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "GATE Developer " + Main.version);
        }
        catch (Exception e) {
            log.debug((Object)"Could not set WM Class (note that this is normal if you are not on an X11-based window system)", (Throwable)e);
        }
        guiRoots.add(this);
        if (fileChooser == null) {
            fileChooser = new XJFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setAcceptAllFileFilterUsed(true);
            guiRoots.add(fileChooser);
            JDialog dialog = new JDialog(this, "", true);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)fileChooser, "Center");
            dialog.pack();
            dialog.getContentPane().removeAll();
            dialog.dispose();
            Object var2_2 = null;
        }
        if (resourceReferenceChooser == null) {
            resourceReferenceChooser = new ResourceReferenceChooser();
        }
        this.enableEvents(64L);
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData() {
        this.resourcesTreeRoot = new DefaultMutableTreeNode("GATE", true);
        this.applicationsRoot = new DefaultMutableTreeNode("Applications", true);
        this.languageResourcesRoot = new DefaultMutableTreeNode("Language Resources", true);
        this.processingResourcesRoot = new DefaultMutableTreeNode("Processing Resources", true);
        this.datastoresRoot = new DefaultMutableTreeNode("Datastores", true);
        this.resourcesTreeRoot.add(this.applicationsRoot);
        this.resourcesTreeRoot.add(this.languageResourcesRoot);
        this.resourcesTreeRoot.add(this.processingResourcesRoot);
        this.resourcesTreeRoot.add(this.datastoresRoot);
        this.resourcesTreeModel = new ResourcesTreeModel(this.resourcesTreeRoot, true);
    }

    protected void initGuiComponents() {
        String splashHtml;
        this.getContentPane().setLayout(new BorderLayout());
        Integer width = Gate.getUserConfig().getInt("Main_frame_width", 1024);
        Integer height = Gate.getUserConfig().getInt("Main_frame_height", 768);
        Rectangle maxDimensions = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setSize(new Dimension(Math.min(width, maxDimensions.width), Math.min(height, maxDimensions.height)));
        if (Gate.getUserConfig().getBoolean("Main_frame_maximized").booleanValue()) {
            this.setExtendedState(6);
        }
        this.setIconImages(Arrays.asList(new GATEVersionIcon(256, 256).getImage(), new GATEVersionIcon(128, 128).getImage(), new GATEVersionIcon(64, 64).getImage(), new GATEVersionIcon(48, 48).getImage(), new GATEVersionIcon(32, 32).getImage(), new GATEIcon(22, 22).getImage(), new GATEIcon(16, 16).getImage()));
        this.resourcesTree = new ResourcesTree();
        this.resourcesTree.setModel(this.resourcesTreeModel);
        this.resourcesTree.setRowHeight(0);
        this.resourcesTree.setEditable(true);
        ResourcesTreeCellRenderer treeCellRenderer = new ResourcesTreeCellRenderer();
        this.resourcesTree.setCellRenderer(treeCellRenderer);
        this.resourcesTree.setCellEditor(new ResourcesTreeCellEditor(this.resourcesTree, treeCellRenderer));
        this.resourcesTree.setInvokesStopCellEditing(true);
        this.resourcesTree.setRowHeight(0);
        this.resourcesTree.expandRow(0);
        this.resourcesTree.expandRow(1);
        this.resourcesTree.expandRow(2);
        this.resourcesTree.expandRow(3);
        this.resourcesTree.expandRow(4);
        this.resourcesTree.getSelectionModel().setSelectionMode(4);
        this.resourcesTree.setEnabled(true);
        ToolTipManager.sharedInstance().registerComponent(this.resourcesTree);
        this.resourcesTreeScroll = new JScrollPane(this.resourcesTree);
        this.resourcesTree.setDragEnabled(true);
        this.resourcesTree.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                TreePath[] paths = MainFrame.this.resourcesTree.getSelectionPaths();
                if (paths == null) {
                    return new StringSelection("");
                }
                ArrayList<String> documentsNames = new ArrayList<String>();
                for (TreePath path : paths) {
                    Handle handle;
                    if (path == null) continue;
                    Object value = path.getLastPathComponent();
                    if (!((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof Handle) || !((handle = (Handle)value).getTarget() instanceof Document)) continue;
                    documentsNames.add(((Document)handle.getTarget()).getName());
                }
                return new StringSelection("ResourcesTree" + Arrays.toString(documentsNames.toArray()));
            }

            @Override
            protected void exportDone(JComponent c, Transferable data, int action) {
            }

            @Override
            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                return false;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                return false;
            }
        });
        this.lowerScroll = new JScrollPane();
        JPanel lowerPane = new JPanel();
        lowerPane.setLayout(new OverlayLayout(lowerPane));
        JPanel animationPane = new JPanel();
        animationPane.setOpaque(false);
        animationPane.setLayout(new BoxLayout(animationPane, 0));
        JPanel vBox = new JPanel();
        vBox.setLayout(new BoxLayout(vBox, 1));
        vBox.setOpaque(false);
        JPanel hBox = new JPanel();
        hBox.setLayout(new BoxLayout(hBox, 0));
        hBox.setOpaque(false);
        vBox.add(Box.createVerticalGlue());
        vBox.add(animationPane);
        hBox.add(vBox);
        hBox.add(Box.createHorizontalGlue());
        lowerPane.add(hBox);
        lowerPane.add(this.lowerScroll);
        this.animator = new CartoonMinder(animationPane);
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), this.animator, "MainFrame animation");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.leftSplit = new JSplitPane(0, this.resourcesTreeScroll, lowerPane);
        this.leftSplit.setResizeWeight(0.7);
        this.leftSplit.setContinuousLayout(true);
        this.leftSplit.setOneTouchExpandable(true);
        this.logArea = new LogArea();
        Out.prln("GATE " + Gate.VERSION_STRING + " build " + Gate.BUILD + " started at " + new Date().toString());
        Out.prln("and using Java " + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " on " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version") + ".");
        this.mainTabbedPane = new XJTabbedPane(1);
        this.mainTabbedPane.insertTab("Messages", null, this.logArea.getComponentToDisplay(), "GATE log", 0);
        this.logHighlighter = new TabHighlighter(this.mainTabbedPane, this.logArea.getComponentToDisplay(), Color.red);
        this.mainSplit = new JSplitPane(1, this.leftSplit, this.mainTabbedPane);
        this.mainSplit.setDividerLocation(this.leftSplit.getPreferredSize().width + 10);
        this.getContentPane().add((Component)this.mainSplit, "Center");
        this.mainSplit.setContinuousLayout(true);
        this.mainSplit.setOneTouchExpandable(true);
        this.statusBar = new JLabel("Welcome to GATE!");
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        UIManager.put("ProgressBar.cellSpacing", 0);
        this.progressBar = new JProgressBar(0);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.progressBar.setForeground(new Color(150, 75, 150));
        this.progressBar.setStringPainted(false);
        this.globalProgressBar = new JProgressBar(0);
        this.globalProgressBar.setBorder(BorderFactory.createEmptyBorder());
        this.globalProgressBar.setForeground(new Color(150, 75, 150));
        this.globalProgressBar.setStringPainted(true);
        JPanel southBox = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        southBox.add((Component)this.statusBar, gbc);
        gbc.insets = new Insets(0, 3, 0, 3);
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        southBox.add((Component)this.progressBar, gbc);
        southBox.add((Component)this.globalProgressBar, gbc);
        this.getContentPane().add((Component)southBox, "South");
        this.progressBar.setVisible(false);
        this.globalProgressBar.setVisible(false);
        this.newResourceDialog = new NewResourceDialog(this, "Resource parameters", true);
        JPanel splashBox = new JPanel();
        splashBox.setBackground(Color.WHITE);
        splashBox.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.gridy = 0;
        constraints.fill = 1;
        JLabel gifLbl = new JLabel(MainFrame.getIcon("splash"));
        splashBox.add((Component)gifLbl, constraints);
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        try {
            splashHtml = Files.getGateResourceAsString("splash.html");
        }
        catch (IOException e) {
            splashHtml = "GATE";
            log.error((Object)"Couldn't get splash.html resource.", (Throwable)e);
        }
        JLabel htmlLbl = new JLabel(splashHtml);
        htmlLbl.setHorizontalAlignment(0);
        splashBox.add((Component)htmlLbl, constraints);
        constraints.gridy = 3;
        htmlLbl = new JLabel("<HTML><FONT color=\"blue\">Version <B>" + Gate.VERSION_STRING + "</B></FONT>, <FONT color=\"red\">build <B>" + Gate.BUILD + "</B></FONT><P><B>JVM version</B>: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + "</HTML>");
        constraints.fill = 2;
        splashBox.add((Component)htmlLbl, constraints);
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        final JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.splash.setVisible(false);
            }
        });
        okButton.setBackground(Color.white);
        splashBox.add((Component)okButton, constraints);
        this.splash = new Splash((Window)this, splashBox);
        this.splash.getRootPane().setDefaultButton(okButton);
        InputMap inputMap = ((JComponent)this.splash.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.splash.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okButton.doClick();
            }
        });
        this.menuBar = new JMenuBar();
        XJMenu fileMenu = new XJMenu("File", null, this);
        fileMenu.setMnemonic(70);
        LiveMenu newAPPMenu = new LiveMenu(3);
        newAPPMenu.setText("New Application");
        newAPPMenu.setIcon(MainFrame.getIcon("applications"));
        fileMenu.add(newAPPMenu);
        LiveMenu newLRMenu = new LiveMenu(1);
        newLRMenu.setText("New Language Resource");
        newLRMenu.setIcon(MainFrame.getIcon("lrs"));
        fileMenu.add(newLRMenu);
        LiveMenu newPRMenu = new LiveMenu(2);
        newPRMenu.setText("New Processing Resource");
        newPRMenu.setIcon(MainFrame.getIcon("prs"));
        fileMenu.add(newPRMenu);
        XJMenu dsMenu = new XJMenu("Datastores", "Repositories for large data", this);
        dsMenu.setIcon(MainFrame.getIcon("datastores"));
        dsMenu.add(new XJMenuItem(new NewDSAction(), this));
        dsMenu.add(new XJMenuItem(new OpenDSAction(), this));
        fileMenu.add(dsMenu);
        fileMenu.addSeparator();
        fileMenu.add(new ReadyMadeMenu());
        fileMenu.add(new XJMenuItem(new LoadResourceFromFileAction(), this));
        RecentAppsMenu recentAppsMenu = new RecentAppsMenu();
        fileMenu.add(recentAppsMenu);
        fileMenu.add(new XJMenuItem(new ManagePluginsAction(), this));
        if (!Gate.runningOnMac()) {
            fileMenu.addSeparator();
            fileMenu.add(new XJMenuItem(new ExitGateAction(), this));
        }
        this.menuBar.add(fileMenu);
        XJMenu optionsMenu = new XJMenu("Options", null, this);
        optionsMenu.setMnemonic(79);
        boolean optionsMenuHasEntries = false;
        this.optionsDialog = new OptionsDialog(this);
        if (!Gate.runningOnMac()) {
            optionsMenu.add(new XJMenuItem(new AbstractAction("Configuration"){
                private static final long serialVersionUID = 1L;
                {
                    this.putValue("ShortDescription", "Edit GATE options");
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.optionsDialog.showDialog();
                    MainFrame.this.optionsDialog.dispose();
                }
            }, this));
            optionsMenuHasEntries = true;
        }
        if (optionsMenuHasEntries) {
            this.menuBar.add(optionsMenu);
        }
        ToolsMenu toolsMenu = new ToolsMenu("Tools", null, this);
        toolsMenu.setMnemonic(84);
        toolsMenu.add(new XJMenuItem(new NewAnnotDiffAction(), this));
        try {
            Class.forName("org.apache.log4j.Appender");
            final XJMenuItem reportClearMenuItem = new XJMenuItem(new AbstractAction("Clear Profiling History"){
                {
                    this.putValue("ShortDescription", "Clear profiling history otherwise the report is cumulative.");
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    File logFile = new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt");
                    logFile.deleteOnExit();
                    if (logFile.exists() && !logFile.delete()) {
                        log.info((Object)("Error when deleting the file:\n" + logFile.getAbsolutePath()));
                    }
                }
            }, this);
            XJMenu reportMenu = new XJMenu("Profiling Reports", "Generates profiling reports from processing resources", this);
            reportMenu.setIcon(MainFrame.getIcon("gazetteer"));
            reportMenu.add(new XJMenuItem(new AbstractAction("Start Profiling Applications"){
                boolean benchmarkWasEnabled;
                {
                    super(x0);
                    this.putValue("ShortDescription", "Toggles the profiling of processing resources");
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (this.getValue("Name").equals("Start Profiling Applications")) {
                        FileAppender appender;
                        reportClearMenuItem.setEnabled(false);
                        this.benchmarkWasEnabled = Benchmark.isBenchmarkingEnabled();
                        Benchmark.setBenchmarkingEnabled(true);
                        PatternLayout layout = new PatternLayout("%m%n");
                        File logFile = new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt");
                        logFile.deleteOnExit();
                        try {
                            appender = new FileAppender((Layout)layout, logFile.getAbsolutePath(), true);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return;
                        }
                        appender.setName("gate-benchmark");
                        Benchmark.logger.addAppender((Appender)appender);
                        this.putValue("Name", "Stop Profiling Applications");
                    } else {
                        Benchmark.setBenchmarkingEnabled(this.benchmarkWasEnabled);
                        Benchmark.logger.removeAppender("gate-benchmark");
                        this.putValue("Name", "Start Profiling Applications");
                        reportClearMenuItem.setEnabled(true);
                    }
                }
            }, this));
            reportMenu.add(reportClearMenuItem);
            reportMenu.add(new XJMenuItem(new AbstractAction("Help on this tool"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.showHelpFrame("chap:profiling", "Profiling Processing Resources");
                }
            }, this));
            reportMenu.addSeparator();
            final JCheckBoxMenuItem reportZeroTimesCheckBox = new JCheckBoxMenuItem();
            reportZeroTimesCheckBox.setAction(new AbstractAction("Report Zero Time Entries"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportzerotime"), (Object)reportZeroTimesCheckBox.isSelected());
                }
            });
            reportZeroTimesCheckBox.setSelected(Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".reportzerotimes"));
            ButtonGroup group = new ButtonGroup();
            JRadioButtonMenuItem reportSortExecution = new JRadioButtonMenuItem();
            reportSortExecution.setAction(new AbstractAction("Sort by Execution"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportsorttime"), (Object)false);
                }
            });
            reportSortExecution.setSelected(Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".reportsorttime") == false);
            group.add(reportSortExecution);
            final JRadioButtonMenuItem reportSortTime = new JRadioButtonMenuItem();
            reportSortTime.setAction(new AbstractAction("Sort by Time"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportsorttime"), (Object)true);
                }
            });
            reportSortTime.setSelected(Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".reportsorttime"));
            group.add(reportSortTime);
            reportMenu.add(new XJMenuItem(new AbstractAction("Report on Processing Resources"){
                {
                    super(x0);
                    this.putValue("ShortDescription", "Report time taken by each processing resource");
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PRTimeReporter report = new PRTimeReporter();
                    report.setBenchmarkFile(new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt"));
                    report.setSuppressZeroTimeEntries(!reportZeroTimesCheckBox.isSelected());
                    report.setSortOrder(reportSortTime.isSelected() ? "time_taken" : "exec_order");
                    try {
                        report.executeReport();
                    }
                    catch (BenchmarkReportException e) {
                        e.printStackTrace();
                        return;
                    }
                    MainFrame.this.showHelpFrame("file://" + report.getReportFile(), "processing times report");
                }
            }, this));
            reportMenu.add(reportZeroTimesCheckBox);
            reportMenu.add(reportSortTime);
            reportMenu.add(reportSortExecution);
            reportMenu.addSeparator();
            reportMenu.add(new XJMenuItem(new AbstractAction("Report on Documents Processed"){
                {
                    this.putValue("ShortDescription", "Report most time consuming documents");
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String prRegex;
                    DocTimeReporter report = new DocTimeReporter();
                    report.setBenchmarkFile(new File(System.getProperty("java.io.tmpdir"), "gate-benchmark-log.txt"));
                    String maxDocs = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportmaxdocs");
                    if (maxDocs != null) {
                        report.setMaxDocumentInReport(maxDocs.equals("All") ? -1 : Integer.parseInt(maxDocs));
                    }
                    if ((prRegex = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportprregex")) != null) {
                        report.setPRMatchingRegex(prRegex.equals("") ? "all_prs" : prRegex);
                    }
                    try {
                        report.executeReport();
                    }
                    catch (BenchmarkReportException e) {
                        e.printStackTrace();
                        return;
                    }
                    MainFrame.this.showHelpFrame("file://" + report.getReportFile(), "documents time report");
                }
            }, this));
            String maxDocs = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportmaxdocs");
            if (maxDocs == null) {
                maxDocs = "10";
            }
            reportMenu.add(new XJMenuItem(new AbstractAction("Set Max Documents (" + maxDocs + ")"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Object response = JOptionPane.showInputDialog(instance, "Set the maximum of documents to report", "Report options", 3, null, new Object[]{"All", "10", "20", "30", "40", "50", "100"}, "10");
                    if (response != null) {
                        Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportmaxdocs"), response);
                        this.putValue("Name", "Set Max Documents (" + response + ")");
                    }
                }
            }, this));
            String prRegex = Gate.getUserConfig().getString(MainFrame.class.getName() + ".reportprregex");
            if (prRegex == null || prRegex.equals("")) {
                prRegex = "All";
            }
            reportMenu.add(new XJMenuItem(new AbstractAction("Set PR Matching Regex (" + prRegex + ")"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String response = JOptionPane.showInputDialog(instance, "Set the processing resource regex filter\nLeave empty to not filter", "Report options", 3);
                    if (response != null) {
                        Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".reportprregex"), response);
                        if (response.equals("")) {
                            response = "All";
                        }
                        this.putValue("Name", "Set PR Matching Regex (" + response + ")");
                    }
                }
            }, this));
            toolsMenu.add(reportMenu);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"log4j.jar not found on the classpath, disabling profiling reports.");
        }
        toolsMenu.add(new XJMenuItem(new NewBootStrapAction(), this));
        XJMenu corpusEvalMenu = new XJMenu("Corpus Benchmark", "Compares processed and human-annotated annotations", this);
        corpusEvalMenu.setIcon(MainFrame.getIcon("corpus-benchmark"));
        toolsMenu.add(corpusEvalMenu);
        corpusEvalMenu.add(new XJMenuItem(new NewCorpusEvalAction(), this));
        corpusEvalMenu.addSeparator();
        corpusEvalMenu.add(new XJMenuItem(new GenerateStoredCorpusEvalAction(), this));
        corpusEvalMenu.addSeparator();
        corpusEvalMenu.add(new XJMenuItem(new StoredMarkedCorpusEvalAction(), this));
        corpusEvalMenu.add(new XJMenuItem(new CleanMarkedCorpusEvalAction(), this));
        corpusEvalMenu.addSeparator();
        this.verboseModeItem = new JCheckBoxMenuItem(new VerboseModeCorpusEvalToolAction());
        corpusEvalMenu.add(this.verboseModeItem);
        toolsMenu.add(new XJMenuItem(new UpgradeXGAPP.UpgradeAction(), this));
        toolsMenu.staticItemsAdded();
        this.menuBar.add(toolsMenu);
        XJMenu helpMenu = new XJMenu("Help", null, this);
        helpMenu.setMnemonic(72);
        helpMenu.add(new XJMenuItem(new HelpUserGuideAction(), this));
        helpMenu.add(new XJMenuItem(new HelpUserGuideInContextAction(), this));
        helpMenu.add(new XJMenuItem(new AbstractAction("Keyboard Shortcuts"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showHelpFrame("sec:developer:keyboard", "shortcuts");
            }
        }, this));
        helpMenu.addSeparator();
        helpMenu.add(new XJMenuItem(new AbstractAction("Using GATE Developer"){
            {
                this.putValue("ShortDescription", "To read first");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showHelpFrame("chap:developer", "Using GATE Developer");
            }
        }, this));
        helpMenu.add(new XJMenuItem(new AbstractAction("Demo Movies"){
            {
                this.putValue("ShortDescription", "Movie tutorials");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showHelpFrame("http://gate.ac.uk/demos/developer-videos/", "movies");
            }
        }, this));
        helpMenu.addSeparator();
        JCheckBoxMenuItem toggleToolTipsCheckBoxMenuItem = new JCheckBoxMenuItem(new ToggleToolTipsAction());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".hidetooltips").booleanValue()) {
            toolTipManager.setEnabled(false);
            toggleToolTipsCheckBoxMenuItem.setSelected(false);
        } else {
            toolTipManager.setEnabled(true);
            toggleToolTipsCheckBoxMenuItem.setSelected(true);
        }
        helpMenu.add(toggleToolTipsCheckBoxMenuItem);
        helpMenu.add(new XJMenuItem(new AbstractAction("What's New"){
            {
                this.putValue("ShortDescription", "List new features and important changes");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showHelpFrame("chap:changes", "changes");
            }
        }, this));
        if (!Gate.runningOnMac()) {
            helpMenu.add(new XJMenuItem(new HelpAboutAction(), this));
        }
        this.menuBar.add(helpMenu);
        this.setJMenuBar(this.menuBar);
        this.lrsPopup = new XJPopupMenu();
        LiveMenu lrsMenu = new LiveMenu(1);
        lrsMenu.setText("New");
        this.lrsPopup.add(lrsMenu);
        guiRoots.add(this.lrsPopup);
        guiRoots.add(lrsMenu);
        this.prsPopup = new XJPopupMenu();
        LiveMenu prsMenu = new LiveMenu(2);
        prsMenu.setText("New");
        this.prsPopup.add(prsMenu);
        guiRoots.add(this.prsPopup);
        guiRoots.add(prsMenu);
        this.dssPopup = new XJPopupMenu();
        this.dssPopup.add(new NewDSAction());
        this.dssPopup.add(new OpenDSAction());
        guiRoots.add(this.dssPopup);
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        JButton button = new JButton(new LoadResourceFromFileAction());
        button.setToolTipText(button.getText());
        button.setText("");
        this.toolbar.add(button);
        this.toolbar.addSeparator();
        try {
            JButton annieMenu = new JButton(new LoadApplicationAction("ANNIE", "annie-application", new ResourceReference(new URI("creole://uk.ac.gate.plugins;annie;8.5/resources/ANNIE_with_defaults.gapp"))));
            annieMenu.setText("");
            annieMenu.setToolTipText("Load ANNIE");
            this.toolbar.add(annieMenu);
            this.toolbar.addSeparator();
        }
        catch (URISyntaxException annieMenu) {
            // empty catch block
        }
        LiveMenu tbNewLRMenu = new LiveMenu(1);
        JMenuButton menuButton = new JMenuButton(tbNewLRMenu);
        menuButton.setToolTipText("New Language Resource");
        menuButton.setIcon(MainFrame.getIcon("lrs"));
        this.toolbar.add(menuButton);
        LiveMenu tbNewPRMenu = new LiveMenu(2);
        menuButton = new JMenuButton(tbNewPRMenu);
        menuButton.setToolTipText("New Processing Resource");
        menuButton.setIcon(MainFrame.getIcon("prs"));
        this.toolbar.add(menuButton);
        LiveMenu tbNewAppMenu = new LiveMenu(3);
        menuButton = new JMenuButton(tbNewAppMenu);
        menuButton.setToolTipText("New Application");
        menuButton.setIcon(MainFrame.getIcon("applications"));
        this.toolbar.add(menuButton);
        this.toolbar.addSeparator();
        JPopupMenu tbDsMenu = new JPopupMenu();
        tbDsMenu.add(new NewDSAction());
        tbDsMenu.add(new OpenDSAction());
        menuButton = new JMenuButton(tbDsMenu);
        menuButton.setToolTipText("Datastores");
        menuButton.setIcon(MainFrame.getIcon("datastores"));
        this.toolbar.add(menuButton);
        this.toolbar.addSeparator();
        button = new JButton(new ManagePluginsAction());
        button.setToolTipText(button.getText());
        button.setText("");
        this.toolbar.add(button);
        this.toolbar.addSeparator();
        button = new JButton(new NewAnnotDiffAction());
        button.setToolTipText(button.getText());
        button.setText("");
        this.toolbar.add(button);
        this.toolbar.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)this.toolbar, "North");
    }

    protected void initListeners() {
        Gate.getCreoleRegister().addCreoleListener(this);
        Gate.getCreoleRegister().addPluginListener(this);
        this.resourcesTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    new ShowSelectedResourcesAction().actionPerformed(null);
                } else if (e.getKeyCode() == 127) {
                    new CloseSelectedResourcesAction().actionPerformed(null);
                } else if (e.getKeyCode() == 127 && e.getModifiers() == 64) {
                    new CloseRecursivelySelectedResourcesAction().actionPerformed(null);
                }
            }
        });
        this.resourcesTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = MainFrame.this.resourcesTree.getClosestPathForLocation(e.getX(), e.getY());
                if (e.isPopupTrigger() && !MainFrame.this.resourcesTree.isPathSelected(path)) {
                    MainFrame.this.resourcesTree.getSelectionModel().setSelectionPath(path);
                }
                this.processMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processMouseEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.processMouseEvent(e);
            }

            protected void processMouseEvent(MouseEvent e) {
                Object value;
                int x = e.getX();
                int y = e.getY();
                TreePath path = MainFrame.this.resourcesTree.getClosestPathForLocation(x, y);
                JPopupMenu popup = null;
                Handle handle = null;
                if (path != null && (value = path.getLastPathComponent()) != MainFrame.this.resourcesTreeRoot) {
                    if (value == MainFrame.this.applicationsRoot) {
                        MainFrame.this.appsPopup = new XJPopupMenu();
                        LiveMenu appsMenu = new LiveMenu(3);
                        appsMenu.setText("Create New Application");
                        appsMenu.setIcon(MainFrame.getIcon("applications"));
                        MainFrame.this.appsPopup.add(appsMenu);
                        MainFrame.this.appsPopup.add(new ReadyMadeMenu());
                        MainFrame.this.appsPopup.add(new XJMenuItem(new LoadResourceFromFileAction(), MainFrame.this));
                        RecentAppsMenu recentApps = new RecentAppsMenu();
                        if (recentApps.getMenuComponentCount() > 0) {
                            MainFrame.this.appsPopup.add(recentApps);
                        }
                        popup = MainFrame.this.appsPopup;
                    } else if (value == MainFrame.this.languageResourcesRoot) {
                        popup = MainFrame.this.lrsPopup;
                    } else if (value == MainFrame.this.processingResourcesRoot) {
                        popup = MainFrame.this.prsPopup;
                    } else if (value == MainFrame.this.datastoresRoot) {
                        popup = MainFrame.this.dssPopup;
                    } else if ((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof Handle) {
                        handle = (Handle)value;
                        String resName = handle.getTarget().getClass().getName();
                        fileChooser.setResource(resName);
                        resourceReferenceChooser.setResource(resName);
                        if (e.isPopupTrigger()) {
                            popup = handle.getPopup();
                        }
                    }
                }
                if (e.isPopupTrigger()) {
                    if (MainFrame.this.resourcesTree.getSelectionCount() > 1) {
                        Object userObject;
                        TreePath[] selectedPaths;
                        popup = new XJPopupMenu();
                        popup.add(new XJMenuItem(new CloseSelectedResourcesAction(), MainFrame.this));
                        for (TreePath selectedPath : selectedPaths = MainFrame.this.resourcesTree.getSelectionPaths()) {
                            userObject = ((DefaultMutableTreeNode)selectedPath.getLastPathComponent()).getUserObject();
                            if (!(userObject instanceof NameBearerHandle) || !(((NameBearerHandle)userObject).getTarget() instanceof Controller)) continue;
                            popup.add(new XJMenuItem(new CloseRecursivelySelectedResourcesAction(), MainFrame.this));
                            break;
                        }
                        for (TreePath selectedPath : selectedPaths = MainFrame.this.resourcesTree.getSelectionPaths()) {
                            userObject = ((DefaultMutableTreeNode)selectedPath.getLastPathComponent()).getUserObject();
                            if (!(userObject instanceof Handle) || ((Handle)userObject).viewsBuilt() && MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)userObject).getLargeView()) != -1) continue;
                            popup.add(new XJMenuItem(new ShowSelectedResourcesAction(), MainFrame.this));
                            break;
                        }
                        for (TreePath selectedPath : selectedPaths = MainFrame.this.resourcesTree.getSelectionPaths()) {
                            userObject = ((DefaultMutableTreeNode)selectedPath.getLastPathComponent()).getUserObject();
                            if (!(userObject instanceof Handle) || !((Handle)userObject).viewsBuilt() || ((Handle)userObject).getLargeView() == null || MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)userObject).getLargeView()) == -1) continue;
                            popup.add(new XJMenuItem(new CloseViewsForSelectedResourcesAction(), MainFrame.this));
                            break;
                        }
                        popup.show(MainFrame.this.resourcesTree, e.getX(), e.getY());
                    } else if (popup != null) {
                        if (handle != null) {
                            if (handle instanceof NameBearerHandle) {
                                popup.insert(new XJMenuItem(((NameBearerHandle)handle).getCloseAction(), MainFrame.this), 0);
                            }
                            if (handle instanceof NameBearerHandle && handle.getTarget() instanceof Controller) {
                                popup.insert(new XJMenuItem(((NameBearerHandle)handle).getCloseRecursivelyAction(), MainFrame.this), 1);
                            }
                            if (handle.viewsBuilt() && handle.getLargeView() != null && MainFrame.this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
                                popup.insert(new XJMenuItem(new CloseViewAction(handle), MainFrame.this), 2);
                            } else {
                                popup.insert(new XJMenuItem(new ShowResourceAction(handle), MainFrame.this), 2);
                            }
                            popup.insert(new XJMenuItem(new RenameResourceAction(path), MainFrame.this), 3);
                            if (handle instanceof NameBearerHandle) {
                                popup.insert(new XJMenuItem(new HelpOnItemTreeAction((NameBearerHandle)handle), MainFrame.this), 4);
                            }
                        }
                        popup.show(MainFrame.this.resourcesTree, e.getX(), e.getY());
                    }
                } else if (e.getID() == 500 && e.getClickCount() == 2 && handle != null) {
                    MainFrame.this.select(handle);
                }
            }
        });
        this.resourcesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object value;
                Object object;
                if (!Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".treeselectview").booleanValue()) {
                    return;
                }
                if (MainFrame.this.resourcesTree.getSelectionPaths() != null && MainFrame.this.resourcesTree.getSelectionPaths().length == 1 && (object = ((DefaultMutableTreeNode)(value = e.getPath().getLastPathComponent())).getUserObject()) instanceof Handle && ((Handle)object).viewsBuilt() && MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)object).getLargeView()) != -1) {
                    MainFrame.this.select((Handle)object);
                }
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("control F4"), "Close resource");
        inputMap.put(KeyStroke.getKeyStroke("shift F4"), "Close recursively");
        inputMap.put(KeyStroke.getKeyStroke("control H"), "Hide");
        inputMap.put(KeyStroke.getKeyStroke("control shift H"), "Hide all");
        inputMap.put(KeyStroke.getKeyStroke("control S"), "Save As XML");
        if (inputMap.get(KeyStroke.getKeyStroke("CONTEXT_MENU")) == null) {
            inputMap.put(KeyStroke.getKeyStroke("CONTEXT_MENU"), "Show context menu");
        }
        ActionMap actionMap = ((JComponent)instance.getContentPane()).getActionMap();
        actionMap.put("Show context menu", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focusedComponent = focusManager.getFocusOwner();
                if (focusedComponent != null) {
                    Point menuLocation = null;
                    Rectangle selectionRectangle = null;
                    if (focusedComponent instanceof JTable && ((JTable)focusedComponent).getSelectedRowCount() > 0) {
                        JTable table = (JTable)focusedComponent;
                        selectionRectangle = table.getCellRect(table.getSelectionModel().getLeadSelectionIndex(), table.convertColumnIndexToView(table.getSelectedColumn()), false);
                    } else if (focusedComponent instanceof JTree && ((JTree)focusedComponent).getSelectionCount() > 0) {
                        JTree tree = (JTree)focusedComponent;
                        selectionRectangle = tree.getRowBounds(tree.getSelectionModel().getLeadSelectionRow());
                    } else {
                        menuLocation = new Point(focusedComponent.getX() - 1, focusedComponent.getY() - 1);
                    }
                    if (menuLocation == null) {
                        menuLocation = new Point(new Double(selectionRectangle.getMinX() + 1.0).intValue(), new Double(selectionRectangle.getMaxY() - 1.0).intValue());
                    }
                    focusedComponent.dispatchEvent(new MouseEvent(focusedComponent, 501, e.getWhen(), 4096, menuLocation.x, menuLocation.y, 1, true, 3));
                }
            }
        });
        this.mainTabbedPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JComponent largeView = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent();
                Enumeration<TreeNode> nodesEnum = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
                boolean done = false;
                DefaultMutableTreeNode node = MainFrame.this.resourcesTreeRoot;
                while (!done && nodesEnum.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)nodesEnum.nextElement();
                    done = node.getUserObject() instanceof Handle && ((Handle)node.getUserObject()).viewsBuilt() && ((Handle)node.getUserObject()).getLargeView() == largeView;
                }
                ActionMap actionMap = ((JComponent)instance.getContentPane()).getActionMap();
                if (done) {
                    Handle handle = (Handle)node.getUserObject();
                    if (Gate.getUserConfig().getBoolean(MainFrame.class.getName() + ".viewselecttree").booleanValue()) {
                        TreePath nodePath = new TreePath(node.getPath());
                        MainFrame.this.resourcesTree.setSelectionPath(nodePath);
                        MainFrame.this.resourcesTree.scrollPathToVisible(nodePath);
                    }
                    MainFrame.this.lowerScroll.getViewport().setView(handle.getSmallView());
                    JComponent resource = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent();
                    actionMap.put("Close resource", resource.getActionMap().get("Close resource"));
                    actionMap.put("Close recursively", resource.getActionMap().get("Close recursively"));
                    actionMap.put("Hide", new CloseViewAction(handle));
                    actionMap.put("Hide all", new HideAllAction());
                    actionMap.put("Save As XML", resource.getActionMap().get("Save As XML"));
                } else {
                    MainFrame.this.lowerScroll.getViewport().setView(null);
                    actionMap.put("Close resource", null);
                    actionMap.put("Close recursively", null);
                    actionMap.put("Hide", null);
                    actionMap.put("Hide all", null);
                    actionMap.put("Save As XML", null);
                }
            }
        });
        this.mainTabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.processMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processMouseEvent(e);
            }

            protected void processMouseEvent(MouseEvent e) {
                int index;
                if (e.isPopupTrigger() && (index = MainFrame.this.mainTabbedPane.getIndexAt(e.getPoint())) != -1) {
                    JComponent view = (JComponent)MainFrame.this.mainTabbedPane.getComponentAt(index);
                    Enumeration<TreeNode> nodesEnum = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
                    boolean done = false;
                    DefaultMutableTreeNode node = MainFrame.this.resourcesTreeRoot;
                    while (!done && nodesEnum.hasMoreElements()) {
                        node = (DefaultMutableTreeNode)nodesEnum.nextElement();
                        done = node.getUserObject() instanceof Handle && ((Handle)node.getUserObject()).viewsBuilt() && ((Handle)node.getUserObject()).getLargeView() == view;
                    }
                    if (done) {
                        Handle handle = (Handle)node.getUserObject();
                        JPopupMenu popup = handle.getPopup();
                        CloseViewAction cva = new CloseViewAction(handle);
                        XJMenuItem menuItem = new XJMenuItem(cva, MainFrame.this);
                        popup.insert(menuItem, 0);
                        if (MainFrame.this.mainTabbedPane.getTabCount() > 2) {
                            HideAllAction haa = new HideAllAction();
                            menuItem = new XJMenuItem(haa, MainFrame.this);
                            popup.insert(menuItem, 1);
                        }
                        popup.show(MainFrame.this.mainTabbedPane, e.getX(), e.getY());
                    }
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MainFrame.this.leftSplit.setDividerLocation(0.7);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                int width = MainFrame.this.getWidth();
                MainFrame.this.statusBar.setPreferredSize(new Dimension(width * 65 / 100, MainFrame.this.statusBar.getPreferredSize().height));
                MainFrame.this.progressBar.setPreferredSize(new Dimension(width * 20 / 100, MainFrame.this.progressBar.getPreferredSize().height));
                MainFrame.this.progressBar.setMinimumSize(new Dimension(80, 0));
                MainFrame.this.globalProgressBar.setPreferredSize(new Dimension(width * 10 / 100, MainFrame.this.globalProgressBar.getPreferredSize().height));
                MainFrame.this.globalProgressBar.setMinimumSize(new Dimension(80, 0));
            }
        });
        this.logArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeOccured();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeOccured();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            protected void changeOccured() {
                MainFrame.this.logHighlighter.highlight();
            }
        });
        this.logArea.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainFrame.this.logArea.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.changeOccured();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.changeOccured();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.changeOccured();
                    }

                    protected void changeOccured() {
                        MainFrame.this.logHighlighter.highlight();
                    }
                });
            }
        });
        Gate.getListeners().put("gate.event.StatusListener", this);
        Gate.getListeners().put("gate.event.ProgressListener", this);
        if (Gate.runningOnMac()) {
            this.initMacListeners();
        }
    }

    protected void initMacListeners() {
        try {
            Object applicationObject = Desktop.getDesktop();
            Class applicationClass = Desktop.class;
            Class<?> aboutHandlerClass = null;
            Class<?> preferencesHandlerClass = null;
            Class<Enum> quitStrategyClass = null;
            try {
                aboutHandlerClass = Gate.getClassLoader().loadClass("java.awt.desktop.AboutHandler");
                preferencesHandlerClass = Gate.getClassLoader().loadClass("java.awt.desktop.PreferencesHandler");
                quitStrategyClass = Gate.getClassLoader().loadClass("java.awt.desktop.QuitStrategy").asSubclass(Enum.class);
            }
            catch (ClassNotFoundException e) {
                applicationClass = Gate.getClassLoader().loadClass("com.apple.eawt.Application");
                Method getApplicationMethod = applicationClass.getMethod("getApplication", new Class[0]);
                applicationObject = getApplicationMethod.invoke(null, new Object[0]);
                aboutHandlerClass = Gate.getClassLoader().loadClass("com.apple.eawt.AboutHandler");
                preferencesHandlerClass = Gate.getClassLoader().loadClass("com.apple.eawt.PreferencesHandler");
                quitStrategyClass = Gate.getClassLoader().loadClass("com.apple.eawt.QuitStrategy").asSubclass(Enum.class);
            }
            InvocationHandler handler = new InvocationHandler(){
                private Action aboutAction;
                {
                    this.aboutAction = new HelpAboutAction();
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    SwingUtilities.invokeLater(() -> {
                        if ("handleAbout".equals(method.getName())) {
                            this.aboutAction.actionPerformed(null);
                        } else if ("handlePreferences".equals(method.getName())) {
                            MainFrame.this.optionsDialog.showDialog();
                            MainFrame.this.optionsDialog.dispose();
                        }
                    });
                    return null;
                }
            };
            Object applicationListenerObject = Proxy.newProxyInstance(Gate.getClassLoader(), new Class[]{aboutHandlerClass, preferencesHandlerClass}, handler);
            applicationClass.getMethod("setAboutHandler", aboutHandlerClass).invoke(applicationObject, applicationListenerObject);
            applicationClass.getMethod("setPreferencesHandler", preferencesHandlerClass).invoke(applicationObject, applicationListenerObject);
            applicationClass.getMethod("setQuitStrategy", quitStrategyClass).invoke(applicationObject, Enum.valueOf(quitStrategyClass, "CLOSE_ALL_WINDOWS"));
        }
        catch (Throwable error) {
            String message = "There was a problem setting up the Mac application\nmenu.  Your options/session will not be saved if you exit\nwith \u2318Q, use the close button at the top-leftcorner\nof this window instead.";
            log.error((Object)message, error);
        }
    }

    @Override
    public void progressChanged(int i) {
        int oldValue = this.progressBar.getValue();
        if (!this.animator.isActive()) {
            this.animator.activate();
        }
        if (oldValue != i) {
            SwingUtilities.invokeLater(new ProgressBarUpdater(i));
        }
    }

    @Override
    public void processFinished() {
        SwingUtilities.invokeLater(new ProgressBarUpdater(0));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.globalProgressBar.setVisible(false);
            }
        });
        this.animator.deactivate();
    }

    @Override
    public void statusChanged(String text) {
        SwingUtilities.invokeLater(new StatusBarUpdater(text));
        if (text != null) {
            Matcher m = START_RUNNING_PATTERN.matcher(text);
            if (m.matches()) {
                final int corpusSize = Integer.parseInt(m.group(1));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.globalProgressBar.setMaximum(corpusSize);
                        MainFrame.this.globalProgressBar.setValue(0);
                        MainFrame.this.globalProgressBar.setString("0/" + corpusSize);
                        MainFrame.this.globalProgressBar.setVisible(true);
                    }
                });
            } else if (text.startsWith("Finished running ")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.globalProgressBar.setValue(MainFrame.this.globalProgressBar.getValue() + 1);
                        MainFrame.this.globalProgressBar.setString(MainFrame.this.globalProgressBar.getValue() + "/" + MainFrame.this.globalProgressBar.getMaximum());
                    }
                });
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
        Resource res = e.getResource();
        if (Gate.getHiddenAttribute(res.getFeatures()) || res instanceof VisualResource) {
            return;
        }
        NameBearerHandle handle = null;
        if (res instanceof Controller) {
            handle = new NameBearerHandle(res, this);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(handle, false);
            this.resourcesTreeModel.insertNodeInto(node, this.applicationsRoot, 0);
        } else if (res instanceof ProcessingResource) {
            handle = new NameBearerHandle(res, this);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(handle, false);
            this.resourcesTreeModel.insertNodeInto(node, this.processingResourcesRoot, 0);
        } else if (res instanceof LanguageResource) {
            handle = new NameBearerHandle(res, this);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(handle, false);
            this.resourcesTreeModel.insertNodeInto(node, this.languageResourcesRoot, 0);
        }
        if (handle != null) {
            handle.addProgressListener(this);
        }
        if (handle != null) {
            handle.addStatusListener(this);
        }
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        final Resource res = e.getResource();
        if (Gate.getHiddenAttribute(res.getFeatures())) {
            return;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode parent = null;
                if (res instanceof Controller) {
                    parent = MainFrame.this.applicationsRoot;
                } else if (res instanceof ProcessingResource) {
                    parent = MainFrame.this.processingResourcesRoot;
                } else if (res instanceof LanguageResource) {
                    parent = MainFrame.this.languageResourcesRoot;
                }
                if (parent != null) {
                    Enumeration<TreeNode> children = parent.children();
                    while (children.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
                        if (((NameBearerHandle)node.getUserObject()).getTarget() != res) continue;
                        MainFrame.this.resourcesTreeModel.removeNodeFromParent(node);
                        Handle handle = (Handle)node.getUserObject();
                        if (handle.viewsBuilt()) {
                            if (MainFrame.this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
                                MainFrame.this.mainTabbedPane.remove(handle.getLargeView());
                            }
                            if (MainFrame.this.lowerScroll.getViewport().getView() == handle.getSmallView()) {
                                MainFrame.this.lowerScroll.getViewport().setView(null);
                            }
                        }
                        handle.cleanup();
                        return;
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
        final DataStore ds = e.getDatastore();
        if (ds.getName() == null || ds.getName().length() == 0) {
            String name = ds.getStorageUrl();
            StringBuilder nameBuilder = new StringBuilder();
            int state = 0;
            block4: for (int i = name.length() - 1; i >= 0 && state != 2; --i) {
                char currentChar = name.charAt(i);
                switch (state) {
                    case 0: {
                        if (currentChar == '/') continue block4;
                        state = 1;
                        nameBuilder.insert(0, currentChar);
                        continue block4;
                    }
                    case 1: {
                        if (currentChar == '/') {
                            state = 2;
                            continue block4;
                        }
                        nameBuilder.insert(0, currentChar);
                        continue block4;
                    }
                    default: {
                        throw new GateRuntimeException("A phanthom state of things!");
                    }
                }
            }
            if (nameBuilder.length() > 0) {
                name = nameBuilder.toString();
            }
            ds.setName(name);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NameBearerHandle handle = new NameBearerHandle(ds, MainFrame.this);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(handle, false);
                MainFrame.this.resourcesTreeModel.insertNodeInto(node, MainFrame.this.datastoresRoot, 0);
                handle.addProgressListener(MainFrame.this);
                handle.addStatusListener(MainFrame.this);
            }
        });
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
        this.datastoreOpened(e);
    }

    @Override
    public void datastoreClosed(final CreoleEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataStore ds = e.getDatastore();
                DefaultMutableTreeNode parent = MainFrame.this.datastoresRoot;
                if (parent != null) {
                    Enumeration<TreeNode> children = parent.children();
                    while (children.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
                        if (((NameBearerHandle)node.getUserObject()).getTarget() != ds) continue;
                        MainFrame.this.resourcesTreeModel.removeNodeFromParent(node);
                        NameBearerHandle handle = (NameBearerHandle)node.getUserObject();
                        if (handle.viewsBuilt()) {
                            if (MainFrame.this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
                                MainFrame.this.mainTabbedPane.remove(handle.getLargeView());
                            }
                            if (MainFrame.this.lowerScroll.getViewport().getView() == handle.getSmallView()) {
                                MainFrame.this.lowerScroll.getViewport().setView(null);
                            }
                        }
                        return;
                    }
                }
            }
        });
    }

    @Override
    public void resourceRenamed(final Resource resource, final String oldName, final String newName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Handle handle = MainFrame.this.findHandleForResource(resource);
                if (handle != null && handle.viewsBuilt()) {
                    for (int i = 0; i < MainFrame.this.mainTabbedPane.getTabCount(); ++i) {
                        if (!MainFrame.this.mainTabbedPane.getTitleAt(i).equals(oldName) || MainFrame.this.mainTabbedPane.getComponentAt(i) != handle.getLargeView()) continue;
                        MainFrame.this.mainTabbedPane.setTitleAt(i, newName);
                        return;
                    }
                }
            }
        });
    }

    @Override
    public void pluginLoaded(Plugin plugin) {
    }

    @Override
    public void pluginUnloaded(Plugin plugin) {
        try {
            String classloaderID = plugin.getBaseURI().toString();
            Iterator<String> it = iconByName.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                Icon icon = iconByName.get(name);
                ClassLoader cl = icon.getClass().getClassLoader();
                if (!(cl instanceof GateClassLoader) || !((GateClassLoader)cl).getID().equals(classloaderID)) continue;
                it.remove();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            new ExitGateAction().actionPerformed(null);
        }
        super.processWindowEvent(e);
    }

    public static Collection<Component> getGuiRoots() {
        return guiRoots;
    }

    public static synchronized void lockGUI(final String message) {
        if (MainFrame.getGuiRoots() == null || MainFrame.getGuiRoots().isEmpty()) {
            return;
        }
        MainFrame.unlockGUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] options = new Object[]{new JButton(new StopAction())};
                JOptionPane pane = new JOptionPane(message, 2, -1, null, options, null);
                Component parentComp = (Component)((List)MainFrame.getGuiRoots()).get(0);
                Window parentWindow = parentComp instanceof Window ? (Window)parentComp : SwingUtilities.getWindowAncestor(parentComp);
                JDialog dialog = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow, "Please wait", true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void processWindowEvent(WindowEvent e) {
                        if (e.getID() == 201) {
                            this.getToolkit().beep();
                        }
                    }
                } : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow, "Please wait", true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void processWindowEvent(WindowEvent e) {
                        if (e.getID() == 201) {
                            this.getToolkit().beep();
                        }
                    }
                } : new JDialog(JOptionPane.getRootFrame(), "Please wait", true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void processWindowEvent(WindowEvent e) {
                        if (e.getID() == 201) {
                            this.getToolkit().beep();
                        }
                    }
                });
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)pane, "Center");
                dialog.pack();
                dialog.setLocationRelativeTo(parentComp);
                dialog.setDefaultCloseOperation(0);
                guiLock = dialog;
                guiLock.setVisible(true);
            }
        });
    }

    public static synchronized void unlockGUI() {
        Thread t = new Thread(){

            @Override
            public void run() {
                if (MainFrame.getGuiRoots() == null || MainFrame.getGuiRoots().isEmpty()) {
                    return;
                }
                if (guiLock != null) {
                    guiLock.setVisible(false);
                    guiLock.dispose();
                }
                guiLock = null;
            }
        };
        SwingUtilities.invokeLater(t);
    }

    public void setTitleChangable(boolean isChangable) {
        this.titleChangable = isChangable;
    }

    @Override
    public synchronized void setTitle(String title) {
        if (this.titleChangable) {
            super.setTitle(title);
        }
    }

    protected DataStore createSerialDataStore() {
        DataStore ds = null;
        fileChooser.setDialogTitle("Please create a new empty directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setResource("gate.persist.SerialDataStore");
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL dsURL = fileChooser.getSelectedFile().toURI().toURL();
                ds = Factory.createDataStore("gate.persist.SerialDataStore", dsURL.toExternalForm());
            }
            catch (MalformedURLException mue) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + mue.toString(), "GATE", 0);
            }
            catch (PersistenceException pe) {
                JOptionPane.showMessageDialog(this, "Datastore creation error!\n " + pe.toString(), "GATE", 0);
            }
        }
        return ds;
    }

    protected DataStore openSerialDataStore() {
        DataStore ds = null;
        fileChooser.setDialogTitle("Select the datastore directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setResource("gate.persist.SerialDataStore");
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL dsURL = fileChooser.getSelectedFile().toURI().toURL();
                ds = Factory.openDataStore("gate.persist.SerialDataStore", dsURL.toExternalForm());
            }
            catch (MalformedURLException mue) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + mue.toString(), "GATE", 0);
            }
            catch (PersistenceException pe) {
                JOptionPane.showMessageDialog(this, "Datastore opening error!\n " + pe.toString(), "GATE", 0);
            }
        }
        return ds;
    }

    protected DataStore openDocServiceDataStore() {
        DataStore ds = null;
        try {
            String DSLocation = JOptionPane.showInputDialog(this, "Enter document service URL", "http://localhost:8080/docservice/services/docservice");
            ds = Factory.openDataStore("gleam.docservice.gate.DocServiceDataStore", DSLocation);
        }
        catch (Exception error) {
            String message = "Error when opening the Datastore.";
            log.error((Object)message, (Throwable)error);
        }
        return ds;
    }

    protected DataStore createSearchableDataStore() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            JTextField dsLocation = new JTextField("", 20);
            dsLocation.setEditable(false);
            final JTextField indexLocation = new JTextField("", 20);
            indexLocation.setToolTipText("directory to store the the lucene index");
            JTextField btat = new JTextField("Token", 20);
            btat.setToolTipText("Examples: Token, AnnotationSetName.Token, <null>.Token");
            JCheckBox createTokensAutomatically = new JCheckBox("Create Tokens Automatically");
            createTokensAutomatically.setSelected(true);
            JTextField iuat = new JTextField("", 20);
            iuat.setToolTipText("Examples: Sentence, AnnotationSetName.Sentence, <null>.Sentence");
            final ArrayList<String> inputASList = new ArrayList<String>();
            inputASList.add("Key");
            inputASList.add("<null>");
            final JTextField inputAS = new JTextField("", 20);
            inputAS.setText("Key;<null>");
            inputAS.setEditable(false);
            JButton editInputAS = new JButton(MainFrame.getIcon("edit-list"));
            editInputAS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ListEditorDialog listEditor = new ListEditorDialog((Component)instance, inputASList, "java.lang.String");
                    List result = listEditor.showDialog();
                    if (result != null) {
                        inputASList.clear();
                        inputASList.addAll(result);
                        if (inputASList.size() > 0) {
                            String text = inputASList.get(0) == null ? "<null>" : (String)inputASList.get(0);
                            for (int j = 1; j < inputASList.size(); ++j) {
                                text = text + ";" + (inputASList.get(j) == null ? "<null>" : (String)inputASList.get(j));
                            }
                            inputAS.setText(text);
                        } else {
                            inputAS.setText("");
                        }
                    }
                }
            });
            JComboBox<String> asie = new JComboBox<String>(new String[]{"include", "exclude"});
            inputAS.setToolTipText("Leave blank for indexing all annotation sets. \"<null>\" indicates the default annotation set");
            final ArrayList<String> fteList = new ArrayList<String>();
            fteList.add("SpaceToken");
            fteList.add("Split");
            final JTextField fte = new JTextField("", 20);
            fte.setText("SpaceToken;Split");
            fte.setEditable(false);
            JButton editFTE = new JButton(MainFrame.getIcon("edit-list"));
            editFTE.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ListEditorDialog listEditor = new ListEditorDialog((Component)instance, fteList, "java.lang.String");
                    List result = listEditor.showDialog();
                    if (result != null) {
                        fteList.clear();
                        fteList.addAll(result);
                        if (fteList.size() > 0) {
                            String text = fteList.get(0) == null ? "<null>" : (String)fteList.get(0);
                            for (int j = 1; j < fteList.size(); ++j) {
                                text = text + ";" + (fteList.get(j) == null ? "<null>" : (String)fteList.get(j));
                            }
                            fte.setText(text);
                        } else {
                            fte.setText("");
                        }
                    }
                }
            });
            JComboBox<String> ftie = new JComboBox<String>(new String[]{"include", "exclude"});
            ftie.setSelectedIndex(1);
            fte.setToolTipText("Leave blank for inclusion of all features");
            JButton indexBrowse = new JButton(MainFrame.getIcon("open-file"));
            indexBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    fileChooser.setDialogTitle("Please create a new empty directory for datastore");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setResource("gate.DataStore.index");
                    if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        try {
                            indexLocation.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (Exception e) {
                            indexLocation.setText("");
                        }
                    }
                }
            });
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 0;
            constraints.gridwidth = 3;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            mainPanel.add((Component)new JLabel("Datastore URL:"), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 0;
            constraints.gridwidth = 6;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 10);
            mainPanel.add((Component)dsLocation, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 1;
            constraints.gridwidth = 3;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            mainPanel.add((Component)new JLabel("Index Location:"), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 1;
            constraints.gridwidth = 5;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 10);
            mainPanel.add((Component)indexLocation, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            mainPanel.add((Component)indexBrowse, constraints);
            indexBrowse.setBorderPainted(false);
            indexBrowse.setContentAreaFilled(false);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 2;
            constraints.gridwidth = 2;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            mainPanel.add((Component)new JLabel("Annotation Sets:"), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 10);
            mainPanel.add(asie, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 2;
            constraints.gridwidth = 5;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 10);
            mainPanel.add((Component)inputAS, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            mainPanel.add((Component)editInputAS, constraints);
            editInputAS.setBorderPainted(false);
            editInputAS.setContentAreaFilled(false);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 3;
            constraints.gridwidth = 3;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            mainPanel.add((Component)new JLabel("Base Token Type:"), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 3;
            constraints.gridwidth = 5;
            constraints.anchor = 18;
            mainPanel.add((Component)btat, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 4;
            constraints.gridy = 4;
            constraints.gridwidth = 5;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            mainPanel.add((Component)createTokensAutomatically, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 5;
            constraints.gridwidth = 3;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            mainPanel.add((Component)new JLabel("Index Unit Type:"), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 5;
            constraints.gridwidth = 5;
            constraints.anchor = 18;
            mainPanel.add((Component)iuat, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 6;
            constraints.gridwidth = 2;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 5);
            mainPanel.add((Component)new JLabel("Features:"), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 6;
            constraints.gridwidth = 1;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 10);
            mainPanel.add(ftie, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 6;
            constraints.gridwidth = 5;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 10);
            mainPanel.add((Component)fte, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 6;
            constraints.gridwidth = 1;
            constraints.anchor = 18;
            mainPanel.add((Component)editFTE, constraints);
            editFTE.setBorderPainted(false);
            editFTE.setContentAreaFilled(false);
            fileChooser.setDialogTitle("Please create a new empty directory");
            fileChooser.setFileSelectionMode(1);
            fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
            fileChooser.setResource("gate.persist.LuceneDataStoreImpl");
            int response = fileChooser.showOpenDialog(this);
            if (response == 0) {
                try {
                    File dsFolder = fileChooser.getSelectedFile();
                    dsLocation.setText(dsFolder.toURI().toURL().toExternalForm());
                    File indexFolder = new File(dsFolder.getParentFile(), dsFolder.getName() + "-index");
                    indexLocation.setText(indexFolder.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException mue) {
                    JOptionPane.showMessageDialog(this, "Invalid location\n " + mue.toString(), "GATE", 0);
                }
            } else {
                return null;
            }
            boolean validEntry = false;
            while (!validEntry) {
                int returnValue = JOptionPane.showOptionDialog(this, mainPanel, "SearchableDataStore", -1, 2, MainFrame.getIcon("empty"), new String[]{"OK", "Cancel"}, "OK");
                if (returnValue == 0) {
                    String[] inputASArray;
                    block25: {
                        if (dsLocation.getText().equals(indexLocation.getText())) {
                            JOptionPane.showMessageDialog(this, "Datastore and index cannot be stored in the same directory", "Error", 0);
                            continue;
                        }
                        try {
                            File indexDir = new File(new URL(indexLocation.getText()).getFile());
                            if (indexDir.exists() && indexDir.isFile()) {
                                JOptionPane.showMessageDialog(this, indexDir.getAbsolutePath() + " is a file on your disk. Index directory must be an empty folder.", "Error", 0);
                                continue;
                            }
                            if (indexDir.isDirectory() && indexDir.list().length > 0) {
                                JOptionPane.showMessageDialog(instance, "Index directory " + indexDir.getAbsolutePath() + " must be an empty folder. ", "Error", 0);
                                continue;
                            }
                            if (!indexDir.exists() && !indexDir.mkdirs()) {
                                JOptionPane.showMessageDialog(this, "Cannot create index directory " + indexDir.getAbsolutePath() + "an empty folder. ", "Error", 0);
                            }
                            break block25;
                        }
                        catch (MalformedURLException mue) {
                            JOptionPane.showMessageDialog(this, "Invalid index location " + indexLocation.getText(), "Error", 0);
                        }
                        catch (SecurityException se) {
                            JOptionPane.showMessageDialog(this, "Could not create a directory " + indexLocation.getText() + " because " + se.getMessage(), "Error", 0);
                        }
                        continue;
                    }
                    validEntry = true;
                    DataStore ds = Factory.createDataStore("gate.persist.LuceneDataStoreImpl", dsLocation.getText());
                    Class[] consParam = new Class[]{URL.class};
                    Constructor<?> constructor = Class.forName("gate.creole.annic.lucene.LuceneIndexer", true, Gate.getClassLoader()).getConstructor(consParam);
                    Object indexer = constructor.newInstance(new URL(indexLocation.getText()));
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("INDEX_LOCATION_URL", new URL(indexLocation.getText()));
                    parameters.put("BASE_TOKEN_ANNOTATION_TYPE", btat.getText());
                    parameters.put("INDEX_UNIT_ANNOTATION_TYPE", iuat.getText());
                    parameters.put("CREATE_TOKENS_AUTOMATICALLY", createTokensAutomatically.isSelected());
                    if (inputAS.getText().trim().length() > 0) {
                        ArrayList<String> inputASList1 = new ArrayList<String>();
                        inputASArray = inputAS.getText().trim().split(";");
                        if (inputASArray != null && inputASArray.length > 0) {
                            inputASList1.addAll(Arrays.asList(inputASArray));
                        }
                        if (asie.getSelectedIndex() == 0) {
                            parameters.put("ANNOTATION_SETS_NAMES_TO_INCLUDE", inputASList1);
                            parameters.put("ANNOTATION_SETS_NAMES_TO_EXCLUDE", new ArrayList());
                        } else {
                            parameters.put("ANNOTATION_SETS_NAMES_TO_EXCLUDE", inputASList1);
                            parameters.put("ANNOTATION_SETS_NAMES_TO_INCLUDE", new ArrayList());
                        }
                    } else {
                        parameters.put("ANNOTATION_SETS_NAMES_TO_EXCLUDE", new ArrayList());
                        parameters.put("ANNOTATION_SETS_NAMES_TO_INCLUDE", new ArrayList());
                    }
                    if (fte.getText().trim().length() > 0) {
                        ArrayList<String> fteList1 = new ArrayList<String>();
                        inputASArray = fte.getText().trim().split(";");
                        if (inputASArray != null && inputASArray.length > 0) {
                            fteList1.addAll(Arrays.asList(inputASArray));
                        }
                        if (ftie.getSelectedIndex() == 0) {
                            parameters.put("FEATURES_TO_INCLUDE", fteList1);
                            parameters.put("FEATURES_TO_EXCLUDE", new ArrayList());
                        } else {
                            parameters.put("FEATURES_TO_EXCLUDE", fteList1);
                            parameters.put("FEATURES_TO_INCLUDE", new ArrayList());
                        }
                    } else {
                        parameters.put("FEATURES_TO_EXCLUDE", new ArrayList());
                        parameters.put("FEATURES_TO_INCLUDE", new ArrayList());
                    }
                    Class[] params = new Class[]{Class.forName("gate.creole.annic.Indexer", true, Gate.getClassLoader()), Map.class};
                    Method indexerMethod = ds.getClass().getMethod("setIndexer", params);
                    indexerMethod.invoke((Object)ds, indexer, parameters);
                    Constructor<?> searcherConst = Class.forName("gate.creole.annic.lucene.LuceneSearcher", true, Gate.getClassLoader()).getConstructor(new Class[0]);
                    Object searcher = searcherConst.newInstance(new Object[0]);
                    Class[] searchParams = new Class[]{Class.forName("gate.creole.annic.Searcher", true, Gate.getClassLoader())};
                    Method searcherMethod = ds.getClass().getMethod("setSearcher", searchParams);
                    searcherMethod.invoke((Object)ds, searcher);
                    return ds;
                }
                validEntry = true;
            }
            return null;
        }
        catch (Exception e) {
            throw new GateRuntimeException(e);
        }
    }

    protected DataStore openSearchableDataStore() {
        DataStore ds = null;
        fileChooser.setDialogTitle("Select the datastore directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setResource("gate.DataStore.data");
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL dsURL = fileChooser.getSelectedFile().toURI().toURL();
                ds = Factory.openDataStore("gate.persist.LuceneDataStoreImpl", dsURL.toExternalForm());
            }
            catch (MalformedURLException mue) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + mue.toString(), "GATE", 0);
            }
            catch (PersistenceException pe) {
                JOptionPane.showMessageDialog(this, "Datastore opening error!\n " + pe.toString(), "GATE", 0);
            }
        }
        return ds;
    }

    public void showHelpFrame(String urlString, String resourceName) {
        URL url;
        if (resourceName == null) {
            resourceName = "unknown";
        }
        if (!(urlString == null || urlString.startsWith("http://") || urlString.startsWith("https://") || urlString.startsWith("file://"))) {
            urlString = "http://gate.ac.uk/userguide/" + urlString;
        }
        try {
            URL baseUrl = new URL(urlString);
            if (baseUrl.toString().startsWith("http://gate.ac.uk/userguide/")) {
                StringBuilder actualURL = new StringBuilder(baseUrl.toString());
                int insertPoint = actualURL.length();
                if (baseUrl.getRef() != null) {
                    insertPoint -= baseUrl.getRef().length() + 1;
                }
                if (baseUrl.getQuery() == null) {
                    actualURL.insert(insertPoint, '?');
                } else {
                    actualURL.insert(insertPoint, "&");
                }
                actualURL.insert(insertPoint + 1, "gateVersion=" + Main.version);
                url = new URL(actualURL.toString());
            } else {
                url = baseUrl;
            }
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, urlString == null ? "There is no help page for this resource !\n\nFind the developer of the resource:\n" + resourceName + "\nand force him/her to put one." : "The URL of the page for " + resourceName + " is invalid.\n" + urlString, "GATE", 1);
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (SecurityException se) {
                    JOptionPane.showMessageDialog(instance, se.getMessage(), "Help Error", 0);
                    log.error((Object)"Help browser Error", (Throwable)se);
                }
                catch (IOException | URISyntaxException ie) {
                    JOptionPane.showMessageDialog(instance, ie.getMessage(), "Help Error", 0);
                    log.error((Object)"Help browser Error", (Throwable)ie);
                }
            }
        };
        Thread thread = new Thread(runnable, "showHelpFrame");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPCache getHttpCache() {
        HTTPCache cache = this.httpCache;
        if (cache == null) {
            MainFrame mainFrame = this;
            synchronized (mainFrame) {
                cache = this.httpCache;
                if (cache == null) {
                    File cacheDir = new File(new File(System.getProperty("user.home"), ".gate"), "download-cache");
                    cacheDir.mkdirs();
                    Object storage = cacheDir.exists() ? new FilePersistentCacheStorage(cacheDir) : new NullCacheStorage();
                    this.httpCache = cache = new HTTPCache((CacheStorage)storage, (ResponseResolver)new JavaNetResponseResolver(new ConnectionConfiguration()));
                }
            }
        }
        return cache;
    }

    public Optional<InputStream> downloadWithCache(String url) {
        HTTPCache cache = this.getHttpCache();
        try {
            return cache.execute(new HTTPRequest(url)).getPayload().map(Payload::getInputStream);
        }
        catch (RuntimeException e) {
            log.warn((Object)"Unable to download list of default plugins. Please check your Internet connection and restart GATE");
            return Optional.empty();
        }
    }

    static {
        iconByName = new HashMap<String, Icon>();
        guiRoots = new ArrayList<Component>();
        ICON_EXTENSIONS = new String[]{"", ".png", ".gif"};
        guiLock = null;
        START_RUNNING_PATTERN = Pattern.compile("Start running .* on (\\d+) documents?");
    }

    class ReadyMadeMenu
    extends XJMenu {
        private static final long serialVersionUID = -4841440121026127302L;
        private XJMenuItem annie;
        private XJMenuItem openNLP;

        public ReadyMadeMenu() {
            super("Ready Made Applications");
            this.setIcon(new ReadyMadeIcon(24, 24));
            try {
                this.annie = new XJMenuItem(new LoadApplicationAction("ANNIE", "annie-application", new ResourceReference(new URI("creole://uk.ac.gate.plugins;annie;8.5/resources/ANNIE_with_defaults.gapp"))), MainFrame.this);
                this.openNLP = new XJMenuItem(new LoadApplicationAction("OpenNLP (English)", "application", new ResourceReference(new URI("creole://uk.ac.gate.plugins;opennlp;8.5/resources/opennlp.gapp"))), MainFrame.this);
                this.addMenuListener(new MenuListener(){

                    @Override
                    public void menuSelected(MenuEvent arg0) {
                        MainFrame.this.statusChanged("");
                    }

                    @Override
                    public void menuDeselected(MenuEvent e) {
                        MainFrame.this.statusChanged("");
                    }

                    @Override
                    public void menuCanceled(MenuEvent e) {
                        this.menuDeselected(e);
                    }
                });
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            Gate.getCreoleRegister().addCreoleListener(new CreoleListener(){

                @Override
                public void resourceLoaded(CreoleEvent e) {
                    if (e.getSource() instanceof PackagedController) {
                        SwingUtilities.invokeLater(() -> ReadyMadeMenu.this.rebuildMenu());
                    }
                }

                @Override
                public void resourceUnloaded(CreoleEvent e) {
                    if (e.getSource() instanceof PackagedController) {
                        SwingUtilities.invokeLater(() -> ReadyMadeMenu.this.rebuildMenu());
                    }
                }

                @Override
                public void datastoreOpened(CreoleEvent e) {
                }

                @Override
                public void datastoreCreated(CreoleEvent e) {
                }

                @Override
                public void datastoreClosed(CreoleEvent e) {
                }

                @Override
                public void resourceRenamed(Resource resource, String oldName, String newName) {
                }
            });
            this.rebuildMenu();
        }

        private void rebuildMenu() {
            this.removeAll();
            XJMenu menu = new XJMenu("ANNIE");
            menu.add(this.annie);
            this.add(menu);
            menu = new XJMenu("OpenNLP");
            menu.add(this.openNLP);
            this.add(menu);
            Set<String> toolTypes = Gate.getCreoleRegister().getApplicationTypes();
            for (String type : toolTypes) {
                List<Resource> instances = ((ResourceData)Gate.getCreoleRegister().get(type)).getInstantiations();
                for (Resource res : instances) {
                    if (!(res instanceof PackagedController)) continue;
                    this.addAppToMenu((PackagedController)res);
                }
            }
            this.revalidate();
        }

        private String getPluginName(URL url) {
            String name = url.getPath();
            int lastSlash = (name = name.substring(0, name.length() - 11)).lastIndexOf("/");
            if (lastSlash != -1) {
                name = name.substring(lastSlash + 1);
            }
            try {
                name = new URI(name).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return name;
        }

        protected void addAppToMenu(PackagedController res) {
            JMenuItem item;
            int pos;
            String[] stringArray;
            ResourceData rd = (ResourceData)Gate.getCreoleRegister().get(res.getClass().getName());
            if (res.getMenu() != null) {
                stringArray = res.getMenu().toArray(new String[res.getMenu().size()]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.getPluginName(rd.getXmlFileUrl());
            }
            String[] menus = stringArray;
            LoadApplicationAction a = new LoadApplicationAction(rd, res.getPipelineURL());
            XJMenu menuToUse = this;
            if (menus != null) {
                block0: for (String pathElement : menus) {
                    int i;
                    for (i = 0; i < menuToUse.getItemCount(); ++i) {
                        JMenuItem item2 = menuToUse.getItem(i);
                        if (item2 instanceof XJMenu && item2.getText().equals(pathElement)) {
                            menuToUse = (XJMenu)item2;
                            continue block0;
                        }
                        if (item2.getText().compareTo(pathElement) > 0) break;
                    }
                    XJMenu newMenu = new XJMenu(pathElement, pathElement, MainFrame.this);
                    menuToUse.insert(newMenu, i);
                    menuToUse = newMenu;
                }
            }
            for (pos = 0; pos < menuToUse.getItemCount() && ((item = menuToUse.getItem(pos)) == null || item.getText().compareTo((String)a.getValue("Name")) <= 0); ++pos) {
            }
            menuToUse.insert(new XJMenuItem(a, MainFrame.this), pos);
        }
    }

    class CartoonMinder
    implements Runnable {
        boolean dying = false;
        boolean active = false;
        JPanel targetPanel;
        JLabel imageLabel;

        CartoonMinder(JPanel targetPanel) {
            this.targetPanel = targetPanel;
            this.imageLabel = new JLabel(MainFrame.getIcon("working"));
            this.imageLabel.setOpaque(false);
            this.imageLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public synchronized boolean isActive() {
            return this.active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activate() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CartoonMinder.this.targetPanel.add(CartoonMinder.this.imageLabel);
                }
            });
            CartoonMinder cartoonMinder = this;
            synchronized (cartoonMinder) {
                this.active = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate() {
            CartoonMinder cartoonMinder = this;
            synchronized (cartoonMinder) {
                this.active = false;
                this.notifyAll();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CartoonMinder.this.targetPanel.removeAll();
                    CartoonMinder.this.targetPanel.repaint();
                }
            });
        }

        public synchronized void dispose() {
            this.dying = true;
            this.notifyAll();
        }

        @Override
        public synchronized void run() {
            while (!this.dying) {
                if (this.active && this.targetPanel.isVisible()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CartoonMinder.this.targetPanel.getParent().getParent().invalidate();
                            CartoonMinder.this.targetPanel.getParent().getParent().repaint();
                        }
                    });
                    try {
                        this.wait(300L);
                    }
                    catch (InterruptedException ie) {
                        log.debug((Object)"Animation interrupted", (Throwable)ie);
                    }
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    log.debug((Object)"Animation interrupted", (Throwable)ie);
                }
            }
        }
    }

    class StatusBarUpdater
    implements Runnable {
        String text;

        StatusBarUpdater(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            MainFrame.this.statusBar.setText(this.text);
        }
    }

    class ProgressBarUpdater
    implements Runnable {
        int value;

        ProgressBarUpdater(int newValue) {
            this.value = newValue;
        }

        @Override
        public void run() {
            if (this.value == 0) {
                MainFrame.this.progressBar.setVisible(false);
            } else {
                MainFrame.this.progressBar.setVisible(true);
            }
            MainFrame.this.progressBar.setValue(this.value);
        }
    }

    protected class ResourcesTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;

        ResourcesTreeModel(TreeNode root, boolean asksAllowChildren) {
            super(root, asksAllowChildren);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = aNode.getUserObject();
            if (userObject instanceof Handle) {
                Handle handle = (Handle)userObject;
                Object target = handle.getTarget();
                if (target instanceof Resource) {
                    Gate.getCreoleRegister().setResourceName((Resource)target, (String)newValue);
                } else if (target instanceof NameBearer) {
                    ((NameBearer)target).setName((String)newValue);
                    for (int i = 0; i < MainFrame.this.mainTabbedPane.getTabCount(); ++i) {
                        if (MainFrame.this.mainTabbedPane.getComponentAt(i) != handle.getLargeView()) continue;
                        MainFrame.this.mainTabbedPane.setTitleAt(i, (String)newValue);
                        break;
                    }
                }
            }
            this.nodeChanged(aNode);
        }
    }

    protected class ResourcesTreeCellEditor
    extends DefaultTreeCellEditor {
        ResourcesTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        protected void startEditingTimer() {
            if (this.timer == null) {
                this.timer = new Timer(500, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Component retValue = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            if (this.renderer != null) {
                this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, false);
                this.editingIcon = this.renderer.getIcon();
            }
            return retValue;
        }
    }

    protected class ResourcesTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        public ResourcesTreeCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value == MainFrame.this.resourcesTreeRoot) {
                this.setIcon(MainFrame.getIcon("GATE"));
                this.setToolTipText("Resources tree root ");
            } else if (value == MainFrame.this.applicationsRoot) {
                this.setIcon(MainFrame.getIcon("Applications"));
                this.setToolTipText("Run processes on data ");
            } else if (value == MainFrame.this.languageResourcesRoot) {
                this.setIcon(MainFrame.getIcon("lrs"));
                this.setToolTipText("Data used for annotating ");
            } else if (value == MainFrame.this.processingResourcesRoot) {
                this.setIcon(MainFrame.getIcon("prs"));
                this.setToolTipText("Processes that annotate data ");
            } else if (value == MainFrame.this.datastoresRoot) {
                this.setIcon(MainFrame.getIcon("Datastores"));
                this.setToolTipText("Repositories for large data ");
            } else if ((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof Handle) {
                this.setIcon(((Handle)value).getIcon());
                this.setText(((Handle)value).getTitle());
                this.setToolTipText(((Handle)value).getTooltipText());
            }
            return this;
        }
    }

    class ToggleToolTipsAction
    extends AbstractAction {
        public ToggleToolTipsAction() {
            super("Show Tooltips");
            this.putValue("ShortDescription", "Tooltips appear in help balloon like this one");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    if (toolTipManager.isEnabled()) {
                        toolTipManager.setEnabled(false);
                        Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".hidetooltips"), (Object)false);
                    } else {
                        toolTipManager.setEnabled(true);
                        Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".hidetooltips"), (Object)true);
                    }
                }
            };
            Thread thread = new Thread(runnable, "ToggleToolTipsAction");
            thread.start();
        }
    }

    class HelpOnItemTreeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        NameBearerHandle resource;

        HelpOnItemTreeAction(NameBearerHandle resource) {
            super("Help");
            this.putValue("ShortDescription", "Help on this resource");
            this.resource = resource;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String helpURL = null;
            String resourceClassName = this.resource.getTarget().getClass().getName();
            if (this.resource.getTarget() instanceof Resource) {
                ResourceData rd = (ResourceData)Gate.getCreoleRegister().get(resourceClassName);
                helpURL = rd.getHelpURL();
            }
            if (helpURL == null) {
                List<String> vrList = Gate.getCreoleRegister().getLargeVRsForResource(resourceClassName);
                for (String vrClass : vrList) {
                    ResourceData vrd = (ResourceData)Gate.getCreoleRegister().get(vrClass);
                    if (vrd == null || vrd.getHelpURL() == null) continue;
                    helpURL = vrd.getHelpURL();
                    break;
                }
            }
            MainFrame.this.showHelpFrame(helpURL, resourceClassName);
        }
    }

    class HelpUserGuideInContextAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpUserGuideInContextAction() {
            super("Contextual User Guide");
            this.putValue("ShortDescription", "Online help for the selected component");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent largeView = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent();
            if (largeView == null) {
                return;
            }
            Enumeration<TreeNode> nodesEnum = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
            boolean done = false;
            DefaultMutableTreeNode node = MainFrame.this.resourcesTreeRoot;
            while (!done && nodesEnum.hasMoreElements()) {
                node = (DefaultMutableTreeNode)nodesEnum.nextElement();
                done = node.getUserObject() instanceof Handle && ((Handle)node.getUserObject()).viewsBuilt() && ((Handle)node.getUserObject()).getLargeView() == largeView;
            }
            if (done && (Handle)node.getUserObject() instanceof NameBearerHandle) {
                new HelpOnItemTreeAction((NameBearerHandle)node.getUserObject()).actionPerformed(null);
            } else if (MainFrame.this.mainTabbedPane.getTitleAt(MainFrame.this.mainTabbedPane.getSelectedIndex()).equals("Messages")) {
                MainFrame.this.showHelpFrame("sec:developer:gui", "messages pane");
            } else {
                MainFrame.this.showHelpFrame(null, node.getUserObject().getClass().getName());
            }
        }
    }

    class HelpUserGuideAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpUserGuideAction() {
            super("User Guide Contents");
            this.putValue("ShortDescription", "Contents of the online user guide");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.showHelpFrame("", "help contents");
        }
    }

    class HelpMailingListAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        String keywords;

        public HelpMailingListAction() {
            super("Search in Mailing List");
            this.putValue("ShortDescription", "Search keywords in GATE users mailing list");
            this.keywords = null;
        }

        public HelpMailingListAction(String keywords) {
            super("Search in Mailing List");
            this.keywords = keywords;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.keywords == null) {
                this.keywords = JOptionPane.showInputDialog(instance, "Please enter your search keywords.", (String)this.getValue("Name"), 3);
                if (this.keywords == null || this.keywords.trim().length() == 0) {
                    return;
                }
            }
            try {
                MainFrame.this.showHelpFrame("http://search.gmane.org/search.php?group=gmane.comp.ai.gate.general&query=" + URLEncoder.encode(this.keywords, "UTF-8"), "mailing list");
            }
            catch (UnsupportedEncodingException error) {
                String message = "The Character Encoding is not supported.";
                log.error((Object)message, (Throwable)error);
            }
            finally {
                this.keywords = null;
            }
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpAboutAction() {
            super("About");
            this.putValue("ShortDescription", "Show developers names and version");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.splash.showSplash();
        }
    }

    class ResourceToolTip
    extends JToolTip {
        private static final long serialVersionUID = 1L;
        JLabel iconLabel;
        JLabel textLabel;
        JPanel tipComponent;

        public ResourceToolTip() {
            this.setLayout(new BoxLayout(this, 0));
            this.tipComponent = new JPanel();
            this.tipComponent.setOpaque(false);
            this.tipComponent.setLayout(new BoxLayout(this.tipComponent, 0));
            this.tipComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.iconLabel = new JLabel(MainFrame.getIcon("annie-application"));
            this.iconLabel.setText(null);
            this.iconLabel.setOpaque(false);
            this.tipComponent.add(this.iconLabel);
            this.textLabel = new JLabel();
            this.textLabel.setOpaque(false);
            this.tipComponent.add(Box.createHorizontalStrut(10));
            this.tipComponent.add(this.textLabel);
            this.add(this.tipComponent);
        }

        @Override
        public void setTipText(String tipText) {
        }

        public void setValue(Object value) {
            if (value != null) {
                if (value instanceof String) {
                    String text = (String)value;
                    if (text.equals("GATE")) {
                        this.textLabel.setText("Resources tree root ");
                        this.iconLabel.setIcon(MainFrame.getIcon("GATE"));
                    } else if (text.equals("Applications")) {
                        this.textLabel.setText("Applications: run processes on data ");
                        this.iconLabel.setIcon(MainFrame.getIcon("applications"));
                    } else if (text.equals("Language Resources")) {
                        this.textLabel.setText("Language Resources: data used for annotating ");
                        this.iconLabel.setIcon(MainFrame.getIcon("lrs"));
                    } else if (text.equals("Processing Resources")) {
                        this.textLabel.setText("Processing Resources: processes that annotate data ");
                        this.iconLabel.setIcon(MainFrame.getIcon("prs"));
                    } else if (text.equals("Datastores")) {
                        this.textLabel.setText("Datastores: repositories for large data ");
                        this.iconLabel.setIcon(MainFrame.getIcon("datastores"));
                    } else {
                        this.textLabel.setText(text);
                        this.iconLabel.setIcon(null);
                    }
                } else if (value instanceof NameBearerHandle) {
                    NameBearerHandle handle = (NameBearerHandle)value;
                    this.textLabel.setText(handle.getTooltipText());
                    this.iconLabel.setIcon(handle.getIcon());
                } else {
                    this.textLabel.setText(null);
                    this.iconLabel.setIcon(null);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = this.tipComponent.getPreferredSize();
            Insets ins = this.getInsets();
            return new Dimension(d.width + ins.left + ins.right, d.height + ins.top + ins.bottom);
        }
    }

    class ResourcesTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        ResourceToolTip myToolTip;

        public ResourcesTree() {
            this.myToolTip = new ResourceToolTip();
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            String res = super.getToolTipText(event);
            if (event != null) {
                Point p = event.getPoint();
                int selRow = this.getRowForLocation(p.x, p.y);
                if (selRow != -1) {
                    TreePath path = this.getPathForRow(selRow);
                    Object lastPath = path.getLastPathComponent();
                    Object value = ((DefaultMutableTreeNode)lastPath).getUserObject();
                    this.myToolTip.setValue(value);
                }
            }
            return res;
        }

        @Override
        public JToolTip createToolTip() {
            return this.myToolTip;
        }
    }

    class ToolsMenu
    extends XJMenu
    implements CreoleListener {
        protected int firstPluginItem;
        protected IdentityHashMap<Resource, List<JMenuItem>> itemsByResource;

        public ToolsMenu(String name, String description, StatusListener listener) {
            super(name, description, listener);
            this.firstPluginItem = 0;
            this.itemsByResource = new IdentityHashMap();
            Gate.getCreoleRegister().addCreoleListener(this);
        }

        public void staticItemsAdded() {
            this.firstPluginItem = this.getItemCount();
            this.processExistingTools();
        }

        protected void processExistingTools() {
            Set<String> toolTypes = Gate.getCreoleRegister().getToolTypes();
            for (String type : toolTypes) {
                List<Resource> instances = ((ResourceData)Gate.getCreoleRegister().get(type)).getInstantiations();
                for (Resource res : instances) {
                    if (!(res instanceof ActionsPublisher)) continue;
                    this.toolLoaded(res);
                }
            }
        }

        @Override
        public void resourceLoaded(CreoleEvent e) {
            Resource res = e.getResource();
            if (((ResourceData)Gate.getCreoleRegister().get(res.getClass().getName())).isTool() && res instanceof ActionsPublisher) {
                this.toolLoaded(res);
            }
        }

        protected void toolLoaded(final Resource res) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    List<Action> actions = ((ActionsPublisher)((Object)res)).getActions();
                    ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
                    for (Action a : actions) {
                        items.add(ToolsMenu.this.addMenuItem(a));
                    }
                    ToolsMenu.this.itemsByResource.put(res, items);
                }
            });
        }

        protected JMenuItem addMenuItem(Action a) {
            JMenuItem item;
            int pos;
            XJMenu menuToUse = this;
            int firstIndex = this.firstPluginItem;
            String[] menuPath = (String[])a.getValue("gate.MenuPath");
            if (menuPath != null) {
                block0: for (String pathElement : menuPath) {
                    int i;
                    for (i = firstIndex; i < menuToUse.getItemCount(); ++i) {
                        JMenuItem item2 = menuToUse.getItem(i);
                        if (item2 instanceof XJMenu && item2.getText().equals(pathElement)) {
                            firstIndex = 0;
                            menuToUse = (XJMenu)item2;
                            continue block0;
                        }
                        if (item2.getText().compareTo(pathElement) > 0) break;
                    }
                    XJMenu newMenu = new XJMenu(pathElement, pathElement, this.listener);
                    menuToUse.insert(newMenu, i);
                    firstIndex = 0;
                    menuToUse = newMenu;
                }
            }
            for (pos = firstIndex; pos < menuToUse.getItemCount() && ((item = menuToUse.getItem(pos)) == null || item.getText().compareTo((String)a.getValue("Name")) <= 0); ++pos) {
            }
            return menuToUse.insert(a.getValue("SwingSelectedKey") == null ? new JMenuItem(a) : new JCheckBoxMenuItem(a), pos);
        }

        @Override
        public void resourceUnloaded(CreoleEvent e) {
            Resource res = e.getResource();
            List<JMenuItem> items = this.itemsByResource.remove(res);
            if (items != null) {
                for (JMenuItem item : items) {
                    this.removeMenuItem(item);
                }
            }
        }

        protected void removeMenuItem(JMenuItem itemToRemove) {
            Action a = itemToRemove.getAction();
            XJMenu menuToUse = this;
            int firstIndex = this.firstPluginItem;
            JMenu parentMenu = null;
            String[] menuPath = (String[])a.getValue("gate.MenuPath");
            if (menuPath != null) {
                for (String pathElement : menuPath) {
                    JMenuItem item;
                    block5: {
                        for (int i = firstIndex; i < menuToUse.getItemCount(); ++i) {
                            item = menuToUse.getItem(i);
                            if (!(item instanceof XJMenu) || !item.getText().equals(pathElement)) {
                                continue;
                            }
                            break block5;
                        }
                        return;
                    }
                    firstIndex = 0;
                    parentMenu = menuToUse;
                    menuToUse = (XJMenu)item;
                }
            }
            menuToUse.remove(itemToRemove);
            if (menuToUse.getItemCount() == 0 && parentMenu != null) {
                parentMenu.remove(menuToUse);
            }
        }

        @Override
        public void datastoreClosed(CreoleEvent e) {
        }

        @Override
        public void datastoreCreated(CreoleEvent e) {
        }

        @Override
        public void datastoreOpened(CreoleEvent e) {
        }

        @Override
        public void resourceRenamed(Resource resource, String oldName, String newName) {
        }
    }

    class RecentAppsMenu
    extends XJMenu {
        public RecentAppsMenu() {
            super("Reload Recent Application");
            this.setIcon(MainFrame.getIcon("open-application"));
            this.init();
            this.addMenuItems();
        }

        protected void init() {
            this.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    MainFrame.this.statusChanged("");
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    RecentAppsMenu.this.removeAll();
                    RecentAppsMenu.this.addMenuItems();
                    if (RecentAppsMenu.this.getMenuComponentCount() == 0) {
                        RecentAppsMenu.this.add("No Recent Applications");
                    }
                }
            });
        }

        protected void addMenuItems() {
            final Map<String, String> locations = fileChooser.getLocations();
            final String list = locations.get("applications");
            if (list == null || list.equals("")) {
                return;
            }
            for (final String name : list.split(";")) {
                final String location = locations.get("application." + name);
                XJMenuItem item = new XJMenuItem(new AbstractAction(name, MainFrame.getIcon("open-application")){
                    {
                        super(x0, x1);
                        this.putValue("ShortDescription", location);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    File file = new File(location);
                                    PersistenceManager.loadObjectFromFile(file);
                                }
                                catch (Exception e) {
                                    String message = "Couldn't reload application.\n" + e.getMessage();
                                    log.error((Object)message, (Throwable)e);
                                    if (e instanceof IOException) {
                                        locations.put("applications", list.replaceFirst(name + "(;|$)", ""));
                                        fileChooser.setLocations(locations);
                                    }
                                }
                                finally {
                                    MainFrame.this.processFinished();
                                }
                            }
                        };
                        Thread thread = new Thread(runnable, "Reload application");
                        thread.setPriority(1);
                        thread.start();
                    }
                }, MainFrame.this);
                item.addMenuKeyListener(new MenuKeyListener(){

                    @Override
                    public void menuKeyTyped(MenuKeyEvent e) {
                    }

                    @Override
                    public void menuKeyPressed(MenuKeyEvent e) {
                        if (e.getKeyCode() == 127) {
                            locations.put("applications", list.replaceFirst(name + "(;|$)", ""));
                            fileChooser.setLocations(locations);
                        }
                    }

                    @Override
                    public void menuKeyReleased(MenuKeyEvent e) {
                    }
                });
                this.add(item);
            }
            this.add(new XJMenuItem(new AbstractAction("Clear List"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    locations.put("applications", "");
                    fileChooser.setLocations(locations);
                }
            }, MainFrame.this));
        }
    }

    class LiveMenu
    extends XJMenu {
        protected int type;
        public static final int LR = 1;
        public static final int PR = 2;
        public static final int APP = 3;

        public LiveMenu(int type) {
            this.type = type;
            this.init();
        }

        protected void init() {
            this.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                    this.menuDeselected(e);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    MainFrame.this.statusChanged("");
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    MainFrame.this.statusChanged("");
                }
            });
            Gate.getCreoleRegister().addPluginListener(new PluginListener(){

                @Override
                public void pluginLoaded(Plugin plugin) {
                    SwingUtilities.invokeLater(() -> LiveMenu.this.rebuildMenu());
                }

                @Override
                public void pluginUnloaded(Plugin plugin) {
                    SwingUtilities.invokeLater(() -> LiveMenu.this.rebuildMenu());
                }
            });
            this.rebuildMenu();
        }

        private void rebuildMenu() {
            List<String> resTypes;
            this.removeAll();
            CreoleRegister reg = Gate.getCreoleRegister();
            switch (this.type) {
                case 1: {
                    resTypes = reg.getPublicLrTypes();
                    break;
                }
                case 2: {
                    resTypes = new ArrayList<String>(reg.getPublicPrTypes());
                    resTypes.removeAll(reg.getPublicControllerTypes());
                    break;
                }
                case 3: {
                    resTypes = reg.getPublicControllerTypes();
                    break;
                }
                default: {
                    throw new GateRuntimeException("Unknown LiveMenu type: " + this.type);
                }
            }
            if (resTypes != null) {
                if (!resTypes.isEmpty()) {
                    HashMap<String, ResourceData> resourcesByName = new HashMap<String, ResourceData>();
                    Iterator<String> resIter = resTypes.iterator();
                    while (resIter.hasNext()) {
                        ResourceData rData = (ResourceData)reg.get(resIter.next());
                        resourcesByName.put(rData.getName(), rData);
                    }
                    ArrayList resNames = new ArrayList(resourcesByName.keySet());
                    Collections.sort(resNames);
                    resIter = resNames.iterator();
                    while (resIter.hasNext()) {
                        ResourceData rData = (ResourceData)resourcesByName.get(resIter.next());
                        this.add(new XJMenuItem(new NewResourceAction(rData), MainFrame.this));
                    }
                } else if (this.type == 2) {
                    this.add(new AbstractAction("Add ANNIE Resources to this Menu"){
                        {
                            this.putValue("ShortDescription", "Load the ANNIE plugin.");
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Plugin.Maven anniePlugin = new Plugin.Maven("uk.ac.gate.plugins", "annie", "8.5");
                                Gate.getCreoleRegister().registerPlugin(anniePlugin);
                            }
                            catch (Exception ex) {
                                log.error((Object)"Unable to load ANNIE plugin.", (Throwable)ex);
                            }
                        }
                    });
                }
            }
            switch (this.type) {
                case 1: {
                    MainFrame.this.statusChanged("Data used for annotating");
                    break;
                }
                case 2: {
                    MainFrame.this.statusChanged("Processes that annotate data");
                    break;
                }
                case 3: {
                    MainFrame.this.statusChanged("Run processes on data");
                    break;
                }
                default: {
                    MainFrame.this.statusChanged("Unknown resource: " + this.type);
                }
            }
        }
    }

    class OpenDSAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OpenDSAction() {
            super("Open Datastore");
            this.putValue("ShortDescription", "Open a datastore");
            this.putValue("SmallIcon", MainFrame.getIcon("datastore"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map<String, String> dsTypes = DataStoreRegister.getDataStoreClassNames();
            HashMap<String, String> dsTypeByName = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : dsTypes.entrySet()) {
                dsTypeByName.put(entry.getValue(), entry.getKey());
            }
            if (!dsTypeByName.isEmpty()) {
                JLabel label = new JLabel("Select a type of Datastore:");
                JList<String> list = new JList<String>(dsTypeByName.keySet().toArray(new String[dsTypeByName.keySet().size()]));
                String initialSelection = Gate.getUserConfig().getString(MainFrame.class.getName() + ".datastoretype");
                if (dsTypeByName.containsKey(initialSelection)) {
                    list.setSelectedValue(initialSelection, true);
                } else {
                    list.setSelectedIndex(0);
                }
                list.setVisibleRowCount(Math.min(10, list.getModel().getSize()));
                list.setSelectionMode(0);
                final JOptionPane optionPane = new JOptionPane(new Object[]{label, new JScrollPane(list)}, 3, 2, MainFrame.getIcon("datastore"), new String[]{"OK", "Cancel", "Help"}, "OK");
                final JDialog dialog = new JDialog(MainFrame.this, "Open a datastore", true);
                dialog.setContentPane(optionPane);
                list.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            optionPane.setValue("OK");
                            dialog.setVisible(false);
                        }
                    }
                });
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        Object value = optionPane.getValue();
                        if (value == null || value.equals(JOptionPane.UNINITIALIZED_VALUE)) {
                            return;
                        }
                        if (dialog.isVisible() && e.getSource() == optionPane && e.getPropertyName().equals("value")) {
                            if (optionPane.getValue().equals("Help")) {
                                optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                                MainFrame.this.showHelpFrame("sec:datastores", "gate.persist.SerialDataStore");
                            } else {
                                dialog.setVisible(false);
                            }
                        }
                    }
                });
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
                Object answer = optionPane.getValue();
                if (answer == null) {
                    return;
                }
                String className = (String)dsTypeByName.get(list.getSelectedValue());
                if (answer.equals("OK") && !list.isSelectionEmpty()) {
                    Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".datastoretype"), list.getSelectedValue());
                    if (className.indexOf("SerialDataStore") != -1) {
                        MainFrame.this.openSerialDataStore();
                    } else if (className.indexOf("LuceneDataStoreImpl") != -1) {
                        MainFrame.this.openSearchableDataStore();
                    } else if (className.indexOf("DocServiceDataStore") != -1) {
                        MainFrame.this.openDocServiceDataStore();
                    } else {
                        JOptionPane.showMessageDialog(MainFrame.this, "Support for this type of datastores is not implemenented!\n", "GATE", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(MainFrame.this, "Could not find any registered types of datastores...\nCheck your GATE installation!", "GATE", 0);
            }
        }
    }

    class ExitGateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExitGateAction() {
            super("Exit GATE");
            this.putValue("ShortDescription", "Closes the application");
            this.putValue("SmallIcon", MainFrame.getIcon("Exit"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt F4"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    OptionsMap userConfig = Gate.getUserConfig();
                    try {
                        if (userConfig.getBoolean("Save_options_on_exit").booleanValue()) {
                            Integer width = MainFrame.this.getWidth();
                            Integer height = MainFrame.this.getHeight();
                            userConfig.put((Object)"Main_frame_width", width);
                            userConfig.put((Object)"Main_frame_height", height);
                            userConfig.put((Object)"Main_frame_maximized", (Object)(MainFrame.this.getExtendedState() == 6 ? 1 : 0));
                            Gate.writeUserConfig();
                        } else {
                            OptionsMap originalUserConfig = Gate.getOriginalUserConfig();
                            if (originalUserConfig.getBoolean("Save_options_on_exit").booleanValue()) {
                                originalUserConfig.put((Object)"Save_options_on_exit", (Object)false);
                                userConfig.clear();
                                userConfig.putAll(originalUserConfig);
                                Gate.writeUserConfig();
                            }
                        }
                    }
                    catch (GateException error) {
                        String message = "Failed to save config data.";
                        log.error((Object)message, (Throwable)error);
                    }
                    File sessionFile = Gate.getUserSessionFile();
                    if (sessionFile != null && userConfig.getBoolean("Save_session_on_exit").booleanValue()) {
                        try {
                            ArrayList<Resource> appList = new ArrayList<Resource>(Gate.getCreoleRegister().getAllInstances("gate.Controller"));
                            Iterator appIter = appList.iterator();
                            while (appIter.hasNext()) {
                                if (!Gate.getHiddenAttribute(((Controller)appIter.next()).getFeatures())) continue;
                                appIter.remove();
                            }
                            PersistenceManager.saveObjectToFile(appList, sessionFile, true, false);
                        }
                        catch (Exception error) {
                            String message = "Failed to save session data.";
                            log.error((Object)message, (Throwable)error);
                        }
                    } else if (sessionFile != null && sessionFile.exists() && !sessionFile.delete()) {
                        log.error((Object)"Error when deleting the session file.");
                    }
                    System.setErr(MainFrame.this.logArea.getOriginalErr());
                    System.setOut(MainFrame.this.logArea.getOriginalOut());
                    ArrayList<Component> roots = new ArrayList<Component>(MainFrame.getGuiRoots());
                    while (!roots.isEmpty()) {
                        Component aRoot = (Component)roots.remove(0);
                        if (!(aRoot instanceof Window)) continue;
                        Window window = (Window)aRoot;
                        roots.addAll(Arrays.asList(window.getOwnedWindows()));
                        window.setVisible(false);
                        window.dispose();
                    }
                    try {
                        ArrayList<List<Resource>> listOfListOfResources = new ArrayList<List<Resource>>();
                        listOfListOfResources.add(Gate.getCreoleRegister().getAllInstances(LanguageResource.class.getName()));
                        listOfListOfResources.add(Gate.getCreoleRegister().getAllInstances(ProcessingResource.class.getName()));
                        listOfListOfResources.add(Gate.getCreoleRegister().getAllInstances(Controller.class.getName()));
                        for (List list : listOfListOfResources) {
                            for (Resource aResource : list) {
                                try {
                                    Factory.deleteResource(aResource);
                                }
                                catch (Throwable e) {
                                    log.error((Object)"Some problems occurred when cleaning up the resources.", e);
                                }
                            }
                        }
                        if (Gate.getDataStoreRegister() != null) {
                            HashSet<DataStore> dataStores = new HashSet<DataStore>(Gate.getDataStoreRegister());
                            for (DataStore aDs : dataStores) {
                                try {
                                    aDs.close();
                                }
                                catch (Throwable e) {
                                    log.error((Object)"Some problems occurred when closing the datastores.", e);
                                }
                            }
                        }
                        if (MainFrame.this.httpCache != null) {
                            MainFrame.this.httpCache.shutdown();
                        }
                    }
                    catch (GateException e) {
                        log.error((Object)"A problem occurred when exiting from GATE.", (Throwable)e);
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Shutdown thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    class ShowResourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        Handle handle;

        public ShowResourceAction(Handle handle) {
            super("Show");
            this.putValue("ShortDescription", "Show this resource");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("Enter"));
            this.handle = handle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.select(ShowResourceAction.this.handle);
                }
            });
        }
    }

    class ShowSelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ShowSelectedResourcesAction() {
            super("Show all");
            this.putValue("ShortDescription", "Show the selected resources");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("Enter"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    TreePath[] paths = MainFrame.this.resourcesTree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    if (paths.length > 10) {
                        Object[] possibleValues = new Object[]{"Open the " + paths.length + " objects", "Don't open"};
                        int selectedValue = JOptionPane.showOptionDialog(instance, "Do you want to open " + paths.length + " objects in the central tabbed pane ?", "Warning", -1, 3, null, possibleValues, possibleValues[1]);
                        if (selectedValue == 1 || selectedValue == -1) {
                            return;
                        }
                    }
                    for (TreePath path : paths) {
                        if (path == null) continue;
                        Object value = path.getLastPathComponent();
                        if (!((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof Handle)) continue;
                        final Handle handle = (Handle)value;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainFrame.this.select(handle);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runner, "ShowSelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class HideAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HideAllAction() {
            super("Hide all");
            this.putValue("ShortDescription", "Hide all resource views");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift H"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    Enumeration<TreeNode> nodesEnum = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
                    while (nodesEnum.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodesEnum.nextElement();
                        if (!(node.getUserObject() instanceof Handle) || MainFrame.this.mainTabbedPane.indexOfComponent(((Handle)node.getUserObject()).getLargeView()) == -1) continue;
                        final Handle handle = (Handle)node.getUserObject();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                new CloseViewAction(handle).actionPerformed(null);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runner, "HideAllAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseRecursivelySelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseRecursivelySelectedResourcesAction() {
            super("Close Recursively all");
            this.putValue("ShortDescription", "Close recursively the selected resources");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    TreePath[] paths;
                    for (TreePath path : paths = MainFrame.this.resourcesTree.getSelectionPaths()) {
                        final Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                        if (!(userObject instanceof NameBearerHandle)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((NameBearerHandle)userObject).getCloseRecursivelyAction().actionPerformed(null);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runner, "CloseRecursivelySelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseSelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseSelectedResourcesAction() {
            super("Close all");
            this.putValue("ShortDescription", "Close the selected resources");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    TreePath[] paths;
                    for (TreePath path : paths = MainFrame.this.resourcesTree.getSelectionPaths()) {
                        final Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                        if (!(userObject instanceof NameBearerHandle)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((NameBearerHandle)userObject).getCloseAction().actionPerformed(null);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runner, "CloseSelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class RenameResourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        TreePath path;

        RenameResourceAction(TreePath path) {
            super("Rename");
            this.putValue("ShortDescription", "Rename this resource");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F2"));
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.resourcesTree.startEditingAtPath(this.path);
        }
    }

    class CloseViewsForSelectedResourcesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseViewsForSelectedResourcesAction() {
            super("Hide all");
            this.putValue("ShortDescription", "Hide the selected resources");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    TreePath[] paths;
                    for (TreePath path : paths = MainFrame.this.resourcesTree.getSelectionPaths()) {
                        final Object value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                        if (!(value instanceof Handle)) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                new CloseViewAction((Handle)value).actionPerformed(null);
                            }
                        });
                    }
                }
            };
            Thread thread = new Thread(runner, "CloseViewsForSelectedResourcesAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseViewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        Handle handle;

        public CloseViewAction(Handle handle) {
            super("Hide");
            this.putValue("ShortDescription", "Hide this resource view");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control H"));
            this.handle = handle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.mainTabbedPane.remove(CloseViewAction.this.handle.getLargeView());
                    MainFrame.this.mainTabbedPane.setSelectedIndex(MainFrame.this.mainTabbedPane.getTabCount() - 1);
                    CloseViewAction.this.handle.removeViews();
                }
            });
        }
    }

    class LoadResourceFromFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LoadResourceFromFileAction() {
            super("Restore Application from File...");
            this.putValue("ShortDescription", "Restores a previously saved application from a file");
            this.putValue("SmallIcon", MainFrame.getIcon("open-application"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            resourceReferenceChooser.setSuffixes("GATE Application files (.gapp, .xgapp)", Arrays.asList(".gapp", ".xgapp"));
            resourceReferenceChooser.setResource("lastapplication");
            final String gappUri = resourceReferenceChooser.showDialog(MainFrame.this, "Select application to load");
            if (gappUri != null) {
                try {
                    final ResourceReference rr = new ResourceReference(URI.create(gappUri));
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Object resource = PersistenceManager.loadObjectFromUri(rr.toURI());
                                if (gappUri.startsWith("file:") && resource instanceof Resource) {
                                    File file = new File(rr.toURI());
                                    Map<String, String> locations = fileChooser.getLocations();
                                    Resource res = (Resource)resource;
                                    locations.put("application." + res.getName(), file.getAbsolutePath());
                                    locations.put("application.zip." + res.getName(), file.getAbsolutePath().replaceFirst("\\.[^.]{3,5}$", ".zip"));
                                    String list = locations.get("applications");
                                    if (list == null) {
                                        list = "";
                                    }
                                    list = list.replaceFirst("\\Q" + res.getName() + "\\E(;|$)", "");
                                    list = res.getName() + ";" + list;
                                    locations.put("applications", list);
                                    fileChooser.setLocations(locations);
                                }
                            }
                            catch (MalformedURLException e) {
                                log.error((Object)"Error when saving the resource URL.", (Throwable)e);
                            }
                            catch (Exception error) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        String message = error.getMessage();
                                        log.error((Object)message, (Throwable)error);
                                    }
                                });
                            }
                            finally {
                                MainFrame.this.processFinished();
                            }
                        }
                    };
                    Thread thread = new Thread(runnable, "LoadResourceFromFileAction");
                    thread.setPriority(1);
                    thread.start();
                }
                catch (URISyntaxException e1) {
                    log.error((Object)"Unexpected exception", (Throwable)e1);
                }
            }
        }
    }

    class NewDSAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewDSAction() {
            super("Create Datastore");
            this.putValue("ShortDescription", "Create a new datastore");
            this.putValue("SmallIcon", MainFrame.getIcon("datastore"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Map<String, String> dsTypes = DataStoreRegister.getDataStoreClassNames();
            HashMap<String, String> dsTypeByName = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : dsTypes.entrySet()) {
                dsTypeByName.put(entry.getValue(), entry.getKey());
            }
            if (!dsTypeByName.isEmpty()) {
                JLabel label = new JLabel("Select a type of Datastore:");
                JList<String> list = new JList<String>(dsTypeByName.keySet().toArray(new String[dsTypeByName.keySet().size()]));
                String initialSelection = Gate.getUserConfig().getString(MainFrame.class.getName() + ".datastoretype");
                if (dsTypeByName.containsKey(initialSelection)) {
                    list.setSelectedValue(initialSelection, true);
                } else {
                    list.setSelectedIndex(0);
                }
                list.setVisibleRowCount(Math.min(10, list.getModel().getSize()));
                list.setSelectionMode(0);
                final JOptionPane optionPane = new JOptionPane(new Object[]{label, new JScrollPane(list)}, 3, 2, MainFrame.getIcon("datastore"), new String[]{"OK", "Cancel", "Help"}, "OK");
                final JDialog dialog = new JDialog(MainFrame.this, "Create a datastore", true);
                dialog.setContentPane(optionPane);
                list.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            optionPane.setValue("OK");
                            dialog.setVisible(false);
                        }
                    }
                });
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        Object value = optionPane.getValue();
                        if (value == null || value.equals(JOptionPane.UNINITIALIZED_VALUE)) {
                            return;
                        }
                        if (dialog.isVisible() && e.getSource() == optionPane && e.getPropertyName().equals("value")) {
                            if (optionPane.getValue().equals("Help")) {
                                optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                                MainFrame.this.showHelpFrame("sec:datastores", "gate.persist.SerialDataStore");
                            } else {
                                dialog.setVisible(false);
                            }
                        }
                    }
                });
                dialog.pack();
                dialog.setLocationRelativeTo(MainFrame.this);
                dialog.setVisible(true);
                Object answer = optionPane.getValue();
                if (answer == null) {
                    return;
                }
                String className = (String)dsTypeByName.get(list.getSelectedValue());
                if (!answer.equals("OK") || list.isSelectionEmpty()) return;
                Gate.getUserConfig().put((Object)(MainFrame.class.getName() + ".datastoretype"), list.getSelectedValue());
                if (className.equals("gate.persist.SerialDataStore")) {
                    MainFrame.this.createSerialDataStore();
                    return;
                } else {
                    if (!className.equals("gate.persist.LuceneDataStoreImpl")) throw new UnsupportedOperationException("Unimplemented option!\nUse a serial datastore");
                    MainFrame.this.createSearchableDataStore();
                }
                return;
            } else {
                JOptionPane.showMessageDialog(MainFrame.this, "Could not find any registered types of datastores...\nCheck your GATE installation!", "GATE", 0);
            }
        }
    }

    static class StopAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StopAction() {
            super(" Stop! ");
            this.putValue("ShortDescription", "Stops the current action");
        }

        @Override
        public boolean isEnabled() {
            return Gate.getExecutable() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Executable ex = Gate.getExecutable();
            if (ex != null) {
                ex.interrupt();
            }
        }
    }

    class NewResourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        ResourceData rData;

        public NewResourceAction(ResourceData rData) {
            super(rData.getName());
            this.putValue("ShortDescription", rData.getComment());
            this.rData = rData;
            this.putValue("SmallIcon", MainFrame.getIcon(rData.getIcon(), rData.getResourceClassLoader()));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.newResourceDialog.setTitle("Parameters for the new " + NewResourceAction.this.rData.getName());
                    fileChooser.setResource(NewResourceAction.this.rData.getClassName());
                    resourceReferenceChooser.setResource(NewResourceAction.this.rData.getClassName());
                    MainFrame.this.newResourceDialog.show(NewResourceAction.this.rData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    class ManagePluginsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ManagePluginsAction() {
            super("Manage CREOLE Plugins...");
            this.putValue("ShortDescription", "Load, unload, add and remove CREOLE plugins");
            this.putValue("SmallIcon", new AvailableIcon(24, 24));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this.pluginManager == null) {
                MainFrame.this.pluginManager = new PluginUpdateManager(MainFrame.this);
            }
            MainFrame.this.pluginManager.setVisible(true);
        }
    }

    class NewBootStrapAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewBootStrapAction() {
            super("Bootstrap Wizard", MainFrame.getIcon("application"));
            this.putValue("ShortDescription", "Create a generic resource to be completed");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JLabel msg = new JLabel("<html><body>The bootstrap wizard has been replaced by a Maven archetype. To create a new plugin please run the following command from a console<br><br>");
            JTextField txtCommand = new JTextField("mvn archetype:generate -DarchetypeGroupId=uk.ac.gate -DarchetypeArtifactId=gate-plugin-archetype -DarchetypeVersion=" + Main.version);
            txtCommand.setEditable(false);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)msg, "North");
            panel.add((Component)txtCommand, "Center");
            JOptionPane.showMessageDialog(MainFrame.getInstance(), panel, "Bootstrap Wizard", 1);
        }
    }

    class LoadApplicationAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String name;
        private String icon;
        private ResourceReference pipelineURL;

        public LoadApplicationAction(ResourceData rData, ResourceReference pipelineURL) {
            super(rData.getName(), MainFrame.getIcon(rData.getIcon(), rData.getResourceClassLoader()));
            this.pipelineURL = null;
            if (this.getValue("SmallIcon") == null) {
                this.putValue("SmallIcon", MainFrame.getIcon("application"));
            }
            this.name = rData.getName();
            this.pipelineURL = pipelineURL;
            this.icon = rData.getIcon();
        }

        public LoadApplicationAction(String name, String icon, ResourceReference pipelineURL) {
            super(name, MainFrame.getIcon(icon));
            this.pipelineURL = null;
            if (this.getValue("SmallIcon") == null) {
                this.putValue("SmallIcon", MainFrame.getIcon("application"));
            }
            this.name = name;
            this.pipelineURL = pipelineURL;
            this.icon = icon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.pipelineURL == null) {
                System.err.println("The URL of the application has not been correctly set and cannot be loaded.");
                return;
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MainFrame.lockGUI(LoadApplicationAction.this.name + " is being loaded...");
                    try {
                        long startTime = System.currentTimeMillis();
                        if (LoadApplicationAction.this.pipelineURL.toURI().getScheme().equals("creole")) {
                            String[] coordinates = LoadApplicationAction.this.pipelineURL.toURI().getAuthority().split(";");
                            Plugin.Maven plugin = new Plugin.Maven(coordinates[0], coordinates[1], coordinates[2]);
                            Gate.getCreoleRegister().registerPlugin(plugin);
                        }
                        Resource controller = (Resource)PersistenceManager.loadObjectFromUri(LoadApplicationAction.this.pipelineURL.toURI());
                        if (!LoadApplicationAction.this.icon.equals(controller.getFeatures().get("gate.gui.icon"))) {
                            controller.getFeatures().put("gate.gui.icon", LoadApplicationAction.this.icon);
                            Enumeration<TreeNode> items = MainFrame.this.applicationsRoot.depthFirstEnumeration();
                            while (items.hasMoreElements()) {
                                Object userObject;
                                TreeNode n = items.nextElement();
                                if (!(n instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)n).getUserObject()) instanceof NameBearerHandle) || !((NameBearerHandle)userObject).getTarget().equals(controller)) continue;
                                ((NameBearerHandle)((DefaultMutableTreeNode)n).getUserObject()).setIcon((Icon)LoadApplicationAction.this.getValue("SmallIcon"));
                                MainFrame.this.resourcesTree.invalidate();
                                break;
                            }
                        }
                        long endTime = System.currentTimeMillis();
                        MainFrame.this.statusChanged(LoadApplicationAction.this.name + " loaded in " + NumberFormat.getInstance().format((double)(endTime - startTime) / 1000.0) + " seconds");
                    }
                    catch (Exception error) {
                        String message = "There was an error when loading the " + LoadApplicationAction.this.name + " application.";
                        error.printStackTrace();
                        log.error((Object)message, (Throwable)error);
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "LoadApplicationAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class LoadANNIEWithoutDefaultsAction
    extends AbstractAction
    implements ANNIEConstants {
        private static final long serialVersionUID = 1L;

        public LoadANNIEWithoutDefaultsAction() {
            super("without Defaults");
            this.putValue("ShortDescription", "Load ANNIE without default parameters");
            this.putValue("SmallIcon", MainFrame.getIcon("annie-application"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ConditionalSerialAnalyserController controller;
                    MainFrame.lockGUI("ANNIE is being loaded...");
                    try {
                        controller = (ConditionalSerialAnalyserController)PersistenceManager.loadObjectFromFile(new File(new File(Gate.getPluginsHome(), "ANNIE"), "ANNIE_with_defaults.gapp"));
                        MainFrame.this.statusChanged("ANNIE loaded!");
                        MainFrame.unlockGUI();
                    }
                    catch (Exception error) {
                        MainFrame.unlockGUI();
                        String message = "There was an error when loading the ANNIE application.";
                        log.error((Object)message, (Throwable)error);
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList prs = new ArrayList(controller.getPRs());
                            for (ProcessingResource pr : prs) {
                                try {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            int selectedRow = MainFrame.this.resourcesTree.getRowForPath(new TreePath(MainFrame.this.processingResourcesRoot.getPath()));
                                            MainFrame.this.resourcesTree.setSelectionRow(selectedRow += MainFrame.this.processingResourcesRoot.getChildCount());
                                            MainFrame.this.resourcesTree.scrollRowToVisible(selectedRow);
                                        }
                                    });
                                    ResourceData resData = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
                                    if (resData == null) {
                                        throw new ResourceInstantiationException(pr.getName() + " was not possible to load.");
                                    }
                                    fileChooser.setResource(resData.getClassName());
                                    resourceReferenceChooser.setResource(resData.getClassName());
                                    if (MainFrame.this.newResourceDialog.show(resData, "Parameters for the new " + resData.getName())) {
                                        controller.add((ProcessingResource)Factory.createResource(pr.getClass().getName(), MainFrame.this.newResourceDialog.getSelectedParameters()));
                                    }
                                    Factory.deleteResource(pr);
                                }
                                catch (ResourceInstantiationException error) {
                                    String message = "There was an error when creating the resource: " + pr.getName() + ".";
                                    log.error((Object)message, (Throwable)error);
                                }
                            }
                        }
                    });
                }
            };
            Thread thread = new Thread(runnable, "LoadANNIEWithoutDefaultsAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class VerboseModeCorpusEvalToolAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected boolean verboseMode;

        public VerboseModeCorpusEvalToolAction() {
            super("Verbose Mode");
            this.verboseMode = false;
        }

        public boolean isVerboseMode() {
            return this.verboseMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof JCheckBoxMenuItem)) {
                return;
            }
            this.verboseMode = ((JCheckBoxMenuItem)e.getSource()).getState();
        }
    }

    class GenerateStoredCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public GenerateStoredCorpusEvalAction() {
            super("Store Corpus for Future Evaluation");
            this.putValue("ShortDescription", "Store corpus for future evaluation");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int state = fileChooser.showOpenDialog(MainFrame.this);
                    File startDir = fileChooser.getSelectedFile();
                    if (state == 1 || startDir == null) {
                        return;
                    }
                    fileChooser.setDialogTitle("Please select the application that you want to run");
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName() + ".application");
                    state = fileChooser.showOpenDialog(MainFrame.this);
                    File testApp = fileChooser.getSelectedFile();
                    if (state == 1 || testApp == null) {
                        return;
                    }
                    CorpusBenchmarkTool theTool = new CorpusBenchmarkTool();
                    theTool.setStartDirectory(startDir);
                    theTool.setApplicationFile(testApp);
                    theTool.setGenerateMode(true);
                    Out.prln("Processing and storing documents for future evaluation.");
                    theTool.init();
                    theTool.execute();
                    theTool.unloadPRs();
                    Out.prln("Finished!");
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "GenerateStoredCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CleanMarkedCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CleanMarkedCorpusEvalAction() {
            super("Human Marked Against Current Processing Results");
            this.putValue("ShortDescription", "Compares current processed set with human-annotated set");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int state = fileChooser.showOpenDialog(MainFrame.this);
                    File startDir = fileChooser.getSelectedFile();
                    if (state == 1 || startDir == null) {
                        return;
                    }
                    fileChooser.setDialogTitle("Please select the application that you want to run");
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName() + ".application");
                    state = fileChooser.showOpenDialog(MainFrame.this);
                    File testApp = fileChooser.getSelectedFile();
                    if (state == 1 || testApp == null) {
                        return;
                    }
                    CorpusBenchmarkTool theTool = new CorpusBenchmarkTool();
                    theTool.setStartDirectory(startDir);
                    theTool.setApplicationFile(testApp);
                    theTool.setMarkedClean(true);
                    theTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Evaluating human-marked documents against current processing results.");
                    theTool.init();
                    theTool.execute();
                    theTool.printStatistics();
                    Out.prln("Overall average precision: " + theTool.getPrecisionAverage());
                    Out.prln("Overall average recall: " + theTool.getRecallAverage());
                    Out.prln("Overall average fMeasure : " + theTool.getFMeasureAverage());
                    Out.prln("Finished!");
                    theTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "CleanMarkedCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class StoredMarkedCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StoredMarkedCorpusEvalAction() {
            super("Human Marked Against Stored Processing Results");
            this.putValue("ShortDescription", "Compares stored processed set with human-annotated set");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int state = fileChooser.showOpenDialog(MainFrame.this);
                    File startDir = fileChooser.getSelectedFile();
                    if (state == 1 || startDir == null) {
                        return;
                    }
                    CorpusBenchmarkTool theTool = new CorpusBenchmarkTool();
                    theTool.setStartDirectory(startDir);
                    theTool.setMarkedStored(true);
                    theTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Evaluating human-marked documents against pre-stored results.");
                    theTool.init();
                    theTool.execute();
                    theTool.printStatistics();
                    Out.prln("<BR>Overall average precision: " + theTool.getPrecisionAverage());
                    Out.prln("<BR>Overall average recall: " + theTool.getRecallAverage());
                    Out.prln("<BR>Overall average fMeasure : " + theTool.getFMeasureAverage());
                    Out.prln("<BR>Finished!");
                    theTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "StoredMarkedCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class NewCorpusEvalAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewCorpusEvalAction() {
            super("Default Mode");
            this.putValue("ShortDescription", "Compares stored processed set with current processed set and human-annotated set");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    fileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName());
                    int state = fileChooser.showOpenDialog(MainFrame.this);
                    File startDir = fileChooser.getSelectedFile();
                    if (state == 1 || startDir == null) {
                        return;
                    }
                    fileChooser.setDialogTitle("Please select the application that you want to run");
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setResource(CorpusBenchmarkTool.class.getName() + ".application");
                    state = fileChooser.showOpenDialog(MainFrame.this);
                    File testApp = fileChooser.getSelectedFile();
                    if (state == 1 || testApp == null) {
                        return;
                    }
                    CorpusBenchmarkTool theTool = new CorpusBenchmarkTool();
                    theTool.setStartDirectory(startDir);
                    theTool.setApplicationFile(testApp);
                    theTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Please wait while GATE tools are initialised.");
                    theTool.init();
                    theTool.execute();
                    theTool.printStatistics();
                    Out.prln("<BR>Overall average precision: " + theTool.getPrecisionAverage());
                    Out.prln("<BR>Overall average recall: " + theTool.getRecallAverage());
                    Out.prln("<BR>Overall average fMeasure : " + theTool.getFMeasureAverage());
                    Out.prln("<BR>Finished!");
                    theTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "NewCorpusEvalAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class NewAnnotDiffAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NewAnnotDiffAction() {
            super("Annotation Diff", MainFrame.getIcon("annotation-diff"));
            this.putValue("ShortDescription", "Compare annotations and features in one or two documents");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Enumeration<TreeNode> nodesEnum = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
            Handle handle = null;
            while (nodesEnum.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodesEnum.nextElement();
                if (!(node.getUserObject() instanceof Handle) || !((Handle)node.getUserObject()).viewsBuilt() || !MainFrame.this.mainTabbedPane.getSelectedComponent().equals(((Handle)node.getUserObject()).getLargeView())) continue;
                handle = (Handle)node.getUserObject();
                break;
            }
            String documentName = null;
            if (handle != null && handle.getTarget() instanceof Document) {
                documentName = ((Document)handle.getTarget()).getName();
            }
            AnnotationDiffGUI frame = documentName != null ? new AnnotationDiffGUI("Annotation Diff Tool", documentName, documentName, null, null, null, null) : new AnnotationDiffGUI("Annotation Diff Tool");
            frame.pack();
            frame.setLocationRelativeTo(MainFrame.this);
            frame.setVisible(true);
        }
    }
}

