/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.creole.ontology.BooleanDT;
import gate.creole.ontology.ByteDT;
import gate.creole.ontology.DateDT;
import gate.creole.ontology.DateTimeDT;
import gate.creole.ontology.DoubleDT;
import gate.creole.ontology.FloatDT;
import gate.creole.ontology.IntegerDT;
import gate.creole.ontology.InvalidURIException;
import gate.creole.ontology.LongDT;
import gate.creole.ontology.NegativeIntegerDT;
import gate.creole.ontology.NonNegativeIntegerDT;
import gate.creole.ontology.OConstants;
import gate.creole.ontology.OURI;
import gate.creole.ontology.ShortDT;
import gate.creole.ontology.TimeDT;
import gate.creole.ontology.URI;
import gate.creole.ontology.UnsignedByteDT;
import gate.creole.ontology.UnsignedLongDT;
import gate.creole.ontology.UnsignedShortDT;
import gate.util.GateRuntimeException;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class DataType {
    protected String xmlSchemaURIString;
    static DatatypeFactory datatypeFactory = null;
    private static HashMap<String, DataType> datatypeMap;
    private static HashMap<String, Locale> localsMap;

    public DataType(OURI xmlSchemaURI) {
        this.xmlSchemaURIString = xmlSchemaURI.toString();
    }

    public DataType(String xmlSchemaURIString) {
        this.xmlSchemaURIString = xmlSchemaURIString;
    }

    public boolean isStringDataType() {
        return this.xmlSchemaURIString.equals("http://www.w3.org/2001/XMLSchema#string");
    }

    public static DataType getBooleanDataType() {
        try {
            return new BooleanDT("http://www.w3.org/2001/XMLSchema#boolean");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getByteDataType() {
        try {
            return new ByteDT("http://www.w3.org/2001/XMLSchema#byte");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getDateDataType() {
        try {
            return new DateDT("http://www.w3.org/2001/XMLSchema#date");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getDecimalDataType() {
        try {
            return new DoubleDT("http://www.w3.org/2001/XMLSchema#decimal");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getDoubleDataType() {
        try {
            return new DoubleDT("http://www.w3.org/2001/XMLSchema#double");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getDurationDataType() {
        try {
            return new LongDT("http://www.w3.org/2001/XMLSchema#duration");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getFloatDataType() {
        try {
            return new FloatDT("http://www.w3.org/2001/XMLSchema#float");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getIntDataType() {
        try {
            return new IntegerDT("http://www.w3.org/2001/XMLSchema#int");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getIntegerDataType() {
        try {
            return new IntegerDT("http://www.w3.org/2001/XMLSchema#integer");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getLongDataType() {
        try {
            return new LongDT("http://www.w3.org/2001/XMLSchema#long");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getNegativeIntegerDataType() {
        try {
            return new NegativeIntegerDT("http://www.w3.org/2001/XMLSchema#negativeInteger");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getNonNegativeIntegerDataType() {
        try {
            return new NonNegativeIntegerDT("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getNonPositiveIntegerDataType() {
        try {
            return new NegativeIntegerDT("http://www.w3.org/2001/XMLSchema#nonPositiveInteger");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getPositiveIntegerDataType() {
        try {
            return new NonNegativeIntegerDT("http://www.w3.org/2001/XMLSchema#positiveInteger");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getShortDataType() {
        try {
            return new ShortDT("http://www.w3.org/2001/XMLSchema#short");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getStringDataType() {
        try {
            return new DataType("http://www.w3.org/2001/XMLSchema#string");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getTimeDataType() {
        try {
            return new TimeDT("http://www.w3.org/2001/XMLSchema#time");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getDateTimeDataType() {
        try {
            return new DateTimeDT("http://www.w3.org/2001/XMLSchema#dateTime");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getUnsignedByteDataType() {
        try {
            return new UnsignedByteDT("http://www.w3.org/2001/XMLSchema#unsignedByte");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getUnsignedIntDataType() {
        try {
            return new NonNegativeIntegerDT("http://www.w3.org/2001/XMLSchema#unsignedInt");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getUnsignedLongDataType() {
        try {
            return new UnsignedLongDT("http://www.w3.org/2001/XMLSchema#unsignedLong");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    public static DataType getUnsignedShortDataType() {
        try {
            return new UnsignedShortDT("http://www.w3.org/2001/XMLSchema#unsignedShort");
        }
        catch (InvalidURIException iue) {
            return null;
        }
    }

    @Deprecated
    public OURI getXmlSchemaURI() {
        return new URI(this.xmlSchemaURIString, false);
    }

    public String getXmlSchemaURIString() {
        return this.xmlSchemaURIString;
    }

    public boolean equals(Object o) {
        if (o instanceof DataType) {
            DataType dt = (DataType)o;
            return this.getXmlSchemaURIString().equals(dt.getXmlSchemaURIString());
        }
        return false;
    }

    public int hashCode() {
        return this.getXmlSchemaURIString().hashCode();
    }

    public boolean isValidValue(String value) {
        return true;
    }

    public static DataType getDataType(String datatypeURI) {
        return datatypeMap.get(datatypeURI);
    }

    public static Locale getLocale(String languageCode) {
        if (languageCode == null) {
            return null;
        }
        return localsMap.get(languageCode.toLowerCase());
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new GateRuntimeException("could not initialize data type factory :\n", e);
        }
        datatypeMap = new HashMap();
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#boolean", DataType.getBooleanDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#byte", DataType.getByteDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#date", DataType.getDateDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#decimal", DataType.getDecimalDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#double", DataType.getDoubleDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#duration", DataType.getDurationDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#float", DataType.getFloatDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#int", DataType.getIntDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#integer", DataType.getIntegerDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#long", DataType.getLongDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#negativeInteger", DataType.getNegativeIntegerDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", DataType.getNonNegativeIntegerDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", DataType.getNonPositiveIntegerDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#positiveInteger", DataType.getPositiveIntegerDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#short", DataType.getShortDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#string", DataType.getStringDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#time", DataType.getTimeDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#unsignedByte", DataType.getUnsignedByteDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#unsignedInt", DataType.getUnsignedIntDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#unsignedLong", DataType.getUnsignedLongDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#unsignedShort", DataType.getUnsignedShortDataType());
        datatypeMap.put("http://www.w3.org/2001/XMLSchema#dateTime", DataType.getDateTimeDataType());
        localsMap = new HashMap();
        localsMap.put("aa", OConstants.AFAR);
        localsMap.put("ab", OConstants.ABKHAZIAN);
        localsMap.put("af", OConstants.AFRIKAANS);
        localsMap.put("am", OConstants.AMHARIC);
        localsMap.put("ar", OConstants.ARABIC);
        localsMap.put("as", OConstants.ASSAMESE);
        localsMap.put("ay", OConstants.AYMARA);
        localsMap.put("az", OConstants.AZERBAIJANI);
        localsMap.put("ba", OConstants.BASHKIR);
        localsMap.put("be", OConstants.BYELORUSSIAN);
        localsMap.put("bg", OConstants.BULGARIAN);
        localsMap.put("bh", OConstants.BIHARI);
        localsMap.put("bi", OConstants.BISLAMA);
        localsMap.put("bn", OConstants.BENGALI);
        localsMap.put("bo", OConstants.TIBETAN);
        localsMap.put("br", OConstants.BRETON);
        localsMap.put("ca", OConstants.CATALAN);
        localsMap.put("co", OConstants.CORSICAN);
        localsMap.put("cs", OConstants.CZECH);
        localsMap.put("cy", OConstants.WELSH);
        localsMap.put("da", OConstants.DANISH);
        localsMap.put("de", OConstants.GERMAN);
        localsMap.put("dz", OConstants.BHUTANI);
        localsMap.put("el", OConstants.GREEK);
        localsMap.put("en", OConstants.ENGLISH);
        localsMap.put("eo", OConstants.ESPERANTO);
        localsMap.put("es", OConstants.SPANISH);
        localsMap.put("et", OConstants.ESTONIAN);
        localsMap.put("eu", OConstants.BASQUE);
        localsMap.put("fa", OConstants.PERSIAN);
        localsMap.put("fi", OConstants.FINNISH);
        localsMap.put("fj", OConstants.FIJI);
        localsMap.put("fo", OConstants.FAROESE);
        localsMap.put("fr", OConstants.FRENCH);
        localsMap.put("fy", OConstants.FRISIAN);
        localsMap.put("ga", OConstants.IRISH);
        localsMap.put("gd", OConstants.SCOTS);
        localsMap.put("gl", OConstants.GALICIAN);
        localsMap.put("gn", OConstants.GUARANI);
        localsMap.put("gu", OConstants.GUJARATI);
        localsMap.put("ha", OConstants.HAUSA);
        localsMap.put("he", OConstants.HEBREW);
        localsMap.put("hi", OConstants.HINDI);
        localsMap.put("hr", OConstants.CROATIAN);
        localsMap.put("hu", OConstants.HUNGARIAN);
        localsMap.put("hy", OConstants.ARMENIAN);
        localsMap.put("ia", OConstants.INTERLINGUA);
        localsMap.put("id", OConstants.INDONESIAN);
        localsMap.put("ie", OConstants.INTERLINGUE);
        localsMap.put("ik", OConstants.INUPIAK);
        localsMap.put("is", OConstants.ICELANDIC);
        localsMap.put("it", OConstants.ITALIAN);
        localsMap.put("iu", OConstants.INUKTITUT);
        localsMap.put("ja", OConstants.JAPANESE);
        localsMap.put("jw", OConstants.JAVANESE);
        localsMap.put("ka", OConstants.GEORGIAN);
        localsMap.put("kk", OConstants.KAZAKH);
        localsMap.put("kl", OConstants.GREENLANDIC);
        localsMap.put("km", OConstants.CAMBODIAN);
        localsMap.put("kn", OConstants.KANNADA);
        localsMap.put("ko", OConstants.KOREAN);
        localsMap.put("ks", OConstants.KASHMIRI);
        localsMap.put("ku", OConstants.KURDISH);
        localsMap.put("ky", OConstants.KIRGHIZ);
        localsMap.put("la", OConstants.LATIN);
        localsMap.put("ln", OConstants.LINGALA);
        localsMap.put("lo", OConstants.LAOTHIAN);
        localsMap.put("lt", OConstants.LITHUANIAN);
        localsMap.put("lv", OConstants.LATVIAN);
        localsMap.put("mg", OConstants.MALAGASY);
        localsMap.put("mi", OConstants.MAORI);
        localsMap.put("mk", OConstants.MACEDONIAN);
        localsMap.put("ml", OConstants.MALAYALAM);
        localsMap.put("mn", OConstants.MONGOLIAN);
        localsMap.put("mo", OConstants.MOLDAVIAN);
        localsMap.put("mr", OConstants.MARATHI);
        localsMap.put("ms", OConstants.MALAY);
        localsMap.put("mt", OConstants.MALTESE);
        localsMap.put("my", OConstants.BURMESE);
        localsMap.put("na", OConstants.NAURU);
        localsMap.put("ne", OConstants.NEPALI);
        localsMap.put("nl", OConstants.DUTCH);
        localsMap.put("no", OConstants.NORWEGIAN);
        localsMap.put("oc", OConstants.OCCITAN);
        localsMap.put("om", OConstants.OROMO);
        localsMap.put("or", OConstants.ORIYA);
        localsMap.put("pa", OConstants.PUNJABI);
        localsMap.put("pl", OConstants.POLISH);
        localsMap.put("ps", OConstants.PASHTO);
        localsMap.put("pt", OConstants.PORTUGUESE);
        localsMap.put("qu", OConstants.QUECHUA);
        localsMap.put("rm", OConstants.RHAETO_ROMANCE);
        localsMap.put("rn", OConstants.KIRUNDI);
        localsMap.put("ro", OConstants.ROMANIAN);
        localsMap.put("ru", OConstants.RUSSIAN);
        localsMap.put("rw", OConstants.KINYARWANDA);
        localsMap.put("sa", OConstants.SANSKRIT);
        localsMap.put("sd", OConstants.SINDHI);
        localsMap.put("sg", OConstants.SANGHO);
        localsMap.put("sh", OConstants.SERBO_CROATIAN);
        localsMap.put("si", OConstants.SINHALESE);
        localsMap.put("sk", OConstants.SLOVAK);
        localsMap.put("sl", OConstants.SLOVENIAN);
        localsMap.put("sm", OConstants.SAMOAN);
        localsMap.put("sn", OConstants.SHONA);
        localsMap.put("so", OConstants.SOMALI);
        localsMap.put("sq", OConstants.ALBANIAN);
        localsMap.put("sr", OConstants.SERBIAN);
        localsMap.put("ss", OConstants.SISWATI);
        localsMap.put("st", OConstants.SESOTHO);
        localsMap.put("su", OConstants.SUNDANESE);
        localsMap.put("sv", OConstants.SWEDISH);
        localsMap.put("sw", OConstants.SWAHILI);
        localsMap.put("ta", OConstants.TAMIL);
        localsMap.put("te", OConstants.TELUGU);
        localsMap.put("tg", OConstants.TAJIK);
        localsMap.put("th", OConstants.THAI);
        localsMap.put("ti", OConstants.TIGRINYA);
        localsMap.put("tk", OConstants.TURKMEN);
        localsMap.put("tl", OConstants.TAGALOG);
        localsMap.put("tn", OConstants.SETSWANA);
        localsMap.put("to", OConstants.TONGA);
        localsMap.put("tr", OConstants.TURKISH);
        localsMap.put("ts", OConstants.TSONGA);
        localsMap.put("tt", OConstants.TATAR);
        localsMap.put("tw", OConstants.TWI);
        localsMap.put("ug", OConstants.UIGHUR);
        localsMap.put("uk", OConstants.UKRAINIAN);
        localsMap.put("ur", OConstants.URDU);
        localsMap.put("uz", OConstants.UZBEK);
        localsMap.put("vi", OConstants.VIETNAMESE);
        localsMap.put("vo", OConstants.VOLAPUK);
        localsMap.put("wo", OConstants.WOLOF);
        localsMap.put("xh", OConstants.XHOSA);
        localsMap.put("yi", OConstants.YIDDISH);
        localsMap.put("yo", OConstants.YORUBA);
        localsMap.put("za", OConstants.ZHUANG);
        localsMap.put("zh", OConstants.CHINESE);
        localsMap.put("zu", OConstants.ZULU);
    }
}

