/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;

final class TermInfosWriter {
    public static final int FORMAT = -2;
    private FieldInfos fieldInfos;
    private OutputStream output;
    private Term lastTerm = new Term("", "", "");
    private TermInfo lastTi = new TermInfo();
    private long size = 0L;
    int indexInterval = 128;
    int skipInterval = 16;
    private long lastIndexPointer = 0L;
    private boolean isIndex = false;
    private TermInfosWriter other = null;

    TermInfosWriter(Directory directory, String segment, FieldInfos fis) throws IOException {
        this.initialize(directory, segment, fis, false);
        this.other = new TermInfosWriter(directory, segment, fis, true);
        this.other.other = this;
    }

    private TermInfosWriter(Directory directory, String segment, FieldInfos fis, boolean isIndex) throws IOException {
        this.initialize(directory, segment, fis, isIndex);
    }

    private void initialize(Directory directory, String segment, FieldInfos fis, boolean isi) throws IOException {
        this.fieldInfos = fis;
        this.isIndex = isi;
        this.output = directory.createFile(segment + (this.isIndex ? ".tii" : ".tis"));
        this.output.writeInt(-2);
        this.output.writeLong(0L);
        this.output.writeInt(this.indexInterval);
        this.output.writeInt(this.skipInterval);
    }

    final void add(Term term, TermInfo ti) throws IOException {
        int compareResult = term.compareTo(this.lastTerm);
        if (!this.isIndex && compareResult <= 0) {
            throw new IOException("term out of order");
        }
        if (ti.freqPointer < this.lastTi.freqPointer) {
            throw new IOException("freqPointer out of order");
        }
        if (ti.proxPointer < this.lastTi.proxPointer) {
            throw new IOException("proxPointer out of order");
        }
        if (!this.isIndex && this.size % (long)this.indexInterval == 0L) {
            this.other.add(this.lastTerm, this.lastTi);
        }
        this.writeTerm(term);
        this.output.writeVInt(ti.docFreq);
        this.output.writeVLong(ti.freqPointer - this.lastTi.freqPointer);
        this.output.writeVLong(ti.proxPointer - this.lastTi.proxPointer);
        if (ti.docFreq >= this.skipInterval) {
            this.output.writeVInt(ti.skipOffset);
        }
        if (this.isIndex) {
            this.output.writeVLong(this.other.output.getFilePointer() - this.lastIndexPointer);
            this.lastIndexPointer = this.other.output.getFilePointer();
        }
        this.lastTi.set(ti);
        ++this.size;
    }

    private final void writeTerm(Term term) throws IOException {
        int length = term.text.length();
        this.output.writeVInt(length);
        this.output.writeChars(term.text, 0, length);
        if (term.type == null) {
            term.type = "word";
        }
        length = term.type.length();
        this.output.writeVInt(length);
        this.output.writeChars(term.type, 0, length);
        this.output.writeVInt(this.fieldInfos.fieldNumber(term.field));
        this.lastTerm = term;
    }

    final void close() throws IOException {
        this.output.seek(4L);
        this.output.writeLong(this.size);
        this.output.close();
        if (!this.isIndex) {
            this.other.close();
        }
    }
}

