/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;

final class CompoundFileWriter {
    private Directory directory;
    private String fileName;
    private HashSet ids;
    private LinkedList entries;
    private boolean merged = false;

    public CompoundFileWriter(Directory dir, String name) {
        if (dir == null) {
            throw new IllegalArgumentException("Missing directory");
        }
        if (name == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.directory = dir;
        this.fileName = name;
        this.ids = new HashSet();
        this.entries = new LinkedList();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public void addFile(String file) {
        if (this.merged) {
            throw new IllegalStateException("Can't add extensions after merge has been called");
        }
        if (file == null) {
            throw new IllegalArgumentException("Missing source file");
        }
        if (!this.ids.add(file)) {
            throw new IllegalArgumentException("File " + file + " already added");
        }
        FileEntry entry = new FileEntry();
        entry.file = file;
        this.entries.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.merged) {
            throw new IllegalStateException("Merge already performed");
        }
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("No entries to merge have been defined");
        }
        this.merged = true;
        OutputStream os = null;
        try {
            os = this.directory.createFile(this.fileName);
            os.writeVInt(this.entries.size());
            for (FileEntry fe : this.entries) {
                fe.directoryOffset = os.getFilePointer();
                os.writeLong(0L);
                os.writeString(fe.file);
            }
            byte[] buffer = new byte[1024];
            for (FileEntry fe : this.entries) {
                fe.dataOffset = os.getFilePointer();
                this.copyFile(fe, os, buffer);
            }
            for (FileEntry fe : this.entries) {
                os.seek(fe.directoryOffset);
                os.writeLong(fe.dataOffset);
            }
            OutputStream tmp = os;
            os = null;
            tmp.close();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(FileEntry source, OutputStream os, byte[] buffer) throws IOException {
        try (InputStream is = null;){
            long length;
            long remainder;
            int len;
            long startPtr = os.getFilePointer();
            is = this.directory.openFile(source.file);
            int chunk = buffer.length;
            for (remainder = length = is.length(); remainder > 0L; remainder -= (long)len) {
                len = (int)Math.min((long)chunk, remainder);
                is.readBytes(buffer, 0, len);
                os.writeBytes(buffer, len);
            }
            if (remainder != 0L) {
                throw new IOException("Non-zero remainder length after copying: " + remainder + " (id: " + source.file + ", length: " + length + ", buffer size: " + chunk + ")");
            }
            long endPtr = os.getFilePointer();
            long diff = endPtr - startPtr;
            if (diff != length) {
                throw new IOException("Difference in the output file offsets " + diff + " does not match the original file length " + length);
            }
        }
    }

    private static final class FileEntry {
        String file;
        long directoryOffset;
        long dataOffset;

        private FileEntry() {
        }
    }
}

