/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.ParameterException;
import gate.creole.Plugin;
import gate.creole.ResourceData;
import gate.creole.ResourceReference;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 6611664706992065985L;
    String typeName;
    boolean optional = false;
    String itemClassName = null;
    Set<String> suffixes = null;
    static Map<Class<?>, Class<?>> substituteClasses = new HashMap();
    protected ResourceData resData;
    String defaultValueString;
    String comment;
    String helpURL;
    String name;
    boolean runtime = false;
    protected Plugin plugin;
    protected Class<?> paramClass;

    public Parameter(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object calculateDefaultValue() throws ParameterException {
        if (this.defaultValueString == null && this.typeName != null && this.typeName.startsWith("java.")) {
            return null;
        }
        return this.calculateValueFromString(this.defaultValueString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object calculateValueFromString(String stringValue) throws ParameterException {
        Enum value = null;
        Class<String> paramClass = this.getParameterClass();
        if (substituteClasses.containsKey(paramClass)) {
            paramClass = substituteClasses.get(paramClass);
        }
        if (Collection.class.isAssignableFrom(paramClass) && !paramClass.isInterface()) {
            Collection colection = null;
            try {
                colection = paramClass.asSubclass(Collection.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new ParameterException("Could not construct an object of type " + this.typeName + " for param " + this.name + "\nProblem was: " + ex.toString());
            }
            if (this.itemClassName == null) {
                StringTokenizer strTokenizer = new StringTokenizer(stringValue, ";");
                while (strTokenizer.hasMoreTokens()) {
                    String itemStringValue = strTokenizer.nextToken();
                    colection.add(itemStringValue);
                }
                return colection;
            }
            Class<?> itemClass = null;
            try {
                itemClass = Gate.getClassLoader().loadClass(this.itemClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ParameterException("Could not construct a class object for " + this.itemClassName + " for param " + this.name + ", with type name=" + this.typeName);
            }
            StringTokenizer strTokenizer = new StringTokenizer(stringValue, ";");
            while (strTokenizer.hasMoreTokens()) {
                String itemStringValue = strTokenizer.nextToken();
                Object itemValue = null;
                try {
                    itemValue = itemClass.getConstructor(String.class).newInstance(itemStringValue);
                }
                catch (Exception e) {
                    throw new ParameterException("Could not create an object of " + this.itemClassName + " for param name " + this.name + ", with type name =" + this.typeName);
                }
                colection.add(itemValue);
            }
            return colection;
        }
        if (FeatureMap.class.isAssignableFrom(paramClass)) {
            if (stringValue == null) {
                return null;
            }
            FeatureMap fm = null;
            if (paramClass.isInterface()) {
                fm = Factory.newFeatureMap();
            } else {
                try {
                    fm = paramClass.asSubclass(FeatureMap.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new ParameterException("Could not construct an object of type " + this.typeName + " for param " + this.name + "\nProblem was: " + e.toString());
                }
            }
            StringTokenizer strTokenizer = new StringTokenizer(stringValue, ";");
            while (strTokenizer.hasMoreTokens()) {
                String keyAndValue = strTokenizer.nextToken();
                int indexOfEquals = keyAndValue.indexOf(61);
                if (indexOfEquals == -1) {
                    throw new ParameterException("Error parsing string \"" + stringValue + "\" for parameter " + this.name + " of type " + this.typeName + ". Value string must be of the form name1=value1;name2=value2;...");
                }
                String featName = keyAndValue.substring(0, indexOfEquals);
                String featValue = keyAndValue.substring(indexOfEquals + 1);
                fm.put(featName, featValue);
            }
            return fm;
        }
        if (paramClass.isEnum()) {
            if (stringValue == null) {
                return null;
            }
            try {
                return Enum.valueOf(paramClass.asSubclass(Enum.class), stringValue);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException("Invalid enum constant name " + stringValue + " for type " + this.typeName);
            }
        }
        if (this.typeName.equals("gate.creole.ResourceReference")) {
            if (stringValue == null) return value;
            if (stringValue.equals("")) return value;
            try {
                return new ResourceReference(this.plugin, stringValue);
            }
            catch (URISyntaxException e) {
                throw new ParameterException("Malformed ResourceReference parameter value: " + stringValue, e);
            }
        }
        if (this.typeName.startsWith("java.")) {
            if (this.typeName.equals("java.lang.Boolean")) {
                return Boolean.valueOf(stringValue);
            }
            if (this.typeName.equals("java.lang.Long")) {
                if (stringValue == null) return value;
                if (stringValue.equals("")) return value;
                return Long.valueOf(stringValue);
            }
            if (this.typeName.equals("java.lang.Integer")) {
                if (stringValue == null) return value;
                if (stringValue.equals("")) return value;
                return Integer.valueOf(stringValue);
            }
            if (this.typeName.equals("java.lang.String")) {
                return stringValue;
            }
            if (this.typeName.equals("java.lang.Double")) {
                if (stringValue == null) return value;
                if (stringValue.equals("")) return value;
                return Double.valueOf(stringValue);
            }
            if (this.typeName.equals("java.lang.Float")) {
                if (stringValue == null) return value;
                if (stringValue.equals("")) return value;
                return Float.valueOf(stringValue);
            }
            if (this.typeName.equals("java.net.URL")) {
                try {
                    if (stringValue == null) return value;
                    if (stringValue.equals("")) return value;
                    return new URL(this.plugin.getBaseURL(), stringValue);
                }
                catch (MalformedURLException mue) {
                    throw new ParameterException("Malformed URL parameter value: " + stringValue, mue);
                }
            }
            try {
                if (paramClass.isAssignableFrom(String.class)) return value;
                return paramClass.getConstructor(String.class).newInstance(stringValue);
            }
            catch (Exception e) {
                throw new ParameterException("Unsupported parameter type " + this.typeName);
            }
        }
        if (stringValue == null) return value;
        if (this.resData == null) {
            this.resData = (ResourceData)Gate.getCreoleRegister().get(this.typeName);
        }
        if (this.resData == null) {
            return null;
        }
        List<Resource> instantiations = this.resData.getInstantiations();
        if (instantiations.isEmpty()) return value;
        return instantiations.get(0);
    }

    public Object getDefaultValue() throws ParameterException {
        return this.calculateDefaultValue();
    }

    public void setDefaultValueString(String defaultValueString) {
        this.defaultValueString = defaultValueString;
    }

    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getSuffixes() {
        return this.suffixes;
    }

    public void setRuntime(boolean runtime) {
        this.runtime = runtime;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    protected Class<?> getParameterClass() throws ParameterException {
        try {
            ResourceData resData = (ResourceData)Gate.getCreoleRegister().get(this.typeName);
            this.paramClass = resData == null ? Gate.getClassLoader().loadClass(this.typeName) : resData.getResourceClass();
        }
        catch (ClassNotFoundException e) {
            throw new ParameterException("Couldn't find class " + this.typeName + ": " + Strings.getNl() + e);
        }
        if (this.paramClass == null) {
            throw new ParameterException("Couldn't find class " + this.typeName);
        }
        return this.paramClass;
    }

    public String toString() {
        try {
            return "Parameter: name=" + this.name + "; valueString=" + this.typeName + "; optional=" + this.optional + "; defaultValueString=" + this.defaultValueString + "; defaultValue=" + this.getDefaultValue() + "; comment=" + this.comment + "; helpURL=" + this.helpURL + "; runtime=" + this.runtime + "; itemClassName=" + this.itemClassName + "; suffixes=" + this.suffixes;
        }
        catch (ParameterException pe) {
            throw new GateRuntimeException(pe.toString());
        }
    }

    public String getItemClassName() {
        return this.itemClassName;
    }

    static {
        substituteClasses.put(Collection.class, ArrayList.class);
        substituteClasses.put(List.class, ArrayList.class);
        substituteClasses.put(Set.class, HashSet.class);
        substituteClasses.put(SortedSet.class, TreeSet.class);
        substituteClasses.put(Queue.class, LinkedList.class);
    }
}

