/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.FeatureMap;
import gate.creole.ANNIEConstants;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OConstants;
import gate.creole.ontology.Ontology;
import gate.event.FeatureMapListener;
import gate.util.GateRuntimeException;
import gate.util.SimpleMapImpl;
import java.io.Serializable;
import java.util.Set;
import java.util.Vector;

public class SimpleFeatureMapImpl
extends SimpleMapImpl
implements FeatureMap,
Serializable,
Cloneable,
ANNIEConstants {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = -2747241616127229116L;
    private transient Vector<FeatureMapListener> mapListeners;

    @Override
    public boolean subsumes(FeatureMap aFeatureMap) {
        if (aFeatureMap == null) {
            return true;
        }
        if (this.size() < aFeatureMap.size()) {
            return false;
        }
        SimpleFeatureMapImpl sfm = (SimpleFeatureMapImpl)aFeatureMap;
        for (int i = 0; i < sfm.count; ++i) {
            Object key = sfm.theKeys[i];
            Object keyValueFromAFeatureMap = sfm.theValues[i];
            int v = super.getSubsumeKey(key);
            if (v < 0) {
                return false;
            }
            Object keyValueFromThis = this.theValues[v];
            if (keyValueFromThis == null && keyValueFromAFeatureMap != null || keyValueFromThis != null && keyValueFromAFeatureMap == null) {
                return false;
            }
            if (keyValueFromThis == null || keyValueFromAFeatureMap == null || keyValueFromThis.equals(keyValueFromAFeatureMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean subsumes(Ontology ontologyLR, FeatureMap aFeatureMap) {
        if (ontologyLR == null) {
            return this.subsumes(aFeatureMap);
        }
        if (aFeatureMap == null) {
            return true;
        }
        if (this.size() < aFeatureMap.size()) {
            return false;
        }
        SimpleFeatureMapImpl sfm = (SimpleFeatureMapImpl)aFeatureMap;
        for (int i = 0; i < sfm.count; ++i) {
            Object key = sfm.theKeys[i];
            Object keyValueFromAFeatureMap = sfm.theValues[i];
            int v = super.getSubsumeKey(key);
            if (v < 0) {
                return false;
            }
            Object keyValueFromThis = this.theValues[v];
            if (keyValueFromThis == null && keyValueFromAFeatureMap != null || keyValueFromThis != null && keyValueFromAFeatureMap == null) {
                return false;
            }
            if (keyValueFromThis == null || keyValueFromAFeatureMap == null) continue;
            if (key.equals("class")) {
                try {
                    OClass superClass = this.getClassForURIOrName(ontologyLR, keyValueFromAFeatureMap.toString());
                    OClass subClass = this.getClassForURIOrName(ontologyLR, keyValueFromThis.toString());
                    if (superClass == null || subClass == null) {
                        return false;
                    }
                    return subClass.equals(superClass) || subClass.isSubClassOf(superClass, OConstants.Closure.TRANSITIVE_CLOSURE);
                }
                catch (Exception ex) {
                    throw new GateRuntimeException(ex);
                }
            }
            if (keyValueFromThis.equals(keyValueFromAFeatureMap)) continue;
            return false;
        }
        return true;
    }

    protected OClass getClassForURIOrName(Ontology ontologyLR, String name) {
        OClass cls = null;
        try {
            cls = ontologyLR.getOClass(ontologyLR.createOURI(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cls == null) {
            try {
                cls = ontologyLR.getOClass(ontologyLR.createOURIForName(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cls;
    }

    @Override
    public boolean subsumes(FeatureMap aFeatureMap, Set<? extends Object> aFeatureNamesSet) {
        if (aFeatureNamesSet == null) {
            return this.subsumes(aFeatureMap);
        }
        if (aFeatureMap == null) {
            return true;
        }
        if (aFeatureNamesSet.isEmpty()) {
            return true;
        }
        SimpleFeatureMapImpl sfm = (SimpleFeatureMapImpl)aFeatureMap;
        for (int i = 0; i < sfm.count; ++i) {
            Object key = sfm.theKeys[i];
            if (!aFeatureNamesSet.contains(key)) continue;
            Object keyValueFromAFeatureMap = sfm.theValues[i];
            Object keyValueFromThis = this.get(key);
            if (keyValueFromThis == null && keyValueFromAFeatureMap != null || keyValueFromThis != null && keyValueFromAFeatureMap == null) {
                return false;
            }
            if (keyValueFromThis == null || keyValueFromAFeatureMap == null || keyValueFromThis.equals(keyValueFromAFeatureMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object put(Object key, Object value) {
        Object result = super.put(key, value);
        this.fireMapUpdatedEvent();
        return result;
    }

    @Override
    public Object remove(Object key) {
        Object result = super.remove(key);
        this.fireMapUpdatedEvent();
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.fireMapUpdatedEvent();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized void removeFeatureMapListener(FeatureMapListener l) {
        if (this.mapListeners != null && this.mapListeners.contains(l)) {
            Vector v = (Vector)this.mapListeners.clone();
            v.removeElement(l);
            this.mapListeners = v;
        }
    }

    @Override
    public synchronized void addFeatureMapListener(FeatureMapListener l) {
        Vector v;
        Vector vector = v = this.mapListeners == null ? new Vector(2) : (Vector)this.mapListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.mapListeners = v;
        }
    }

    protected void fireMapUpdatedEvent() {
        if (this.mapListeners != null) {
            Vector<FeatureMapListener> listeners = this.mapListeners;
            int count = listeners.size();
            if (count == 0) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).featureMapUpdated();
            }
        }
    }
}

