/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.GateEvent;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationList;
import gate.gui.docview.AnnotationListView;
import gate.gui.docview.AnnotationStackView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.ColorGenerator;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;

public class AnnotationSetsView
extends AbstractDocumentView
implements DocumentListener,
AnnotationSetListener,
AnnotationEditorOwner {
    List<SetHandler> setHandlers = new ArrayList<SetHandler>();
    List<Object> tableRows = new ArrayList<Object>();
    XJTable mainTable;
    SetsTableModel tableModel;
    JScrollPane scroller;
    JPanel mainPanel;
    JTextField newSetNameTextField;
    TextualDocumentView textView;
    AnnotationListView listView;
    AnnotationStackView stackView;
    JTextArea textPane;
    OwnedAnnotationEditor annotationEditor;
    NewAnnotationSetAction newSetAction;
    protected TextMouseListener textMouseListener;
    protected PropertyChangeListener textChangeListener;
    protected BlockingQueue<TypeSpec> visibleAnnotationTypes = new LinkedBlockingQueue<TypeSpec>();
    protected Timer mouseMovementTimer;
    protected Timer eventMinder;
    protected BlockingQueue<GateEvent> pendingEvents = new LinkedBlockingQueue<GateEvent>();
    private static final int MOUSE_MOVEMENT_TIMER_DELAY = 500;
    protected MouseStoppedMovingAction mouseStoppedMovingAction;
    protected String lastAnnotationType = "_New_";
    protected ComponentOrientation currentOrientation;
    protected static final ColorGenerator colourGenerator = new ColorGenerator();
    private static final int NAME_COL = 1;
    private static final int SELECTED_COL = 0;
    private static final GateEvent END_OF_LIST = new GateEvent(AnnotationSetsView.class, Integer.MAX_VALUE);
    private static final int EVENTS_HANDLE_DELAY = 300;

    @Override
    public void annotationChanged(Annotation ann, AnnotationSet set, String oldType) {
        this.lastAnnotationType = ann.getType();
        this.setTypeSelected(set.getName(), ann.getType(), true);
    }

    public void changeOrientation(ComponentOrientation orientation) {
        this.currentOrientation = orientation;
        if (this.annotationEditor != null) {
            this.annotationEditor.changeOrientation(orientation);
        }
    }

    @Override
    public void selectAnnotation(final AnnotationData aData) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                List<AnnotationData> selAnns = Collections.singletonList(aData);
                AnnotationSetsView.this.owner.setSelectedAnnotations(selAnns);
            }
        };
        this.pendingEvents.offer(new PerformActionEvent(action));
        this.eventMinder.restart();
    }

    @Override
    public Annotation getNextAnnotation() {
        return null;
    }

    @Override
    public Annotation getPreviousAnnotation() {
        return null;
    }

    @Override
    public JTextComponent getTextComponent() {
        return this.textPane;
    }

    public AnnotationList getListComponent() {
        return this.listView;
    }

    public AnnotationSetsView() {
        this.eventMinder = new Timer(300, new HandleDocumentEventsAction());
        this.eventMinder.setRepeats(true);
        this.eventMinder.setCoalesce(true);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    protected void initGUI() {
        DocumentView aView;
        Iterator<DocumentView> centralViewsIter = this.owner.getCentralViews().iterator();
        while (this.textView == null && centralViewsIter.hasNext()) {
            DocumentView aView2 = centralViewsIter.next();
            if (!(aView2 instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)aView2;
        }
        this.textPane = (JTextArea)((JScrollPane)this.textView.getGUI()).getViewport().getView();
        Iterator<DocumentView> horizontalViewsIter = this.owner.getHorizontalViews().iterator();
        while (this.listView == null && horizontalViewsIter.hasNext()) {
            aView = horizontalViewsIter.next();
            if (!(aView instanceof AnnotationListView)) continue;
            this.listView = (AnnotationListView)aView;
        }
        horizontalViewsIter = this.owner.getHorizontalViews().iterator();
        while (this.stackView == null && horizontalViewsIter.hasNext()) {
            aView = horizontalViewsIter.next();
            if (!(aView instanceof AnnotationStackView)) continue;
            this.stackView = (AnnotationStackView)aView;
        }
        this.mainTable = new XJTable();
        this.tableModel = new SetsTableModel();
        this.mainTable.setSortable(false);
        this.mainTable.setModel(this.tableModel);
        this.mainTable.setRowMargin(0);
        this.mainTable.getColumnModel().setColumnMargin(0);
        SetsTableCellRenderer cellRenderer = new SetsTableCellRenderer();
        this.mainTable.getColumnModel().getColumn(1).setCellRenderer(cellRenderer);
        this.mainTable.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
        SetsTableCellEditor cellEditor = new SetsTableCellEditor();
        this.mainTable.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        this.mainTable.setSelectionMode(0);
        this.mainTable.setColumnSelectionAllowed(false);
        this.mainTable.setRowSelectionAllowed(true);
        this.mainTable.setSelectionMode(2);
        this.mainTable.setAutoCreateColumnsFromModel(false);
        this.mainTable.setTableHeader(null);
        this.mainTable.setShowGrid(false);
        this.mainTable.setAutoResizeMode(0);
        Color tableBG = this.mainTable.getBackground();
        tableBG = new Color(tableBG.getRGB());
        this.mainTable.setBackground(tableBG);
        this.scroller = new JScrollPane(this.mainTable);
        this.scroller.getViewport().setOpaque(true);
        this.scroller.getViewport().setBackground(tableBG);
        try {
            this.annotationEditor = this.createAnnotationEditor(this.textView, this);
        }
        catch (ResourceInstantiationException e) {
            throw new GateRuntimeException("Could not initialise the annotation editor!", e);
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.gridx = -1;
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        this.mainPanel.add((Component)this.scroller, constraints);
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.weighty = 0.0;
        this.newSetNameTextField = new JTextField();
        this.mainPanel.add((Component)this.newSetNameTextField, constraints);
        constraints.weightx = 0.0;
        this.newSetAction = new NewAnnotationSetAction();
        this.mainPanel.add((Component)new JButton(this.newSetAction), constraints);
        this.populateUI();
        this.tableModel.fireTableDataChanged();
        this.eventMinder.start();
        this.initListeners();
    }

    protected OwnedAnnotationEditor createAnnotationEditor(TextualDocumentView textView, AnnotationSetsView asView) throws ResourceInstantiationException {
        ArrayList<String> vrTypes = new ArrayList<String>(Gate.getCreoleRegister().getPublicVrTypes());
        Collections.reverse(vrTypes);
        for (String aVrType : vrTypes) {
            ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(aVrType);
            try {
                Class<? extends Resource> resClass = rData.getResourceClass();
                if (!OwnedAnnotationEditor.class.isAssignableFrom(resClass)) continue;
                OwnedAnnotationEditor newEditor = (OwnedAnnotationEditor)resClass.newInstance();
                newEditor.setOwner(this);
                newEditor.init();
                if (this.currentOrientation != null) {
                    newEditor.changeOrientation(this.currentOrientation);
                }
                return newEditor;
            }
            catch (ClassNotFoundException cnfe) {
                Err.prln("Invalid CREOLE data:");
                cnfe.printStackTrace(Err.getPrintWriter());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Err.prln("Could not find any annotation editors. Editing annotations disabled.");
        return null;
    }

    protected void populateUI() {
        this.setHandlers.add(new SetHandler(this.document.getAnnotations()));
        ArrayList setNames = this.document.getNamedAnnotationSets() == null ? new ArrayList() : new ArrayList<String>(this.document.getNamedAnnotationSets().keySet());
        Collections.sort(setNames);
        Iterator setsIter = setNames.iterator();
        while (setsIter.hasNext()) {
            this.setHandlers.add(new SetHandler(this.document.getAnnotations((String)setsIter.next())));
        }
        this.tableRows.addAll(this.setHandlers);
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    public static Color getColor(String annotationSet, String annotationType) {
        Color colour;
        Map<String, String> colourMap = Gate.getUserConfig().getMap(AnnotationSetsView.class.getName() + ".colours");
        String colourValue = colourMap.get(annotationSet + "." + annotationType);
        if (colourValue == null) {
            colourValue = colourMap.get(annotationType);
        }
        if (colourValue == null) {
            float[] components = colourGenerator.getNextColor().getComponents(null);
            colour = new Color(components[0], components[1], components[2], 0.5f);
            int rgb = colour.getRGB();
            int alpha = colour.getAlpha();
            int rgba = rgb | alpha << 24;
            colourMap.put(annotationType, String.valueOf(rgba));
            Gate.getUserConfig().put((Object)(AnnotationSetsView.class.getName() + ".colours"), colourMap);
        } else {
            colour = new Color(Integer.parseInt(colourValue), true);
        }
        return colour;
    }

    protected void saveColor(String annotationSet, String annotationType, Color colour) {
        Map<String, String> colourMap = Gate.getUserConfig().getMap(AnnotationSetsView.class.getName() + ".colours");
        int rgb = colour.getRGB();
        int alpha = colour.getAlpha();
        int rgba = rgb | alpha << 24;
        String defaultValue = colourMap.get(annotationType);
        String newValue = String.valueOf(rgba);
        if (newValue.equals(defaultValue)) {
            colourMap.remove(annotationSet + "." + annotationType);
        } else {
            colourMap.put(annotationSet + "." + annotationType, newValue);
        }
        Gate.getUserConfig().put((Object)(AnnotationSetsView.class.getName() + ".colours"), colourMap);
    }

    public void saveType(String setName, String typeName, boolean selected) {
        String prefix;
        LinkedHashSet<String> typeList = Gate.getUserConfig().getSet(AnnotationSetsView.class.getName() + ".types");
        String string = prefix = setName == null ? "." : setName + ".";
        if (selected) {
            typeList.add(prefix + typeName);
        } else {
            typeList.remove(prefix + typeName);
        }
        Gate.getUserConfig().put((Object)(AnnotationSetsView.class.getName() + ".types"), typeList);
    }

    public void restoreSavedSelectedTypes() {
        LinkedHashSet<String> typeList = Gate.getUserConfig().getSet(AnnotationSetsView.class.getName() + ".types");
        for (SetHandler sHandler : this.setHandlers) {
            String prefix = sHandler.set.getName() == null ? "." : sHandler.set.getName() + ".";
            for (TypeHandler tHandler : sHandler.typeHandlers) {
                if (!typeList.contains(prefix + tHandler.name)) continue;
                tHandler.setSelected(true);
            }
        }
    }

    public void setNewAnnSetCreationEnabled(boolean b) {
        this.newSetAction.setEnabled(b);
        this.newSetNameTextField.setEnabled(b);
    }

    @Override
    protected void registerHooks() {
        this.textPane.addMouseListener(this.textMouseListener);
        this.textPane.addMouseMotionListener(this.textMouseListener);
        this.textPane.addPropertyChangeListener("highlighter", this.textChangeListener);
        this.restoreSelectedTypes();
    }

    @Override
    protected void unregisterHooks() {
        this.textPane.removeMouseListener(this.textMouseListener);
        this.textPane.removeMouseMotionListener(this.textMouseListener);
        this.textPane.removePropertyChangeListener("highlighter", this.textChangeListener);
        this.storeSelectedTypes();
    }

    protected void storeSelectedTypes() {
        this.visibleAnnotationTypes.clear();
        for (SetHandler sHandler : this.setHandlers) {
            for (TypeHandler tHandler : sHandler.typeHandlers) {
                if (!tHandler.isSelected()) continue;
                this.visibleAnnotationTypes.add(new TypeSpec(sHandler.set.getName(), tHandler.name));
                tHandler.setSelected(false);
            }
        }
    }

    protected void restoreSelectedTypes() {
        TypeSpec typeSpec;
        while ((typeSpec = (TypeSpec)this.visibleAnnotationTypes.poll()) != null) {
            TypeHandler typeHandler = this.getTypeHandler(typeSpec.setName, typeSpec.type);
            if (typeHandler == null) continue;
            typeHandler.setSelected(true);
        }
    }

    protected void initListeners() {
        this.document.addDocumentListener(this);
        this.mainTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.processMouseEvent(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                int row = AnnotationSetsView.this.mainTable.rowAtPoint(evt.getPoint());
                if (evt.isPopupTrigger() && !AnnotationSetsView.this.mainTable.isRowSelected(row)) {
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(row, row);
                }
                this.processMouseEvent(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.processMouseEvent(evt);
            }

            protected void processMouseEvent(MouseEvent evt) {
                int row = AnnotationSetsView.this.mainTable.rowAtPoint(evt.getPoint());
                int col = AnnotationSetsView.this.mainTable.columnAtPoint(evt.getPoint());
                if (row >= 0 && col == 1) {
                    Object handler = AnnotationSetsView.this.tableRows.get(row);
                    if (evt.isPopupTrigger()) {
                        JPopupMenu popup = new JPopupMenu();
                        if (handler instanceof TypeHandler && AnnotationSetsView.this.mainTable.getSelectedRowCount() == 1) {
                            TypeHandler tHandler = (TypeHandler)handler;
                            popup.add(tHandler.changeColourAction);
                            popup.add(new DeleteSelectedAnnotationsAction("Delete"));
                        } else if (AnnotationSetsView.this.mainTable.getSelectedRowCount() > 1 || handler instanceof SetHandler) {
                            popup.add(new SetSelectedAnnotationsAction(true));
                            popup.add(new SetSelectedAnnotationsAction(false));
                            popup.add(new DeleteSelectedAnnotationsAction("Delete all"));
                        }
                        if (popup.getComponentCount() > 0) {
                            popup.show(AnnotationSetsView.this.mainTable, evt.getX(), evt.getY());
                        }
                    } else if (evt.getClickCount() >= 2 && evt.getID() == 500 && handler instanceof TypeHandler) {
                        TypeHandler tHandler = (TypeHandler)handler;
                        tHandler.changeColourAction.actionPerformed(null);
                    }
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = AnnotationSetsView.this.mainTable.getSelectedRow();
                int col = AnnotationSetsView.this.mainTable.getSelectedColumn();
                if (row <= 0 || AnnotationSetsView.this.mainTable.getSelectedRowCount() > 1) {
                    return;
                }
                Object handler = AnnotationSetsView.this.tableRows.get(row);
                if (col == 1) {
                    if (e.getKeyCode() == 10 && handler instanceof TypeHandler) {
                        TypeHandler tHandler = (TypeHandler)handler;
                        tHandler.changeColourAction.actionPerformed(null);
                        e.consume();
                    } else if (e.getKeyCode() == 32) {
                        if (handler instanceof TypeHandler) {
                            TypeHandler tHandler = (TypeHandler)handler;
                            new SetSelectedAnnotationsAction(!tHandler.selected).actionPerformed(null);
                        } else if (handler instanceof SetHandler) {
                            SetHandler sHandler = (SetHandler)handler;
                            boolean allUnselected = true;
                            for (TypeHandler tHandler : sHandler.typeHandlers) {
                                if (!tHandler.selected) continue;
                                allUnselected = false;
                                break;
                            }
                            new SetSelectedAnnotationsAction(allUnselected).actionPerformed(null);
                        }
                    } else if (e.getKeyCode() == 37) {
                        if (handler instanceof SetHandler) {
                            ((SetHandler)handler).setExpanded(false);
                            AnnotationSetsView.this.mainTable.setColumnSelectionInterval(col, col);
                            AnnotationSetsView.this.mainTable.setRowSelectionInterval(row, row);
                        }
                        e.consume();
                    } else if (e.getKeyCode() == 39) {
                        if (handler instanceof SetHandler) {
                            ((SetHandler)handler).setExpanded(true);
                            AnnotationSetsView.this.mainTable.setColumnSelectionInterval(col, col);
                            AnnotationSetsView.this.mainTable.setRowSelectionInterval(row, row);
                        }
                        e.consume();
                    }
                }
            }
        });
        this.mouseStoppedMovingAction = new MouseStoppedMovingAction();
        this.mouseMovementTimer = new Timer(500, this.mouseStoppedMovingAction);
        this.mouseMovementTimer.setRepeats(false);
        this.textMouseListener = new TextMouseListener();
        this.textChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    for (SetHandler sHandler : AnnotationSetsView.this.setHandlers) {
                        for (TypeHandler tHandler : sHandler.typeHandlers) {
                            if (!tHandler.isSelected()) continue;
                            AnnotationSetsView.this.setTypeSelected(sHandler.set.getName(), tHandler.name, false);
                            AnnotationSetsView.this.setTypeSelected(sHandler.set.getName(), tHandler.name, true);
                        }
                    }
                }
            }
        };
        this.mainTable.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "deleteAll");
        this.mainTable.getInputMap().put(KeyStroke.getKeyStroke("shift DELETE"), "deleteAll");
        this.mainTable.getActionMap().put("deleteAll", new DeleteSelectedAnnotationsAction("Delete"));
        this.newSetNameTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "newSet");
        this.newSetNameTextField.getActionMap().put("newSet", this.newSetAction);
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control E"), "edit annotation");
        this.textPane.getActionMap().put("edit annotation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationSetsView.this.mouseStoppedMovingAction.setTextLocation(AnnotationSetsView.this.textPane.getCaretPosition());
                AnnotationSetsView.this.mouseStoppedMovingAction.actionPerformed(null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AnnotationSetsView.this.annotationEditor.setPinnedMode(true);
                    }
                });
            }
        });
        InputMap im = this.mainTable.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke("TAB");
        final Action oldTabAction = this.mainTable.getActionMap().get(im.get(tab));
        AbstractAction tabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                oldTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                if (table.getSelectedColumn() == 0) {
                    oldTabAction.actionPerformed(e);
                }
            }
        };
        this.mainTable.getActionMap().put(im.get(tab), tabAction);
        KeyStroke shiftTab = KeyStroke.getKeyStroke("shift TAB");
        final Action oldShiftTabAction = this.mainTable.getActionMap().get(im.get(shiftTab));
        AbstractAction shiftTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                oldShiftTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                if (table.getSelectedColumn() == 0) {
                    oldShiftTabAction.actionPerformed(e);
                }
            }
        };
        this.mainTable.getActionMap().put(im.get(shiftTab), shiftTabAction);
    }

    @Override
    public void cleanup() {
        this.document.removeDocumentListener(this);
        for (SetHandler sHandler : this.setHandlers) {
            sHandler.set.removeAnnotationSetListener(this);
        }
        this.eventMinder.stop();
        this.pendingEvents.clear();
        super.cleanup();
        this.document = null;
    }

    @Override
    public void annotationSetAdded(DocumentEvent e) {
        this.pendingEvents.offer(e);
        this.eventMinder.restart();
    }

    @Override
    public void annotationSetRemoved(DocumentEvent e) {
        this.pendingEvents.offer(e);
        this.eventMinder.restart();
    }

    @Override
    public void contentEdited(DocumentEvent e) {
        for (SetHandler sHandler : this.setHandlers) {
            for (TypeHandler tHandler : sHandler.typeHandlers) {
                if (!tHandler.isSelected()) continue;
                tHandler.repairHighlights(e.getEditStart().intValue(), e.getEditEnd().intValue());
            }
        }
    }

    @Override
    public void annotationAdded(AnnotationSetEvent e) {
        this.pendingEvents.offer(e);
        this.eventMinder.restart();
    }

    @Override
    public void annotationRemoved(AnnotationSetEvent e) {
        this.pendingEvents.offer(e);
        this.eventMinder.restart();
    }

    protected SetHandler getSetHandler(String name) {
        for (SetHandler setHandler : this.setHandlers) {
            if (!(name == null ? setHandler.set.getName().equals("") : name.equals(setHandler.set.getName()))) continue;
            return setHandler;
        }
        return null;
    }

    public TypeHandler getTypeHandler(String set, String type) {
        for (TypeHandler typeHandler : this.getSetHandler((String)set).typeHandlers) {
            if (!typeHandler.name.equals(type)) continue;
            return typeHandler;
        }
        return null;
    }

    public void setTypeSelected(final String setName, final String typeName, final boolean selected) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TypeHandler tHandler = AnnotationSetsView.this.getTypeHandler(setName, typeName);
                if (tHandler != null) {
                    tHandler.setSelected(selected);
                    int row = AnnotationSetsView.this.tableRows.indexOf(tHandler);
                    AnnotationSetsView.this.tableModel.fireTableRowsUpdated(row, row);
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(row, row);
                } else {
                    AnnotationSetsView.this.visibleAnnotationTypes.add(new TypeSpec(setName, typeName));
                }
            }
        });
    }

    @Override
    public void setSelectedAnnotations(List<AnnotationData> selectedAnnots) {
        if (this.annotationEditor != null && this.annotationEditor.isActive()) {
            PerformActionEvent actionEvent = null;
            if (selectedAnnots.size() == 1) {
                final AnnotationData aData = selectedAnnots.get(0);
                actionEvent = new PerformActionEvent(new Runnable(){

                    @Override
                    public void run() {
                        if (AnnotationSetsView.this.annotationEditor.getAnnotationSetCurrentlyEdited() != aData.getAnnotationSet() || AnnotationSetsView.this.annotationEditor.getAnnotationCurrentlyEdited() != aData.getAnnotation()) {
                            AnnotationSetsView.this.annotationEditor.editAnnotation(aData.getAnnotation(), aData.getAnnotationSet());
                        }
                    }
                });
            } else {
                actionEvent = new PerformActionEvent(new Runnable(){

                    @Override
                    public void run() {
                        AnnotationSetsView.this.annotationEditor.editAnnotation(null, AnnotationSetsView.this.annotationEditor.getAnnotationSetCurrentlyEdited());
                    }
                });
            }
            this.pendingEvents.offer(actionEvent);
            this.eventMinder.restart();
        }
    }

    public void selectAnnotation(Annotation ann, AnnotationSet annSet) {
        this.selectAnnotation(new AnnotationDataImpl(annSet, ann));
    }

    protected class DeleteSelectedAnnotationsAction
    extends AbstractAction {
        public DeleteSelectedAnnotationsAction(String name) {
            this.putValue("Name", name);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Vector<String> resourcesToDelete = new Vector<String>();
            ArrayList<Object> handlersToDelete = new ArrayList<Object>();
            int[] selectedRows = AnnotationSetsView.this.mainTable.getSelectedRows();
            Arrays.sort(selectedRows);
            for (int row : selectedRows) {
                String setName;
                Object handler = AnnotationSetsView.this.tableRows.get(row);
                if (handler instanceof SetHandler) {
                    handlersToDelete.add(0, handler);
                    setName = ((SetHandler)handler).set.getName();
                    setName = setName == null ? "Default set" : setName;
                    resourcesToDelete.add("set: " + setName);
                    continue;
                }
                if (!(handler instanceof TypeHandler) || handlersToDelete.contains(((TypeHandler)handler).setHandler)) continue;
                handlersToDelete.add(handlersToDelete.size(), handler);
                setName = ((TypeHandler)handler).setHandler.set.getName();
                setName = setName == null ? "Default set" : setName;
                resourcesToDelete.add("type: " + ((TypeHandler)handler).name + " in set: " + setName);
            }
            if ((event.getModifiers() & 1) != 1 && (event.getModifiers() & 0x10) != 16) {
                JList list = new JList(resourcesToDelete);
                list.setVisibleRowCount(Math.min(resourcesToDelete.size() + 1, 10));
                int choice = JOptionPane.showOptionDialog(MainFrame.getInstance(), new Object[]{"Are you sure you want to delete the following annotations?", Character.valueOf('\n'), new JScrollPane(list), "<html><i>You can use Shift+Delete to bypass this dialog.</i>\n\n"}, "Delete annotations", -1, 3, null, new String[]{"Delete annotations", "Cancel"}, "Cancel");
                if (choice == -1 || choice == 1) {
                    return;
                }
            }
            Object object = handlersToDelete.iterator();
            while (object.hasNext()) {
                Object handler = object.next();
                if (handler instanceof SetHandler) {
                    SetHandler sHandler = (SetHandler)handler;
                    if (sHandler.set == AnnotationSetsView.this.document.getAnnotations()) {
                        for (Annotation annotation : new HashSet<Annotation>(sHandler.set)) {
                            sHandler.set.remove(annotation);
                        }
                        continue;
                    }
                    AnnotationSetsView.this.document.removeAnnotationSet(sHandler.set.getName());
                    continue;
                }
                if (!(handler instanceof TypeHandler)) continue;
                TypeHandler tHandler = (TypeHandler)handler;
                AnnotationSet set = tHandler.setHandler.set;
                AnnotationSet toDeleteAS = set.get(tHandler.name);
                if (toDeleteAS == null || toDeleteAS.size() <= 0) continue;
                ArrayList<Annotation> toDelete = new ArrayList<Annotation>(toDeleteAS);
                set.removeAll(toDelete);
            }
        }
    }

    protected class SetSelectedAnnotationsAction
    extends AbstractAction {
        boolean selected;

        public SetSelectedAnnotationsAction(boolean selected) {
            String title = selected ? "Select all" : "Unselect all";
            this.putValue("Name", title);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("SPACE"));
            this.selected = selected;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ArrayList<Object> handlersToSelect = new ArrayList<Object>();
            int[] selectedRows = AnnotationSetsView.this.mainTable.getSelectedRows();
            Arrays.sort(selectedRows);
            for (int row : selectedRows) {
                Object handler = AnnotationSetsView.this.tableRows.get(row);
                if (handler instanceof SetHandler) {
                    handlersToSelect.add(0, handler);
                    continue;
                }
                if (!(handler instanceof TypeHandler) || handlersToSelect.contains(((TypeHandler)handler).setHandler)) continue;
                handlersToSelect.add(handlersToSelect.size(), handler);
            }
            Object object = handlersToSelect.iterator();
            while (object.hasNext()) {
                Object handler = object.next();
                if (handler instanceof TypeHandler) {
                    TypeHandler tHandler = (TypeHandler)handler;
                    tHandler.setSelected(this.selected);
                    continue;
                }
                if (!(handler instanceof SetHandler)) continue;
                SetHandler sHandler = (SetHandler)handler;
                for (String setName : sHandler.set.getAllTypes()) {
                    TypeHandler tHandler = sHandler.getTypeHandler(setName);
                    tHandler.setSelected(this.selected);
                }
            }
        }
    }

    protected class EditAnnotationAction
    extends AbstractAction {
        private AnnotationData aData;

        public EditAnnotationAction(AnnotationData aData) {
            super(aData.getAnnotation().getType() + " [" + (aData.getAnnotationSet().getName() == null ? "  " : aData.getAnnotationSet().getName()) + "]");
            this.putValue("ShortDescription", aData.getAnnotation().getFeatures().toString());
            this.aData = aData;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (AnnotationSetsView.this.annotationEditor == null) {
                return;
            }
            if (AnnotationSetsView.this.annotationEditor.editingFinished()) {
                AnnotationSetsView.this.selectAnnotation(this.aData);
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        AnnotationSetsView.this.annotationEditor.editAnnotation(EditAnnotationAction.this.aData.getAnnotation(), EditAnnotationAction.this.aData.getAnnotationSet());
                    }
                };
                AnnotationSetsView.this.pendingEvents.offer(new PerformActionEvent(action));
                AnnotationSetsView.this.eventMinder.restart();
            }
        }
    }

    protected class HighlightMenuItem
    extends JMenuItem {
        int start;
        int end;
        Action action;
        Object highlight;

        public HighlightMenuItem(Action action, int startOffset, int endOffset, JPopupMenu popup) {
            super(action);
            this.start = startOffset;
            this.end = endOffset;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    HighlightMenuItem.this.showHighlight();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    HighlightMenuItem.this.removeHighlight();
                }
            });
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    HighlightMenuItem.this.removeHighlight();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    HighlightMenuItem.this.removeHighlight();
                }
            });
        }

        protected void showHighlight() {
            try {
                this.highlight = AnnotationSetsView.this.textPane.getHighlighter().addHighlight(this.start, this.end, DefaultHighlighter.DefaultPainter);
            }
            catch (BadLocationException ble) {
                throw new GateRuntimeException(ble.toString());
            }
        }

        protected void removeHighlight() {
            if (this.highlight != null) {
                AnnotationSetsView.this.textPane.getHighlighter().removeHighlight(this.highlight);
                this.highlight = null;
            }
        }
    }

    protected class MouseStoppedMovingAction
    extends AbstractAction {
        int textLocation;

        protected MouseStoppedMovingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (AnnotationSetsView.this.annotationEditor == null) {
                return;
            }
            if (!AnnotationSetsView.this.annotationEditor.editingFinished()) {
                return;
            }
            if (this.textLocation == -1) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            if (AnnotationSetsView.this.textPane.getSelectedText() != null && AnnotationSetsView.this.textPane.getSelectionStart() <= this.textLocation && AnnotationSetsView.this.textPane.getSelectionEnd() >= this.textLocation) {
                popup.add(new NewAnnotationAction(AnnotationSetsView.this.textPane.getSelectedText()));
                popup.addSeparator();
            }
            for (SetHandler setHandler : AnnotationSetsView.this.setHandlers) {
                for (Annotation ann : setHandler.set.get(Math.max(0L, (long)(this.textLocation - 1)), Math.min(AnnotationSetsView.this.document.getContent().size(), (long)(this.textLocation + 1)))) {
                    if (!setHandler.getTypeHandler(ann.getType()).isSelected()) continue;
                    AnnotationDataImpl annotAtPoint = new AnnotationDataImpl(setHandler.set, ann);
                    popup.add(new HighlightMenuItem(new EditAnnotationAction(annotAtPoint), annotAtPoint.getAnnotation().getStartNode().getOffset().intValue(), annotAtPoint.getAnnotation().getEndNode().getOffset().intValue(), popup));
                }
            }
            if (popup.getComponentCount() != 0) {
                if (popup.getComponentCount() == 1 || popup.getComponentCount() == 2 && popup.getComponent(1) instanceof JSeparator) {
                    ((JMenuItem)popup.getComponent(0)).getAction().actionPerformed(evt);
                } else {
                    try {
                        Rectangle rect = AnnotationSetsView.this.textPane.modelToView(this.textLocation);
                        popup.show(AnnotationSetsView.this.textPane, rect.x + 10, rect.y);
                    }
                    catch (BadLocationException ble) {
                        throw new GateRuntimeException(ble);
                    }
                }
            }
        }

        public void setTextLocation(int textLocation) {
            this.textLocation = textLocation;
        }
    }

    protected class HandleDocumentEventsAction
    extends AbstractAction {
        boolean uiDirty = false;
        private static final int MAX_EVENTS = 300;

        protected HandleDocumentEventsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.uiDirty) {
                this.rebuildDisplay();
                return;
            }
            if (AnnotationSetsView.this.pendingEvents.size() > 300) {
                this.rebuildDisplay();
                return;
            }
            while (!AnnotationSetsView.this.pendingEvents.isEmpty()) {
                GateEvent e;
                GateEvent event = (GateEvent)AnnotationSetsView.this.pendingEvents.remove();
                if (event instanceof DocumentEvent) {
                    String setName;
                    SetHandler sHandler;
                    e = (DocumentEvent)event;
                    if (event.getType() == 101) {
                        String newSetName = ((DocumentEvent)e).getAnnotationSetName();
                        sHandler = new SetHandler(AnnotationSetsView.this.document.getAnnotations(newSetName));
                        int i = 0;
                        if (newSetName != null) {
                            for (i = 1; i < AnnotationSetsView.this.setHandlers.size() && AnnotationSetsView.this.setHandlers.get((int)i).set.getName().compareTo(newSetName) <= 0; ++i) {
                            }
                        }
                        AnnotationSetsView.this.setHandlers.add(i, sHandler);
                        int j = 0;
                        if (i > 0) {
                            SetHandler previousHandler = AnnotationSetsView.this.setHandlers.get(i - 1);
                            while (AnnotationSetsView.this.tableRows.get(j) != previousHandler) {
                                ++j;
                            }
                            if (previousHandler.isExpanded()) {
                                j += previousHandler.typeHandlers.size();
                            }
                            ++j;
                        }
                        AnnotationSetsView.this.tableRows.add(j, sHandler);
                        AnnotationSetsView.this.tableModel.fireTableRowsInserted(j, j);
                        continue;
                    }
                    if (event.getType() != 102 || (sHandler = AnnotationSetsView.this.getSetHandler(setName = ((DocumentEvent)e).getAnnotationSetName())) == null) continue;
                    sHandler.set.removeAnnotationSetListener(AnnotationSetsView.this);
                    for (TypeHandler tHandler : sHandler.typeHandlers) {
                        tHandler.setSelected(false);
                    }
                    AnnotationSetsView.this.setHandlers.remove(sHandler);
                    int row = AnnotationSetsView.this.tableRows.indexOf(sHandler);
                    AnnotationSetsView.this.tableRows.remove(row);
                    int removed = 1;
                    if (sHandler.isExpanded()) {
                        for (int i = 0; i < sHandler.typeHandlers.size(); ++i) {
                            AnnotationSetsView.this.tableRows.remove(row);
                            ++removed;
                        }
                    }
                    AnnotationSetsView.this.tableModel.fireTableRowsDeleted(row, row + removed - 1);
                    sHandler.cleanup();
                    continue;
                }
                if (event instanceof AnnotationSetEvent) {
                    TypeHandler tHandler;
                    e = (AnnotationSetEvent)event;
                    AnnotationSet set = (AnnotationSet)e.getSource();
                    Annotation ann = ((AnnotationSetEvent)e).getAnnotation();
                    if (event.getType() == 201) {
                        TypeHandler tHandler2 = AnnotationSetsView.this.getTypeHandler(set.getName(), ann.getType());
                        if (tHandler2 == null) {
                            SetHandler sHandler = AnnotationSetsView.this.getSetHandler(set.getName());
                            tHandler2 = sHandler.newType(ann.getType());
                        }
                        tHandler2.annotationAdded(ann);
                        continue;
                    }
                    if (event.getType() != 202 || (tHandler = AnnotationSetsView.this.getTypeHandler(set.getName(), ann.getType())) == null) continue;
                    tHandler.annotationRemoved(ann);
                    continue;
                }
                if (!(event instanceof PerformActionEvent)) continue;
                ((PerformActionEvent)event).run();
            }
        }

        protected void rebuildDisplay() {
            this.uiDirty = false;
            try {
                GateEvent event;
                AnnotationSetsView.this.pendingEvents.offer(END_OF_LIST);
                while ((event = (GateEvent)AnnotationSetsView.this.pendingEvents.poll()) != END_OF_LIST) {
                    if (event instanceof DocumentEvent || event instanceof AnnotationSetEvent) continue;
                    AnnotationSetsView.this.pendingEvents.offer(event);
                }
                AnnotationSetsView.this.storeSelectedTypes();
                HashMap<String, Boolean> expandedSets = new HashMap<String, Boolean>();
                for (SetHandler sHandler : AnnotationSetsView.this.setHandlers) {
                    expandedSets.put(sHandler.set.getName(), sHandler.isExpanded());
                    sHandler.typeHandlers.clear();
                    sHandler.typeHandlersByType.clear();
                    sHandler.set.removeAnnotationSetListener(AnnotationSetsView.this);
                }
                AnnotationSetsView.this.setHandlers.clear();
                AnnotationSetsView.this.tableRows.clear();
                AnnotationSetsView.this.listView.removeAnnotations(AnnotationSetsView.this.listView.getAllAnnotations());
                AnnotationSetsView.this.stackView.updateStackView();
                AnnotationSetsView.this.populateUI();
                AnnotationSetsView.this.restoreSelectedTypes();
                AnnotationSetsView.this.tableModel.fireTableDataChanged();
                for (SetHandler sHandler : AnnotationSetsView.this.setHandlers) {
                    sHandler.setExpanded((Boolean)expandedSets.get(sHandler.set.getName()));
                }
            }
            catch (Throwable t) {
                this.uiDirty = true;
            }
        }
    }

    private class PerformActionEvent
    extends GateEvent {
        private Action action;
        private Runnable runnable;

        public PerformActionEvent(Runnable runnable) {
            super(AnnotationSetsView.this, 0);
            this.runnable = runnable;
            this.action = null;
        }

        public PerformActionEvent(Action action) {
            super(AnnotationSetsView.this, 0);
            this.runnable = null;
            this.action = action;
        }

        public void run() {
            if (this.runnable != null) {
                this.runnable.run();
            } else if (this.action != null) {
                this.action.actionPerformed(null);
            }
        }
    }

    protected class NewAnnotationAction
    extends AbstractAction {
        public NewAnnotationAction(String selection) {
            super("Create new annotation");
            this.putValue("ShortDescription", "Creates a new annotation from the selection: [" + Strings.crop(selection, 30) + "]");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int end;
            if (AnnotationSetsView.this.annotationEditor == null) {
                return;
            }
            int start = AnnotationSetsView.this.textPane.getSelectionStart();
            if (start != (end = AnnotationSetsView.this.textPane.getSelectionEnd())) {
                AnnotationSetsView.this.textPane.setSelectionStart(start);
                AnnotationSetsView.this.textPane.setSelectionEnd(start);
                int row = AnnotationSetsView.this.mainTable.getSelectedRow();
                if (row < 0) {
                    row = 0;
                }
                while (!(AnnotationSetsView.this.tableRows.get(row) instanceof SetHandler)) {
                    --row;
                }
                AnnotationSet set = ((SetHandler)AnnotationSetsView.this.tableRows.get((int)row)).set;
                try {
                    Integer annId = set.add(new Long(start), new Long(end), AnnotationSetsView.this.lastAnnotationType, Factory.newFeatureMap());
                    Annotation ann = set.get(annId);
                    if (AnnotationSetsView.this.tableRows.get(row) instanceof SetHandler) {
                        ((SetHandler)AnnotationSetsView.this.tableRows.get(row)).setExpanded(true);
                        AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                    AnnotationSetsView.this.setTypeSelected(set.getName(), ann.getType(), true);
                    AnnotationSetsView.this.pendingEvents.offer(new PerformActionEvent(new EditAnnotationAction(new AnnotationDataImpl(set, ann))));
                    AnnotationSetsView.this.eventMinder.restart();
                }
                catch (InvalidOffsetException ioe) {
                    throw new GateRuntimeException(ioe);
                }
            }
        }
    }

    protected class NewAnnotationSetAction
    extends AbstractAction {
        public NewAnnotationSetAction() {
            super("New");
            this.putValue("ShortDescription", "Creates a new annotation set");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String name = AnnotationSetsView.this.newSetNameTextField.getText();
            AnnotationSetsView.this.newSetNameTextField.setText("");
            if (name != null && name.length() > 0) {
                AnnotationSet set = AnnotationSetsView.this.document.getAnnotations(name);
                int row = -1;
                for (int i = 0; i < AnnotationSetsView.this.tableRows.size() && row < 0; ++i) {
                    if (!(AnnotationSetsView.this.tableRows.get(i) instanceof SetHandler) || ((SetHandler)AnnotationSetsView.this.tableRows.get((int)i)).set != set) continue;
                    row = i;
                }
                if (row >= 0) {
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        }
    }

    protected class TextMouseListener
    implements MouseInputListener {
        protected TextMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            AnnotationSetsView.this.mouseMovementTimer.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent e) {
            int modEx = e.getModifiersEx();
            if ((modEx & 0x80) != 0) {
                AnnotationSetsView.this.mouseMovementTimer.stop();
                return;
            }
            if ((modEx & 0x400) != 0) {
                AnnotationSetsView.this.mouseMovementTimer.stop();
                return;
            }
            int textLocation = AnnotationSetsView.this.textPane.viewToModel(e.getPoint());
            try {
                Rectangle viewLocation = AnnotationSetsView.this.textPane.modelToView(textLocation);
                int error = 10;
                viewLocation = new Rectangle(viewLocation.x - error, viewLocation.y - error, viewLocation.width + 2 * error, viewLocation.height + 2 * error);
                if (viewLocation.contains(e.getPoint())) {
                    AnnotationSetsView.this.mouseStoppedMovingAction.setTextLocation(textLocation);
                } else {
                    AnnotationSetsView.this.mouseStoppedMovingAction.setTextLocation(-1);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                AnnotationSetsView.this.mouseMovementTimer.restart();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AnnotationSetsView.this.mouseMovementTimer.stop();
        }
    }

    private static class TypeSpec {
        private String setName;
        private String type;

        public TypeSpec(String setName, String type) {
            this.setName = setName;
            this.type = type;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.setName == null ? 0 : this.setName.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeSpec other = (TypeSpec)obj;
            if (this.setName == null ? other.setName != null : !this.setName.equals(other.setName)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public class TypeHandler {
        ChangeColourAction changeColourAction;
        boolean selected;
        Map<Integer, TextualDocumentView.HighlightData> hghltTagsForAnnId;
        Map<Integer, AnnotationData> annListTagsForAnn;
        String name;
        SetHandler setHandler;
        Color colour;
        int annotationCount;

        TypeHandler(SetHandler setHandler, String name) {
            this.setHandler = setHandler;
            this.name = name;
            this.colour = AnnotationSetsView.getColor(setHandler.set.getName(), name);
            this.hghltTagsForAnnId = new HashMap<Integer, TextualDocumentView.HighlightData>();
            this.annListTagsForAnn = new HashMap<Integer, AnnotationData>();
            this.changeColourAction = new ChangeColourAction();
            this.annotationCount = 0;
        }

        public Color getColour() {
            return this.colour;
        }

        public void setColour(Color colour) {
            int row;
            if (this.colour.equals(colour)) {
                return;
            }
            this.colour = colour;
            AnnotationSetsView.this.saveColor(this.setHandler.set.getName(), this.name, colour);
            if (this.isSelected()) {
                AnnotationSetsView.this.textView.removeHighlights(this.hghltTagsForAnnId.values());
                this.hghltTagsForAnnId.clear();
                ArrayList<Annotation> annots = new ArrayList<Annotation>(this.setHandler.set.get(this.name));
                ArrayList<AnnotationData> aDataList = new ArrayList<AnnotationData>();
                for (Annotation ann : annots) {
                    aDataList.add(new AnnotationDataImpl(this.setHandler.set, ann));
                }
                List<TextualDocumentView.HighlightData> tags = AnnotationSetsView.this.textView.addHighlights(aDataList, this.colour);
                for (int i = 0; i < annots.size(); ++i) {
                    this.hghltTagsForAnnId.put(((Annotation)annots.get(i)).getId(), tags.get(i));
                }
            }
            if ((row = AnnotationSetsView.this.tableRows.indexOf(this)) >= 0) {
                AnnotationSetsView.this.tableModel.fireTableRowsUpdated(row, row);
            }
            if (AnnotationSetsView.this.stackView.isActive()) {
                AnnotationSetsView.this.stackView.updateStackView();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(boolean selected) {
            if (this.selected == selected) {
                return;
            }
            this.selected = selected;
            ArrayList<Annotation> annots = new ArrayList<Annotation>(this.setHandler.set.get(this.name));
            if (selected) {
                this.setHandler.setExpanded(true);
                this.annListTagsForAnn.clear();
                List<AnnotationData> listTags = AnnotationSetsView.this.listView.addAnnotations(annots, this.setHandler.set);
                for (AnnotationData aData : listTags) {
                    this.annListTagsForAnn.put(aData.getAnnotation().getId(), aData);
                }
                this.hghltTagsForAnnId.clear();
                List<TextualDocumentView.HighlightData> tags = AnnotationSetsView.this.textView.addHighlights(listTags, this.colour);
                for (int i = 0; i < annots.size(); ++i) {
                    this.hghltTagsForAnnId.put(((Annotation)annots.get(i)).getId(), tags.get(i));
                }
            } else {
                try {
                    AnnotationSetsView.this.listView.removeAnnotations(this.annListTagsForAnn.values());
                    AnnotationSetsView.this.textView.removeHighlights(this.hghltTagsForAnnId.values());
                }
                finally {
                    this.hghltTagsForAnnId.clear();
                    this.annListTagsForAnn.clear();
                }
            }
            int row = AnnotationSetsView.this.tableRows.indexOf(this);
            AnnotationSetsView.this.tableModel.fireTableRowsUpdated(row, row);
            AnnotationSetsView.this.saveType(this.setHandler.set.getName(), this.name, selected);
            AnnotationSetsView.this.stackView.updateStackView();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void annotationAdded(Annotation ann) {
            ++this.annotationCount;
            if (this.selected) {
                if (!this.hghltTagsForAnnId.containsKey(ann.getId())) {
                    this.hghltTagsForAnnId.put(ann.getId(), AnnotationSetsView.this.textView.addHighlight(new AnnotationDataImpl(this.setHandler.set, ann), this.colour));
                }
                if (!this.annListTagsForAnn.containsKey(ann.getId())) {
                    this.annListTagsForAnn.put(ann.getId(), AnnotationSetsView.this.listView.addAnnotation(ann, this.setHandler.set));
                }
                AnnotationSetsView.this.stackView.updateStackView();
            }
        }

        public void annotationRemoved(Annotation ann) {
            --this.annotationCount;
            if (this.selected) {
                TextualDocumentView.HighlightData tag = this.hghltTagsForAnnId.remove(ann.getId());
                if (tag != null) {
                    AnnotationSetsView.this.textView.removeHighlight(tag);
                }
                AnnotationData listTag = this.annListTagsForAnn.remove(ann.getId());
                if (tag != null) {
                    AnnotationSetsView.this.listView.removeAnnotation(listTag);
                }
                AnnotationSetsView.this.stackView.updateStackView();
            }
            if (this.annotationCount == 0) {
                this.setHandler.removeType(this);
            }
        }

        protected void repairHighlights(int start, int end) {
            ArrayList<TextualDocumentView.HighlightData> tags = new ArrayList<TextualDocumentView.HighlightData>(this.hghltTagsForAnnId.size());
            ArrayList<Annotation> annots = new ArrayList<Annotation>(this.hghltTagsForAnnId.size());
            Iterator<Integer> annIter = this.hghltTagsForAnnId.keySet().iterator();
            while (annIter.hasNext()) {
                Annotation ann = this.setHandler.set.get(annIter.next());
                if (ann == null) continue;
                int annStart = ann.getStartNode().getOffset().intValue();
                int annEnd = ann.getEndNode().getOffset().intValue();
                if ((annStart > start || start > annEnd) && (start > annStart || annStart > end)) continue;
                if (!this.hghltTagsForAnnId.containsKey(ann.getId())) {
                    System.out.println("Error!!!");
                }
                tags.add(this.hghltTagsForAnnId.get(ann.getId()));
                annots.add(ann);
            }
            for (int i = 0; i < tags.size(); ++i) {
                Object tag = tags.get(i);
                Annotation ann = (Annotation)annots.get(i);
                try {
                    AnnotationSetsView.this.textView.moveHighlight(tag, ann.getStartNode().getOffset().intValue(), ann.getEndNode().getOffset().intValue());
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected class ChangeColourAction
        extends AbstractAction {
            public ChangeColourAction() {
                super("Change colour");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ENTER"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color col = JColorChooser.showDialog(AnnotationSetsView.this.mainTable, "Select colour for \"" + TypeHandler.this.name + "\"", TypeHandler.this.colour);
                if (col != null) {
                    Color colAlpha = new Color(col.getRed(), col.getGreen(), col.getBlue(), 128);
                    TypeHandler.this.setColour(colAlpha);
                }
            }
        }
    }

    public class SetHandler {
        AnnotationSet set;
        List<TypeHandler> typeHandlers;
        Map<String, TypeHandler> typeHandlersByType;
        private boolean expanded = false;

        SetHandler(AnnotationSet set) {
            this.set = set;
            this.typeHandlers = new ArrayList<TypeHandler>();
            this.typeHandlersByType = new HashMap<String, TypeHandler>();
            ArrayList<String> typeNames = new ArrayList<String>(set.getAllTypes());
            Collections.sort(typeNames);
            for (String name : typeNames) {
                TypeHandler tHandler = new TypeHandler(this, name);
                tHandler.annotationCount = set.get(name).size();
                this.typeHandlers.add(tHandler);
                this.typeHandlersByType.put(name, tHandler);
            }
            set.addAnnotationSetListener(AnnotationSetsView.this);
        }

        public void cleanup() {
            this.set.removeAnnotationSetListener(AnnotationSetsView.this);
            this.typeHandlers.clear();
        }

        public TypeHandler newType(String type) {
            TypeSpec typeSpec;
            int pos;
            TypeHandler tHandler = new TypeHandler(this, type);
            for (pos = 0; pos < this.typeHandlers.size() && this.typeHandlers.get((int)pos).name.compareTo(type) <= 0; ++pos) {
            }
            this.typeHandlers.add(pos, tHandler);
            this.typeHandlersByType.put(type, tHandler);
            int row = AnnotationSetsView.this.mainTable.getSelectedRow();
            int setRow = AnnotationSetsView.this.tableRows.indexOf(this);
            if (this.typeHandlers.size() == 1) {
                AnnotationSetsView.this.tableModel.fireTableRowsUpdated(setRow, setRow);
            }
            if (this.expanded) {
                AnnotationSetsView.this.tableRows.add(setRow + pos + 1, tHandler);
                AnnotationSetsView.this.tableModel.fireTableRowsInserted(setRow + pos + 1, setRow + pos + 1);
            }
            if (row != -1) {
                AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(row, row);
            }
            if (AnnotationSetsView.this.visibleAnnotationTypes.remove(typeSpec = new TypeSpec(this.set.getName(), type))) {
                tHandler.setSelected(true);
            }
            return tHandler;
        }

        public void removeType(TypeHandler tHandler) {
            int setRow = AnnotationSetsView.this.tableRows.indexOf(this);
            int pos = this.typeHandlers.indexOf(tHandler);
            if (setRow != -1 && pos != -1) {
                this.typeHandlers.remove(pos);
                this.typeHandlersByType.remove(tHandler.name);
                int row = AnnotationSetsView.this.mainTable.getSelectedRow();
                if (this.expanded) {
                    AnnotationSetsView.this.tableRows.remove(setRow + pos + 1);
                    AnnotationSetsView.this.tableModel.fireTableRowsDeleted(setRow + pos + 1, setRow + pos + 1);
                }
                if (row != -1) {
                    if (AnnotationSetsView.this.mainTable.getRowCount() <= row) {
                        row = AnnotationSetsView.this.mainTable.getRowCount() - 1;
                    }
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        }

        public void removeType(String type) {
            this.removeType(this.typeHandlersByType.get(type));
        }

        public TypeHandler getTypeHandler(String type) {
            return this.typeHandlersByType.get(type);
        }

        public void setExpanded(boolean expanded) {
            if (this.expanded == expanded) {
                return;
            }
            this.expanded = expanded;
            int myPosition = AnnotationSetsView.this.tableRows.indexOf(this);
            if (expanded) {
                AnnotationSetsView.this.tableRows.addAll(myPosition + 1, this.typeHandlers);
                AnnotationSetsView.this.tableModel.fireTableRowsInserted(myPosition + 1, myPosition + 1 + this.typeHandlers.size());
            } else {
                for (int i = 0; i < this.typeHandlers.size(); ++i) {
                    AnnotationSetsView.this.tableRows.remove(myPosition + 1);
                }
                AnnotationSetsView.this.tableModel.fireTableRowsDeleted(myPosition + 1, myPosition + 1 + this.typeHandlers.size());
            }
            AnnotationSetsView.this.tableModel.fireTableRowsUpdated(myPosition, myPosition);
        }

        public boolean isExpanded() {
            return this.expanded;
        }
    }

    protected class SetsTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JCheckBox currentChk;
        JCheckBox setChk = new JCheckBox();
        JCheckBox typeChk;

        public SetsTableCellEditor() {
            this.setChk.setSelectedIcon(MainFrame.getIcon("expanded"));
            this.setChk.setIcon(MainFrame.getIcon("closed"));
            this.setChk.setOpaque(true);
            this.setChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SetsTableCellEditor.this.fireEditingStopped();
                }
            });
            this.typeChk = new JCheckBox();
            this.typeChk.setOpaque(false);
            this.typeChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SetsTableCellEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            value = AnnotationSetsView.this.tableRows.get(row);
            if (value instanceof SetHandler) {
                SetHandler sHandler = (SetHandler)value;
                switch (column) {
                    case 1: {
                        return null;
                    }
                    case 0: {
                        this.setChk.setSelected(sHandler.isExpanded());
                        this.setChk.setEnabled(sHandler.typeHandlers.size() > 0);
                        this.setChk.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        this.currentChk = this.setChk;
                        return this.setChk;
                    }
                }
            } else if (value instanceof TypeHandler) {
                TypeHandler tHandler = (TypeHandler)value;
                switch (column) {
                    case 1: {
                        return null;
                    }
                    case 0: {
                        this.typeChk.setSelected(tHandler.isSelected());
                        this.currentChk = this.typeChk;
                        return this.typeChk;
                    }
                }
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return new Boolean(this.currentChk.isSelected());
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }
    }

    protected class SetsTableCellRenderer
    implements TableCellRenderer {
        protected JLabel typeLabel;
        protected JLabel setLabel;
        protected JCheckBox setChk;
        protected JCheckBox typeChk;
        protected Border selectedBorder;
        protected Border normalBorder;

        public SetsTableCellRenderer() {
            this.typeLabel = new JLabel(){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                }
            };
            this.typeLabel.setOpaque(true);
            this.typeLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, AnnotationSetsView.this.mainTable.getBackground()), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.setLabel = new JLabel(){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                }
            };
            this.setLabel.setOpaque(true);
            this.setLabel.setFont(this.setLabel.getFont().deriveFont(1));
            this.setLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.typeChk = new JCheckBox(){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                }
            };
            this.typeChk.setOpaque(true);
            this.setChk = new JCheckBox(){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                }
            };
            this.setChk.setSelectedIcon(MainFrame.getIcon("expanded"));
            this.setChk.setIcon(MainFrame.getIcon("closed"));
            this.setChk.setMaximumSize(this.setChk.getMinimumSize());
            this.setChk.setOpaque(true);
            this.normalBorder = BorderFactory.createLineBorder(AnnotationSetsView.this.mainTable.getBackground(), 2);
            this.selectedBorder = BorderFactory.createLineBorder(AnnotationSetsView.this.mainTable.getSelectionBackground(), 2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            value = AnnotationSetsView.this.tableRows.get(row);
            if (value instanceof SetHandler) {
                SetHandler sHandler = (SetHandler)value;
                switch (column) {
                    case 1: {
                        this.setLabel.setText(sHandler.set.getName());
                        this.setLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        return this.setLabel;
                    }
                    case 0: {
                        this.setChk.setSelected(sHandler.isExpanded());
                        this.setChk.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        this.setChk.setEnabled(sHandler.typeHandlers.size() > 0);
                        return this.setChk;
                    }
                }
            } else if (value instanceof TypeHandler) {
                TypeHandler tHandler = (TypeHandler)value;
                switch (column) {
                    case 1: {
                        this.typeLabel.setBackground(tHandler.colour);
                        this.typeLabel.setText(tHandler.name);
                        this.typeLabel.setBorder(isSelected ? this.selectedBorder : this.normalBorder);
                        return this.typeLabel;
                    }
                    case 0: {
                        this.typeChk.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        this.typeChk.setSelected(tHandler.isSelected());
                        return this.typeChk;
                    }
                }
            }
            this.typeLabel.setText("?");
            return this.typeLabel;
        }
    }

    protected class SetsTableModel
    extends AbstractTableModel {
        protected SetsTableModel() {
        }

        @Override
        public int getRowCount() {
            return AnnotationSetsView.this.tableRows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object value = AnnotationSetsView.this.tableRows.get(row);
            switch (column) {
                case 1: {
                    return value;
                }
                case 0: {
                    if (value instanceof SetHandler) {
                        return new Boolean(((SetHandler)value).isExpanded());
                    }
                    if (value instanceof TypeHandler) {
                        return new Boolean(((TypeHandler)value).isSelected());
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Object value = AnnotationSetsView.this.tableRows.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    return false;
                }
                case 0: {
                    if (value instanceof SetHandler) {
                        return ((SetHandler)value).typeHandlers.size() > 0;
                    }
                    if (!(value instanceof TypeHandler)) break;
                    return true;
                }
            }
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Object receiver = AnnotationSetsView.this.tableRows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (receiver instanceof SetHandler) {
                        ((SetHandler)receiver).setExpanded((Boolean)aValue);
                        break;
                    }
                    if (!(receiver instanceof TypeHandler)) break;
                    ((TypeHandler)receiver).setSelected((Boolean)aValue);
                    break;
                }
            }
        }
    }
}

