/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.creole.manager;

import gate.creole.Plugin;
import gate.gui.MainFrame;
import gate.gui.creole.manager.AvailablePlugins;
import gate.gui.creole.manager.ProgressPanel;
import gate.resources.img.svg.AvailableIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PluginUpdateManager
extends JDialog {
    private AvailablePlugins installed = new AvailablePlugins();
    private ProgressPanel progressPanel = new ProgressPanel();
    private JPanel panel = new JPanel(new BorderLayout());
    private JTabbedPane tabs = new JTabbedPane();
    private static Set<Plugin> defaultPlugins = null;

    private void loadData() {
        this.progressPanel.messageChanged("Loading CREOLE Plugin Information...");
        new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        PluginUpdateManager.this.installed.reInit();
                        PluginUpdateManager.this.showProgressPanel(false);
                    }
                });
            }
        }.start();
    }

    private void showProgressPanel(boolean visible) {
        if (visible == this.getRootPane().getGlassPane().isVisible()) {
            return;
        }
        this.progressPanel.reset();
        if (visible) {
            this.remove(this.panel);
            this.add((Component)this.progressPanel, "Center");
        } else {
            this.remove(this.progressPanel);
            this.add((Component)this.panel, "Center");
        }
        this.getRootPane().getGlassPane().setVisible(visible);
        this.validate();
    }

    private void applyChanges() {
        this.progressPanel.messageChanged("Updating CREOLE Plugin Configuration...");
        this.showProgressPanel(true);
        new Thread(){

            @Override
            public void run() {
                PluginUpdateManager.this.progressPanel.messageChanged("Updating CREOLE Plugin Configuration...");
                Set<Plugin> failedPlugins = PluginUpdateManager.this.installed.updateAvailablePlugins(PluginUpdateManager.this.progressPanel);
                if (!failedPlugins.isEmpty()) {
                    JOptionPane.showMessageDialog(PluginUpdateManager.this, "<html><body style='width: 350px;'><b>Loading of " + failedPlugins.size() + " plugins failed!</b><br><br>See the message pane for more details.</body></html>", PluginUpdateManager.this.getTitle(), 0);
                }
                PluginUpdateManager.this.loadData();
            }
        }.start();
    }

    @Override
    public void dispose() {
        MainFrame.getGuiRoots().remove(this);
        super.dispose();
    }

    public PluginUpdateManager(JFrame owner) {
        super((Frame)owner, true);
        this.setTitle("CREOLE Plugin Manager");
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panel.add((Component)this.tabs, "Center");
        this.tabs.addTab("Installed Plugins", new AvailableIcon(MainFrame.ICON_DIMENSION), this.installed);
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new BoxLayout(pnlButtons, 0));
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JButton btnApply = new JButton("Apply All");
        this.getRootPane().setDefaultButton(btnApply);
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginUpdateManager.this.applyChanges();
            }
        });
        AbstractAction cancelAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean changes = false;
                if (!changes) {
                    changes = PluginUpdateManager.this.installed.unsavedChanges();
                }
                if (changes && JOptionPane.showConfirmDialog(PluginUpdateManager.this, "<html><body style='width: 350px;'><b>Changes Have Not Yet Been Applied!</b><br><br>Would you like to apply your changes now?</body></html>", "CREOLE Plugin Manager", 0, 3) == 0) {
                    PluginUpdateManager.this.applyChanges();
                }
                PluginUpdateManager.this.setVisible(false);
            }
        };
        JButton btnCancel = new JButton(cancelAction);
        AbstractAction helpAction = new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showHelpFrame("sec:howto:plugins", "gate.gui.creole.PluginUpdateManager");
            }
        };
        JButton btnHelp = new JButton(helpAction);
        pnlButtons.add(btnHelp);
        pnlButtons.add(Box.createHorizontalGlue());
        pnlButtons.add(btnApply);
        pnlButtons.add(Box.createHorizontalStrut(5));
        pnlButtons.add(btnCancel);
        this.panel.add((Component)pnlButtons, "South");
        this.add((Component)this.panel, "Center");
        this.getRootPane().registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 2);
        this.pack();
        Dimension screenSize = this.getGraphicsConfiguration().getBounds().getSize();
        Dimension dialogSize = this.getPreferredSize();
        int width = dialogSize.width > screenSize.width ? screenSize.width * 3 / 4 : dialogSize.width;
        int height = dialogSize.height > screenSize.height ? screenSize.height * 2 / 3 : dialogSize.height;
        this.setSize(width, height);
        this.validate();
        this.setLocationRelativeTo(owner);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            MainFrame.getGuiRoots().add(this);
            this.tabs.setSelectedIndex(0);
            this.installed.reInit();
        }
        super.setVisible(visible);
        this.dispose();
    }

    public static void loadDefaultPlugins() {
        if (defaultPlugins != null) {
            return;
        }
        defaultPlugins = new HashSet<Plugin>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(PluginUpdateManager.class.getClassLoader().getResource("gate/resources/creole/defaultPlugins.tsv").openStream()));){
            String line = in.readLine();
            while (line != null) {
                try {
                    String[] parts = line.split("\t", 3);
                    if (parts.length == 3) {
                        Plugin.Maven plugin = new Plugin.Maven(parts[0], parts[1], parts[2]);
                        plugin.getMetadataXML();
                        defaultPlugins.add(plugin);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = in.readLine();
            }
        }
        catch (IOException ioe) {
            System.err.println("Unable to completely load list of default plugins");
            ioe.printStackTrace();
        }
    }

    public static synchronized Set<Plugin> getDefaultPlugins() {
        if (defaultPlugins == null) {
            return new HashSet<Plugin>();
        }
        return Collections.unmodifiableSet(defaultPlugins);
    }
}

