/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.creole.manager;

import gate.Gate;
import gate.Main;
import gate.creole.CreoleRegisterImpl;
import gate.creole.Plugin;
import gate.gui.MainFrame;
import gate.resources.img.svg.AddIcon;
import gate.resources.img.svg.AvailableIcon;
import gate.resources.img.svg.DeleteIcon;
import gate.resources.img.svg.GATEIcon;
import gate.resources.img.svg.InvalidIcon;
import gate.resources.img.svg.MavenIcon;
import gate.resources.img.svg.OpenFileIcon;
import gate.resources.img.svg.RemotePluginIcon;
import gate.resources.img.svg.RemoveIcon;
import gate.resources.img.svg.SaveIcon;
import gate.resources.img.svg.UserPluginIcon;
import gate.swing.CheckBoxTableCellRenderer;
import gate.swing.IconTableCellRenderer;
import gate.swing.SpringUtilities;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AvailablePlugins
extends JPanel {
    private XJTable mainTable;
    private List<Plugin> visibleRows = new ArrayList<Plugin>();
    private JSplitPane mainSplit;
    private MainTableModel mainTableModel;
    private ResourcesListModel resourcesListModel;
    private JList<Gate.ResourceInfo> resourcesList;
    private JLabel lblPluginDetails;
    private JButton btnResources;
    private ExtractResourcesActionListener extractResourcesListener = new ExtractResourcesActionListener();
    private JTextField filterTextField;
    private Map<Plugin, Boolean> loadNowByURL = new HashMap<Plugin, Boolean>();
    private Map<Plugin, Boolean> loadAlwaysByURL = new HashMap<Plugin, Boolean>();
    private static final int ICON_COLUMN = 0;
    private static final int NAME_COLUMN = 3;
    private static final int LOAD_NOW_COLUMN = 1;
    private static final int LOAD_ALWAYS_COLUMN = 2;

    public AvailablePlugins() {
        JToolBar tbPluginDirs = new JToolBar(0);
        tbPluginDirs.setFloatable(false);
        tbPluginDirs.setLayout(new BoxLayout(tbPluginDirs, 0));
        tbPluginDirs.add(new JButton(new AddCreoleRepositoryAction()));
        tbPluginDirs.add(new JButton(new DeleteCreoleRepositoryAction()));
        tbPluginDirs.add(Box.createHorizontalStrut(5));
        JLabel titleLabel = new JLabel("CREOLE Plugin");
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 40));
        tbPluginDirs.add(titleLabel);
        tbPluginDirs.add(Box.createHorizontalGlue());
        tbPluginDirs.add(new JLabel("Filter:"));
        this.filterTextField = new JTextField();
        this.filterTextField.setToolTipText("Type some text to filter the table rows.");
        tbPluginDirs.add(this.filterTextField);
        JButton clearFilterButton = new JButton(new AbstractAction(null, new DeleteIcon(MainFrame.ICON_DIMENSION)){
            {
                this.putValue("MnemonicKey", 8);
                this.putValue("ShortDescription", "Clear text field");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AvailablePlugins.this.filterTextField.setText("");
                AvailablePlugins.this.filterTextField.requestFocusInWindow();
            }
        });
        tbPluginDirs.add(clearFilterButton);
        this.mainTableModel = new MainTableModel();
        this.mainTable = new XJTable(this.mainTableModel);
        this.mainTable.setTabSkipUneditableCell(true);
        this.mainTable.setSortedColumn(3);
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        collator.setStrength(2);
        this.mainTable.setComparator(3, collator);
        this.mainTable.setSelectionMode(2);
        this.mainTable.getColumnModel().getColumn(0).setCellRenderer(new IconTableCellRenderer());
        CheckBoxTableCellRenderer cbCellRenderer = new CheckBoxTableCellRenderer();
        this.mainTable.getColumnModel().getColumn(2).setCellRenderer(cbCellRenderer);
        this.mainTable.getColumnModel().getColumn(1).setCellRenderer(cbCellRenderer);
        this.resourcesListModel = new ResourcesListModel();
        this.resourcesList = new JList<Gate.ResourceInfo>(this.resourcesListModel);
        this.resourcesList.setCellRenderer(new ResourcesListCellRenderer());
        Gate.ResourceInfo prototype = new Gate.ResourceInfo("A rather silly long resource name", "java.lang.String", "this is a comment");
        this.resourcesList.setPrototypeCellValue(prototype);
        this.resourcesList.setSelectionMode(0);
        ToolTipManager.sharedInstance().registerComponent(this.resourcesList);
        this.mainSplit = new JSplitPane(1, true);
        this.mainSplit.setResizeWeight(0.8);
        this.mainSplit.setContinuousLayout(true);
        JScrollPane scroller = new JScrollPane(this.mainTable);
        scroller.setVerticalScrollBarPolicy(22);
        this.mainSplit.setLeftComponent(scroller);
        scroller = new JScrollPane(this.resourcesList);
        this.lblPluginDetails = new JLabel();
        JToolBar pluginToolbar = new JToolBar(0);
        pluginToolbar.setFloatable(false);
        this.btnResources = new JButton(new SaveIcon(32, 32));
        this.btnResources.setDisabledIcon(new SaveIcon(32, 32, true));
        this.btnResources.setToolTipText("Extract Plugin Resources");
        this.btnResources.setEnabled(false);
        this.btnResources.addActionListener(this.extractResourcesListener);
        pluginToolbar.add(this.btnResources);
        JPanel pluginDisplay = new JPanel(new BorderLayout());
        pluginDisplay.add((Component)this.lblPluginDetails, "North");
        pluginDisplay.add((Component)scroller, "Center");
        pluginDisplay.add((Component)pluginToolbar, "South");
        this.mainSplit.setRightComponent(pluginDisplay);
        this.setLayout(new BorderLayout());
        this.add((Component)tbPluginDirs, "North");
        this.add((Component)this.mainSplit, "Center");
        this.mainTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AvailablePlugins.this.resourcesListModel.dataChanged();
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){
            private Action a;
            {
                this.a = new DeleteCreoleRepositoryAction();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getModifiers() > 1) {
                    return;
                }
                if (e.getKeyChar() == '\u007f') {
                    this.a.actionPerformed(null);
                    return;
                }
                if (e.getKeyChar() == '\t' || e.getKeyChar() == ' ') {
                    return;
                }
                AvailablePlugins.this.filterTextField.requestFocusInWindow();
                AvailablePlugins.this.filterTextField.setText(String.valueOf(e.getKeyChar()));
            }
        });
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer = new Timer("Plugin manager table rows filter", true);
            private TimerTask timerTask;

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                Date timeToRun = new Date(System.currentTimeMillis() + 300L);
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        AvailablePlugins.this.filterRows(AvailablePlugins.this.filterTextField.getText());
                    }
                };
                this.timer.schedule(this.timerTask, timeToRun);
            }
        });
        this.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 33 || e.getKeyCode() == 34) {
                    AvailablePlugins.this.mainTable.dispatchEvent(e);
                }
            }
        });
        InputMap inputMap = this.mainTable.getInputMap(1);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(enter, "none");
        this.reInit();
    }

    protected void reInit() {
        this.loadNowByURL.clear();
        this.loadAlwaysByURL.clear();
        this.visibleRows.clear();
        this.visibleRows.addAll(Gate.getKnownPlugins());
        if (this.mainTable.getRowCount() > 0) {
            this.mainTable.setRowSelectionInterval(0, 0);
        }
        this.filterRows("");
    }

    private void filterRows(String rowFilter) {
        String previousURL;
        final String filter = rowFilter.trim().toLowerCase();
        String string = previousURL = this.mainTable.getSelectedRow() == -1 ? "" : (String)this.mainTable.getValueAt(this.mainTable.getSelectedRow(), this.mainTable.convertColumnIndexToView(3));
        if (filter.length() < 2) {
            this.visibleRows.clear();
            this.visibleRows.addAll(Gate.getKnownPlugins());
        } else {
            this.visibleRows.clear();
            for (Plugin plugin : Gate.getKnownPlugins()) {
                String name = plugin.getName();
                String resources = "";
                for (int j = 0; j < plugin.getResourceInfoList().size(); ++j) {
                    resources = resources + plugin.getResourceInfoList().get(j).getResourceName() + " ";
                }
                if ((name == null || !name.toLowerCase().contains(filter)) && !resources.toLowerCase().contains(filter)) continue;
                this.visibleRows.add(plugin);
            }
        }
        this.mainTableModel.fireTableDataChanged();
        if (this.mainTable.getRowCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AvailablePlugins.this.mainTable.setRowSelectionInterval(0, 0);
                    if (filter.length() < 2 && previousURL != null && !previousURL.equals("")) {
                        for (int row = 0; row < AvailablePlugins.this.mainTable.getRowCount(); ++row) {
                            String url = (String)AvailablePlugins.this.mainTable.getValueAt(row, AvailablePlugins.this.mainTable.convertColumnIndexToView(3));
                            if (!url.contains(previousURL)) continue;
                            AvailablePlugins.this.mainTable.setRowSelectionInterval(row, row);
                            AvailablePlugins.this.mainTable.scrollRectToVisible(AvailablePlugins.this.mainTable.getCellRect(row, 0, true));
                            break;
                        }
                    }
                }
            });
        }
    }

    private Boolean getLoadNow(Plugin plugin) {
        Boolean res = this.loadNowByURL.get(plugin);
        if (res == null) {
            res = Gate.getCreoleRegister().getPlugins().contains(plugin);
            this.loadNowByURL.put(plugin, res);
        }
        return res;
    }

    private Boolean getLoadAlways(Plugin plugin) {
        Boolean res = this.loadAlwaysByURL.get(plugin);
        if (res == null) {
            res = Gate.getAutoloadPlugins().contains(plugin);
            this.loadAlwaysByURL.put(plugin, res);
        }
        return res;
    }

    protected boolean unsavedChanges() {
        boolean loaded;
        boolean load;
        Set<Plugin> creoleDirectories = Gate.getCreoleRegister().getPlugins();
        for (Plugin aPluginURL : this.loadNowByURL.keySet()) {
            load = this.loadNowByURL.get(aPluginURL);
            loaded = creoleDirectories.contains(aPluginURL);
            if (load && !loaded) {
                return true;
            }
            if (load || !loaded) continue;
            return true;
        }
        for (Plugin aPluginURL : this.loadAlwaysByURL.keySet()) {
            load = this.loadAlwaysByURL.get(aPluginURL);
            loaded = Gate.getAutoloadPlugins().contains(aPluginURL);
            if (load && !loaded) {
                return true;
            }
            if (load || !loaded) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Plugin> updateAvailablePlugins(Plugin.DownloadListener progressPanel) {
        boolean loaded;
        boolean load;
        Set<Plugin> creoleDirectories = Gate.getCreoleRegister().getPlugins();
        Iterator<Plugin> pluginIter = this.loadNowByURL.keySet().iterator();
        HashSet<Plugin> toLoad = new HashSet<Plugin>();
        while (pluginIter.hasNext()) {
            Plugin aPluginURL = pluginIter.next();
            load = this.loadNowByURL.get(aPluginURL);
            loaded = creoleDirectories.contains(aPluginURL);
            if (load && !loaded) {
                toLoad.add(aPluginURL);
            }
            if (load || !loaded) continue;
            Gate.getCreoleRegister().unregisterPlugin(aPluginURL);
        }
        for (Plugin aPluginURL : this.loadAlwaysByURL.keySet()) {
            load = this.loadAlwaysByURL.get(aPluginURL);
            loaded = Gate.getAutoloadPlugins().contains(aPluginURL);
            if (load && !loaded) {
                Gate.addAutoloadPlugin(aPluginURL);
            }
            if (load || !loaded) continue;
            Gate.removeAutoloadPlugin(aPluginURL);
        }
        while (!toLoad.isEmpty()) {
            int numToLoad = toLoad.size();
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            pluginIter = toLoad.iterator();
            while (pluginIter.hasNext()) {
                Plugin aPluginURL = pluginIter.next();
                try {
                    aPluginURL.addDownloadListener(progressPanel);
                    ((CreoleRegisterImpl)Gate.getCreoleRegister()).registerPlugin(aPluginURL);
                    pluginIter.remove();
                }
                catch (Throwable ge) {
                    errors.add(ge);
                }
                finally {
                    aPluginURL.removeDownloadListener(progressPanel);
                }
            }
            if (numToLoad != toLoad.size()) continue;
            for (Throwable t : errors) {
                t.printStackTrace();
            }
        }
        this.loadNowByURL.clear();
        this.loadAlwaysByURL.clear();
        return toLoad;
    }

    private class AddCreoleRepositoryAction
    extends AbstractAction {
        public AddCreoleRepositoryAction() {
            super(null, new AddIcon(MainFrame.ICON_DIMENSION));
            this.putValue("ShortDescription", "Register a new CREOLE plugin");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField urlTextField = new JTextField(20);
            class URLfromFileAction
            extends AbstractAction {
                JTextField textField;

                URLfromFileAction(JTextField textField) {
                    super(null, new OpenFileIcon(MainFrame.ICON_DIMENSION));
                    this.putValue("ShortDescription", "Click to select a directory");
                    this.textField = textField;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    XJFileChooser fileChooser = MainFrame.getFileChooser();
                    fileChooser.setMultiSelectionEnabled(false);
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    fileChooser.setResource("gate.CreoleRegister");
                    int result = fileChooser.showOpenDialog(AvailablePlugins.this);
                    if (result == 0) {
                        try {
                            this.textField.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException mue) {
                            throw new GateRuntimeException(mue.toString());
                        }
                    }
                }
            }
            JButton fileBtn = new JButton(new URLfromFileAction(urlTextField));
            JPanel urlPanel = new JPanel();
            GroupLayout urlPanelLayout = new GroupLayout(urlPanel);
            urlPanel.setLayout(urlPanelLayout);
            urlPanelLayout.setAutoCreateContainerGaps(true);
            urlPanelLayout.setAutoCreateGaps(true);
            JLabel lblURL = new JLabel("Type a URL");
            JLabel lblDir = new JLabel("Select a Directory");
            JLabel lblOR = new JLabel("or");
            urlPanelLayout.setHorizontalGroup(urlPanelLayout.createSequentialGroup().addGroup(urlPanelLayout.createParallelGroup().addComponent(lblURL).addComponent(urlTextField)).addComponent(lblOR).addGroup(urlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(lblDir).addComponent(fileBtn)));
            urlPanelLayout.setVerticalGroup(urlPanelLayout.createSequentialGroup().addGroup(urlPanelLayout.createParallelGroup().addComponent(lblURL).addComponent(lblDir)).addGroup(urlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(urlTextField).addComponent(lblOR).addComponent(fileBtn)));
            JPanel mavenPanel = new JPanel(new SpringLayout());
            JTextField txtGroup = new JTextField("uk.ac.gate.plugins", 20);
            JTextField txtArtifact = new JTextField(20);
            JTextField txtVersion = new JTextField(Main.version, 20);
            mavenPanel.add(new JLabel("Group:"));
            mavenPanel.add(txtGroup);
            mavenPanel.add(new JLabel("Artifact:"));
            mavenPanel.add(txtArtifact);
            mavenPanel.add(new JLabel("Version:"));
            mavenPanel.add(txtVersion);
            SpringUtilities.makeCompactGrid(mavenPanel, 3, 2, 5, 5, 5, 5);
            JTabbedPane tabsPluginType = new JTabbedPane();
            tabsPluginType.add("Maven", mavenPanel);
            tabsPluginType.add("Directory URL", urlPanel);
            if (JOptionPane.showConfirmDialog(AvailablePlugins.this, tabsPluginType, "Register a new CREOLE plugin", 2, 3, new AvailableIcon(48, 48)) != 0) {
                return;
            }
            try {
                final Plugin plugin = tabsPluginType.getSelectedIndex() == 0 ? new Plugin.Maven(txtGroup.getText().trim(), txtArtifact.getText().trim(), txtVersion.getText().trim()) : new Plugin.Directory(new URL(urlTextField.getText()));
                Gate.addKnownPlugin(plugin);
                AvailablePlugins.this.mainTable.clearSelection();
                AvailablePlugins.this.filterRows("");
                AvailablePlugins.this.filterTextField.setText("");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (int row = 0; row < AvailablePlugins.this.mainTable.getRowCount(); ++row) {
                            String url = (String)AvailablePlugins.this.mainTable.getValueAt(row, AvailablePlugins.this.mainTable.convertColumnIndexToView(3));
                            if (!url.equals(plugin.getName())) continue;
                            AvailablePlugins.this.mainTable.setRowSelectionInterval(row, row);
                            AvailablePlugins.this.mainTable.scrollRectToVisible(AvailablePlugins.this.mainTable.getCellRect(row, 0, true));
                            break;
                        }
                    }
                });
                AvailablePlugins.this.mainTable.requestFocusInWindow();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(AvailablePlugins.this, "<html><body style='width: 350px;'><b>Unable to register CREOLE plugin!</b><br><br>The details you specified are not valid. Please check the details and try again.</body></html>", "CREOLE Plugin Manager", 0);
            }
        }
    }

    private class DeleteCreoleRepositoryAction
    extends AbstractAction {
        public DeleteCreoleRepositoryAction() {
            super(null, new RemoveIcon(MainFrame.ICON_DIMENSION));
            this.putValue("ShortDescription", "Unregister selected CREOLE plugin");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows;
            for (int row : rows = AvailablePlugins.this.mainTable.getSelectedRows()) {
                int rowModel = AvailablePlugins.this.mainTable.rowViewToModel(row);
                Plugin toDelete = (Plugin)AvailablePlugins.this.visibleRows.get(rowModel);
                Gate.removeKnownPlugin(toDelete);
                AvailablePlugins.this.loadAlwaysByURL.remove(toDelete);
                AvailablePlugins.this.loadNowByURL.remove(toDelete);
            }
            AvailablePlugins.this.filterRows(AvailablePlugins.this.filterTextField.getText());
        }
    }

    private class ResourcesListCellRenderer
    extends DefaultListCellRenderer {
        private ResourcesListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Gate.ResourceInfo rInfo = (Gate.ResourceInfo)value;
            String filter = AvailablePlugins.this.filterTextField.getText().trim().toLowerCase();
            if (filter.length() > 1 && rInfo.getResourceName().toLowerCase().contains(filter)) {
                isSelected = true;
            }
            super.getListCellRendererComponent(list, rInfo.getResourceName(), index, isSelected, cellHasFocus);
            this.setToolTipText(rInfo.getResourceComment());
            return this;
        }
    }

    private class ExtractResourcesActionListener
    implements ActionListener {
        Plugin plugin = null;

        private ExtractResourcesActionListener() {
        }

        public void setPlugin(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.plugin == null) {
                return;
            }
            if (!this.plugin.hasResources()) {
                return;
            }
            XJFileChooser fileChooser = MainFrame.getFileChooser();
            fileChooser.setDialogTitle("Select Folder to Hold Resources");
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(1);
            fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
            fileChooser.setResource("gate.creole.Plugin");
            int result = fileChooser.showOpenDialog(AvailablePlugins.this);
            if (result != 0) {
                return;
            }
            try {
                this.plugin.copyResources(fileChooser.getSelectedFile());
            }
            catch (IOException | URISyntaxException ex) {
                throw new GateRuntimeException("Unable to extract plugin resources to folder specified", ex);
            }
        }
    }

    private class ResourcesListModel
    extends AbstractListModel<Gate.ResourceInfo> {
        private ResourcesListModel() {
        }

        @Override
        public Gate.ResourceInfo getElementAt(int index) {
            int row = AvailablePlugins.this.mainTable.getSelectedRow();
            if (row == -1) {
                return null;
            }
            row = AvailablePlugins.this.mainTable.rowViewToModel(row);
            Plugin plugin = (Plugin)AvailablePlugins.this.visibleRows.get(row);
            return plugin.getResourceInfoList().get(index);
        }

        @Override
        public int getSize() {
            int row = AvailablePlugins.this.mainTable.getSelectedRow();
            if (row == -1) {
                return 0;
            }
            row = AvailablePlugins.this.mainTable.rowViewToModel(row);
            Plugin plugin = (Plugin)AvailablePlugins.this.visibleRows.get(row);
            if (plugin == null) {
                return 0;
            }
            return plugin.getResourceInfoList().size();
        }

        public void dataChanged() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            AvailablePlugins.this.lblPluginDetails.setText("");
            AvailablePlugins.this.btnResources.setEnabled(false);
            int row = AvailablePlugins.this.mainTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            row = AvailablePlugins.this.mainTable.rowViewToModel(row);
            Plugin plugin = (Plugin)AvailablePlugins.this.visibleRows.get(row);
            StringBuffer details = new StringBuffer("<html><body><h1>").append(plugin.getName()).append("</h1>");
            if (plugin.getDescription() != null) {
                details.append("<p>").append(plugin.getDescription()).append("</p>");
            }
            AvailablePlugins.this.btnResources.setEnabled(plugin.hasResources());
            AvailablePlugins.this.extractResourcesListener.setPlugin(plugin);
            details.append("<p>This plugin contains the following CREOLE resources:</p></body></html>");
            AvailablePlugins.this.lblPluginDetails.setText(details.toString());
        }
    }

    private class MainTableModel
    extends AbstractTableModel {
        private Icon coreIcon;
        private Icon userIcon;
        private Icon remoteIcon;
        private Icon otherIcon = new OpenFileIcon(32, 32);
        private Icon invalidIcon;
        private Icon mavenIcon;

        public MainTableModel() {
            this.coreIcon = new GATEIcon(32, 32);
            this.userIcon = new UserPluginIcon(32, 32);
            this.remoteIcon = new RemotePluginIcon(32, 32);
            this.invalidIcon = new InvalidIcon(32, 32);
            this.mavenIcon = new MavenIcon(32, 32);
        }

        @Override
        public int getRowCount() {
            return AvailablePlugins.this.visibleRows.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 3: {
                    return "<html><body style='padding: 2px; text-align: center;'>Plugin Name</body></html>";
                }
                case 0: {
                    return null;
                }
                case 1: {
                    return "<html><body style='padding: 2px; text-align: center;'>Load<br>Now</body></html>";
                }
                case 2: {
                    return "<html><body style='padding: 2px; text-align: center;'>Load<br>Always</body></html>";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 3: {
                    return String.class;
                }
                case 0: {
                    return Icon.class;
                }
                case 1: 
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Plugin dInfo = (Plugin)AvailablePlugins.this.visibleRows.get(row);
            if (dInfo == null) {
                return null;
            }
            switch (column) {
                case 3: {
                    return dInfo.getName();
                }
                case 0: {
                    if (!dInfo.isValid()) {
                        return this.invalidIcon;
                    }
                    if (dInfo instanceof Plugin.Maven) {
                        return this.mavenIcon;
                    }
                    return this.otherIcon;
                }
                case 1: {
                    return AvailablePlugins.this.getLoadNow(dInfo);
                }
                case 2: {
                    return AvailablePlugins.this.getLoadAlways(dInfo);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            Plugin plugin = (Plugin)AvailablePlugins.this.visibleRows.get(row);
            return plugin.isValid() && (column == 1 || column == 2);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Boolean valueBoolean = (Boolean)aValue;
            Plugin plugin = (Plugin)AvailablePlugins.this.visibleRows.get(rowIndex);
            if (plugin == null) {
                return;
            }
            switch (columnIndex) {
                case 1: {
                    AvailablePlugins.this.loadNowByURL.put(plugin, valueBoolean);
                    AvailablePlugins.this.mainTable.requestFocusInWindow();
                    break;
                }
                case 2: {
                    AvailablePlugins.this.loadAlwaysByURL.put(plugin, valueBoolean);
                    AvailablePlugins.this.mainTable.requestFocusInWindow();
                }
            }
        }
    }
}

