/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.MainFrame;
import gate.swing.JFontChooser;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class OptionsDialog
extends JDialog {
    public static String[] menuKeys = new String[]{"CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "Menu.acceleratorFont", "Menu.font", "MenuBar.font", "MenuItem.acceleratorFont", "MenuItem.font", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font"};
    public static String[] componentsKeys = new String[]{"Button.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "InternalFrame.titleFont", "Label.font", "List.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "ScrollPane.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"};
    public static String[] textComponentsKeys = new String[]{"EditorPane.font", "TextArea.font", "TextPane.font"};
    protected JTabbedPane mainTabbedPane;
    protected JRadioButton textBtn;
    protected JButton okButton;
    protected JButton cancelButton;
    protected String selectedFontBtn = null;
    protected JRadioButton menuBtn;
    protected JRadioButton otherCompsBtn;
    protected ButtonGroup fontBG;
    protected JFontChooser fontChooser;
    protected JCheckBox saveOptionsChk;
    protected JCheckBox saveSessionChk;
    protected JCheckBox addSpaceOnMarkupUnpackChk;
    protected String lookAndFeelClassName;
    protected Font menusFont;
    protected Font textComponentsFont;
    protected Font componentsFont;
    protected boolean dirtyGUI;
    protected JComboBox<LNFData> lnfCombo;
    protected JComboBox<String> browserComboBox;
    protected JTextField browserCommandLineTextField;
    protected JCheckBox treeSelectViewChk;
    protected JCheckBox viewSelectTreeChk;
    private static OptionsMap userConfig = Gate.getUserConfig();

    public OptionsDialog(Frame owner) {
        super(owner, "GATE Options", true);
        MainFrame.getGuiRoots().add(this);
    }

    protected void initLocalData() {
        this.lookAndFeelClassName = userConfig.getString("Look_and_Feel");
        this.textComponentsFont = userConfig.getFont("Text_components_font");
        this.menusFont = userConfig.getFont("Menus_font");
        this.componentsFont = userConfig.getFont("Other_components_font");
        this.dirtyGUI = false;
    }

    protected void initGuiComponents() {
        UIManager.LookAndFeelInfo[] lnfs;
        this.getContentPane().removeAll();
        this.mainTabbedPane = new JTabbedPane(1);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.mainTabbedPane);
        ArrayList<LNFData> supportedLNFs = new ArrayList<LNFData>();
        LNFData currentLNF = null;
        for (UIManager.LookAndFeelInfo lnf : lnfs = UIManager.getInstalledLookAndFeels()) {
            try {
                Class<?> lnfClass = Class.forName(lnf.getClassName());
                if (!((LookAndFeel)lnfClass.newInstance()).isSupportedLookAndFeel()) continue;
                if (lnf.getName().equals(UIManager.getLookAndFeel().getName())) {
                    currentLNF = new LNFData(lnf.getClassName(), lnf.getName());
                    supportedLNFs.add(currentLNF);
                    continue;
                }
                supportedLNFs.add(new LNFData(lnf.getClassName(), lnf.getName()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lnfCombo = new JComboBox<LNFData>(supportedLNFs.toArray(new LNFData[supportedLNFs.size()]));
        this.lnfCombo.setSelectedItem(currentLNF);
        this.lnfCombo.setToolTipText("Be aware that only 'Metal' is fully tested.");
        this.fontBG = new ButtonGroup();
        this.textBtn = new JRadioButton("Text components font");
        this.textBtn.setActionCommand("text");
        this.fontBG.add(this.textBtn);
        this.menuBtn = new JRadioButton("Menu components font");
        this.menuBtn.setActionCommand("menu");
        this.fontBG.add(this.menuBtn);
        this.otherCompsBtn = new JRadioButton("Other components font");
        this.otherCompsBtn.setActionCommand("other");
        this.fontBG.add(this.otherCompsBtn);
        JPanel appearanceBox = new JPanel();
        appearanceBox.setLayout(new BoxLayout(appearanceBox, 1));
        appearanceBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        appearanceBox.add(Box.createVerticalStrut(5));
        Box vBox = Box.createVerticalBox();
        vBox.setBackground(this.getContentPane().getBackground());
        vBox.setBorder(BorderFactory.createTitledBorder(" Look and Feel "));
        vBox.add(Box.createVerticalStrut(5));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(5));
        hBox.add(this.lnfCombo);
        hBox.add(Box.createHorizontalStrut(5));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(5));
        appearanceBox.add(vBox);
        appearanceBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createTitledBorder(" Font options "));
        hBox.add(Box.createHorizontalStrut(5));
        vBox = Box.createVerticalBox();
        vBox.add(this.textBtn);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.menuBtn);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.otherCompsBtn);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(Box.createVerticalGlue());
        hBox.add(Box.createHorizontalStrut(5));
        hBox.add(vBox);
        this.fontChooser = new JFontChooser();
        hBox.add(this.fontChooser);
        hBox.add(Box.createHorizontalStrut(5));
        appearanceBox.add(hBox);
        this.mainTabbedPane.add("Appearance", appearanceBox);
        this.saveOptionsChk = new JCheckBox("Save options on exit", (boolean)userConfig.getBoolean("Save_options_on_exit"));
        this.saveOptionsChk.setToolTipText("Remembers the options set in this dialogue.");
        this.saveSessionChk = new JCheckBox("Save session on exit", (boolean)userConfig.getBoolean("Save_session_on_exit"));
        this.saveSessionChk.setToolTipText("Reloads the same resources in the tree on next start.");
        this.addSpaceOnMarkupUnpackChk = new JCheckBox("Add space on markup unpack if needed", true);
        this.addSpaceOnMarkupUnpackChk.setToolTipText("Adds a space instead of concatenate words separated by a XML tag");
        if (userConfig.get("Document_add_space_on_unpack") != null && !userConfig.getBoolean("Document_add_space_on_unpack").booleanValue()) {
            this.addSpaceOnMarkupUnpackChk.setSelected(false);
        }
        this.browserComboBox = new JComboBox<String>(new String[]{"Default browser", "Custom"});
        this.browserComboBox.setPrototypeDisplayValue("Default browser");
        this.browserComboBox.setToolTipText("Use Custom only if Default doesn't work.");
        this.browserCommandLineTextField = new JTextField(15);
        String commandLine = userConfig.getString(MainFrame.class.getName() + ".browsercommandline");
        if (commandLine == null || commandLine.trim().length() == 0 || commandLine.equals("Set dynamically when you display help.")) {
            this.browserComboBox.setSelectedItem("Default browser");
            this.browserCommandLineTextField.setEnabled(false);
        } else {
            this.browserComboBox.setSelectedItem("Custom");
        }
        this.browserCommandLineTextField.setText(commandLine == null ? "" : commandLine);
        this.treeSelectViewChk = new JCheckBox("Tree select view", (boolean)userConfig.getBoolean(MainFrame.class.getName() + ".treeselectview"));
        this.treeSelectViewChk.setToolTipText("Selection in left resources tree select the main view");
        this.viewSelectTreeChk = new JCheckBox("View select in tree", (boolean)userConfig.getBoolean(MainFrame.class.getName() + ".viewselecttree"));
        this.viewSelectTreeChk.setToolTipText("Selection of the main view select item in left resources tree");
        JPanel advancedBox = new JPanel();
        advancedBox.setLayout(new BoxLayout(advancedBox, 1));
        advancedBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        advancedBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createTitledBorder(" Advanced features "));
        hBox.add(Box.createHorizontalStrut(5));
        vBox = Box.createVerticalBox();
        vBox.add(this.addSpaceOnMarkupUnpackChk);
        vBox.add(Box.createVerticalStrut(5));
        hBox.add(vBox);
        hBox.add(Box.createHorizontalStrut(5));
        hBox.add(Box.createHorizontalGlue());
        advancedBox.add(hBox);
        advancedBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createTitledBorder(" Session persistence "));
        hBox.add(Box.createHorizontalStrut(5));
        Box hBox2 = Box.createHorizontalBox();
        hBox2.add(this.saveOptionsChk);
        hBox2.add(Box.createVerticalStrut(5));
        hBox2.add(this.saveSessionChk);
        hBox2.add(Box.createVerticalStrut(5));
        hBox.add(hBox2);
        hBox.add(Box.createHorizontalStrut(5));
        hBox.add(Box.createHorizontalGlue());
        advancedBox.add(hBox);
        advancedBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createTitledBorder(" Help browser "));
        hBox.add(Box.createHorizontalStrut(5));
        vBox = Box.createVerticalBox();
        vBox.add(this.browserComboBox);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.browserCommandLineTextField);
        vBox.add(Box.createVerticalStrut(5));
        hBox.add(vBox);
        hBox.add(Box.createHorizontalStrut(5));
        advancedBox.add(hBox);
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createTitledBorder(" Link resources tree selection and the main view "));
        hBox.add(Box.createHorizontalStrut(5));
        hBox2 = Box.createHorizontalBox();
        hBox2.add(this.treeSelectViewChk);
        hBox2.add(Box.createVerticalStrut(5));
        hBox2.add(this.viewSelectTreeChk);
        hBox2.add(Box.createVerticalStrut(5));
        hBox.add(hBox2);
        hBox.add(Box.createHorizontalStrut(5));
        hBox.add(Box.createHorizontalGlue());
        advancedBox.add(hBox);
        this.mainTabbedPane.add("Advanced", advancedBox);
        Box buttonsBox = Box.createHorizontalBox();
        this.okButton = new JButton(new OKAction());
        buttonsBox.add(this.okButton);
        buttonsBox.add(Box.createHorizontalStrut(10));
        this.cancelButton = new JButton(new CancelAction());
        buttonsBox.add(this.cancelButton);
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.getContentPane().add(buttonsBox);
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.getRootPane().setDefaultButton(this.okButton);
    }

    protected void initListeners() {
        this.lnfCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!OptionsDialog.this.lookAndFeelClassName.equals(((LNFData)OptionsDialog.this.lnfCombo.getSelectedItem()).className)) {
                    OptionsDialog.this.dirtyGUI = true;
                    OptionsDialog.this.lookAndFeelClassName = ((LNFData)OptionsDialog.this.lnfCombo.getSelectedItem()).className;
                }
            }
        });
        this.fontChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("fontValue")) {
                    String selectedFont = OptionsDialog.this.fontBG.getSelection().getActionCommand();
                    if (selectedFont.equals("text")) {
                        OptionsDialog.this.textComponentsFont = (Font)e.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    } else if (selectedFont.equals("menu")) {
                        OptionsDialog.this.menusFont = (Font)e.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    } else if (selectedFont.equals("other")) {
                        OptionsDialog.this.componentsFont = (Font)e.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    }
                }
            }
        });
        this.textBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OptionsDialog.this.textBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "text";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.textComponentsFont);
            }
        });
        this.menuBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OptionsDialog.this.menuBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "menu";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.menusFont);
            }
        });
        this.otherCompsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OptionsDialog.this.otherCompsBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "other";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.componentsFont);
            }
        });
        this.textBtn.setSelected(true);
        this.browserComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OptionsDialog.this.browserComboBox.getSelectedItem() == null) {
                    return;
                }
                String item = (String)OptionsDialog.this.browserComboBox.getSelectedItem();
                OptionsDialog.this.browserCommandLineTextField.setEnabled(item.equals("Custom"));
                if (item.equals("Default browser")) {
                    OptionsDialog.this.browserCommandLineTextField.setText("Set dynamically when you display help.");
                } else if (item.equals("Custom")) {
                    OptionsDialog.this.browserCommandLineTextField.setText("firefox %file");
                }
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", new OKAction());
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", new CancelAction());
    }

    protected void selectedFontChanged() {
        if (this.selectedFontBtn != null) {
            if (this.selectedFontBtn.equals("text")) {
                this.textComponentsFont = this.fontChooser.getFontValue();
            } else if (this.selectedFontBtn.equals("menu")) {
                this.menusFont = this.fontChooser.getFontValue();
            } else if (this.selectedFontBtn.equals("other")) {
                this.componentsFont = this.fontChooser.getFontValue();
            }
        }
    }

    public void showDialog() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.textBtn.doClick();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        this.selectedFontBtn = null;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final JFrame frame = new JFrame("Foo frame");
        frame.setDefaultCloseOperation(2);
        JButton btn = new JButton("Show dialog");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog dialog = new OptionsDialog(frame);
                dialog.pack();
                dialog.showDialog();
            }
        });
        frame.getContentPane().add(btn);
        frame.pack();
        frame.setVisible(true);
        System.out.println("Font: " + UIManager.getFont("Button.font"));
    }

    protected static void setUIDefaults(Object[] keys, Object value) {
        for (int i = 0; i < keys.length; ++i) {
            UIManager.put(keys[i], value);
        }
    }

    public static void setTextComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(textComponentsKeys, new FontUIResource(font));
        userConfig.put((Object)"Text_components_font", font);
    }

    public static void setMenuComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(menuKeys, new FontUIResource(font));
        userConfig.put((Object)"Menus_font", font);
    }

    public static void setComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(componentsKeys, new FontUIResource(font));
        userConfig.put((Object)"Other_components_font", font);
    }

    protected static class LNFData {
        String className;
        String name;

        public LNFData(String className, String name) {
            this.className = className;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            OptionsDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (OptionsDialog.this.dirtyGUI) {
                OptionsDialog.setMenuComponentsFont(OptionsDialog.this.menusFont);
                OptionsDialog.setComponentsFont(OptionsDialog.this.componentsFont);
                OptionsDialog.setTextComponentsFont(OptionsDialog.this.textComponentsFont);
                userConfig.put((Object)"Look_and_Feel", OptionsDialog.this.lookAndFeelClassName);
                try {
                    UIManager.setLookAndFeel(OptionsDialog.this.lookAndFeelClassName);
                }
                catch (Exception e) {
                    throw new GateRuntimeException("Error while setting the look and feel", e);
                }
                Iterator<Component> rootsIter = MainFrame.getGuiRoots().iterator();
                while (rootsIter.hasNext()) {
                    try {
                        SwingUtilities.updateComponentTreeUI(rootsIter.next());
                    }
                    catch (Exception e) {
                        throw new GateRuntimeException("Error while updating the graphical interface", e);
                    }
                }
            }
            userConfig.put((Object)"Save_options_on_exit", (Object)OptionsDialog.this.saveOptionsChk.isSelected());
            userConfig.put((Object)"Save_session_on_exit", (Object)OptionsDialog.this.saveSessionChk.isSelected());
            userConfig.put((Object)"Document_add_space_on_unpack", (Object)OptionsDialog.this.addSpaceOnMarkupUnpackChk.isSelected());
            userConfig.put((Object)(MainFrame.class.getName() + ".browsercommandline"), OptionsDialog.this.browserCommandLineTextField.getText());
            userConfig.put((Object)(MainFrame.class.getName() + ".treeselectview"), (Object)OptionsDialog.this.treeSelectViewChk.isSelected());
            userConfig.put((Object)(MainFrame.class.getName() + ".viewselecttree"), (Object)OptionsDialog.this.viewSelectTreeChk.isSelected());
            OptionsDialog.this.setVisible(false);
        }
    }
}

