/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.creole.ir.IREngine;
import gate.gui.ListEditorDialog;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateIndexGUI
extends JPanel {
    JComboBox<String> irEngineCombo;
    JTextField indexLocationTextField;
    JCheckBox useContentChk;
    JTextField featuresListTextField;
    List<String> featuresList;
    SortedMap<String, IREngine> engineByName;

    public CreateIndexGUI() {
        this.initLocalData();
        this.initGUIComponents();
        this.initListeners();
    }

    protected void initLocalData() {
        this.featuresList = new ArrayList<String>();
        this.engineByName = new TreeMap<String, IREngine>();
    }

    protected void initGUIComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(2, 5, 2, 5);
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        this.add((Component)new JLabel("IR Engine type:"), constraints);
        constraints.gridwidth = 4;
        this.irEngineCombo = new JComboBox();
        this.add(this.irEngineCombo, constraints);
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        this.add((Component)new JLabel("Index location:"), constraints);
        constraints.gridwidth = 4;
        this.indexLocationTextField = new JTextField(40);
        this.add((Component)this.indexLocationTextField, constraints);
        constraints.gridwidth = 1;
        this.add((Component)new JButton(new SelectDirAction()), constraints);
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        this.add((Component)new JLabel("Features to index:"), constraints);
        this.featuresListTextField = new JTextField(40);
        this.featuresListTextField.setEditable(false);
        constraints.gridwidth = 4;
        this.add((Component)this.featuresListTextField, constraints);
        constraints.gridwidth = 1;
        this.add((Component)new JButton(new EditFeatureListAction()), constraints);
        constraints.gridy = 3;
        constraints.gridwidth = 4;
        this.useContentChk = new JCheckBox("Use document content", true);
        this.add((Component)this.useContentChk, constraints);
        String oldIREngineName = (String)this.irEngineCombo.getSelectedItem();
        ArrayList<String> irEngines = new ArrayList<String>(Gate.getRegisteredIREngines());
        this.engineByName.clear();
        for (int i = 0; i < irEngines.size(); ++i) {
            String anIREngineClassName = (String)irEngines.get(i);
            try {
                Class<?> aClass = Class.forName(anIREngineClassName, true, Gate.getClassLoader());
                IREngine engine = (IREngine)aClass.newInstance();
                this.engineByName.put(engine.getName(), engine);
                continue;
            }
            catch (ClassNotFoundException aClass) {
                continue;
            }
            catch (IllegalAccessException aClass) {
                continue;
            }
            catch (InstantiationException aClass) {
                // empty catch block
            }
        }
        String[] names = new String[this.engineByName.size()];
        int i = 0;
        Iterator<String> namesIter = this.engineByName.keySet().iterator();
        while (namesIter.hasNext()) {
            names[i++] = namesIter.next();
        }
        this.irEngineCombo.setModel(new DefaultComboBoxModel<String>(names));
        if (oldIREngineName != null && this.engineByName.containsKey(oldIREngineName)) {
            this.irEngineCombo.setSelectedItem(oldIREngineName);
        } else if (this.engineByName.size() > 0) {
            this.irEngineCombo.setSelectedIndex(0);
        }
    }

    protected void initListeners() {
    }

    public boolean getUseDocumentContent() {
        return this.useContentChk.isSelected();
    }

    public List<String> getFeaturesList() {
        return this.featuresList;
    }

    public String getIndexLocation() {
        return this.indexLocationTextField.getText();
    }

    public IREngine getIREngine() {
        return (IREngine)this.engineByName.get(this.irEngineCombo.getSelectedItem());
    }

    protected class EditFeatureListAction
    extends AbstractAction {
        public EditFeatureListAction() {
            super(null, MainFrame.getIcon("edit-list"));
            this.putValue("ShortDescription", "Click to edit list!");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListEditorDialog listEditor = new ListEditorDialog(CreateIndexGUI.this, CreateIndexGUI.this.featuresList, "java.lang.String");
            List result = listEditor.showDialog();
            if (result != null) {
                CreateIndexGUI.this.featuresList.clear();
                CreateIndexGUI.this.featuresList.addAll(result);
                if (CreateIndexGUI.this.featuresList.size() > 0) {
                    String text = "[" + CreateIndexGUI.this.featuresList.get(0).toString();
                    for (int j = 1; j < CreateIndexGUI.this.featuresList.size(); ++j) {
                        text = text + ", " + CreateIndexGUI.this.featuresList.get(j).toString();
                    }
                    text = text + "]";
                    CreateIndexGUI.this.featuresListTextField.setText(text);
                } else {
                    CreateIndexGUI.this.featuresListTextField.setText("");
                }
            }
        }
    }

    protected class SelectDirAction
    extends AbstractAction {
        public SelectDirAction() {
            super(null, MainFrame.getIcon("open-file"));
            this.putValue("ShortDescription", "Click to open a file chooser!");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XJFileChooser fileChooser = MainFrame.getFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setDialogTitle("Select a directory for the index files");
            int res = fileChooser.showOpenDialog(CreateIndexGUI.this);
            if (res == 0) {
                CreateIndexGUI.this.indexLocationTextField.setText(fileChooser.getSelectedFile().toString());
            }
        }
    }
}

