/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.BooleanClause;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Query
implements Serializable,
Cloneable {
    private float boost = 1.0f;

    public void setBoost(float b) {
        this.boost = b;
    }

    public float getBoost() {
        return this.boost;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    protected Weight createWeight(Searcher searcher) {
        throw new UnsupportedOperationException();
    }

    public Weight weight(Searcher searcher) throws IOException {
        Query query = searcher.rewrite(this);
        Weight weight = query.createWeight(searcher);
        float sum = weight.sumOfSquaredWeights();
        float norm = this.getSimilarity(searcher).queryNorm(sum);
        weight.normalize(norm);
        return weight;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public Query combine(Query[] queries) {
        throw new UnsupportedOperationException();
    }

    public static Query mergeBooleanQueries(Query[] queries) {
        HashSet<BooleanClause> allClauses = new HashSet<BooleanClause>();
        for (int i = 0; i < queries.length; ++i) {
            BooleanClause[] clauses = ((BooleanQuery)queries[i]).getClauses();
            for (int j = 0; j < clauses.length; ++j) {
                allClauses.add(clauses[j]);
            }
        }
        BooleanQuery result = new BooleanQuery();
        Iterator i = allClauses.iterator();
        while (i.hasNext()) {
            result.add((BooleanClause)i.next());
        }
        return result;
    }

    public Similarity getSimilarity(Searcher searcher) {
        return searcher.getSimilarity();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported: " + e.getMessage());
        }
    }
}

