/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.corpora.MimeType;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.event.StatusListener;
import gate.sgml.Sgml2Xml;
import gate.util.DocumentFormatException;
import gate.xml.XmlDocumentHandler;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@CreoleResource(name="GATE SGML Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class SgmlDocumentFormat
extends TextualDocumentFormat {
    private static final long serialVersionUID = -3596255263987343560L;

    @Override
    public void unpackMarkup(Document doc) throws DocumentFormatException {
        if (doc == null || doc.getSourceUrl() == null && doc.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        StatusListener statusListener = new StatusListener(){

            @Override
            public void statusChanged(String text) {
                SgmlDocumentFormat.this.fireStatusChanged(text);
            }
        };
        XmlDocumentHandler xmlDocHandler = null;
        try {
            Sgml2Xml sgml2Xml = new Sgml2Xml(doc);
            this.fireStatusChanged("Performing SGML to XML...");
            String xmlUri = sgml2Xml.convert();
            this.fireStatusChanged("DONE !");
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(true);
            SAXParser parser = saxParserFactory.newSAXParser();
            xmlDocHandler = new XmlDocumentHandler(doc, this.markupElementsMap, this.element2StringMap);
            xmlDocHandler.addStatusListener(statusListener);
            parser.parse(xmlUri, (DefaultHandler)xmlDocHandler);
            ((DocumentImpl)doc).setNextAnnotationId(xmlDocHandler.getCustomObjectsId());
        }
        catch (ParserConfigurationException e) {
            throw new DocumentFormatException("XML parser configuration exception ", e);
        }
        catch (SAXException e) {
            throw new DocumentFormatException(e);
        }
        catch (IOException e) {
            throw new DocumentFormatException("I/O exception for " + doc.getSourceUrl().toString());
        }
        finally {
            if (xmlDocHandler != null) {
                xmlDocHandler.removeStatusListener(statusListener);
            }
        }
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        MimeType mime = new MimeType("text", "sgml");
        mimeString2ClassHandlerMap.put(mime.getType() + "/" + mime.getSubtype(), this);
        mimeString2mimeTypeMap.put(mime.getType() + "/" + mime.getSubtype(), mime);
        suffixes2mimeTypeMap.put("sgm", mime);
        suffixes2mimeTypeMap.put("sgml", mime);
        this.setMimeType(mime);
        return this;
    }
}

