/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.creole.AbstractLanguageResource;
import gate.event.StatusListener;
import gate.util.BomStrippingInputStreamReader;
import gate.util.DocumentFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.io.IOUtils;

public abstract class DocumentFormat
extends AbstractLanguageResource {
    private static final long serialVersionUID = 4147880563349143923L;
    private MimeType mimeType = null;
    protected static final Map<String, DocumentFormat> mimeString2ClassHandlerMap = new HashMap<String, DocumentFormat>();
    protected static final Map<String, MimeType> mimeString2mimeTypeMap = new HashMap<String, MimeType>();
    protected static final Map<String, MimeType> suffixes2mimeTypeMap = new HashMap<String, MimeType>();
    protected static final Map<String, MimeType> magic2mimeTypeMap = new HashMap<String, MimeType>();
    protected Map<String, String> markupElementsMap = null;
    protected Map<String, String> element2StringMap = null;
    private FeatureMap features = null;
    private transient Vector<StatusListener> statusListeners;
    private Boolean shouldCollectRepositioning = Boolean.FALSE;

    public Boolean supportsRepositioning() {
        return Boolean.FALSE;
    }

    public void setShouldCollectRepositioning(Boolean b) {
        this.shouldCollectRepositioning = this.supportsRepositioning() != false && b != false ? b : Boolean.FALSE;
    }

    public Boolean getShouldCollectRepositioning() {
        return this.shouldCollectRepositioning;
    }

    public abstract void unpackMarkup(Document var1) throws DocumentFormatException;

    public abstract void unpackMarkup(Document var1, RepositioningInfo var2, RepositioningInfo var3) throws DocumentFormatException;

    public void unpackMarkup(Document doc, String originalContentFeatureType) throws DocumentFormatException {
        FeatureMap fm = doc.getFeatures();
        if (fm == null) {
            fm = Factory.newFeatureMap();
        }
        fm.put(originalContentFeatureType, doc.getContent().toString());
        doc.setFeatures(fm);
        this.unpackMarkup(doc);
    }

    private static MimeType getMimeType(String fileSufix) {
        if (fileSufix == null) {
            return null;
        }
        return suffixes2mimeTypeMap.get(fileSufix.toLowerCase());
    }

    public static Set<String> getSupportedMimeTypes() {
        return Collections.unmodifiableSet(mimeString2mimeTypeMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MimeType getMimeType(URL url) {
        String mimeTypeString = null;
        String charsetFromWebServer = null;
        String contentType = null;
        InputStream is = null;
        MimeType mimeTypeFromWebServer = null;
        MimeType mimeTypeFromFileSuffix = null;
        MimeType mimeTypeFromMagicNumbers = null;
        if (url == null) {
            return null;
        }
        try {
            String suffix;
            try {
                URLConnection urlconn = url.openConnection();
                is = urlconn.getInputStream();
                contentType = urlconn.getContentType();
            }
            catch (IOException urlconn) {
                // empty catch block
            }
            if (contentType != null) {
                StringTokenizer st = new StringTokenizer(contentType, ";");
                if (st.hasMoreTokens()) {
                    mimeTypeString = st.nextToken().toLowerCase();
                }
                if (st.hasMoreTokens()) {
                    charsetFromWebServer = st.nextToken().toLowerCase();
                }
                if (charsetFromWebServer != null) {
                    st = new StringTokenizer(charsetFromWebServer, "=");
                    charsetFromWebServer = null;
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        charsetFromWebServer = st.nextToken().toUpperCase();
                    }
                }
            }
            mimeTypeFromWebServer = mimeString2mimeTypeMap.get(mimeTypeString);
            Iterator<String> iterator = DocumentFormat.getFileSuffixes(url).iterator();
            while (iterator.hasNext() && (mimeTypeFromFileSuffix = DocumentFormat.getMimeType(suffix = iterator.next())) == null) {
            }
            mimeTypeFromMagicNumbers = DocumentFormat.guessTypeUsingMagicNumbers(is, charsetFromWebServer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return DocumentFormat.decideBetweenThreeMimeTypes(mimeTypeFromWebServer, mimeTypeFromFileSuffix, mimeTypeFromMagicNumbers);
    }

    protected static MimeType decideBetweenThreeMimeTypes(MimeType aMimeTypeFromWebServer, MimeType aMimeTypeFromFileSuffix, MimeType aMimeTypeFromMagicNumbers) {
        if (DocumentFormat.areEqual(aMimeTypeFromWebServer, aMimeTypeFromFileSuffix)) {
            return aMimeTypeFromFileSuffix;
        }
        if (DocumentFormat.areEqual(aMimeTypeFromFileSuffix, aMimeTypeFromMagicNumbers)) {
            return aMimeTypeFromFileSuffix;
        }
        if (DocumentFormat.areEqual(aMimeTypeFromWebServer, aMimeTypeFromMagicNumbers)) {
            return aMimeTypeFromWebServer;
        }
        if (aMimeTypeFromFileSuffix != null) {
            aMimeTypeFromFileSuffix.addParameter("Priority", "1");
        }
        if (aMimeTypeFromWebServer != null) {
            aMimeTypeFromWebServer.addParameter("Priority", "2");
        }
        if (aMimeTypeFromMagicNumbers != null) {
            aMimeTypeFromMagicNumbers.addParameter("Priority", "3");
        }
        return DocumentFormat.decideBetweenTwoMimeTypes(DocumentFormat.decideBetweenTwoMimeTypes(aMimeTypeFromWebServer, aMimeTypeFromFileSuffix), aMimeTypeFromMagicNumbers);
    }

    protected static MimeType decideBetweenTwoMimeTypes(MimeType aMimeType, MimeType anotherMimeType) {
        if (aMimeType == null) {
            return anotherMimeType;
        }
        if (anotherMimeType == null) {
            return aMimeType;
        }
        int priority1 = 0;
        int priority2 = 0;
        if (aMimeType.hasParameter("Priority")) {
            try {
                priority1 = Integer.parseInt(aMimeType.getParameterValue("Priority"));
            }
            catch (NumberFormatException e) {
                return anotherMimeType;
            }
        }
        if (anotherMimeType.hasParameter("Priority")) {
            try {
                priority2 = Integer.parseInt(anotherMimeType.getParameterValue("Priority"));
            }
            catch (NumberFormatException e) {
                return aMimeType;
            }
        }
        if (priority1 <= priority2) {
            return aMimeType;
        }
        return anotherMimeType;
    }

    protected static boolean areEqual(MimeType aMimeType, MimeType anotherMimeType) {
        if (aMimeType == null || anotherMimeType == null) {
            return false;
        }
        return aMimeType.getType().equals(anotherMimeType.getType()) && aMimeType.getSubtype().equals(anotherMimeType.getSubtype());
    }

    protected static MimeType guessTypeUsingMagicNumbers(InputStream aInputStream, String anEncoding) {
        if (aInputStream == null) {
            return null;
        }
        BomStrippingInputStreamReader reader = null;
        if (anEncoding != null) {
            try {
                reader = new BomStrippingInputStreamReader(aInputStream, anEncoding);
            }
            catch (UnsupportedEncodingException e) {
                reader = null;
            }
        }
        if (reader == null) {
            reader = new BomStrippingInputStreamReader(aInputStream);
        }
        return DocumentFormat.runMagicNumbers(reader);
    }

    protected static MimeType runMagicNumbers(Reader aReader) {
        if (aReader == null) {
            return null;
        }
        String strBuffer = null;
        int bufferSize = 2048;
        int charReads = 0;
        char[] cbuf = new char[bufferSize];
        try {
            charReads = aReader.read(cbuf, 0, bufferSize);
        }
        catch (IOException e) {
            return null;
        }
        if (charReads == -1) {
            return null;
        }
        strBuffer = new String(cbuf, 0, charReads);
        return DocumentFormat.getTypeFromContent(strBuffer);
    }

    private static MimeType getTypeFromContent(String aContent) {
        aContent = aContent.toLowerCase();
        MimeType detectedMimeType = null;
        int firstOffset = Integer.MAX_VALUE;
        MimeType xmlMime = DocumentFormat.getMimeType("xml");
        for (Map.Entry<String, MimeType> kv : magic2mimeTypeMap.entrySet()) {
            String magic = kv.getKey().toLowerCase();
            int offset = aContent.indexOf(magic.toLowerCase());
            if (offset == -1 || offset >= firstOffset && (kv.getValue().equals(xmlMime) || !detectedMimeType.equals(xmlMime))) continue;
            detectedMimeType = kv.getValue();
            firstOffset = offset;
        }
        return detectedMimeType;
    }

    private static String getFileSuffix(URL url) {
        String fileName = null;
        String fileSuffix = null;
        if (url != null) {
            fileName = url.getFile();
            StringTokenizer st = new StringTokenizer(fileName, ".");
            while (st.hasMoreTokens()) {
                fileSuffix = st.nextToken();
            }
        }
        return fileSuffix;
    }

    private static List<String> getFileSuffixes(URL url) {
        LinkedList<String> res = new LinkedList<String>();
        if (url != null) {
            String fileName = url.getPath();
            int pos = fileName.lastIndexOf(47);
            if (pos > 0) {
                fileName = fileName.substring(pos);
            }
            pos = fileName.indexOf(46, 1);
            while (pos > 0 && pos < fileName.length() - 1) {
                res.add(fileName.substring(pos + 1));
                pos = fileName.indexOf(46, pos + 1);
            }
        }
        return res;
    }

    public static DocumentFormat getDocumentFormat(Document aGateDocument, MimeType mimeType) {
        FeatureMap aFeatureMap = null;
        if (mimeType == null) {
            String content = aGateDocument.getContent().toString();
            if (content.length() > 2048) {
                content = content.substring(0, 2048);
            }
            mimeType = DocumentFormat.getTypeFromContent(content);
        }
        if (mimeType != null) {
            if (aGateDocument.getFeatures() == null) {
                aFeatureMap = Factory.newFeatureMap();
                aGateDocument.setFeatures(aFeatureMap);
            }
            aGateDocument.getFeatures().put("MimeType", mimeType.getType() + "/" + mimeType.getSubtype());
            return mimeString2ClassHandlerMap.get(mimeType.getType() + "/" + mimeType.getSubtype());
        }
        return null;
    }

    public static DocumentFormat getDocumentFormat(Document aGateDocument, String fileSuffix) {
        return DocumentFormat.getDocumentFormat(aGateDocument, DocumentFormat.getMimeType(fileSuffix));
    }

    public static DocumentFormat getDocumentFormat(MimeType mimeType) {
        return mimeString2ClassHandlerMap.get(mimeType.getType() + "/" + mimeType.getSubtype());
    }

    public static DocumentFormat getDocumentFormat(Document aGateDocument, URL url) {
        return DocumentFormat.getDocumentFormat(aGateDocument, DocumentFormat.getMimeType(url));
    }

    @Override
    public FeatureMap getFeatures() {
        return this.features;
    }

    public Map<String, String> getMarkupElementsMap() {
        return this.markupElementsMap;
    }

    public Map<String, String> getElement2StringMap() {
        return this.element2StringMap;
    }

    public void setMarkupElementsMap(Map<String, String> markupElementsMap) {
        this.markupElementsMap = markupElementsMap;
    }

    public void setElement2StringMap(Map<String, String> anElement2StringMap) {
        this.element2StringMap = anElement2StringMap;
    }

    @Override
    public void setFeatures(FeatureMap features) {
        this.features = features;
    }

    public void setMimeType(MimeType aMimeType) {
        this.mimeType = aMimeType;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public static MimeType getMimeTypeForString(String typeString) {
        return mimeString2mimeTypeMap.get(typeString);
    }

    public static Set<String> getSupportedFileSuffixes() {
        return Collections.unmodifiableSet(suffixes2mimeTypeMap.keySet());
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    protected void fireStatusChanged(String e) {
        if (this.statusListeners != null) {
            int count = this.statusListeners.size();
            for (int i = 0; i < count; ++i) {
                this.statusListeners.elementAt(i).statusChanged(e);
            }
        }
    }
}

