/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.AbstractResource;
import gate.creole.ResourceData;
import gate.util.ExtensionFileFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.IOUtils;

public abstract class DocumentExporter
extends AbstractResource {
    private static final long serialVersionUID = -4810523902750051704L;
    protected String fileType;
    protected String defaultExtension;
    protected String mimeType;
    protected FileFilter filter;

    public DocumentExporter(String fileType, String defaultExtension, String mimeType) {
        this.fileType = fileType;
        this.defaultExtension = defaultExtension;
        this.mimeType = mimeType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Override
    public String getName() {
        return this.fileType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public FileFilter getFileFilter() {
        if (this.filter == null) {
            this.filter = new ExtensionFileFilter(this.fileType + " Files (*." + this.defaultExtension + ")", this.defaultExtension);
        }
        return this.filter;
    }

    public void export(Document doc, File file) throws IOException {
        this.export(doc, file, Factory.newFeatureMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Document doc, File file, FeatureMap options) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.export(doc, out, options);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public void export(Document doc, OutputStream out) throws IOException {
        this.export(doc, out, Factory.newFeatureMap());
    }

    public abstract void export(Document var1, OutputStream var2, FeatureMap var3) throws IOException;

    public static DocumentExporter getInstance(String className) {
        return (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get(className)).getInstantiations().iterator().next();
    }
}

