package gate.resources.img.svg;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

/**
 * This class has been automatically generated using <a
 * href="http://englishjavadrinker.blogspot.com/search/label/SVGRoundTrip">SVGRoundTrip</a>.
 */
@SuppressWarnings("unused")
public class CreolePluginIcon implements
		javax.swing.Icon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
        Area clip = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    Shape clip_ = g.getClip();
AffineTransform defaultTransform_ = g.getTransform();
//  is CompositeGraphicsNode
float alpha__0 = origAlpha;
origAlpha = origAlpha * 1.0f;
g.setComposite(AlphaComposite.getInstance(3, origAlpha));
Shape clip__0 = g.getClip();
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
clip = new Area(g.getClip());
clip.intersect(new Area(new Rectangle2D.Double(0.0,0.0,64.0,64.0)));
g.setClip(clip);
// _0 is CompositeGraphicsNode
float alpha__0_0 = origAlpha;
origAlpha = origAlpha * 1.0f;
g.setComposite(AlphaComposite.getInstance(3, origAlpha));
Shape clip__0_0 = g.getClip();
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0 is CompositeGraphicsNode
float alpha__0_0_0 = origAlpha;
origAlpha = origAlpha * 1.0f;
g.setComposite(AlphaComposite.getInstance(3, origAlpha));
Shape clip__0_0_0 = g.getClip();
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(0.952406108379364f, 0.0f, 0.0f, 0.952406108379364f, 1.0951876640319824f, 2.7528741359710693f));
// _0_0_0 is CompositeGraphicsNode
float alpha__0_0_0_0 = origAlpha;
origAlpha = origAlpha * 1.0f;
g.setComposite(AlphaComposite.getInstance(3, origAlpha));
Shape clip__0_0_0_0 = g.getClip();
AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0_0 is ShapeNode
paint = new Color(15, 194, 18, 255);
stroke = new BasicStroke(1.75f,0,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(26.023392, 5.875);
((GeneralPath)shape).curveTo(13.932483, 21.875, -7.622566, 21.7323, 8.841574, 39.69318);
((GeneralPath)shape).curveTo(19.841574, 51.69318, 24.750664, 56.965904, 24.750664, 56.965904);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
origAlpha = alpha__0_0_0_0;
g.setTransform(defaultTransform__0_0_0_0);
g.setClip(clip__0_0_0_0);
float alpha__0_0_0_1 = origAlpha;
origAlpha = origAlpha * 1.0f;
g.setComposite(AlphaComposite.getInstance(3, origAlpha));
Shape clip__0_0_0_1 = g.getClip();
AffineTransform defaultTransform__0_0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0_1 is ShapeNode
paint = new Color(15, 194, 18, 255);
stroke = new BasicStroke(1.75f,0,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(38.875, 5.875);
((GeneralPath)shape).curveTo(50.965908, 21.875, 72.52096, 21.7323, 56.056816, 39.69318);
((GeneralPath)shape).curveTo(45.056816, 51.69318, 40.147724, 56.965904, 40.147724, 56.965904);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
origAlpha = alpha__0_0_0_1;
g.setTransform(defaultTransform__0_0_0_1);
g.setClip(clip__0_0_0_1);
float alpha__0_0_0_2 = origAlpha;
origAlpha = origAlpha * 1.0f;
g.setComposite(AlphaComposite.getInstance(3, origAlpha));
Shape clip__0_0_0_2 = g.getClip();
AffineTransform defaultTransform__0_0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0_2 is CompositeGraphicsNode
float alpha__0_0_0_2_0 = origAlpha;
origAlpha = origAlpha * 1.0f;
g.setComposite(AlphaComposite.getInstance(3, origAlpha));
Shape clip__0_0_0_2_0 = g.getClip();
AffineTransform defaultTransform__0_0_0_2_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0_2_0 is ShapeNode
paint = new Color(0, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(52.0, 26.312);
((GeneralPath)shape).curveTo(51.999966, 29.256021, 50.75197, 31.592018, 48.256, 33.32);
((GeneralPath)shape).curveTo(46.047974, 34.792015, 43.391975, 35.528015, 40.288002, 35.528);
((GeneralPath)shape).lineTo(26.608002, 35.528);
((GeneralPath)shape).lineTo(26.608002, 41.816);
((GeneralPath)shape).lineTo(20.896002, 41.816);
((GeneralPath)shape).lineTo(20.896002, 32.696003);
((GeneralPath)shape).curveTo(20.896, 31.92802, 21.184, 31.256021, 21.760002, 30.680002);
((GeneralPath)shape).curveTo(22.335999, 30.104023, 22.991999, 29.816023, 23.728003, 29.816002);
((GeneralPath)shape).lineTo(41.200005, 29.816002);
((GeneralPath)shape).curveTo(42.511982, 29.816021, 43.66398, 29.560022, 44.656006, 29.048002);
((GeneralPath)shape).curveTo(45.90398, 28.408024, 46.527977, 27.480026, 46.528008, 26.264002);
((GeneralPath)shape).curveTo(46.52798, 25.048027, 45.90398, 24.120028, 44.656006, 23.480001);
((GeneralPath)shape).curveTo(43.663982, 22.968029, 42.511982, 22.712029, 41.200005, 22.712002);
((GeneralPath)shape).lineTo(20.896004, 22.712002);
((GeneralPath)shape).lineTo(20.896004, 17.000002);
((GeneralPath)shape).lineTo(40.288002, 17.000002);
((GeneralPath)shape).curveTo(43.39198, 17.000034, 46.047974, 17.752033, 48.256, 19.256002);
((GeneralPath)shape).curveTo(50.75197, 20.984032, 51.99997, 23.33603, 52.0, 26.312002);
((GeneralPath)shape).moveTo(26.608, 47.0);
((GeneralPath)shape).curveTo(26.607992, 47.864002, 26.335993, 48.568, 25.792, 49.112);
((GeneralPath)shape).curveTo(25.247993, 49.656002, 24.543995, 49.928, 23.68, 49.928);
((GeneralPath)shape).curveTo(22.847998, 49.928, 22.143997, 49.656002, 21.568, 49.112);
((GeneralPath)shape).curveTo(21.023998, 48.568, 20.751999, 47.864002, 20.752, 47.0);
((GeneralPath)shape).curveTo(20.751999, 46.168003, 21.023998, 45.480003, 21.568, 44.936);
((GeneralPath)shape).curveTo(22.143997, 44.392006, 22.847998, 44.120007, 23.68, 44.120003);
((GeneralPath)shape).curveTo(24.543995, 44.12001, 25.247993, 44.39201, 25.792, 44.936005);
((GeneralPath)shape).curveTo(26.335993, 45.48001, 26.607992, 46.168007, 26.608, 47.000004);
g.setPaint(paint);
g.fill(shape);
origAlpha = alpha__0_0_0_2_0;
g.setTransform(defaultTransform__0_0_0_2_0);
g.setClip(clip__0_0_0_2_0);
origAlpha = alpha__0_0_0_2;
g.setTransform(defaultTransform__0_0_0_2);
g.setClip(clip__0_0_0_2);
origAlpha = alpha__0_0_0;
g.setTransform(defaultTransform__0_0_0);
g.setClip(clip__0_0_0);
origAlpha = alpha__0_0;
g.setTransform(defaultTransform__0_0);
g.setClip(clip__0_0);
origAlpha = alpha__0;
g.setTransform(defaultTransform__0);
g.setClip(clip__0);
g.setTransform(defaultTransform_);
g.setClip(clip_);

	}
	
	public Image getImage() {
		BufferedImage image =
            new BufferedImage(getIconWidth(), getIconHeight(),
                    BufferedImage.TYPE_INT_ARGB);
    	Graphics2D g = image.createGraphics();
    	paintIcon(null, g, 0, 0);
    	g.dispose();
    	return image;
	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 3;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 8;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 64;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 64;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public CreolePluginIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}
	
	/**
	 * Creates a new transcoded SVG image with the given dimensions.
	 *
	 * @param size the dimensions of the icon
	 */
	public CreolePluginIcon(Dimension size) {
	this.width = size.width;
	this.height = size.width;
	}

	public CreolePluginIcon(int width, int height) {
	this.width = width;
	this.height = height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);
						
		Area clip = new Area(new Rectangle(0, 0, this.width, this.height));		
		if (g2d.getClip() != null) clip.intersect(new Area(g2d.getClip()));		
		g2d.setClip(clip);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

