/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Out;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HtmlLinksExtractor
extends HTMLEditorKit.ParserCallback {
    private static final boolean DEBUG = false;
    private HTML.Tag currentTag = null;
    static boolean firstTitle = true;
    static String endUl = "";
    static String currFile = "";
    static String currPath = "";

    public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        this.currentTag = tag;
        if (HTML.Tag.A == tag) {
            Out.pr("<LI><" + tag);
            String string = "";
            Enumeration<?> enumeration = mutableAttributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                HTML.Attribute attribute = (HTML.Attribute)enumeration.nextElement();
                String string2 = (String)mutableAttributeSet.getAttribute(attribute);
                if (attribute != HTML.Attribute.HREF) continue;
                if (string2.startsWith("http:") || string2.startsWith("HTTP:") || string2.startsWith("file:") || string2.startsWith("FILE:") || string2.startsWith("mailto:") || string2.startsWith("MAILTO:") || string2.startsWith("ftp:") || string2.startsWith("FTP:")) {
                    Out.pr(" HREF=\"" + string2 + "\"");
                    continue;
                }
                Out.pr(" HREF=\"" + currPath + "/" + string2 + "\"");
            }
            Out.pr(">");
        }
        if (HTML.Tag.TITLE == tag) {
            Out.pr(endUl + "<H3>");
            if (firstTitle) {
                firstTitle = false;
                endUl = "</UL>";
            }
        }
    }

    private void printAttributes(MutableAttributeSet mutableAttributeSet) {
        if (mutableAttributeSet == null) {
            return;
        }
        if (0 != mutableAttributeSet.getAttributeCount()) {
            Enumeration<?> enumeration = mutableAttributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Out.pr(" " + obj.toString() + "=\"" + mutableAttributeSet.getAttribute(obj).toString() + "\"");
            }
        }
    }

    public void handleEndTag(HTML.Tag tag, int n) {
        this.currentTag = null;
        if (HTML.Tag.A == tag) {
            Out.pr("</" + tag + ">\n");
        }
        if (HTML.Tag.TITLE == tag) {
            Out.pr("</H3></A>\n\n<P>Links in: <A HREF=\"" + currFile + "\">" + currFile + "</A>:\n<UL>\n");
        }
    }

    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        if (HTML.Tag.A == tag) {
            Out.pr("<" + tag);
            this.printAttributes(mutableAttributeSet);
            Out.pr("/>\n");
        }
        if (HTML.Tag.TITLE == tag) {
            Out.pr("<" + tag);
            this.printAttributes(mutableAttributeSet);
            Out.pr("/>\n");
        }
    }

    public void handleText(char[] cArray, int n) {
        String string;
        if (HTML.Tag.A == this.currentTag) {
            string = new String(cArray);
            Out.pr(string);
        }
        if (HTML.Tag.TITLE == this.currentTag) {
            string = new String(cArray);
            Out.pr(string);
        }
    }

    public void handleError(String string, int n) {
    }

    public void flush() throws BadLocationException {
    }

    public void handleComment(char[] cArray, int n) {
    }

    private static List listAllFiles(File file, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        if (!file.isDirectory()) {
            arrayList.add(file.getPath());
            return arrayList;
        }
        HtmlLinksExtractor.listFilesRec(file, arrayList, arrayList2, set);
        return arrayList;
    }

    private static void listFilesRec(File file, List list, List list2, Set set) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getPath() + "\\" + stringArray[i]);
            if (file2.isDirectory()) {
                if (set.contains(file2.getName())) continue;
                list2.add(file2);
                continue;
            }
            if (!stringArray[i].toLowerCase().endsWith(".html") && !stringArray[i].toLowerCase().endsWith(".htm")) continue;
            list.add(file2.getPath());
        }
        while (!list2.isEmpty()) {
            File file3 = (File)list2.get(0);
            list2.remove(0);
            HtmlLinksExtractor.listFilesRec(file3, list, list2, set);
        }
    }

    public static void main(String[] stringArray) {
        ParserDelegator parserDelegator = new ParserDelegator();
        HtmlLinksExtractor htmlLinksExtractor = new HtmlLinksExtractor();
        if (stringArray.length == 0) {
            Out.prln("Eg: java HtmlLinksExtractor g:\\tmp\\relative javadoc img > results.txt");
            return;
        }
        File file = new File(stringArray[0]);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 1; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        List list = HtmlLinksExtractor.listAllFiles(file, hashSet);
        while (!list.isEmpty()) {
            try {
                String string;
                currFile = string = (String)list.get(0);
                currPath = new File(currFile).getParent().toString();
                list.remove(0);
                Out.prln("\n\n<A HREF=\"file://" + string + "\">");
                FileReader fileReader = new FileReader(string);
                ((HTMLEditorKit.Parser)parserDelegator).parse(fileReader, htmlLinksExtractor, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
        }
        System.err.println("done.");
    }
}

