/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.Files;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CorpusSaver {
    private static final boolean DEBUG = true;
    private File startDir;
    private File currDir;
    private DataStore ds;
    private Corpus theCorpus;
    private String annotSetName = "NE";
    private String dsPath = "d:\\bnc";
    private Controller application = null;
    private File applicationFile = null;
    private boolean processMode = false;
    private boolean saveMode = true;

    public void init() {
        if (this.saveMode) {
            File file = new File(this.dsPath);
            try {
                this.ds = Factory.openDataStore("gate.persist.SerialDataStore", file.toURI().toURL().toString());
            }
            catch (Exception exception) {
                throw new GateRuntimeException(exception.getMessage());
            }
            try {
                Corpus corpus = Factory.newCorpus("bnc");
                LanguageResource languageResource = this.ds.adopt(corpus, null);
                this.ds.sync(languageResource);
                this.theCorpus = (Corpus)languageResource;
            }
            catch (Exception exception) {
                throw new GateRuntimeException(exception.getMessage());
            }
        }
        if (this.processMode) {
            this.initPRs();
        }
    }

    public void initPRs() {
        try {
            if (this.applicationFile == null) {
                Out.prln("Application not set!");
            }
            Out.prln("App file is: " + this.applicationFile.getAbsolutePath());
            this.application = (Controller)PersistenceManager.loadObjectFromFile(this.applicationFile);
        }
        catch (Exception exception) {
            throw new GateRuntimeException("Corpus Saver: " + exception.getMessage());
        }
    }

    public void execute() {
        this.execute(this.startDir);
        try {
            if (this.saveMode) {
                this.ds.sync(this.theCorpus);
                Factory.deleteResource(this.theCorpus);
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            if (this.application != null) {
                Iterator iterator = new ArrayList(this.application.getPRs()).iterator();
                while (iterator.hasNext()) {
                    Factory.deleteResource((Resource)iterator.next());
                }
            }
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception.getMessage());
        }
    }

    public void execute(File file) {
        int n;
        if (file == null || this.saveMode && this.ds == null) {
            return;
        }
        this.currDir = file;
        Out.prln("Processing directory: " + this.currDir);
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray = this.currDir.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n].isDirectory()) {
                arrayList2.add(fileArray[n]);
                continue;
            }
            if (!fileArray[n].isFile()) continue;
            arrayList.add(fileArray[n]);
        }
        this.saveFiles(arrayList);
        if (arrayList2.isEmpty()) {
            return;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.execute((File)arrayList2.get(n));
        }
    }

    public static void main(String[] stringArray) throws GateException {
        File file;
        String string;
        int n;
        Gate.init();
        CorpusSaver corpusSaver = new CorpusSaver();
        if (stringArray.length < 2) {
            throw new GateException("usage: [-process|-process_only] source_directory datastore_path application");
        }
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            if (stringArray[n].equals("-process")) {
                Out.prln("Processing and saving the corpus enabled. <P>");
                corpusSaver.setProcessMode(true);
                continue;
            }
            if (!stringArray[n].equals("-process_only")) continue;
            Out.prln("Processing only enabled. <P>");
            corpusSaver.setSaveMode(false);
            corpusSaver.setProcessMode(true);
        }
        String string2 = stringArray[n];
        File file2 = new File(string2);
        if (!file2.isDirectory()) {
            throw new GateRuntimeException("Corpus directory should be provided as a parameter");
        }
        if (corpusSaver.getSaveMode()) {
            if (++n >= stringArray.length) {
                throw new GateRuntimeException("Datastore path not provided");
            }
            if (corpusSaver.getSaveMode()) {
                string = stringArray[n];
                file = new File(string);
                if (!file.isDirectory()) {
                    throw new GateRuntimeException("Please provide path to an existing GATE serial datastore");
                }
                corpusSaver.setDSPath(string);
            }
        }
        if (corpusSaver.getProcessMode()) {
            if (!(file = new File(string = stringArray[++n])).isFile()) {
                throw new GateException("Please provide an existing GATE application");
            }
            corpusSaver.setApplicationFile(file);
        }
        Out.prln("Initialising GATE please wait...");
        corpusSaver.init();
        corpusSaver.setStartDir(file2);
        Out.prln("Processing...");
        double d = System.currentTimeMillis();
        corpusSaver.execute();
        double d2 = System.currentTimeMillis();
        Out.prln("Done in " + NumberFormat.getInstance().format((d2 - d) / 1000.0) + " seconds");
    }

    public void setStartDir(File file) {
        this.startDir = file;
    }

    public void setProcessMode(boolean bl) {
        this.processMode = bl;
    }

    public boolean getProcessMode() {
        return this.processMode;
    }

    public void setSaveMode(boolean bl) {
        this.saveMode = bl;
    }

    public boolean getSaveMode() {
        return this.saveMode;
    }

    public void setDSPath(String string) {
        this.dsPath = string;
    }

    public void setApplicationFile(File file) {
        this.applicationFile = file;
    }

    protected void saveFiles(List list) {
        if (list == null || list.isEmpty() || this.saveMode && (this.theCorpus == null || this.ds == null)) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                Document document = Factory.newDocument(((File)list.get(i)).toURI().toURL());
                document.setName(Files.getLastPathComponent(((File)list.get(i)).toURI().toURL().toString()));
                Out.prln("Storing document: " + document.getName());
                if (this.processMode) {
                    this.processDocument(document);
                }
                if (this.saveMode) {
                    LanguageResource languageResource = this.ds.adopt(document, null);
                    this.theCorpus.add(languageResource);
                    this.theCorpus.unloadDocument((Document)languageResource);
                    if (languageResource != document) {
                        Factory.deleteResource(languageResource);
                    }
                }
                Factory.deleteResource(document);
                continue;
            }
            catch (Exception exception) {
                throw new GateRuntimeException(exception.getClass() + " " + exception.getMessage());
            }
        }
    }

    protected void processDocument(Document document) {
        try {
            if (this.application instanceof CorpusController) {
                Corpus corpus = Factory.newCorpus("temp");
                corpus.add(document);
                ((CorpusController)this.application).setCorpus(corpus);
                this.application.execute();
                Factory.deleteResource(corpus);
                corpus = null;
            } else {
                Iterator iterator = this.application.getPRs().iterator();
                while (iterator.hasNext()) {
                    ((ProcessingResource)iterator.next()).setParameterValue("document", document);
                }
                this.application.execute();
            }
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new RuntimeException("Error executing application: " + resourceInstantiationException.getMessage());
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException("Error executing application: " + executionException.getMessage());
        }
    }
}

