/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class BomStrippingInputStreamReader
extends BufferedReader {
    private IOException pendingConstructionException;
    private boolean pendingEOF;
    private boolean pendingChecked;

    public BomStrippingInputStreamReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public BomStrippingInputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(new InputStreamReader(inputStream, string));
    }

    public BomStrippingInputStreamReader(InputStream inputStream, String string, int n) throws UnsupportedEncodingException {
        this(new InputStreamReader(inputStream, string), n);
    }

    public BomStrippingInputStreamReader(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public BomStrippingInputStreamReader(InputStream inputStream, int n) {
        this(new InputStreamReader(inputStream), n);
    }

    public BomStrippingInputStreamReader(InputStream inputStream, CharsetDecoder charsetDecoder, int n) {
        this(new InputStreamReader(inputStream, charsetDecoder), n);
    }

    private BomStrippingInputStreamReader(InputStreamReader inputStreamReader, int n) {
        super(inputStreamReader, n);
        this.stripBomIfPresent();
    }

    private BomStrippingInputStreamReader(InputStreamReader inputStreamReader) {
        super(inputStreamReader);
        this.stripBomIfPresent();
    }

    public BomStrippingInputStreamReader(InputStream inputStream, CharsetDecoder charsetDecoder) {
        super(new InputStreamReader(inputStream, charsetDecoder));
        this.stripBomIfPresent();
    }

    private void stripBomIfPresent() {
        try {
            super.mark(1);
            int n = super.read();
            if (n == -1) {
                this.pendingEOF = true;
            } else if (n != 65279) {
                super.reset();
            }
        }
        catch (IOException iOException) {
            this.pendingConstructionException = iOException;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    private boolean checkPending() throws IOException {
        if (!this.pendingChecked) {
            if (this.pendingEOF) {
                return true;
            }
            if (this.pendingConstructionException != null) {
                throw this.pendingConstructionException;
            }
            this.pendingChecked = true;
        }
        return false;
    }

    public int read(CharBuffer charBuffer) throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read(charBuffer);
    }

    public int read(char[] cArray) throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read(cArray);
    }

    public int read() throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read(cArray, n, n2);
    }

    public String readLine() throws IOException {
        if (this.checkPending()) {
            return null;
        }
        return super.readLine();
    }

    public long skip(long l) throws IOException {
        if (this.checkPending()) {
            return 0L;
        }
        return super.skip(l);
    }

    public boolean ready() throws IOException {
        if (this.checkPending()) {
            return false;
        }
        return super.ready();
    }

    public boolean markSupported() {
        return super.markSupported();
    }

    public void mark(int n) throws IOException {
        this.checkPending();
        super.mark(n);
    }

    public void reset() throws IOException {
        this.checkPending();
        super.reset();
    }

    public void close() throws IOException {
        super.close();
    }
}

