/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.Gate;
import gate.gui.MainFrame;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJFileChooser
extends JFileChooser {
    private String resource;
    private String fileName;
    private boolean isFileSelected = false;
    private Map<String, String> locations;

    public XJFileChooser() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                XJFileChooser.this.resource = null;
                XJFileChooser.this.fileName = null;
                XJFileChooser.this.isFileSelected = false;
                XJFileChooser.this.resetChoosableFileFilters();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    @Override
    public int showDialog(Component component, String string) throws HeadlessException {
        this.setSelectedFileFromPreferences();
        return super.showDialog(component != null ? component : (MainFrame.getFileChooser() != null ? MainFrame.getInstance() : null), string);
    }

    public void setSelectedFileFromPreferences() {
        File file;
        String string = this.getLocationForResource(this.resource);
        String string2 = System.getProperty("gate.user.filechooser.defaultdir");
        if (this.isFileSelected) {
            return;
        }
        if (string != null && this.fileName != null) {
            file = new File(string);
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            file = new File(file, this.fileName);
        } else if (string != null) {
            file = new File(string);
        } else if (this.fileName != null) {
            file = string2 != null ? new File(string2, this.fileName) : new File(System.getProperty("user.home"), this.fileName);
        } else {
            if (string2 != null) {
                this.setCurrentDirectory(new File(string2));
            }
            return;
        }
        this.setSelectedFile(file);
        this.ensureFileIsVisible(file);
    }

    public String getLocationForResource(String string) {
        this.locations = this.getLocations();
        return string == null ? null : this.locations.get(string);
    }

    public Map<String, String> getLocations() {
        return Gate.getUserConfig().getMap(XJFileChooser.class.getName());
    }

    public void setLocations(Map<String, String> map) {
        Gate.getUserConfig().put((Object)XJFileChooser.class.getName(), map);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public void approveSelection() {
        if (this.resource != null && this.getSelectedFile() != null) {
            try {
                String string = this.getSelectedFile().getCanonicalPath();
                this.locations.put(this.resource, string);
                this.setLocations(this.locations);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        super.approveSelection();
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public String getResource() {
        return this.resource;
    }

    @Override
    public void ensureFileIsVisible(File file) {
        if (file != null && file.exists()) {
            super.ensureFileIsVisible(file);
        }
    }

    @Override
    public void setSelectedFile(File file) {
        if (file != null) {
            if (file.exists() || file.getParentFile() != null && file.getParentFile().exists()) {
                super.setSelectedFile(file);
            }
            this.isFileSelected = true;
        }
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
        for (FileFilter fileFilter2 : this.getChoosableFileFilters()) {
            if (!fileFilter2.getDescription().equals(fileFilter.getDescription())) continue;
            this.setFileFilter(fileFilter2);
            return;
        }
        super.addChoosableFileFilter(fileFilter);
    }
}

