/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ListDataListener;

public class JChoice
extends JPanel
implements ItemSelectable {
    public static final int DEFAULT_MAX_WIDTH = 500;
    public static final int DEFAULT_MAX_FAST_CHOICES = 10;
    private int maximumFastChoices;
    private Insets defaultButtonMargin;
    private int maximumWidth;
    private FlowLayout layout = new FlowLayout();
    private JComboBox combo;
    private ItemListener sharedItemListener;
    private ComboBoxModel model;
    private Map<AbstractButton, Object> buttonToValueMap;
    private Map<EventListener, ListenerWrapper> listenersMap;

    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedItem()};
    }

    public JChoice() {
        this(new DefaultComboBoxModel());
    }

    public JChoice(ComboBoxModel comboBoxModel) {
        this.layout.setHgap(0);
        this.layout.setVgap(0);
        this.layout.setAlignment(0);
        this.setLayout(this.layout);
        this.model = comboBoxModel;
        this.setSelectedItem(null);
        this.initLocalData();
        this.buildGui();
    }

    public JChoice(Object[] objectArray) {
        this(new DefaultComboBoxModel<Object>(objectArray));
    }

    private void initLocalData() {
        this.maximumFastChoices = 10;
        this.maximumWidth = 500;
        this.listenersMap = new HashMap<EventListener, ListenerWrapper>();
        this.combo = new JComboBox(this.model);
        this.buttonToValueMap = new HashMap<AbstractButton, Object>();
        this.sharedItemListener = new ItemListener(){
            private boolean disabled = false;

            public void itemStateChanged(ItemEvent itemEvent) {
                if (this.disabled) {
                    return;
                }
                if (itemEvent.getSource() == JChoice.this.combo) {
                    this.disabled = true;
                    if (itemEvent.getStateChange() == 1) {
                        for (AbstractButton abstractButton : JChoice.this.buttonToValueMap.keySet()) {
                            Object v = JChoice.this.buttonToValueMap.get(abstractButton);
                            if (v.equals(itemEvent.getItem())) {
                                if (abstractButton.isSelected()) continue;
                                abstractButton.setSelected(true);
                                abstractButton.requestFocusInWindow();
                                continue;
                            }
                            if (!abstractButton.isSelected()) continue;
                            abstractButton.setSelected(false);
                        }
                    } else if (itemEvent.getStateChange() == 2) {
                        for (AbstractButton abstractButton : JChoice.this.buttonToValueMap.keySet()) {
                            Object v = JChoice.this.buttonToValueMap.get(abstractButton);
                            if (!v.equals(itemEvent.getItem()) || !abstractButton.isSelected()) continue;
                            abstractButton.setSelected(false);
                        }
                    }
                    this.disabled = false;
                } else if (itemEvent.getSource() instanceof AbstractButton && JChoice.this.buttonToValueMap.containsKey(itemEvent.getSource())) {
                    Object v = JChoice.this.buttonToValueMap.get(itemEvent.getSource());
                    if (itemEvent.getStateChange() == 1) {
                        JChoice.this.model.setSelectedItem(v);
                    } else if (itemEvent.getStateChange() == 2) {
                        JChoice.this.model.setSelectedItem(null);
                    }
                }
            }
        };
        this.combo.addItemListener(this.sharedItemListener);
    }

    public static void main(String[] stringArray) {
        final JChoice jChoice = new JChoice(new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
        jChoice.setMaximumFastChoices(20);
        jChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Action (" + actionEvent.getActionCommand() + ") :" + jChoice.getSelectedItem() + " selected!");
            }
        });
        jChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                System.out.println("Item " + itemEvent.getItem().toString() + (itemEvent.getStateChange() == 1 ? " selected!" : " deselected!"));
            }
        });
        JFrame jFrame = new JFrame("Fast Chioce Test Frame");
        jFrame.getContentPane().add(jChoice);
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Clearing");
                jChoice.setSelectedItem(null);
            }
        });
        box.add(Box.createHorizontalStrut(10));
        box.add(jButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(new JToggleButton("GAGA"));
        jFrame.add((Component)box, "North");
        jFrame.pack();
        jFrame.setDefaultCloseOperation(2);
        jFrame.setVisible(true);
    }

    public void removeActionListener(ActionListener actionListener) {
        ListenerWrapper listenerWrapper = this.listenersMap.remove(actionListener);
        this.combo.removeActionListener(listenerWrapper);
    }

    public void removeItemListener(ItemListener itemListener) {
        ListenerWrapper listenerWrapper = this.listenersMap.remove(itemListener);
        this.combo.removeActionListener(listenerWrapper);
    }

    public void addActionListener(ActionListener actionListener) {
        this.combo.addActionListener(new ListenerWrapper(actionListener));
    }

    public void addItemListener(ItemListener itemListener) {
        this.combo.addItemListener(new ListenerWrapper(itemListener));
    }

    private void buildGui() {
        this.removeAll();
        if (this.model != null && this.model.getSize() > 0) {
            if (this.model.getSize() > this.maximumFastChoices) {
                this.add(this.combo);
            } else {
                if (this.buttonToValueMap.size() > 0) {
                    for (AbstractButton abstractButton : this.buttonToValueMap.keySet()) {
                        abstractButton.removeItemListener(this.sharedItemListener);
                    }
                }
                this.buttonToValueMap.clear();
                for (int i = 0; i < this.model.getSize(); ++i) {
                    AbstractButton abstractButton;
                    abstractButton = this.model.getElementAt(i);
                    JToggleButton jToggleButton = new JToggleButton(((Object)abstractButton).toString());
                    if (this.defaultButtonMargin != null) {
                        jToggleButton.setMargin(this.defaultButtonMargin);
                    }
                    jToggleButton.addItemListener(this.sharedItemListener);
                    this.buttonToValueMap.put(jToggleButton, abstractButton);
                    this.add(jToggleButton);
                }
            }
        }
        this.revalidate();
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.model.addListDataListener(listDataListener);
    }

    public Object getElementAt(int n) {
        return this.model.getElementAt(n);
    }

    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.model.removeListDataListener(listDataListener);
    }

    public void setSelectedItem(Object object) {
        this.model.setSelectedItem(object);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getItemCount() <= this.maximumFastChoices && dimension.width > this.maximumWidth) {
            this.setSize(this.maximumWidth, Integer.MAX_VALUE);
            this.doLayout();
            int n = this.getComponentCount();
            if (n > 0) {
                Component component = this.getComponent(n - 1);
                Point point = component.getLocation();
                Dimension dimension2 = component.getSize();
                dimension.width = this.maximumWidth;
                dimension.height = point.y + dimension2.height + this.getInsets().bottom;
            }
        }
        return dimension;
    }

    public int getMaximumFastChoices() {
        return this.maximumFastChoices;
    }

    public void setMaximumFastChoices(int n) {
        this.maximumFastChoices = n;
        this.buildGui();
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.model = comboBoxModel;
        this.combo.setModel(comboBoxModel);
        this.buildGui();
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int n) {
        this.maximumWidth = n;
    }

    public Insets getDefaultButtonMargin() {
        return this.defaultButtonMargin;
    }

    public void setDefaultButtonMargin(Insets insets) {
        this.defaultButtonMargin = insets;
        this.buildGui();
    }

    private class ListenerWrapper
    implements ActionListener,
    ItemListener {
        private EventListener originalListener;

        public ListenerWrapper(EventListener eventListener) {
            this.originalListener = eventListener;
            JChoice.this.listenersMap.put(eventListener, this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ((ItemListener)this.originalListener).itemStateChanged(new ItemEvent(JChoice.this, itemEvent.getID(), itemEvent.getItem(), itemEvent.getStateChange()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((ActionListener)this.originalListener).actionPerformed(new ActionEvent(JChoice.this, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
        }
    }
}

