/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.DataStore;
import gate.Document;
import gate.DocumentContent;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Node;
import gate.Resource;
import gate.annotation.DatabaseAnnotationSetImpl;
import gate.annotation.EventAwareAnnotationSet;
import gate.corpora.DatabaseCorpusImpl;
import gate.corpora.DatabaseDocumentImpl;
import gate.corpora.DocumentData;
import gate.corpora.DocumentImpl;
import gate.corpora.EventAwareCorpus;
import gate.corpora.EventAwareDocument;
import gate.corpora.EventAwareLanguageResource;
import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.persist.DBHelper;
import gate.persist.DatabaseDataStore;
import gate.persist.PersistenceException;
import gate.security.AccessController;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.security.Session;
import gate.security.User;
import gate.util.AbstractFeatureBearer;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.MethodNotImplementedException;
import java.io.Serializable;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;
import oracle.jdbc.driver.OraclePreparedStatement;

public abstract class JDBCDataStore
extends AbstractFeatureBearer
implements DatabaseDataStore,
CreoleListener {
    private static final boolean DEBUG = false;
    private String dbURL;
    protected String dbSchema;
    protected int dbType;
    protected String datastoreComment;
    protected String iconName;
    private String dbID;
    protected Session session;
    protected String name;
    protected transient Connection jdbcConn;
    protected transient AccessController ac;
    private transient Vector datastoreListeners = new Vector();
    protected transient Vector dependentResources = new Vector();

    protected JDBCDataStore() {
    }

    public String getComment() {
        Assert.assertNotNull((Object)this.datastoreComment);
        return this.datastoreComment;
    }

    public String getIconName() {
        Assert.assertNotNull((Object)this.iconName);
        return this.iconName;
    }

    public String getLrName(Object object) throws PersistenceException {
        String string;
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2;
            String string3 = " select lr_name  from   " + this.dbSchema + "t_lang_resource " + " where  lr_id = ?";
            preparedStatement = this.jdbcConn.prepareStatement(string3);
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            resultSet.next();
            string = string2 = resultSet.getString("lr_name");
            Object var9_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't get LR name from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                DBHelper.cleanup(preparedStatement);
                DBHelper.cleanup(resultSet);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
        DBHelper.cleanup(resultSet);
        return string;
    }

    public void setStorageUrl(String string) throws PersistenceException {
        if (!string.startsWith("jdbc:")) {
            throw new PersistenceException("Incorrect JDBC url (should start with \"jdbc:\")");
        }
        this.dbURL = string;
        this.dbSchema = DBHelper.getSchemaPrefix(this.dbURL);
        this.dbType = DBHelper.getDatabaseType(this.dbURL);
        Assert.assertNotNull((Object)this.dbSchema);
        Assert.assertTrue((this.dbType > 0 ? 1 : 0) != 0);
    }

    public String getStorageUrl() {
        return this.dbURL;
    }

    public void create() throws PersistenceException, UnsupportedOperationException {
        throw new UnsupportedOperationException("create() is not supported for DatabaseDataStore");
    }

    public void open() throws PersistenceException {
        try {
            this.jdbcConn = DBHelper.connect(this.dbURL);
            this.ac = Factory.createAccessController(this.dbURL);
            this.ac.open();
            this.dbID = this.readDatabaseID();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("could not get DB connection [" + sQLException.getMessage() + "]");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PersistenceException("cannot locate JDBC driver [" + classNotFoundException.getMessage() + "]");
        }
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public void close() throws PersistenceException {
        Gate.getCreoleRegister().removeCreoleListener(this);
        for (int i = 0; i < this.dependentResources.size(); ++i) {
            LanguageResource languageResource = (LanguageResource)this.dependentResources.elementAt(i);
            try {
                this.sync(languageResource);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Factory.deleteResource(languageResource);
        }
        this.ac.close();
        DBHelper.disconnect(this.jdbcConn);
        Gate.getDataStoreRegister().remove(this);
    }

    public void delete() throws PersistenceException, UnsupportedOperationException {
        throw new UnsupportedOperationException("delete() is not supported for DatabaseDataStore");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(String string, Object object) throws PersistenceException, SecurityException {
        LanguageResource languageResource;
        block15: {
            if (!(object instanceof Long)) {
                throw new IllegalArgumentException();
            }
            if (!string.equals("gate.corpora.DatabaseDocumentImpl") && !string.equals("gate.corpora.DatabaseCorpusImpl")) {
                throw new IllegalArgumentException("Only Corpus and Document classes are supported by Database data store");
            }
            if (null == this.session) {
                throw new SecurityException("session not set");
            }
            if (!this.ac.isValidSession(this.session)) {
                throw new SecurityException("invalid session supplied");
            }
            if (!this.canWriteLR(object)) {
                throw new SecurityException("insufficient privileges");
            }
            User user = this.getLockingUser((Long)object);
            User user2 = this.session.getUser();
            if (null != user && !user.equals(user2)) {
                throw new PersistenceException("LR locked by another user");
            }
            boolean bl = false;
            try {
                try {
                    this.beginTrans();
                    if (string.equals("gate.corpora.DatabaseDocumentImpl")) {
                        this.deleteDocument((Long)object);
                    } else {
                        this.deleteCorpus((Long)object);
                    }
                    this.commitTrans();
                }
                catch (PersistenceException persistenceException) {
                    bl = true;
                    throw persistenceException;
                }
                languageResource = null;
                if (!bl) break block15;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (!bl) throw throwable;
                this.rollbackTrans();
                throw throwable;
            }
            this.rollbackTrans();
        }
        boolean bl = false;
        Iterator iterator = this.dependentResources.iterator();
        while (iterator.hasNext()) {
            languageResource = (LanguageResource)iterator.next();
            if (!languageResource.getLRPersistenceId().equals(object)) continue;
            bl = true;
            iterator.remove();
            break;
        }
        this.fireResourceDeleted(new DatastoreEvent(this, 302, null, object));
        try {
            this.unloadLR((Long)object);
            return;
        }
        catch (GateException gateException) {
            Err.prln("can't unload resource from GUI...");
        }
    }

    public void sync(LanguageResource languageResource) throws PersistenceException, SecurityException {
        this._sync(languageResource, true);
    }

    public void setAutoSaving(boolean bl) throws UnsupportedOperationException, PersistenceException {
        try {
            this.jdbcConn.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("cannot change autosave mode [" + sQLException.getMessage() + "]");
        }
    }

    public boolean isAutoSaving() {
        throw new MethodNotImplementedException();
    }

    public LanguageResource adopt(LanguageResource languageResource, SecurityInfo securityInfo) throws PersistenceException, SecurityException {
        return this._adopt(languageResource, securityInfo, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected LanguageResource _adopt(LanguageResource languageResource, SecurityInfo securityInfo, boolean bl) throws PersistenceException, SecurityException {
        LanguageResource languageResource2;
        block14: {
            Object object;
            block16: {
                block17: {
                    DataStore dataStore;
                    block15: {
                        languageResource2 = null;
                        Assert.assertNotNull((Object)languageResource);
                        Assert.assertNotNull((Object)securityInfo);
                        if (!(languageResource instanceof Document) && !(languageResource instanceof Corpus)) {
                            throw new IllegalArgumentException("only Documents and Corpuses could be serialized in DB");
                        }
                        if (!this.ac.isValidSecurityInfo(securityInfo)) {
                            throw new SecurityException("Invalid security settings supplied");
                        }
                        if (null == this.session) {
                            throw new SecurityException("user session not set");
                        }
                        dataStore = languageResource.getDataStore();
                        if (dataStore != null) break block15;
                        if (languageResource instanceof Document) break block16;
                        break block17;
                    }
                    if (dataStore.equals(this)) {
                        return languageResource;
                    }
                    throw new PersistenceException("Can't adopt a resource which is already in a different datastore");
                }
                if (!(languageResource instanceof Corpus)) {
                    throw new IllegalArgumentException("Database datastore is implemented only for Documents and Corpora");
                }
            }
            if ((object = languageResource.getLRPersistenceId()) != null) {
                throw new PersistenceException("This LR is already stored in the  database (persistance ID is =[" + (Long)object + "] )");
            }
            boolean bl2 = false;
            try {
                try {
                    if (bl) {
                        this.beginTrans();
                    }
                    languageResource2 = languageResource instanceof Document ? this.createDocument((Document)languageResource, securityInfo) : this.createCorpus((Corpus)languageResource, securityInfo, true);
                    if (bl) {
                        this.commitTrans();
                    }
                }
                catch (PersistenceException persistenceException) {
                    bl2 = true;
                    throw persistenceException;
                }
                catch (SecurityException securityException) {
                    bl2 = true;
                    throw securityException;
                }
                Object var10_8 = null;
                if (!bl2) break block14;
                System.out.println("trans failed ...rollback");
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (bl2) {
                    System.out.println("trans failed ...rollback");
                    this.rollbackTrans();
                }
                throw throwable;
            }
            this.rollbackTrans();
        }
        this.fireResourceAdopted(new DatastoreEvent(this, 301, languageResource2, languageResource2.getLRPersistenceId()));
        this.fireResourceWritten(new DatastoreEvent(this, 303, languageResource2, languageResource2.getLRPersistenceId()));
        this.dependentResources.add(languageResource2);
        return languageResource2;
    }

    public List getLrTypes() throws PersistenceException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.jdbcConn.createStatement();
            resultSet = statement.executeQuery(" SELECT lrtp_type  FROM   " + this.dbSchema + "t_lr_type LRTYPE ");
            while (resultSet.next()) {
                object = resultSet.getString(1);
                vector.add(object);
            }
            object = vector;
            Object var6_6 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't get LR types from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(statement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(statement);
        return object;
    }

    public List getLrIds(String string) throws PersistenceException {
        Serializable serializable;
        Vector vector = new Vector();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement(" SELECT lr_id  FROM   " + this.dbSchema + "t_lang_resource LR, " + "        " + this.dbSchema + "t_lr_type LRTYPE " + " WHERE  LR.lr_type_id = LRTYPE.lrtp_id " + "        AND LRTYPE.lrtp_type = ? " + " ORDER BY lr_name");
            preparedStatement.setString(1, string);
            if (this.dbType == 101) {
                ((OraclePreparedStatement)preparedStatement).setRowPrefetch(30);
            }
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            while (resultSet.next()) {
                serializable = new Long(resultSet.getLong(1));
                vector.add(serializable);
            }
            serializable = vector;
            Object var7_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't get LR types from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return serializable;
    }

    public List getLrNames(String string) throws PersistenceException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement(" SELECT lr_name  FROM   " + this.dbSchema + "t_lang_resource LR, " + "        t_lr_type LRTYPE " + " WHERE  LR.lr_type_id = LRTYPE.lrtp_id " + "        AND LRTYPE.lrtp_type = ? " + " ORDER BY lr_name desc");
            preparedStatement.setString(1, string);
            if (this.dbType == 101) {
                ((OraclePreparedStatement)preparedStatement).setRowPrefetch(30);
            }
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                vector.add(object);
            }
            object = vector;
            Object var7_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't get LR types from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return object;
    }

    public boolean canReadLR(Object object) throws PersistenceException, SecurityException {
        return this.canAccessLR((Long)object, 0);
    }

    public boolean canWriteLR(Object object) throws PersistenceException, SecurityException {
        return this.canAccessLR((Long)object, 1);
    }

    protected boolean canAccessLR(Long l, int n) throws PersistenceException, SecurityException {
        throw new MethodNotImplementedException();
    }

    public void beginTrans() throws PersistenceException, UnsupportedOperationException {
        try {
            this.jdbcConn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("cannot begin transaction, DB error is: [" + sQLException.getMessage() + "]");
        }
    }

    public void commitTrans() throws PersistenceException, UnsupportedOperationException {
        try {
            this.jdbcConn.commit();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("cannot commit transaction, DB error is: [" + sQLException.getMessage() + "]");
        }
    }

    public void rollbackTrans() throws PersistenceException, UnsupportedOperationException {
        try {
            this.jdbcConn.rollback();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("cannot commit transaction, DB error is: [" + sQLException.getMessage() + "]");
        }
    }

    public Long timestamp() throws PersistenceException {
        throw new MethodNotImplementedException();
    }

    public void deleteSince(Long l) throws PersistenceException {
        throw new MethodNotImplementedException();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    protected int findFeatureType(Object object) {
        if (null == object) {
            return 100;
        }
        if (object instanceof Integer) {
            return 101;
        }
        if (object instanceof Long) {
            return 102;
        }
        if (object instanceof Boolean) {
            return 103;
        }
        if (object instanceof Double || object instanceof Float) {
            return 106;
        }
        if (object instanceof String) {
            return 104;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return 113;
            }
            Object e = list.get(0);
            if (e instanceof Integer) {
                return 107;
            }
            if (e instanceof Long) {
                return 108;
            }
            if (e instanceof Boolean) {
                return 109;
            }
            if (e instanceof Double || e instanceof Float) {
                return 112;
            }
            if (e instanceof String) {
                return 110;
            }
        } else if (object instanceof Serializable) {
            return 105;
        }
        throw new IllegalArgumentException();
    }

    public String getDatabaseID() {
        return this.dbID;
    }

    protected String readDatabaseID() throws PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            try {
                String string2 = " select par_value_string  from  " + this.dbSchema + "t_parameter " + " where  par_key = ? ";
                preparedStatement = this.jdbcConn.prepareStatement(string2);
                preparedStatement.setString(1, "DB_GUID");
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    throw new PersistenceException("Can't read database parameter [DB_GUID]");
                }
                string = resultSet.getString(1);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("Can't read database parameter [" + sQLException.getMessage() + "]");
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatastoreListener(DatastoreListener datastoreListener) {
        Assert.assertNotNull((Object)this.datastoreListeners);
        Vector vector = this.datastoreListeners;
        synchronized (vector) {
            this.datastoreListeners.remove(datastoreListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatastoreListener(DatastoreListener datastoreListener) {
        Assert.assertNotNull((Object)this.datastoreListeners);
        Vector vector = this.datastoreListeners;
        synchronized (vector) {
            if (!this.datastoreListeners.contains(datastoreListener)) {
                this.datastoreListeners.add(datastoreListener);
            }
        }
    }

    protected void fireResourceAdopted(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)this.datastoreListeners);
        Vector vector = this.datastoreListeners;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((DatastoreListener)vector.elementAt(i)).resourceAdopted(datastoreEvent);
        }
    }

    protected void fireResourceDeleted(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)this.datastoreListeners);
        Vector vector = this.datastoreListeners;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((DatastoreListener)vector.elementAt(i)).resourceDeleted(datastoreEvent);
        }
    }

    protected void fireResourceWritten(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)this.datastoreListeners);
        Vector vector = this.datastoreListeners;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((DatastoreListener)vector.elementAt(i)).resourceWritten(datastoreEvent);
        }
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        Assert.assertNotNull((Object)creoleEvent.getResource());
        if (!(creoleEvent.getResource() instanceof LanguageResource)) {
            return;
        }
        LanguageResource languageResource = (LanguageResource)creoleEvent.getResource();
        if (languageResource.getDataStore() != this) {
            return;
        }
        this.dependentResources.remove(languageResource);
        this.removeDatastoreListener((DatastoreListener)((Object)languageResource));
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    public void setSession(Session session) throws SecurityException {
        this.session = session;
    }

    public Session getSession(Session session) throws SecurityException {
        return this.session;
    }

    public abstract List findLrIds(List var1) throws PersistenceException;

    public abstract List findLrIds(List var1, String var2) throws PersistenceException;

    public SecurityInfo getSecurityInfo(LanguageResource languageResource) throws PersistenceException {
        SecurityInfo securityInfo;
        int n;
        Object object;
        Assert.assertNotNull((Object)languageResource);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertTrue((boolean)(languageResource.getLRPersistenceId() instanceof Long));
        Assert.assertEquals((Object)this, (Object)languageResource.getDataStore());
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Long l = null;
        Long l2 = null;
        try {
            try {
                object = "   select lr_owner_user_id,           lr_owner_group_id,           lr_access_mode    from   " + this.dbSchema + "t_lang_resource " + "   where  lr_id = ?";
                preparedStatement = this.jdbcConn.prepareStatement((String)object);
                preparedStatement.setLong(1, (Long)languageResource.getLRPersistenceId());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw new PersistenceException("Invalid LR ID supplied - no data found");
                }
                l = new Long(resultSet.getLong("lr_owner_user_id"));
                l2 = new Long(resultSet.getLong("lr_owner_group_id"));
                n = resultSet.getInt("lr_access_mode");
                Assert.assertTrue((n == 2 || n == 3 || n == 4 || n == 1 ? 1 : 0) != 0);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("Can't read document permissions from DB, error is [" + sQLException.getMessage() + "]");
            }
            securityInfo = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        object = null;
        Group group = null;
        try {
            object = this.ac.findUser(l);
            group = this.ac.findGroup(l2);
        }
        catch (SecurityException securityException) {
            throw new PersistenceException("Invalid security settings found in DB [" + securityException.getMessage() + "]");
        }
        securityInfo = new SecurityInfo(n, (User)object, group);
        return securityInfo;
    }

    protected Corpus createCorpus(Corpus corpus, SecurityInfo securityInfo, boolean bl) throws PersistenceException, SecurityException {
        Object object;
        LanguageResource languageResource;
        Long l = this.createLR("gate.corpora.DatabaseCorpusImpl", corpus.getName(), securityInfo, null);
        Long l2 = null;
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            block18: {
                try {
                    if (this.dbType == 101) {
                        callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_corpus(?,?) }");
                        callableStatement.setLong(1, (long)l);
                        callableStatement.registerOutParameter(2, -5);
                        callableStatement.execute();
                        l2 = new Long(callableStatement.getLong(2));
                        break block18;
                    }
                    if (this.dbType == 102) {
                        preparedStatement = this.jdbcConn.prepareStatement("select persist_create_corpus(?) ");
                        preparedStatement.setLong(1, l);
                        preparedStatement.execute();
                        resultSet = preparedStatement.getResultSet();
                        if (!resultSet.next()) {
                            throw new PersistenceException("empty result set");
                        }
                        l2 = new Long(resultSet.getLong(1));
                        break block18;
                    }
                    Assert.fail();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceException("can't create corpus [step 2] in DB: [" + sQLException.getMessage() + "]");
                }
            }
            languageResource = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            DBHelper.cleanup(callableStatement);
            DBHelper.cleanup(preparedStatement);
            DBHelper.cleanup(resultSet);
            throw throwable;
        }
        DBHelper.cleanup(callableStatement);
        DBHelper.cleanup(preparedStatement);
        DBHelper.cleanup(resultSet);
        Iterator iterator = corpus.iterator();
        Vector<Object> vector = new Vector<Object>();
        while (iterator.hasNext()) {
            languageResource = (Document)iterator.next();
            if (languageResource.getLRPersistenceId() == null) {
                if (bl) {
                    this.beginTrans();
                }
                iterator.remove();
                object = this.createDocument((Document)languageResource, l2, securityInfo);
                if (bl) {
                    this.commitTrans();
                }
                vector.add(object);
                this.fireResourceAdopted(new DatastoreEvent(this, 301, (Resource)object, object.getLRPersistenceId()));
                this.fireResourceWritten(new DatastoreEvent(this, 303, (Resource)object, object.getLRPersistenceId()));
                continue;
            }
            if (languageResource.getDataStore().equals(this)) {
                this.fireResourceAdopted(new DatastoreEvent(this, 301, languageResource, languageResource.getLRPersistenceId()));
                this.fireResourceWritten(new DatastoreEvent(this, 303, languageResource, languageResource.getLRPersistenceId()));
                continue;
            }
            Err.prln("document [" + languageResource.getLRPersistenceId() + "] is adopted from another " + " datastore. Skipped.");
        }
        if (this.dbType == 101) {
            this.createFeaturesBulk(l, 1, corpus.getFeatures());
        } else if (this.dbType == 102) {
            this.createFeatures(l, 1, corpus.getFeatures());
        } else {
            Assert.fail();
        }
        languageResource = null;
        object = Factory.newFeatureMap();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("DS", this);
        hashMap.put("LR_ID", l);
        hashMap.put("CORP_NAME", corpus.getName());
        hashMap.put("CORP_FEATURES", corpus.getFeatures());
        hashMap.put("CORP_SUPPORT_LIST", vector);
        object.put("initData__$$__", hashMap);
        try {
            languageResource = (Corpus)Factory.createResource("gate.corpora.DatabaseCorpusImpl", (FeatureMap)object);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new GateRuntimeException(resourceInstantiationException.getMessage());
        }
        return languageResource;
    }

    protected Document createDocument(Document document, SecurityInfo securityInfo) throws PersistenceException, SecurityException {
        return this.createDocument(document, null, securityInfo);
    }

    protected Document createDocument(Document document, Long l, SecurityInfo securityInfo) throws PersistenceException, SecurityException {
        Object object;
        Object object2;
        Object object3;
        Assert.assertNotNull((Object)document);
        Assert.assertNotNull((Object)securityInfo);
        if (!this.ac.isValidSecurityInfo(securityInfo)) {
            throw new SecurityException("Invalid security settings");
        }
        AnnotationSet annotationSet = document.getAnnotations();
        DocumentContent documentContent = document.getContent();
        FeatureMap featureMap = document.getFeatures();
        String string = document.getName();
        URL uRL = document.getSourceUrl();
        Boolean bl = document.getMarkupAware();
        Long l2 = document.getSourceUrlStartOffset();
        Long l3 = document.getSourceUrlEndOffset();
        String string2 = null;
        try {
            string2 = (String)document.getParameterValue("encoding");
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new PersistenceException("cannot create document: error getting  document encoding [" + resourceInstantiationException.getMessage() + "]");
        }
        Long l4 = this.createLR("gate.corpora.DatabaseDocumentImpl", string, securityInfo, null);
        Long l5 = this.createDoc(l4, uRL, string2, l2, l3, bl, l);
        if (documentContent.size() > 0L) {
            this.updateDocumentContent(l5, documentContent);
        }
        this.createAnnotationSet(l4, annotationSet);
        Map<String, AnnotationSet> map = document.getNamedAnnotationSets();
        if (null != map) {
            object3 = map.entrySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                AnnotationSet annotationSet2 = object.getValue();
                this.createAnnotationSet(l4, annotationSet2);
            }
        }
        if (this.dbType == 101) {
            this.createFeaturesBulk(l4, 2, featureMap);
        } else if (this.dbType == 102) {
            this.createFeatures(l4, 2, featureMap);
        } else {
            Assert.fail();
        }
        object3 = null;
        object2 = Factory.newFeatureMap();
        object = new HashMap();
        ((HashMap)object).put("JDBC_CONN", this.jdbcConn);
        ((HashMap)object).put("DS", this);
        ((HashMap)object).put("LR_ID", l4);
        ((HashMap)object).put("DOC_NAME", document.getName());
        ((HashMap)object).put("DOC_CONTENT", document.getContent());
        ((HashMap)object).put("DOC_FEATURES", document.getFeatures());
        ((HashMap)object).put("DOC_MARKUP_AWARE", document.getMarkupAware());
        ((HashMap)object).put("DOC_SOURCE_URL", document.getSourceUrl());
        if (document instanceof DocumentImpl) {
            ((HashMap)object).put("DOC_STRING_CONTENT", ((DocumentImpl)document).getStringContent());
        }
        ((HashMap)object).put("DOC_SOURCE_URL_START", document.getSourceUrlStartOffset());
        ((HashMap)object).put("DOC_SOURCE_URL_END", document.getSourceUrlEndOffset());
        ((HashMap)object).put("DOC_DEFAULT_ANNOTATIONS", document.getAnnotations());
        ((HashMap)object).put("DOC_NAMED_ANNOTATION_SETS", document.getNamedAnnotationSets());
        object2.put("initData__$$__", object);
        try {
            object3 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", (FeatureMap)object2);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new GateRuntimeException(resourceInstantiationException.getMessage());
        }
        Factory.deleteResource(document);
        return object3;
    }

    protected abstract Long createLR(String var1, String var2, SecurityInfo var3, Long var4) throws PersistenceException, SecurityException;

    protected abstract Long createDoc(Long var1, URL var2, String var3, Long var4, Long var5, Boolean var6, Long var7) throws PersistenceException;

    protected abstract void updateDocumentContent(Long var1, DocumentContent var2) throws PersistenceException;

    protected abstract void createAnnotationSet(Long var1, AnnotationSet var2) throws PersistenceException;

    protected abstract void createFeaturesBulk(Long var1, int var2, FeatureMap var3) throws PersistenceException;

    protected abstract void createFeatures(Long var1, int var2, FeatureMap var3) throws PersistenceException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _sync(LanguageResource languageResource, boolean bl) throws PersistenceException, SecurityException {
        block15: {
            Assert.assertNotNull((Object)languageResource);
            Long l = (Long)languageResource.getLRPersistenceId();
            if (!(languageResource instanceof Document) && !(languageResource instanceof Corpus)) {
                throw new IllegalArgumentException("only Documents and Corpuses could be serialized in DB");
            }
            if (null == languageResource.getDataStore() || !languageResource.getDataStore().equals(this)) {
                throw new PersistenceException("This LR is not stored in this DataStore");
            }
            if (null == this.session) {
                throw new SecurityException("session not set");
            }
            if (!this.ac.isValidSession(this.session)) {
                throw new SecurityException("invalid session supplied");
            }
            if (!this.canWriteLR(l)) {
                throw new SecurityException("insufficient privileges");
            }
            User user = this.getLockingUser(languageResource);
            User user2 = this.session.getUser();
            if (user != null && !user.equals(user2)) {
                throw new PersistenceException("document is locked by another user and cannot be synced");
            }
            boolean bl2 = false;
            try {
                try {
                    if (bl) {
                        this.beginTrans();
                    }
                    if (languageResource instanceof Document) {
                        this.syncDocument((Document)languageResource);
                    } else {
                        this.syncCorpus((Corpus)languageResource);
                    }
                    if (bl) {
                        this.commitTrans();
                    }
                }
                catch (PersistenceException persistenceException) {
                    bl2 = true;
                    throw persistenceException;
                }
                Object var9_7 = null;
                if (!bl2) break block15;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (bl2) {
                    this.rollbackTrans();
                }
                throw throwable;
            }
            this.rollbackTrans();
        }
        this.fireResourceWritten(new DatastoreEvent(this, 303, languageResource, languageResource.getLRPersistenceId()));
    }

    protected User getLockingUser(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)languageResource);
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertEquals((Object)languageResource.getDataStore(), (Object)this);
        return this.getLockingUser((Long)languageResource.getLRPersistenceId());
    }

    protected User getLockingUser(Long l) throws PersistenceException, SecurityException {
        User user;
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        PreparedStatement preparedStatement = null;
        Object var3_3 = null;
        ResultSet resultSet = null;
        try {
            String string = null;
            if (this.dbType == 101) {
                string = "   select  nvl(lr_locking_user_id,0) as user_id   from " + this.dbSchema + "t_lang_resource " + "   where   lr_id = ?";
            } else if (this.dbType == 102) {
                string = "   select  coalesce(lr_locking_user_id,0) as user_id   from t_lang_resource    where   lr_id = ?";
            } else {
                throw new IllegalArgumentException();
            }
            preparedStatement = this.jdbcConn.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (!resultSet.next()) {
                throw new PersistenceException("LR not found in DB");
            }
            long l2 = resultSet.getLong("user_id");
            user = l2 == 0L ? null : this.ac.findUser(new Long(l2));
            Object var10_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't get locking user from DB : [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return user;
    }

    protected void syncCorpus(Corpus corpus) throws PersistenceException, SecurityException {
        List list;
        Assert.assertNotNull((Object)corpus);
        Assert.assertTrue((boolean)(corpus instanceof DatabaseCorpusImpl));
        Assert.assertEquals((Object)this, (Object)corpus.getDataStore());
        Assert.assertNotNull((Object)corpus.getLRPersistenceId());
        EventAwareCorpus eventAwareCorpus = (EventAwareCorpus)((Object)corpus);
        if (eventAwareCorpus.isResourceChanged(1001)) {
            this._syncLR(corpus);
        }
        if (eventAwareCorpus.isResourceChanged(1003)) {
            this._syncFeatures(corpus);
        }
        if ((list = eventAwareCorpus.getRemovedDocuments()).size() > 0) {
            this._syncRemovedDocumentsFromCorpus(list, (Long)corpus.getLRPersistenceId());
        }
        Iterator iterator = eventAwareCorpus.getLoadedDocuments().iterator();
        List list2 = eventAwareCorpus.getAddedDocuments();
        while (iterator.hasNext()) {
            Document document = (Document)iterator.next();
            if (null == document) continue;
            if (null == document.getLRPersistenceId()) {
                iterator.remove();
                SecurityInfo securityInfo = this.getSecurityInfo(corpus);
                Document document2 = null;
                try {
                    document2 = (Document)this._adopt(document, securityInfo, true);
                    this.addDocumentToCorpus((Long)document2.getLRPersistenceId(), (Long)corpus.getLRPersistenceId());
                }
                catch (SecurityException securityException) {
                    throw new PersistenceException(securityException);
                }
                corpus.add(document2);
                continue;
            }
            try {
                this._sync(document, true);
                this.fireResourceWritten(new DatastoreEvent(this, 303, document, document.getLRPersistenceId()));
                if (!list2.contains(document.getLRPersistenceId())) continue;
                this.addDocumentToCorpus((Long)document.getLRPersistenceId(), (Long)corpus.getLRPersistenceId());
            }
            catch (SecurityException securityException) {
                Err.prln("document cannot be synced: [" + securityException.getMessage() + "]");
            }
        }
    }

    protected void syncDocument(Document document) throws PersistenceException, SecurityException {
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        Assert.assertTrue((boolean)(document.getLRPersistenceId() instanceof Long));
        Long l = (Long)document.getLRPersistenceId();
        EventAwareLanguageResource eventAwareLanguageResource = (EventAwareLanguageResource)((Object)document);
        if (eventAwareLanguageResource.isResourceChanged(1001)) {
            this._syncLR(document);
        }
        if (eventAwareLanguageResource.isResourceChanged(1004)) {
            this._syncDocumentHeader(document);
        }
        if (eventAwareLanguageResource.isResourceChanged(1002)) {
            this._syncDocumentContent(document);
        }
        if (eventAwareLanguageResource.isResourceChanged(1003)) {
            this._syncFeatures(document);
        }
        Collection collection = ((EventAwareDocument)eventAwareLanguageResource).getRemovedAnnotationSets();
        Collection collection2 = ((EventAwareDocument)eventAwareLanguageResource).getAddedAnnotationSets();
        if (!collection.isEmpty() || !collection2.isEmpty()) {
            this._syncAnnotationSets(document, collection, collection2);
        }
        this._syncAnnotations(document);
    }

    protected abstract void _syncLR(LanguageResource var1) throws PersistenceException, SecurityException;

    protected abstract void _syncDocumentHeader(Document var1) throws PersistenceException;

    protected abstract void _syncDocumentContent(Document var1) throws PersistenceException;

    protected abstract void _syncFeatures(LanguageResource var1) throws PersistenceException;

    protected void _syncAnnotationSets(Document document, Collection collection, Collection collection2) throws PersistenceException {
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        Assert.assertNotNull((Object)document.getLRPersistenceId());
        Assert.assertEquals((String)((DatabaseDataStore)document.getDataStore()).getDatabaseID(), (String)this.getDatabaseID());
        Assert.assertNotNull((Object)collection);
        Assert.assertNotNull((Object)collection2);
        Long l = (Long)document.getLRPersistenceId();
        PreparedStatement preparedStatement = null;
        try {
            try {
                if (this.dbType == 101) {
                    preparedStatement = this.jdbcConn.prepareCall("{ call " + this.dbSchema + "persist.delete_annotation_set(?,?) }");
                } else if (this.dbType == 102) {
                    preparedStatement = this.jdbcConn.prepareStatement("select persist_delete_annotation_set(?,?)");
                } else {
                    Assert.fail();
                }
                for (String string : collection) {
                    preparedStatement.setLong(1, l);
                    preparedStatement.setString(2, string);
                    preparedStatement.execute();
                }
                Object var9_9 = null;
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't remove annotation set from DB: [" + sQLException.getMessage() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(preparedStatement);
        for (String string : collection2) {
            AnnotationSet annotationSet = document.getAnnotations(string);
            Assert.assertNotNull((Object)annotationSet);
            Assert.assertTrue((boolean)(annotationSet instanceof DatabaseAnnotationSetImpl));
            this.createAnnotationSet(l, annotationSet);
        }
    }

    protected void _syncAnnotations(Document document) throws PersistenceException {
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        Assert.assertNotNull((Object)document.getLRPersistenceId());
        Assert.assertEquals((String)((DatabaseDataStore)document.getDataStore()).getDatabaseID(), (String)this.getDatabaseID());
        EventAwareDocument eventAwareDocument = (EventAwareDocument)((Object)document);
        Collection collection = eventAwareDocument.getLoadedAnnotationSets();
        for (AnnotationSet annotationSet : collection) {
            if (eventAwareDocument.getAddedAnnotationSets().contains(annotationSet.getName()) || eventAwareDocument.getRemovedAnnotationSets().contains(annotationSet.getName())) continue;
            EventAwareAnnotationSet eventAwareAnnotationSet = (EventAwareAnnotationSet)annotationSet;
            Assert.assertNotNull((Object)annotationSet);
            Collection collection2 = null;
            collection2 = eventAwareAnnotationSet.getAddedAnnotations();
            Assert.assertNotNull((Object)collection2);
            if (collection2.size() > 0) {
                this._syncAddedAnnotations(document, annotationSet, collection2);
            }
            collection2 = eventAwareAnnotationSet.getRemovedAnnotations();
            Assert.assertNotNull((Object)collection2);
            if (collection2.size() > 0) {
                this._syncRemovedAnnotations(document, annotationSet, collection2);
            }
            collection2 = eventAwareAnnotationSet.getChangedAnnotations();
            Assert.assertNotNull((Object)collection2);
            if (collection2.size() <= 0) continue;
            this._syncChangedAnnotations(document, annotationSet, collection2);
        }
    }

    protected void _syncAddedAnnotations(Document document, AnnotationSet annotationSet, Collection collection) throws PersistenceException {
        Assert.assertNotNull((Object)document);
        Assert.assertNotNull((Object)annotationSet);
        Assert.assertNotNull((Object)collection);
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        Assert.assertTrue((boolean)(annotationSet instanceof DatabaseAnnotationSetImpl));
        Assert.assertTrue((collection.size() > 0 ? 1 : 0) != 0);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        CallableStatement callableStatement = null;
        Long l = (Long)document.getLRPersistenceId();
        Long l2 = null;
        try {
            try {
                String string = " select as_id   from  " + this.dbSchema + "v_annotation_set " + " where  lr_id = ? ";
                String string2 = null;
                String string3 = annotationSet.getName();
                string2 = null != string3 ? "        and as_name = ? " : "        and as_name is null ";
                string = string + string2;
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, l);
                if (null != string3) {
                    preparedStatement.setString(2, string3);
                }
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    throw new PersistenceException("cannot find annotation set with name=[" + string3 + "] , LRID=[" + l + "] in database");
                }
                l2 = new Long(resultSet.getLong("as_id"));
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                if (this.dbType == 101) {
                    callableStatement = this.jdbcConn.prepareCall("{ call gateadmin.persist.create_annotation(?,?,?,?,?,?,?,?,?) }");
                    Long l3 = null;
                    for (Annotation annotation : collection) {
                        Node node = annotation.getStartNode();
                        Node node2 = annotation.getEndNode();
                        String string4 = annotation.getType();
                        callableStatement.setLong(1, (long)l);
                        callableStatement.setLong(2, annotation.getId().longValue());
                        callableStatement.setLong(3, (long)l2);
                        callableStatement.setLong(4, node.getId().longValue());
                        callableStatement.setLong(5, (long)node.getOffset());
                        callableStatement.setLong(6, node2.getId().longValue());
                        callableStatement.setLong(7, (long)node2.getOffset());
                        callableStatement.setString(8, string4);
                        callableStatement.registerOutParameter(9, -5);
                        callableStatement.execute();
                        l3 = new Long(callableStatement.getLong(9));
                        FeatureMap featureMap = annotation.getFeatures();
                        Assert.assertNotNull((Object)featureMap);
                        if (this.dbType == 101) {
                            this.createFeaturesBulk(l3, 3, featureMap);
                            continue;
                        }
                        if (this.dbType == 102) {
                            this.createFeatures(l3, 3, featureMap);
                            continue;
                        }
                        Assert.fail();
                    }
                } else if (this.dbType == 102) {
                    string = "select persist_create_annotation(?,?,?,?,?,?,?,?)";
                    preparedStatement = this.jdbcConn.prepareStatement(string);
                    Long l4 = null;
                    for (Annotation annotation : collection) {
                        Node node = annotation.getStartNode();
                        Node node3 = annotation.getEndNode();
                        String string5 = annotation.getType();
                        preparedStatement.setLong(1, l);
                        preparedStatement.setLong(2, annotation.getId().longValue());
                        preparedStatement.setLong(3, l2);
                        preparedStatement.setLong(4, node.getId().longValue());
                        preparedStatement.setLong(5, node.getOffset());
                        preparedStatement.setLong(6, node3.getId().longValue());
                        preparedStatement.setLong(7, node3.getOffset());
                        preparedStatement.setString(8, string5);
                        preparedStatement.execute();
                        resultSet = preparedStatement.getResultSet();
                        if (!resultSet.next()) {
                            throw new PersistenceException("empty result set");
                        }
                        l4 = new Long(resultSet.getLong(1));
                        FeatureMap featureMap = annotation.getFeatures();
                        Assert.assertNotNull((Object)featureMap);
                        this.createFeatures(l4, 3, featureMap);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                Object var20_27 = null;
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't add annotations in DB : [" + sQLException.getMessage() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var20_28 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            DBHelper.cleanup(callableStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        DBHelper.cleanup(callableStatement);
    }

    protected void _syncRemovedAnnotations(Document document, AnnotationSet annotationSet, Collection collection) throws PersistenceException {
        Assert.assertNotNull((Object)document);
        Assert.assertNotNull((Object)annotationSet);
        Assert.assertNotNull((Object)collection);
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        Assert.assertTrue((boolean)(annotationSet instanceof DatabaseAnnotationSetImpl));
        Assert.assertTrue((collection.size() > 0 ? 1 : 0) != 0);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Long l = (Long)document.getLRPersistenceId();
        Long l2 = null;
        Long l3 = null;
        try {
            try {
                String string = " select as_id,          as_doc_id  from  " + this.dbSchema + "v_annotation_set " + " where  lr_id = ? ";
                String string2 = null;
                String string3 = annotationSet.getName();
                string2 = null != string3 ? "        and as_name = ? " : "        and as_name is null ";
                string = string + string2;
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, l);
                if (null != string3) {
                    preparedStatement.setString(2, string3);
                }
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    throw new PersistenceException("cannot find annotation set with name=[" + string3 + "] , LRID=[" + l + "] in database");
                }
                l3 = new Long(resultSet.getLong("as_id"));
                l2 = new Long(resultSet.getLong("as_doc_id"));
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                if (this.dbType == 101) {
                    preparedStatement = this.jdbcConn.prepareCall("{ call " + this.dbSchema + "persist.delete_annotation(?,?) }");
                } else if (this.dbType == 102) {
                    preparedStatement = this.jdbcConn.prepareStatement("select persist_delete_annotation(?,?)");
                } else {
                    throw new IllegalArgumentException();
                }
                for (Annotation annotation : collection) {
                    preparedStatement.setLong(1, l2);
                    preparedStatement.setLong(2, annotation.getId().longValue());
                    preparedStatement.execute();
                }
                Object var15_15 = null;
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't delete annotations in DB : [" + sQLException.getMessage() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
    }

    protected void _syncChangedAnnotations(Document document, AnnotationSet annotationSet, Collection collection) throws PersistenceException {
        this._syncRemovedAnnotations(document, annotationSet, collection);
        this._syncAddedAnnotations(document, annotationSet, collection);
    }

    public LanguageResource getLr(String string, Object object) throws PersistenceException, SecurityException {
        AbstractLanguageResource abstractLanguageResource = null;
        Assert.assertNotNull((Object)object);
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!this.canReadLR(object)) {
            throw new SecurityException("insufficient privileges");
        }
        if (string.equals("gate.corpora.DatabaseDocumentImpl")) {
            abstractLanguageResource = this.readDocument(object);
            Assert.assertTrue((boolean)(abstractLanguageResource instanceof DatabaseDocumentImpl));
        } else if (string.equals("gate.corpora.DatabaseCorpusImpl")) {
            abstractLanguageResource = this.readCorpus(object);
            Assert.assertTrue((boolean)(abstractLanguageResource instanceof DatabaseCorpusImpl));
        } else {
            throw new IllegalArgumentException("resource class should be either Document or Corpus");
        }
        Assert.assertNotNull((Object)abstractLanguageResource.getDataStore());
        Assert.assertTrue((boolean)(abstractLanguageResource.getDataStore() instanceof DatabaseDataStore));
        Assert.assertNotNull((Object)abstractLanguageResource.getLRPersistenceId());
        this.addDatastoreListener((DatastoreListener)((Object)abstractLanguageResource));
        this.dependentResources.add(abstractLanguageResource);
        return abstractLanguageResource;
    }

    private DatabaseDocumentImpl readDocument(Object object) throws PersistenceException {
        Assert.assertNotNull((Object)object);
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException();
        }
        DatabaseDocumentImpl databaseDocumentImpl = new DatabaseDocumentImpl(this.jdbcConn);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string = " select lr_name,         lrtp_type,         lr_id,         lr_parent_id,         doc_id,         doc_url,         doc_start,         doc_end,         doc_is_markup_aware  from  " + this.dbSchema + "v_document " + " where  lr_id = ? ";
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, (Long)object);
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    throw new PersistenceException("Invalid LR ID supplied - no data found");
                }
                String string2 = resultSet.getString("lr_name");
                Assert.assertNotNull((Object)string2);
                databaseDocumentImpl.setName(string2);
                Long l = null;
                long l2 = resultSet.getLong("lr_parent_id");
                if (!resultSet.wasNull()) {
                    l = new Long(l2);
                    LanguageResource languageResource = this.getLr("gate.corpora.DatabaseDocumentImpl", l);
                    Assert.assertNotNull((Object)languageResource);
                    Assert.assertTrue((boolean)(languageResource instanceof DatabaseDocumentImpl));
                    databaseDocumentImpl.setParent(languageResource);
                }
                if (this.dbType == 101) {
                    long l3 = resultSet.getLong("doc_is_markup_aware");
                    Assert.assertTrue((l3 == 0L || l3 == 1L ? 1 : 0) != 0);
                    if (l3 == 0L) {
                        databaseDocumentImpl.setMarkupAware(Boolean.FALSE);
                    } else {
                        databaseDocumentImpl.setMarkupAware(Boolean.TRUE);
                    }
                } else if (this.dbType == 102) {
                    boolean bl = resultSet.getBoolean("doc_is_markup_aware");
                    databaseDocumentImpl.setMarkupAware(new Boolean(bl));
                } else {
                    throw new IllegalArgumentException();
                }
                databaseDocumentImpl.setDataStore(this);
                Long l4 = new Long(resultSet.getLong("lr_id"));
                databaseDocumentImpl.setLRPersistenceId(l4);
                String string3 = resultSet.getString("doc_url");
                if (string3 != null && string3.length() > 0) {
                    databaseDocumentImpl.setSourceUrl(new URL(string3));
                }
                Long l5 = null;
                long l6 = resultSet.getLong("doc_start");
                if (!resultSet.wasNull()) {
                    l5 = new Long(l6);
                }
                databaseDocumentImpl.setSourceUrlStartOffset(l5);
                Long l7 = null;
                l6 = resultSet.getLong("doc_end");
                if (!resultSet.wasNull()) {
                    l7 = new Long(l6);
                }
                databaseDocumentImpl.setSourceUrlEndOffset(l7);
                FeatureMap featureMap = this.readFeatures((Long)object, 2);
                databaseDocumentImpl.setFeatures(featureMap);
                long l8 = resultSet.getLong("doc_id");
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                string = " select  max(ann_local_id),'ann_id' from " + this.dbSchema + "t_annotation " + " where ann_doc_id = ?" + " union " + " select max(node_local_id),'node_id' " + " from " + this.dbSchema + "t_node " + " where node_doc_id = ?";
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, l8);
                preparedStatement.setLong(2, l8);
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                int n = 0;
                int n2 = 0;
                if (!resultSet.next()) {
                    throw new PersistenceException("Invalid LR ID supplied - no data found");
                }
                if (resultSet.getString(2).equals("ann_id")) {
                    n = resultSet.getInt(1);
                } else {
                    n2 = resultSet.getInt(1);
                }
                if (!resultSet.next()) {
                    throw new PersistenceException("Invalid LR ID supplied - no data found");
                }
                if (resultSet.getString(2).equals("node_id")) {
                    n2 = resultSet.getInt(1);
                } else {
                    n = resultSet.getInt(1);
                }
                databaseDocumentImpl.setNextNodeId(n2 + 1);
                databaseDocumentImpl.setNextAnnotationId(n + 1);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't read LR from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Exception exception) {
                throw new PersistenceException(exception);
            }
            Object var22_23 = null;
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return databaseDocumentImpl;
    }

    private DatabaseCorpusImpl readCorpus(Object object) throws PersistenceException {
        Assert.assertNotNull((Object)object);
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException();
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DatabaseCorpusImpl databaseCorpusImpl = null;
        try {
            try {
                String string = " select lr_name  from  " + this.dbSchema + "t_lang_resource " + " where  lr_id = ? ";
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, (Long)object);
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    throw new PersistenceException("Invalid LR ID supplied - no data found");
                }
                String string2 = resultSet.getString("lr_name");
                Assert.assertNotNull((Object)string2);
                FeatureMap featureMap = this.readFeatures((Long)object, 1);
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                string = " select lr_id ,         lr_name  from " + this.dbSchema + "t_document        doc, " + "      " + this.dbSchema + "t_lang_resource   lr, " + "      " + this.dbSchema + "t_corpus_document corpdoc, " + "      " + this.dbSchema + "t_corpus          corp " + " where lr.lr_id = doc.doc_lr_id " + "       and doc.doc_id = corpdoc.cd_doc_id " + "       and corpdoc.cd_corp_id = corp.corp_id " + "       and corp_lr_id = ? ";
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, (Long)object);
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                Vector<DocumentData> vector = new Vector<DocumentData>();
                while (resultSet.next()) {
                    Long l = new Long(resultSet.getLong("lr_id"));
                    String string3 = resultSet.getString("lr_name");
                    vector.add(new DocumentData(string3, l));
                }
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                databaseCorpusImpl = new DatabaseCorpusImpl(string2, this, (Long)object, featureMap, vector);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("can't read LR from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Exception exception) {
                throw new PersistenceException(exception);
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            throw throwable;
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return databaseCorpusImpl;
    }

    protected abstract FeatureMap readFeatures(Long var1, int var2) throws PersistenceException;

    protected abstract void deleteDocument(Long var1) throws PersistenceException;

    protected abstract void deleteCorpus(Long var1) throws PersistenceException;

    protected void unloadLR(Long l) throws GateException {
        Assert.assertNotNull((Object)l);
        List<Resource> list = Gate.getCreoleRegister().getAllInstances("gate.LanguageResource");
        for (LanguageResource languageResource : list) {
            if (!l.equals(languageResource.getLRPersistenceId()) || !this.equals(languageResource.getDataStore())) continue;
            Factory.deleteResource(languageResource);
            break;
        }
    }

    protected abstract void _syncRemovedDocumentsFromCorpus(List var1, Long var2) throws PersistenceException;

    protected abstract void addDocumentToCorpus(Long var1, Long var2) throws PersistenceException, SecurityException;
}

