/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.functest;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.jape.functest.TransducerType;
import gate.util.Files;
import gate.util.GateException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJapeTests
extends TestCase {
    public static final TransducerType transducerType = TransducerType.CLASSIC;
    private static final Logger logger = Logger.getLogger(BaseJapeTests.class);
    protected static final String DEFAULT_DATA_FILE = "jape/InputTexts/AveShort";

    public BaseJapeTests(String string) {
        super(string);
        BaseJapeTests.setUpGate();
    }

    protected static void setUpGate() {
        File[] fileArray;
        if (Gate.isInitialised()) {
            logger.warn((Object)"GATE already intialized and set up for JAPE Transducer tests.");
            return;
        }
        Properties properties = new Properties();
        InputStream inputStream = BaseJapeTests.class.getResourceAsStream("log4j-test.properties");
        assert (inputStream != null) : "Cannot locate LOG4J properties file";
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            logger.warn((Object)"Unable to load logging properties.");
            BasicConfigurator.configure();
        }
        PropertyConfigurator.configure((Properties)properties);
        if (System.getProperty("gate.home") == null) {
            System.setProperty("gate.home", ".");
        }
        try {
            Gate.init();
        }
        catch (GateException gateException) {
            String string = "Unable to initialize GATE";
            logger.fatal((Object)string);
            throw new RuntimeException(string);
        }
        logger.debug((Object)("GATE home is: " + Gate.getGateHome().getAbsolutePath()));
        if (!Gate.getPluginsHome().isDirectory()) {
            String string = "GATE home and plug-in directory set up failure.";
            logger.fatal((Object)string);
            throw new RuntimeException(string);
        }
        for (File file : fileArray = new File[]{new File(Gate.getPluginsHome(), "Ontology")}) {
            try {
                BaseJapeTests.registerCREOLE(file);
            }
            catch (GateException gateException) {
                logger.warn((Object)(file.getAbsoluteFile() + " was not loaded."));
            }
        }
        try {
            BaseJapeTests.registerCREOLE(transducerType == TransducerType.CLASSIC ? new File(Gate.getPluginsHome(), "ANNIE") : transducerType.getPlugInDir());
        }
        catch (Exception exception) {
            String string = "JAPE Transducer plug-in cannot be loaded.";
            logger.fatal((Object)string);
            throw new RuntimeException(string);
        }
    }

    private static void registerCREOLE(File file) throws GateException {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a valid plug-in directory.");
        }
        try {
            File file2 = file.getCanonicalFile();
            Gate.getCreoleRegister().registerDirectories(file2.toURI().toURL());
        }
        catch (IOException iOException) {
            throw new GateException(iOException);
        }
    }

    private static Resource createOntology(String string) throws MalformedURLException {
        Resource resource;
        block2: {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("rdfXmlURL", new URL(string));
            featureMap.put("loadImports", true);
            resource = null;
            try {
                resource = Factory.createResource("gate.creole.ontology.impl.sesame.OWLIMOntology", featureMap);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Cannot instantiate ontology class: gate.creole.ontology.impl.sesame.OWLIMOntology");
            }
        }
        return resource;
    }

    private Set<Annotation> runTransducer(Document document, String string, String string2) throws MalformedURLException, ResourceInstantiationException, ExecutionException {
        Resource resource;
        if (document == null || string == null) {
            throw new IllegalArgumentException("Document or JAPE file must not be null");
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        URL uRL = Files.getGateResource(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Resource with relative path: " + string + " is missing.");
        }
        switch (transducerType) {
            case PLUS: 
            case PDAPLUS: {
                featureMap.put("sourceType", "JAPE");
                featureMap.put("sourceURL", uRL);
                break;
            }
            case CLASSIC: 
            case PDA: {
                featureMap.put("grammarURL", uRL);
                break;
            }
            default: {
                String string3 = "Unknown JAPE transducer type";
                logger.fatal((Object)string3);
                throw new IllegalArgumentException(string3);
            }
        }
        featureMap.put("encoding", "UTF-8");
        featureMap.put("outputASName", "Output");
        if (string2 != null) {
            resource = BaseJapeTests.createOntology(string2);
            featureMap.put("ontology", resource);
        }
        resource = (AbstractLanguageAnalyser)Factory.createResource(transducerType.getFqdnClass(), featureMap);
        ((AbstractLanguageAnalyser)resource).setDocument(document);
        ((AbstractProcessingResource)resource).execute();
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(new OffsetComparator());
        treeSet.addAll(document.getAnnotations("Output"));
        return treeSet;
    }

    protected Set<Annotation> doTest(String string, String string2, AnnotationCreator annotationCreator, String string3) throws Exception {
        Document document = Factory.newDocument(Files.getGateResourceAsString(string));
        return this.doTest(document, string2, annotationCreator, string3);
    }

    protected Set<Annotation> doTest(String string, String string2, AnnotationCreator annotationCreator) throws Exception {
        return this.doTest(string, string2, annotationCreator, null);
    }

    protected Set<Annotation> doTest(Document document, String string, AnnotationCreator annotationCreator, String string2) throws Exception {
        if (annotationCreator != null) {
            annotationCreator.annotate(document);
        }
        Set<Annotation> set = this.runTransducer(document, string, string2);
        return set;
    }

    protected static void compareResults(String[] stringArray, Set<Annotation> set) {
        int n = 0;
        BaseJapeTests.assertEquals((String)"Number of the expected and transducet annotations must be equal.", (int)stringArray.length, (int)set.size());
        for (Annotation annotation : set) {
            String string = (String)annotation.getFeatures().get("rule");
            BaseJapeTests.assertEquals((String)("Annotation must be created by rule: " + stringArray[n]), (String)stringArray[n], (String)string);
            ++n;
        }
    }

    protected static final void compareStartOffsets(Set<Annotation> set, int ... nArray) {
        BaseJapeTests.assertEquals((int)nArray.length, (int)set.size());
        int n = 0;
        for (Annotation annotation : set) {
            BaseJapeTests.assertEquals((String)("Annotation " + annotation.getId() + " must start at position " + nArray[n]), (int)nArray[n], (int)annotation.getStartNode().getOffset().intValue());
            ++n;
        }
    }

    protected static final void compareEndOffsets(Set<Annotation> set, int ... nArray) {
        BaseJapeTests.assertEquals((int)nArray.length, (int)set.size());
        int n = 0;
        for (Annotation annotation : set) {
            BaseJapeTests.assertEquals((String)("Annotation  " + annotation.getId() + " msut end at position " + nArray[n]), (int)nArray[n], (int)annotation.getEndNode().getOffset().intValue());
            ++n;
        }
    }

    public static abstract class BaseAnnotationCreator
    implements AnnotationCreator {
        protected AnnotationSet as;
        protected int curOffset = 0;
        protected int dfltAnnotLen = 2;
        protected static FeatureMap emptyFeat = Factory.newFeatureMap();

        public final void annotate(Document document) throws InvalidOffsetException {
            this.as = document.getAnnotations();
            this.createAnnots(document);
        }

        protected AnnotationCreator add(int n, int n2, String string) throws InvalidOffsetException {
            return this.add(n, n2, string, emptyFeat);
        }

        protected AnnotationCreator add(int n, int n2, String string, FeatureMap featureMap) throws InvalidOffsetException {
            this.as.add(new Long(n), new Long(n2), string, featureMap);
            return this;
        }

        protected AnnotationCreator addInc(String string) throws InvalidOffsetException {
            this.add(string);
            this.curOffset += this.dfltAnnotLen;
            return this;
        }

        protected AnnotationCreator add(String string) throws InvalidOffsetException {
            this.as.add(new Long(this.curOffset), new Long(this.curOffset + this.dfltAnnotLen), string, emptyFeat);
            return this;
        }
    }

    public static interface AnnotationCreator {
        public AnnotationSet createAnnots(Document var1) throws InvalidOffsetException;

        public void annotate(Document var1) throws InvalidOffsetException;
    }
}

