/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SourceInfo {
    private List<BlockInfo> blocks = new ArrayList<BlockInfo>();
    private String className = null;
    private String phaseName = null;
    private String sectionName = null;

    public SourceInfo(String string, String string2, String string3) {
        this.className = string;
        this.phaseName = string2;
        this.sectionName = string3;
    }

    public String addBlock(String string, String string2) {
        if (!string2.startsWith("  // JAPE Source:")) {
            return string2;
        }
        String string3 = string2.substring(18, string2.indexOf("\n")).trim();
        String string4 = string2.substring(string2.indexOf("\n") + 1);
        String string5 = string3.substring(0, string3.lastIndexOf(":"));
        int n = Integer.parseInt(string3.substring(string3.lastIndexOf(":") + 1));
        int n2 = string.split("\n").length + 1;
        int n3 = n2 + string4.split("\n").length;
        int n4 = string.length();
        int n5 = string.length() + string4.length();
        this.blocks.add(new BlockInfo(string5, n, n2, n3, n4, n5));
        return string4;
    }

    public String getSource(String string, int n) {
        for (BlockInfo blockInfo : this.blocks) {
            if (!blockInfo.contains(n)) continue;
            return blockInfo.getSource(string, blockInfo.getJapeLineNumber(n));
        }
        return "";
    }

    public StackTraceElement getStackTraceElement(int n) {
        for (BlockInfo blockInfo : this.blocks) {
            StackTraceElement stackTraceElement = blockInfo.getStackTraceElement(n);
            if (stackTraceElement == null) continue;
            return stackTraceElement;
        }
        return null;
    }

    public void enhanceTheThrowable(Throwable throwable) {
        if (throwable.getCause() != null) {
            this.enhanceTheThrowable(throwable.getCause());
        }
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (stackTraceElement.getClassName().equals(this.className)) {
                StackTraceElement stackTraceElement2 = null;
                if (stackTraceElement.getLineNumber() >= 0) {
                    BlockInfo blockInfo;
                    Iterator<BlockInfo> iterator = this.blocks.iterator();
                    while (iterator.hasNext() && (stackTraceElement2 = (blockInfo = iterator.next()).getStackTraceElement(stackTraceElement.getLineNumber())) == null) {
                    }
                } else {
                    stackTraceElement2 = new StackTraceElement(this.phaseName, this.sectionName, null, -1);
                }
                arrayList.add(stackTraceElement2 != null ? stackTraceElement2 : stackTraceElement);
                continue;
            }
            arrayList.add(stackTraceElement);
        }
        throwable.setStackTrace(arrayList.toArray(new StackTraceElement[arrayList.size()]));
    }

    private class BlockInfo {
        String japeURL;
        int japeLine;
        int startLine;
        int endLine;
        int startOffset;
        int endOffset;

        BlockInfo(String string, int n, int n2, int n3, int n4, int n5) {
            this.japeURL = string;
            this.japeLine = n;
            this.startLine = n2;
            this.endLine = n3;
            this.startOffset = n4;
            this.endOffset = n5;
        }

        public boolean contains(int n) {
            return this.startLine <= n && n <= this.endLine;
        }

        public String getNumberedSource(String string) {
            return Strings.addLineNumbers(this.getSource(string), this.japeLine);
        }

        public String getSource(String string, int n) {
            String[] stringArray = this.getSource(string).split("\n");
            return stringArray[n - this.japeLine];
        }

        public int getJapeLineNumber(int n) {
            if (!this.contains(n)) {
                return -1;
            }
            return this.japeLine + (n - this.startLine);
        }

        public StackTraceElement getStackTraceElement(int n) {
            int n2 = this.getJapeLineNumber(n);
            if (n2 == -1) {
                return null;
            }
            return new StackTraceElement(SourceInfo.this.phaseName, SourceInfo.this.sectionName, this.japeURL, n2);
        }

        public String getSource(String string) {
            return string.substring(this.startOffset, this.endOffset);
        }
    }
}

