/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import java.io.Serializable;
import org.apache.log4j.Logger;

public class KleeneOperator
implements Serializable {
    protected static final Logger log = Logger.getLogger(KleeneOperator.class);
    private Type type;
    private Integer min;
    private Integer max;
    private String displayString;

    public KleeneOperator(Type type) {
        this.type = type;
        if (type == Type.SINGLE) {
            this.min = 1;
            this.max = 1;
        } else if (type == Type.OPTIONAL) {
            this.min = 0;
            this.max = 1;
        } else if (type == Type.STAR) {
            this.min = 0;
        } else if (type == Type.PLUS) {
            this.min = 1;
        } else if (type == Type.RANGE) {
            this.min = 1;
            this.max = 1;
        }
    }

    public KleeneOperator(Integer n) {
        this(n, n);
    }

    public KleeneOperator(Integer n, Integer n2) {
        this.type = Type.RANGE;
        if (n != null && n2 != null && n > n2) {
            throw new IllegalArgumentException("min cannot be greater than max: " + n + ", " + n2);
        }
        this.min = n;
        this.max = n2;
    }

    public String toString() {
        if (this.type != Type.RANGE) {
            return this.type.getSymbol();
        }
        if (this.displayString != null) {
            return this.displayString;
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.getMin());
        if (!this.min.equals(this.max)) {
            stringBuilder.append(",");
            if (this.max != null) {
                stringBuilder.append(this.max);
            }
        }
        stringBuilder.append("]");
        this.displayString = stringBuilder.toString();
        return this.displayString;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SINGLE(""),
        OPTIONAL("?"),
        STAR("*"),
        PLUS("+"),
        RANGE("[x,y]");

        private String symbol;

        private Type() {
        }

        private Type(String string2) {
            this.symbol = string2;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static Type getFromJapeConstant(int n) {
            switch (n) {
                case 0: {
                    return SINGLE;
                }
                case 2: {
                    return PLUS;
                }
                case 1: {
                    return PLUS;
                }
                case 3: {
                    return OPTIONAL;
                }
            }
            throw new IllegalArgumentException("Unknown op code: " + n);
        }

        public static Type getFromSymbol(String string) {
            for (Type type : Type.values()) {
                if (!type.getSymbol().equals(string)) continue;
                return type;
            }
            return null;
        }
    }
}

