/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubClassAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3258409543049359926L;
    protected JTextField nameSpace;
    protected JTextField className;
    protected JPanel mainPanel = new JPanel(new GridBagLayout());
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;

    public SubClassAction(String string, Icon icon) {
        super(string, icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new JLabel("Name Space:"), gridBagConstraints);
        this.nameSpace = new JTextField(30);
        this.mainPanel.add((Component)this.nameSpace, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)new JLabel("Class Name:"), gridBagConstraints);
        this.className = new JTextField(30);
        this.mainPanel.add((Component)this.className, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        OResource oResource = ((OResourceNode)this.selectedNodes.get(0).getUserObject()).getResource();
        String string = oResource.getURI().getNameSpace();
        if (gate.creole.ontology.Utils.hasSystemNameSpace(oResource.getURI().toString())) {
            string = this.ontology.getDefaultNameSpace();
        }
        this.nameSpace.setText(string);
        ArrayList<OClass> arrayList = new ArrayList<OClass>();
        for (int i = 0; i < this.selectedNodes.size(); ++i) {
            object = ((OResourceNode)this.selectedNodes.get(i).getUserObject()).getResource();
            if (!(object instanceof OClass)) continue;
            arrayList.add((OClass)object);
        }
        this.nameSpace.setText(this.ontology.getDefaultNameSpace() == null ? "http://gate.ac.uk/example#" : this.ontology.getDefaultNameSpace());
        JOptionPane jOptionPane = new JOptionPane(this.mainPanel, 3, 2, MainFrame.getIcon("ontology-subclass")){

            public void selectInitialValue() {
                SubClassAction.this.className.requestFocusInWindow();
                SubClassAction.this.className.selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), "New Sub Class").setVisible(true);
        object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object == 0) {
            String string2 = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string2)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Name Space: " + string2 + "\nExample: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.className.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Class Name: " + this.className.getText());
                return;
            }
            if (this.ontology.getOResourceFromMap(string2 + this.className.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>Resource <b>" + string2 + this.className.getText() + "</b> already exists.");
                return;
            }
            OClass oClass = this.ontology.addOClass(new URI(string2 + this.className.getText(), false), (byte)0);
            for (int i = 0; i < arrayList.size(); ++i) {
                ((OClass)arrayList.get(i)).addSubClass(oClass);
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }
}

