/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.DataType;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import gate.gui.ontology.ValuesSelectionAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypePropertyAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3257852073457235252L;
    protected JPanel mainPanel = new JPanel(new GridBagLayout());
    protected JTextField nameSpace;
    protected JComboBox datatypesComboBox;
    protected JButton domainButton;
    protected JTextField propertyName;
    protected ValuesSelectionAction domainAction;
    protected ArrayList<String> ontologyClassesURIs;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;

    public DatatypePropertyAction(String string, Icon icon) {
        super(string, icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new JLabel("Name Space:"), gridBagConstraints);
        this.nameSpace = new JTextField(30);
        this.mainPanel.add((Component)this.nameSpace, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)new JLabel("Data Type:"), gridBagConstraints);
        this.datatypesComboBox = new JComboBox();
        this.mainPanel.add(this.datatypesComboBox, gridBagConstraints);
        this.mainPanel.add((Component)this.datatypesComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.mainPanel.add((Component)new JLabel("Property Name:"), gridBagConstraints);
        this.propertyName = new JTextField(30);
        this.mainPanel.add((Component)this.propertyName, gridBagConstraints);
        this.domainButton = new JButton("Domain");
        this.mainPanel.add((Component)this.domainButton, gridBagConstraints);
        this.datatypesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#byte", "http://www.w3.org/2001/XMLSchema#date", "http://www.w3.org/2001/XMLSchema#decimal", "http://www.w3.org/2001/XMLSchema#double", "http://www.w3.org/2001/XMLSchema#duration", "http://www.w3.org/2001/XMLSchema#float", "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#negativeInteger", "http://www.w3.org/2001/XMLSchema#nonNegativeInteger", "http://www.w3.org/2001/XMLSchema#nonPositiveInteger", "http://www.w3.org/2001/XMLSchema#positiveInteger", "http://www.w3.org/2001/XMLSchema#short", "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#time", "http://www.w3.org/2001/XMLSchema#unsignedByte", "http://www.w3.org/2001/XMLSchema#unsignedInt", "http://www.w3.org/2001/XMLSchema#unsignedLong", "http://www.w3.org/2001/XMLSchema#unsignedShort"}));
        this.domainAction = new ValuesSelectionAction();
        this.domainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[DatatypePropertyAction.this.ontologyClassesURIs.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = DatatypePropertyAction.this.ontologyClassesURIs.get(i);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < DatatypePropertyAction.this.selectedNodes.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = DatatypePropertyAction.this.selectedNodes.get(i);
                    OResource oResource = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
                    if (!(oResource instanceof OClass)) continue;
                    arrayList.add(oResource.getURI().toString());
                }
                String[] stringArray2 = new String[arrayList.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)arrayList.get(i);
                }
                DatatypePropertyAction.this.domainAction.showGUI("Domain", stringArray, stringArray2, false, MainFrame.getIcon("ontology-datatype-property"));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.nameSpace.setText(this.ontology.getDefaultNameSpace() == null ? "http://gate.ac.uk/example#" : this.ontology.getDefaultNameSpace());
        JOptionPane jOptionPane = new JOptionPane(this.mainPanel, 3, 2, MainFrame.getIcon("ontology-datatype-property")){

            public void selectInitialValue() {
                DatatypePropertyAction.this.propertyName.requestFocusInWindow();
                DatatypePropertyAction.this.propertyName.selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), "New Datatype Property").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object == 0) {
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Name Space: " + string + "\nExample: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Property Name: " + this.propertyName.getText());
                return;
            }
            if (this.ontology.getOResourceFromMap(string + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>Resource <b>" + string + this.propertyName.getText() + "</b> already exists.");
                return;
            }
            String[] stringArray = this.domainAction.getSelectedValues();
            HashSet<OClass> hashSet = new HashSet<OClass>();
            for (String string2 : stringArray) {
                OClass oClass = (OClass)this.ontology.getOResourceFromMap(string2);
                hashSet.add(oClass);
            }
            DataType dataType = DataType.getDataType((String)this.datatypesComboBox.getSelectedItem());
            this.ontology.addDatatypeProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false), hashSet, dataType);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }

    public ArrayList getOntologyClassesURIs() {
        return this.ontologyClassesURIs;
    }

    public void setOntologyClassesURIs(ArrayList<String> arrayList) {
        this.ontologyClassesURIs = arrayList;
    }
}

