/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AnnotationPropertyAction
extends AbstractAction {
    private static final long serialVersionUID = 3546358452780544048L;
    protected JPanel mainPanel = new JPanel(new GridBagLayout());
    protected JTextField nameSpace;
    protected JTextField propertyName;
    protected Ontology ontology;

    public AnnotationPropertyAction(String string, Icon icon) {
        super(string, icon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)new JLabel("Name Space:"), gridBagConstraints);
        this.nameSpace = new JTextField(30);
        this.mainPanel.add((Component)this.nameSpace, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)new JLabel("Property Name:"), gridBagConstraints);
        this.propertyName = new JTextField(30);
        this.mainPanel.add((Component)this.propertyName, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.nameSpace.setText(this.ontology.getDefaultNameSpace() == null ? "http://gate.ac.uk/example#" : this.ontology.getDefaultNameSpace());
        JOptionPane jOptionPane = new JOptionPane(this.mainPanel, 3, 2, MainFrame.getIcon("ontology-annotation-property")){

            public void selectInitialValue() {
                AnnotationPropertyAction.this.propertyName.requestFocusInWindow();
                AnnotationPropertyAction.this.propertyName.selectAll();
            }
        };
        jOptionPane.createDialog(MainFrame.getInstance(), "New Annotation Property").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object == 0) {
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Name Space: " + string + "\nExample: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Property Name: " + this.propertyName.getText());
                return;
            }
            if (this.ontology.getOResourceFromMap(string + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>Resource <b>" + string + this.propertyName.getText() + "</b> already exists.");
                return;
            }
            this.ontology.addAnnotationProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false));
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }
}

