/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.jape;

import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractVisualResource;
import gate.creole.Transducer;
import gate.event.ProgressListener;
import gate.jape.parser.ParseCpslTokenManager;
import gate.jape.parser.SimpleCharStream;
import gate.jape.parser.Token;
import gate.util.BomStrippingInputStreamReader;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class JapeViewer
extends AbstractVisualResource
implements ANNIEConstants,
ProgressListener {
    private JTextPane textArea;
    private JTree treePhases;
    private JScrollPane treeScroll;
    private boolean updating = false;
    private Transducer transducer;
    private Map<Integer, Style> colorMap = new HashMap<Integer, Style>();
    private Style defaultStyle;

    public Resource init() {
        this.initGuiComponents();
        return this;
    }

    private void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextPane();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 20, 30);
        this.add((Component)jScrollPane, "Center");
        this.treePhases = new JTree();
        this.treeScroll = new JScrollPane(this.treePhases, 20, 30);
        this.add((Component)this.treeScroll, "West");
        this.treePhases.getSelectionModel().setSelectionMode(1);
        this.treePhases.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (JapeViewer.this.updating) {
                    return;
                }
                if (treeSelectionEvent.getPath().getLastPathComponent() == null) {
                    return;
                }
                try {
                    JapeViewer.this.readJAPEFileContents(new URL(JapeViewer.this.transducer.getGrammarURL(), treeSelectionEvent.getPath().getLastPathComponent() + ".jape"));
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        });
        this.defaultStyle = this.textArea.addStyle("default", null);
        Style style = this.textArea.addStyle("brackets", null);
        StyleConstants.setForeground(style, Color.red);
        this.colorMap.put(57, style);
        this.colorMap.put(58, style);
        this.colorMap.put(59, style);
        this.colorMap.put(60, style);
        this.colorMap.put(61, style);
        this.colorMap.put(62, style);
        style = this.textArea.addStyle("keywords", null);
        StyleConstants.setForeground(style, Color.blue);
        this.colorMap.put(27, style);
        this.colorMap.put(30, style);
        this.colorMap.put(28, style);
        this.colorMap.put(48, style);
        this.colorMap.put(24, style);
        this.colorMap.put(25, style);
        this.colorMap.put(26, style);
        this.colorMap.put(11, style);
        this.colorMap.put(12, style);
        style = this.textArea.addStyle("strings", null);
        StyleConstants.setForeground(style, new Color(0, 128, 128));
        this.colorMap.put(47, style);
        style = this.textArea.addStyle("comments", null);
        StyleConstants.setForeground(style, new Color(0, 128, 0));
        this.colorMap.put(66, style);
        this.colorMap.put(67, style);
        this.colorMap.put(68, style);
        this.colorMap.put(69, style);
        this.colorMap.put(70, style);
        this.colorMap.put(15, style);
        this.colorMap.put(16, style);
        this.colorMap.put(17, style);
        this.colorMap.put(18, style);
        this.colorMap.put(19, style);
    }

    public void setTarget(Object object) {
        if (object == null || !(object instanceof Transducer)) {
            throw new IllegalArgumentException("The GATE jape viewer can only be used with a GATE jape transducer!\n" + object.getClass().toString() + " is not a GATE Jape Transducer!");
        }
        if (this.transducer != null) {
            this.transducer.removeProgressListener(this);
        }
        this.transducer = (Transducer)object;
        URL uRL = this.transducer.getGrammarURL();
        if (uRL == null) {
            this.textArea.setText("The source for this JAPE grammar is not available!");
            this.remove(this.treeScroll);
            return;
        }
        String string = uRL.getFile();
        string = string.substring(string.lastIndexOf("/") + 1, string.length() - 5);
        this.treePhases.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(string)));
        this.treePhases.setSelectionRow(0);
        this.readJAPEFileContents(uRL);
        this.transducer.addProgressListener(this);
    }

    private void readJAPEFileContents(URL uRL) {
        if (this.treePhases.getLastSelectedPathComponent() == null) {
            return;
        }
        this.updating = true;
        try {
            BomStrippingInputStreamReader bomStrippingInputStreamReader = null;
            bomStrippingInputStreamReader = this.transducer.getEncoding() == null ? new BomStrippingInputStreamReader(uRL.openStream()) : new BomStrippingInputStreamReader(uRL.openStream(), this.transducer.getEncoding());
            BufferedReader bufferedReader = new BufferedReader(bomStrippingInputStreamReader);
            String string = bufferedReader.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (string != null) {
                arrayList.add(stringBuilder.length());
                stringBuilder.append(string.replaceAll("\t", "   ")).append("\n");
                string = bufferedReader.readLine();
            }
            this.textArea.setText(stringBuilder.toString());
            this.textArea.updateUI();
            bufferedReader.close();
            ParseCpslTokenManager parseCpslTokenManager = new ParseCpslTokenManager(new SimpleCharStream(new StringReader(stringBuilder.toString())));
            StyledDocument styledDocument = this.textArea.getStyledDocument();
            styledDocument.setCharacterAttributes(0, stringBuilder.length(), this.defaultStyle, true);
            ((DefaultMutableTreeNode)this.treePhases.getSelectionPath().getLastPathComponent()).removeAllChildren();
            while (true) {
                Token token = parseCpslTokenManager.getNextToken();
                if (token.kind != 0) {
                    int n;
                    int n2;
                    Style style;
                    Token token2 = token.specialToken;
                    while (token2 != null) {
                        style = this.colorMap.get(token2.kind);
                        if (style != null) {
                            n2 = (Integer)arrayList.get(token2.beginLine - 1) + token2.beginColumn - 1;
                            n = (Integer)arrayList.get(token2.endLine - 1) + token2.endColumn - 1;
                            styledDocument.setCharacterAttributes(n2, n - n2 + 1, style, true);
                        }
                        token2 = token2.specialToken;
                    }
                    style = this.colorMap.get(token.kind);
                    if (style != null) {
                        n2 = (Integer)arrayList.get(token.beginLine - 1) + token.beginColumn - 1;
                        n = (Integer)arrayList.get(token.endLine - 1) + token.endColumn - 1;
                        styledDocument.setCharacterAttributes(n2, n - n2 + 1, style, true);
                    }
                    if (token.kind != 13) continue;
                    ((DefaultMutableTreeNode)this.treePhases.getSelectionPath().getLastPathComponent()).add(new DefaultMutableTreeNode(token.toString()));
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new GateRuntimeException(iOException);
        }
        if (this.treePhases.getSelectionRows() != null && this.treePhases.getSelectionRows().length > 0) {
            this.treePhases.expandRow(this.treePhases.getSelectionRows()[0]);
        }
        this.updating = false;
    }

    public void processFinished() {
        this.setTarget(this.transducer);
    }

    public void progressChanged(int n) {
    }
}

