/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.corpora.DocumentContentImpl;
import gate.event.DocumentEvent;
import gate.gui.annedit.AnnotationData;
import gate.gui.docview.AbstractDocumentView;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextualDocumentView
extends AbstractDocumentView {
    protected JScrollPane scroller;
    protected GateDocumentListener gateDocListener;
    protected Map<AnnotationData, HighlightData> blinkingTagsForAnnotations = new HashMap<AnnotationData, HighlightData>();
    protected List<HighlightData> highlightsToAdd = new LinkedList<HighlightData>();
    protected List<HighlightData> highlightsToRemove = new LinkedList<HighlightData>();
    protected Set<AnnotationData> blinkingHighlightsToRemove = new HashSet<AnnotationData>();
    protected List<AnnotationData> blinkingHighlightsToAdd = new LinkedList<AnnotationData>();
    protected Timer highlightsMinder;
    protected JTextArea textView;
    protected static final int BLINK_DELAY = 400;
    protected static final int HIGHLIGHT_DELAY = 100;

    public TextualDocumentView() {
        this.gateDocListener = new GateDocumentListener();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.highlightsMinder.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addHighlight(AnnotationData annotationData, Color color) {
        HighlightData highlightData = new HighlightData(annotationData, color);
        TextualDocumentView textualDocumentView = this;
        synchronized (textualDocumentView) {
            this.highlightsToAdd.add(highlightData);
        }
        this.highlightsMinder.restart();
        return highlightData;
    }

    public List addHighlights(Collection<AnnotationData> collection, Color color) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AnnotationData annotationData : collection) {
            arrayList.add(this.addHighlight(annotationData, color));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlight(Object object) {
        TextualDocumentView textualDocumentView = this;
        synchronized (textualDocumentView) {
            this.highlightsToRemove.add((HighlightData)object);
        }
        this.highlightsMinder.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlights(List<HighlightData> list) {
        for (HighlightData highlightData : list) {
            TextualDocumentView textualDocumentView = this;
            synchronized (textualDocumentView) {
                this.highlightsToAdd.add(highlightData);
            }
        }
        this.highlightsMinder.restart();
    }

    public void removeHighlights(Collection collection) {
        for (Object e : collection) {
            this.removeHighlight(e);
        }
    }

    public void scrollAnnotationToVisible(Annotation annotation) {
        Rectangle rectangle = this.scroller.getViewport().getViewRect();
        int n = this.textView.viewToModel(rectangle.getLocation());
        Point point = new Point(rectangle.getLocation());
        point.translate(rectangle.width, rectangle.height);
        int n2 = this.textView.viewToModel(point);
        int n3 = annotation.getStartNode().getOffset().intValue();
        int n4 = annotation.getEndNode().getOffset().intValue();
        if (n4 < n || n2 < n3) {
            try {
                this.textView.scrollRectToVisible(this.textView.modelToView(n3));
            }
            catch (BadLocationException badLocationException) {
                throw new GateRuntimeException(badLocationException);
            }
        }
    }

    public void moveHighlight(Object object, int n, int n2) throws BadLocationException {
        if (object instanceof HighlightData) {
            this.textView.getHighlighter().changeHighlight(((HighlightData)object).tag, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedAnnotations(List<AnnotationData> list) {
        Map<AnnotationData, HighlightData> map = this.blinkingTagsForAnnotations;
        synchronized (map) {
            this.blinkingHighlightsToAdd.clear();
            this.blinkingHighlightsToRemove.addAll(this.blinkingTagsForAnnotations.keySet());
            for (AnnotationData annotationData : list) {
                this.blinkingHighlightsToAdd.add(annotationData);
            }
            this.highlightsMinder.restart();
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void setTarget(Object object) {
        if (this.document != null) {
            this.document.removeDocumentListener(this.gateDocListener);
        }
        super.setTarget(object);
        this.document.addDocumentListener(this.gateDocListener);
    }

    public void setEditable(boolean bl) {
        this.textView.setEditable(bl);
    }

    @Override
    protected void initGUI() {
        this.textView = new JTextArea();
        this.textView.setAutoscrolls(false);
        this.textView.setLineWrap(true);
        this.textView.setWrapStyleWord(true);
        this.textView.setCaret(new PermanentSelectionCaret());
        this.scroller = new JScrollPane(this.textView);
        this.textView.setText(this.document.getContent().toString());
        this.textView.getDocument().addDocumentListener(new SwingDocumentListener());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (TextualDocumentView.this.textView.modelToView(0) != null) {
                        TextualDocumentView.this.textView.scrollRectToVisible(TextualDocumentView.this.textView.modelToView(0));
                    }
                    TextualDocumentView.this.textView.select(0, 0);
                    TextualDocumentView.this.textView.requestFocus();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        this.highlightsMinder = new Timer(400, new UpdateHighlightsAction());
        this.highlightsMinder.setInitialDelay(100);
        this.highlightsMinder.setDelay(400);
        this.highlightsMinder.setRepeats(true);
        this.highlightsMinder.setCoalesce(true);
        this.highlightsMinder.start();
        this.initListeners();
    }

    @Override
    public Component getGUI() {
        return this.scroller;
    }

    protected void initListeners() {
        this.textView.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 72 && keyEvent.isControlDown()) {
                    TextualDocumentView.this.getGUI().dispatchEvent(keyEvent);
                    keyEvent.consume();
                }
            }
        });
    }

    @Override
    protected void unregisterHooks() {
    }

    @Override
    protected void registerHooks() {
    }

    public JTextArea getTextView() {
        return this.textView;
    }

    public class PermanentSelectionCaret
    extends DefaultCaret {
        private boolean isFocused;

        public void setSelectionVisible(boolean bl) {
            if (bl != this.isFocused) {
                this.isFocused = bl;
                super.setSelectionVisible(false);
                super.setSelectionVisible(true);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            super.setVisible(true);
        }
    }

    protected class SwingDocumentListener
    implements DocumentListener {
        protected SwingDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
            block5: {
                try {
                    try {
                        TextualDocumentView.this.gateDocListener.setActive(false);
                        TextualDocumentView.this.document.edit(new Long(documentEvent.getOffset()), new Long(documentEvent.getOffset()), new DocumentContentImpl(documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength())));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace(Err.getPrintWriter());
                        Object var4_3 = null;
                        TextualDocumentView.this.gateDocListener.setActive(true);
                        break block5;
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        invalidOffsetException.printStackTrace(Err.getPrintWriter());
                        Object var4_4 = null;
                        TextualDocumentView.this.gateDocListener.setActive(true);
                    }
                    Object var4_2 = null;
                    TextualDocumentView.this.gateDocListener.setActive(true);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    TextualDocumentView.this.gateDocListener.setActive(true);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
            try {
                try {
                    TextualDocumentView.this.gateDocListener.setActive(false);
                    TextualDocumentView.this.document.edit(new Long(documentEvent.getOffset()), new Long(documentEvent.getOffset() + documentEvent.getLength()), new DocumentContentImpl(""));
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    invalidOffsetException.printStackTrace(Err.getPrintWriter());
                    Object var4_3 = null;
                    TextualDocumentView.this.gateDocListener.setActive(true);
                }
                Object var4_2 = null;
                TextualDocumentView.this.gateDocListener.setActive(true);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                TextualDocumentView.this.gateDocListener.setActive(true);
                throw throwable;
            }
        }

        public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
        }
    }

    protected class GateDocumentListener
    implements gate.event.DocumentListener {
        private boolean active = true;

        protected GateDocumentListener() {
        }

        public void annotationSetAdded(DocumentEvent documentEvent) {
        }

        public void annotationSetRemoved(DocumentEvent documentEvent) {
        }

        public void contentEdited(DocumentEvent documentEvent) {
            if (this.active) {
                TextualDocumentView.this.textView.setText(TextualDocumentView.this.document.getContent().toString());
            }
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }
    }

    private class HighlightData {
        Annotation annotation;
        AnnotationSet set;
        Color colour;
        Object tag;

        public HighlightData(AnnotationData annotationData, Color color) {
            this.annotation = annotationData.getAnnotation();
            this.set = annotationData.getAnnotationSet();
            this.colour = color;
        }
    }

    protected class UpdateHighlightsAction
    extends AbstractAction {
        protected boolean highlightsShown = false;

        protected UpdateHighlightsAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Map<AnnotationData, HighlightData> map = TextualDocumentView.this.blinkingTagsForAnnotations;
            synchronized (map) {
                this.updateBlinkingHighlights();
                this.updateNormalHighlights();
            }
        }

        protected void updateBlinkingHighlights() {
            Object object;
            Object object2;
            Highlighter highlighter = TextualDocumentView.this.textView.getHighlighter();
            for (AnnotationData object32 : TextualDocumentView.this.blinkingHighlightsToRemove) {
                object2 = TextualDocumentView.this.blinkingTagsForAnnotations.remove(object32);
                if (object2 == null || (object = ((HighlightData)object2).tag) == null) continue;
                highlighter.removeHighlight(object);
                ((HighlightData)object2).tag = null;
            }
            TextualDocumentView.this.blinkingHighlightsToRemove.clear();
            for (AnnotationData annotationData : TextualDocumentView.this.blinkingHighlightsToAdd) {
                TextualDocumentView.this.blinkingTagsForAnnotations.put(annotationData, new HighlightData(annotationData, null));
            }
            TextualDocumentView.this.blinkingHighlightsToAdd.clear();
            if (TextualDocumentView.this.blinkingTagsForAnnotations.isEmpty()) {
                return;
            }
            Iterator<AnnotationData> iterator = new ArrayList<AnnotationData>(TextualDocumentView.this.blinkingTagsForAnnotations.keySet()).iterator();
            if (this.highlightsShown) {
                while (iterator.hasNext()) {
                    HighlightData highlightData = TextualDocumentView.this.blinkingTagsForAnnotations.get(iterator.next());
                    if (highlightData == null) continue;
                    object2 = highlightData.tag;
                    if (object2 != null) {
                        highlighter.removeHighlight(object2);
                    }
                    highlightData.tag = null;
                }
                this.highlightsShown = false;
            } else {
                while (iterator.hasNext()) {
                    HighlightData highlightData = TextualDocumentView.this.blinkingTagsForAnnotations.get(iterator.next());
                    if (highlightData == null) continue;
                    object2 = highlightData.annotation;
                    try {
                        highlightData.tag = object = highlighter.addHighlight(object2.getStartNode().getOffset().intValue(), object2.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(TextualDocumentView.this.textView.getSelectionColor()));
                    }
                    catch (BadLocationException badLocationException) {
                        throw new GateRuntimeException(badLocationException);
                    }
                }
                this.highlightsShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateNormalHighlights() {
            TextualDocumentView textualDocumentView = TextualDocumentView.this;
            synchronized (textualDocumentView) {
                if (TextualDocumentView.this.highlightsToRemove.size() + TextualDocumentView.this.highlightsToAdd.size() > 0) {
                    HighlightData highlightData;
                    Highlighter highlighter = TextualDocumentView.this.textView.getHighlighter();
                    while (TextualDocumentView.this.highlightsToAdd.size() > 0) {
                        highlightData = TextualDocumentView.this.highlightsToAdd.remove(0);
                        try {
                            highlightData.tag = highlighter.addHighlight(highlightData.annotation.getStartNode().getOffset().intValue(), highlightData.annotation.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(highlightData.colour));
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    while (TextualDocumentView.this.highlightsToRemove.size() > 0) {
                        highlightData = TextualDocumentView.this.highlightsToRemove.remove(0);
                        if (highlightData.tag == null) continue;
                        highlighter.removeHighlight(highlightData.tag);
                    }
                }
            }
        }
    }
}

