/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationSchema;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.FeaturesSchemaEditor;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.annedit.AnnotationEditorOwner;
import gate.gui.annedit.OwnedAnnotationEditor;
import gate.gui.annedit.SearchAndAnnotatePanel;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;

public class AnnotationEditor
extends AbstractVisualResource
implements OwnedAnnotationEditor {
    private static final long serialVersionUID = 1L;
    protected JWindow popupWindow;
    protected JToggleButton pinnedButton;
    protected JComboBox typeCombo;
    protected FeaturesSchemaEditor featuresEditor;
    protected JScrollPane featuresScroller;
    protected JButton solButton;
    protected JButton sorButton;
    protected JButton delButton;
    protected JButton eolButton;
    protected JButton eorButton;
    protected JButton dismissButton;
    protected Timer hideTimer;
    protected MouseEvent pressed;
    protected static final int HIDE_DELAY = 1500;
    protected static final int SHIFT_INCREMENT = 5;
    protected static final int CTRL_SHIFT_INCREMENT = 10;
    protected Map<String, AnnotationSchema> schemasByType;
    private AnnotationEditorOwner owner;
    protected Annotation ann;
    protected AnnotationSet set;
    protected AnnotationEditor annotationEditorInstance;
    private ActionMap actionMap;
    private StartOffsetLeftAction solAction;
    private StartOffsetRightAction sorAction;
    private DeleteAnnotationAction delAction;
    private EndOffsetLeftAction eolAction;
    private EndOffsetRightAction eorAction;

    public Resource init() throws ResourceInstantiationException {
        super.init();
        this.initData();
        this.initGUI();
        this.initListeners();
        this.annotationEditorInstance = this;
        return this;
    }

    protected void initData() {
        this.schemasByType = new HashMap<String, AnnotationSchema>();
        List<LanguageResource> list = Gate.getCreoleRegister().getLrInstances("gate.creole.AnnotationSchema");
        for (AnnotationSchema annotationSchema : list) {
            this.schemasByType.put(annotationSchema.getAnnotationName(), annotationSchema);
        }
        CreoleListener creoleListener = new CreoleListener(){

            public void resourceLoaded(CreoleEvent creoleEvent) {
                Resource resource = creoleEvent.getResource();
                if (resource instanceof AnnotationSchema) {
                    AnnotationSchema annotationSchema = (AnnotationSchema)resource;
                    AnnotationEditor.this.schemasByType.put(annotationSchema.getAnnotationName(), annotationSchema);
                }
            }

            public void resourceUnloaded(CreoleEvent creoleEvent) {
                AnnotationSchema annotationSchema;
                Resource resource = creoleEvent.getResource();
                if (resource instanceof AnnotationSchema && AnnotationEditor.this.schemasByType.containsValue(annotationSchema = (AnnotationSchema)resource)) {
                    AnnotationEditor.this.schemasByType.remove(annotationSchema.getAnnotationName());
                }
            }

            public void datastoreOpened(CreoleEvent creoleEvent) {
            }

            public void datastoreCreated(CreoleEvent creoleEvent) {
            }

            public void datastoreClosed(CreoleEvent creoleEvent) {
            }

            public void resourceRenamed(Resource resource, String string, String string2) {
            }
        };
        Gate.getCreoleRegister().addCreoleListener(creoleListener);
    }

    protected void initGUI() {
        this.popupWindow = new JWindow(SwingUtilities.getWindowAncestor(this.owner.getTextComponent())){

            public void pack() {
                if (this.isVisible()) {
                    int n = MainFrame.getInstance().getHeight();
                    int n2 = this.getHeight() - AnnotationEditor.this.featuresScroller.getHeight();
                    if (AnnotationEditor.this.featuresScroller.getPreferredSize().height > (n -= n2)) {
                        AnnotationEditor.this.featuresScroller.setMaximumSize(new Dimension(AnnotationEditor.this.featuresScroller.getMaximumSize().width, n));
                        AnnotationEditor.this.featuresScroller.setPreferredSize(new Dimension(AnnotationEditor.this.featuresScroller.getPreferredSize().width, n));
                    }
                }
                super.pack();
            }

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (bl) {
                    AnnotationEditor.this.typeCombo.requestFocus();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        this.popupWindow.setContentPane(jPanel);
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        this.solButton = new JButton();
        this.solButton.setContentAreaFilled(false);
        this.solButton.setBorderPainted(false);
        this.solButton.setMargin(insets);
        jPanel.add((Component)this.solButton, gridBagConstraints);
        this.sorButton = new JButton();
        this.sorButton.setContentAreaFilled(false);
        this.sorButton.setBorderPainted(false);
        this.sorButton.setMargin(insets);
        jPanel.add((Component)this.sorButton, gridBagConstraints);
        this.delButton = new JButton();
        this.delButton.setContentAreaFilled(false);
        this.delButton.setBorderPainted(false);
        this.delButton.setMargin(insets);
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        jPanel.add((Component)this.delButton, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this.eolButton = new JButton();
        this.eolButton.setContentAreaFilled(false);
        this.eolButton.setBorderPainted(false);
        this.eolButton.setMargin(insets);
        jPanel.add((Component)this.eolButton, gridBagConstraints);
        this.eorButton = new JButton();
        this.eorButton.setContentAreaFilled(false);
        this.eorButton.setBorderPainted(false);
        this.eorButton.setMargin(insets);
        jPanel.add((Component)this.eorButton, gridBagConstraints);
        this.pinnedButton = new JToggleButton(MainFrame.getIcon("pin"));
        this.pinnedButton.setSelectedIcon(MainFrame.getIcon("pin-in"));
        this.pinnedButton.setSelected(false);
        this.pinnedButton.setBorderPainted(false);
        this.pinnedButton.setContentAreaFilled(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.pinnedButton, gridBagConstraints);
        this.dismissButton = new JButton();
        this.dismissButton.setBorder(null);
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)this.dismissButton, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.typeCombo = new JComboBox();
        this.typeCombo.setEditable(true);
        this.typeCombo.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        jPanel.add((Component)this.typeCombo, gridBagConstraints);
        this.featuresEditor = new FeaturesSchemaEditor();
        this.featuresEditor.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        try {
            this.featuresEditor.init();
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new GateRuntimeException(resourceInstantiationException);
        }
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.featuresScroller = new JScrollPane(this.featuresEditor);
        jPanel.add((Component)this.featuresScroller, gridBagConstraints);
        SearchAndAnnotatePanel searchAndAnnotatePanel = new SearchAndAnnotatePanel(jPanel.getBackground(), this, this.popupWindow);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)searchAndAnnotatePanel, gridBagConstraints);
        this.popupWindow.pack();
    }

    protected void initListeners() {
        this.featuresEditor.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                AnnotationEditor.this.popupWindow.pack();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AnnotationEditor.this.hideTimer.stop();
            }
        };
        this.typeCombo.getEditor().getEditorComponent().addKeyListener(keyAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                AnnotationEditor.this.hideTimer.stop();
            }

            public void mousePressed(MouseEvent mouseEvent) {
                AnnotationEditor.this.pressed = mouseEvent;
            }
        };
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){
            Point location;

            public void mouseDragged(MouseEvent mouseEvent) {
                this.location = AnnotationEditor.this.popupWindow.getLocation(this.location);
                int n = this.location.x - AnnotationEditor.this.pressed.getX() + mouseEvent.getX();
                int n2 = this.location.y - AnnotationEditor.this.pressed.getY() + mouseEvent.getY();
                AnnotationEditor.this.popupWindow.setLocation(n, n2);
                AnnotationEditor.this.pinnedButton.setSelected(true);
            }
        };
        this.popupWindow.getRootPane().addMouseListener(mouseAdapter);
        this.popupWindow.getRootPane().addMouseMotionListener(mouseMotionAdapter);
        InputMap inputMap = ((JComponent)this.popupWindow.getContentPane()).getInputMap(1);
        this.actionMap = ((JComponent)this.popupWindow.getContentPane()).getActionMap();
        this.solAction = new StartOffsetLeftAction("", MainFrame.getIcon("extend-left"), "<html><b>Extend start</b><small><br>LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 37);
        this.solButton.setAction(this.solAction);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "solAction");
        inputMap.put(KeyStroke.getKeyStroke("shift LEFT"), "solAction");
        inputMap.put(KeyStroke.getKeyStroke("control shift released LEFT"), "solAction");
        this.actionMap.put("solAction", this.solAction);
        this.sorAction = new StartOffsetRightAction("", MainFrame.getIcon("extend-right"), "<html><b>Shrink start</b><small><br>RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 39);
        this.sorButton.setAction(this.sorAction);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "sorAction");
        inputMap.put(KeyStroke.getKeyStroke("shift RIGHT"), "sorAction");
        inputMap.put(KeyStroke.getKeyStroke("control shift released RIGHT"), "sorAction");
        this.actionMap.put("sorAction", this.sorAction);
        this.delAction = new DeleteAnnotationAction("", MainFrame.getIcon("remove-annotation"), "Delete the annotation", 127);
        this.delButton.setAction(this.delAction);
        inputMap.put(KeyStroke.getKeyStroke("alt DELETE"), "delAction");
        this.actionMap.put("delAction", this.delAction);
        this.eolAction = new EndOffsetLeftAction("", MainFrame.getIcon("extend-left"), "<html><b>Shrink end</b><small><br>ALT + LEFT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 37);
        this.eolButton.setAction(this.eolAction);
        inputMap.put(KeyStroke.getKeyStroke("alt LEFT"), "eolAction");
        inputMap.put(KeyStroke.getKeyStroke("alt shift LEFT"), "eolAction");
        inputMap.put(KeyStroke.getKeyStroke("control alt shift released LEFT"), "eolAction");
        this.actionMap.put("eolAction", this.eolAction);
        this.eorAction = new EndOffsetRightAction("", MainFrame.getIcon("extend-right"), "<html><b>Extend end</b><small><br>ALT + RIGHT = 1 character<br> + SHIFT = 5 characters, <br> + CTRL + SHIFT = 10 characters</small></html>", 39);
        this.eorButton.setAction(this.eorAction);
        inputMap.put(KeyStroke.getKeyStroke("alt RIGHT"), "eorAction");
        inputMap.put(KeyStroke.getKeyStroke("alt shift RIGHT"), "eorAction");
        inputMap.put(KeyStroke.getKeyStroke("control alt shift released RIGHT"), "eorAction");
        this.actionMap.put("eorAction", this.eorAction);
        this.pinnedButton.setToolTipText("<html>Press to pin window in place&nbsp;&nbsp;<font color=#667799><small>Ctrl-P&nbsp;&nbsp;</small></font></html>");
        inputMap.put(KeyStroke.getKeyStroke("control P"), "toggle pin");
        this.actionMap.put("toggle pin", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditor.this.pinnedButton.doClick();
            }
        });
        DismissAction dismissAction = new DismissAction("", null, "Close the window", 27);
        this.dismissButton.setAction(dismissAction);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "dismissAction");
        inputMap.put(KeyStroke.getKeyStroke("alt ESCAPE"), "dismissAction");
        this.actionMap.put("dismissAction", dismissAction);
        ApplyAction applyAction = new ApplyAction("Apply", null, "", 10);
        inputMap.put(KeyStroke.getKeyStroke("alt ENTER"), "applyAction");
        this.actionMap.put("applyAction", applyAction);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AnnotationEditor.this.typeCombo.getSelectedItem().toString();
                if (AnnotationEditor.this.ann == null || AnnotationEditor.this.ann.getType().equals(string)) {
                    return;
                }
                Integer n = AnnotationEditor.this.ann.getId();
                Annotation annotation = AnnotationEditor.this.ann;
                AnnotationEditor.this.set.remove(AnnotationEditor.this.ann);
                try {
                    AnnotationEditor.this.set.add(n, annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), string, annotation.getFeatures());
                    Annotation annotation2 = AnnotationEditor.this.set.get(n);
                    AnnotationEditor.this.getOwner().selectAnnotation(new AnnotationDataImpl(AnnotationEditor.this.set, annotation2));
                    AnnotationEditor.this.editAnnotation(annotation2, AnnotationEditor.this.set);
                    AnnotationEditor.this.owner.annotationChanged(annotation2, AnnotationEditor.this.set, annotation.getType());
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new GateRuntimeException(invalidOffsetException);
                }
            }
        });
        this.hideTimer = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditor.this.annotationEditorInstance.setVisible(false);
            }
        });
        this.hideTimer.setRepeats(false);
        AncestorListener ancestorListener = new AncestorListener(){
            private boolean wasShowing = false;

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (this.wasShowing) {
                    AnnotationEditor.this.annotationEditorInstance.setVisible(true);
                }
                this.wasShowing = false;
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (AnnotationEditor.this.isShowing()) {
                    this.wasShowing = true;
                    AnnotationEditor.this.popupWindow.dispose();
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        };
        this.owner.getTextComponent().addAncestorListener(ancestorListener);
    }

    public boolean isActive() {
        return this.popupWindow.isVisible();
    }

    public void editAnnotation(Annotation annotation, AnnotationSet annotationSet) {
        this.ann = annotation;
        this.set = annotationSet;
        if (annotation == null) {
            this.typeCombo.setModel(new DefaultComboBoxModel());
            this.featuresEditor.setSchema(new AnnotationSchema());
            this.popupWindow.validate();
            return;
        }
        String string = annotation.getType();
        HashSet<String> hashSet = new HashSet<String>(this.schemasByType.keySet());
        hashSet.add(string);
        hashSet.addAll(annotationSet.getAllTypes());
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList);
        this.typeCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.typeCombo.setSelectedItem(string);
        this.featuresEditor.setSchema(this.schemasByType.get(string));
        this.featuresEditor.setTargetFeatures(annotation.getFeatures());
        this.popupWindow.validate();
        this.setEditingEnabled(true);
        this.setVisible(true);
        if (!this.pinnedButton.isSelected()) {
            this.hideTimer.restart();
        }
    }

    public Annotation getAnnotationCurrentlyEdited() {
        return this.ann;
    }

    public boolean editingFinished() {
        return true;
    }

    public boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.placeDialog(this.ann.getStartNode().getOffset().intValue(), this.ann.getEndNode().getOffset().intValue());
        } else {
            this.popupWindow.setVisible(false);
            this.pinnedButton.setSelected(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AnnotationEditor.this.owner.getTextComponent().requestFocus();
                }
            });
        }
    }

    public void placeDialog(int n, int n2) {
        if (this.popupWindow.isVisible() && this.pinnedButton.isSelected()) {
            Point point = this.popupWindow.getLocation();
            this.popupWindow.pack();
            if (point != null) {
                this.popupWindow.setLocation(point);
            }
        } else {
            try {
                Rectangle rectangle = this.owner.getTextComponent().modelToView(n);
                Rectangle rectangle2 = this.owner.getTextComponent().modelToView(n2);
                Point point = this.owner.getTextComponent().getLocationOnScreen();
                int n3 = point.x + rectangle.x;
                int n4 = point.y + rectangle2.y + rectangle2.height;
                Rectangle rectangle3 = this.owner.getTextComponent().getVisibleRect();
                int n5 = point.y + rectangle3.y + rectangle3.height;
                this.popupWindow.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                boolean bl = false;
                if (this.popupWindow.getSize().width > dimension.width) {
                    this.popupWindow.setSize(dimension.width, this.popupWindow.getSize().height);
                    bl = true;
                }
                if (this.popupWindow.getSize().height > dimension.height) {
                    this.popupWindow.setSize(this.popupWindow.getSize().width, dimension.height);
                    bl = true;
                }
                if (bl) {
                    this.popupWindow.validate();
                }
                int n6 = dimension.width - this.popupWindow.getSize().width;
                if (n5 + this.popupWindow.getSize().height > dimension.height) {
                    n5 = dimension.height - this.popupWindow.getSize().height;
                }
                if (n4 > n5) {
                    n4 = n5;
                }
                if (n3 > n6) {
                    n3 = n6;
                }
                this.popupWindow.setLocation(n3, n4);
            }
            catch (BadLocationException badLocationException) {
                throw new GateRuntimeException(badLocationException);
            }
        }
        if (!this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(true);
        }
    }

    protected void moveAnnotation(AnnotationSet annotationSet, Annotation annotation, Long l, Long l2) throws InvalidOffsetException {
        Integer n;
        Annotation annotation2 = null;
        if (annotationSet.get(annotation.getType()).size() == 1) {
            n = annotationSet.add(annotation.getStartNode(), annotation.getStartNode(), annotation.getType(), annotation.getFeatures());
            annotation2 = annotationSet.get(n);
        }
        n = annotation.getId();
        annotationSet.remove(annotation);
        annotationSet.add(n, l, l2, annotation.getType(), annotation.getFeatures());
        Annotation annotation3 = annotationSet.get(n);
        this.getOwner().selectAnnotation(new AnnotationDataImpl(annotationSet, annotation3));
        this.editAnnotation(annotation3, annotationSet);
        if (annotation2 != null) {
            annotationSet.remove(annotation2);
        }
        this.owner.annotationChanged(annotation3, annotationSet, null);
    }

    public AnnotationSet getAnnotationSetCurrentlyEdited() {
        return this.set;
    }

    public AnnotationEditorOwner getOwner() {
        return this.owner;
    }

    public void setOwner(AnnotationEditorOwner annotationEditorOwner) {
        this.owner = annotationEditorOwner;
    }

    public void setPinnedMode(boolean bl) {
        this.pinnedButton.setSelected(bl);
    }

    public void setEditingEnabled(boolean bl) {
        this.solButton.setEnabled(bl);
        this.sorButton.setEnabled(bl);
        this.delButton.setEnabled(bl);
        this.eolButton.setEnabled(bl);
        this.eorButton.setEnabled(bl);
        this.typeCombo.setEnabled(bl);
        if (this.featuresEditor.isEditing()) {
            this.featuresEditor.getColumnModel().getColumn(this.featuresEditor.getEditingColumn()).getCellEditor().cancelCellEditing();
        }
        this.featuresEditor.setEnabled(bl);
        if (bl) {
            Color color = this.featuresEditor.getBackground();
            color = new Color(color.getRGB());
            this.featuresEditor.setBackground(color);
        }
        final boolean bl2 = bl;
        for (int i = 0; i < this.featuresEditor.getColumnCount(); ++i) {
            final TableCellRenderer tableCellRenderer = this.featuresEditor.getColumnModel().getColumn(i).getCellRenderer();
            TableCellRenderer tableCellRenderer2 = new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl22, int n, int n2) {
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl22, n, n2);
                    component.setEnabled(bl2);
                    return component;
                }
            };
            this.featuresEditor.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer2);
        }
        if (bl) {
            this.actionMap.put("solAction", this.solAction);
            this.actionMap.put("sorAction", this.sorAction);
            this.actionMap.put("delAction", this.delAction);
            this.actionMap.put("eolAction", this.eolAction);
            this.actionMap.put("eorAction", this.eorAction);
        } else {
            this.actionMap.put("solAction", null);
            this.actionMap.put("sorAction", null);
            this.actionMap.put("delAction", null);
            this.actionMap.put("eolAction", null);
            this.actionMap.put("eorAction", null);
        }
    }

    public void cancelAction() throws GateException {
    }

    public boolean canDisplayAnnotationType(String string) {
        return true;
    }

    public void okAction() throws GateException {
    }

    public boolean supportsCancel() {
        return false;
    }

    protected class ApplyAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public ApplyAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationEditor.this.annotationEditorInstance.setVisible(false);
        }
    }

    protected class DismissAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public DismissAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
            Icon icon2 = UIManager.getIcon("InternalFrame.closeIcon");
            if (icon2 == null) {
                icon2 = MainFrame.getIcon("exit");
            }
            this.putValue("SmallIcon", icon2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationEditor.this.annotationEditorInstance.setVisible(false);
        }
    }

    protected class DeleteAnnotationAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public DeleteAnnotationAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationEditor.this.set.remove(AnnotationEditor.this.ann);
            AnnotationEditor.this.editAnnotation(null, AnnotationEditor.this.set);
            if (!AnnotationEditor.this.pinnedButton.isSelected()) {
                AnnotationEditor.this.annotationEditorInstance.setVisible(false);
            } else {
                AnnotationEditor.this.setEditingEnabled(false);
            }
        }
    }

    protected class EndOffsetRightAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public EndOffsetRightAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = AnnotationEditor.this.owner.getDocument().getContent().size();
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getEndNode().getOffset() + (long)n) > l2) {
                l = l2;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, AnnotationEditor.this.ann.getStartNode().getOffset(), new Long(l));
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class EndOffsetLeftAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public EndOffsetLeftAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = AnnotationEditor.this.ann.getStartNode().getOffset();
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getEndNode().getOffset() - (long)n) < l2) {
                l = l2;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, AnnotationEditor.this.ann.getStartNode().getOffset(), new Long(l));
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class StartOffsetRightAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public StartOffsetRightAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = AnnotationEditor.this.ann.getEndNode().getOffset();
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getStartNode().getOffset() + (long)n) > l2) {
                l = l2;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, new Long(l), AnnotationEditor.this.ann.getEndNode().getOffset());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class StartOffsetLeftAction
    extends AnnotationAction {
        private static final long serialVersionUID = 1L;

        public StartOffsetLeftAction(String string, Icon icon, String string2, int n) {
            super(string, icon, string2, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getStartNode().getOffset() - (long)n) < 0L) {
                l = 0L;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, new Long(l), AnnotationEditor.this.ann.getEndNode().getOffset());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected abstract class AnnotationAction
    extends AbstractAction {
        public AnnotationAction(String string, Icon icon, String string2, int n) {
            super(string, icon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }
    }
}

