/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.corpora.DocType;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SingleConcatenatedFileInputDialog
extends JPanel {
    JTextField urlTextField;
    JButton filerBtn;
    JTextField encodingTextField;
    JTextField documentRootElementTextField;
    JTextField documentNamePrefixTextField;
    JComboBox documentTypeComboBox;
    JTextField numOfDocumentsToFetchTextField;

    public SingleConcatenatedFileInputDialog() {
        this.initGUIComponents();
        this.initListeners();
    }

    protected void initGUIComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("File URL:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.urlTextField = new JTextField(40);
        this.add((Component)this.urlTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        this.filerBtn = new JButton(MainFrame.getIcon("open-file"));
        this.add((Component)this.filerBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Encoding:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.encodingTextField = new JTextField(15);
        this.add((Component)this.encodingTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Root Element:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.documentRootElementTextField = new JTextField("DOC", 15);
        this.add((Component)this.documentRootElementTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Document type:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.documentTypeComboBox = new JComboBox<DocType>(DocType.values());
        this.documentTypeComboBox.setEditable(false);
        this.add((Component)this.documentTypeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("No. of Docs:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.numOfDocumentsToFetchTextField = new JTextField("-1", 15);
        this.add((Component)this.numOfDocumentsToFetchTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Prefix for documents:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.documentNamePrefixTextField = new JTextField("Document", 15);
        this.add((Component)this.documentNamePrefixTextField, gridBagConstraints);
    }

    protected void initListeners() {
        this.filerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                xJFileChooser.setFileSelectionMode(0);
                xJFileChooser.setDialogTitle("Select a file");
                xJFileChooser.resetChoosableFileFilters();
                xJFileChooser.setAcceptAllFileFilterUsed(true);
                xJFileChooser.setFileFilter(xJFileChooser.getAcceptAllFileFilter());
                int n = xJFileChooser.showOpenDialog(SingleConcatenatedFileInputDialog.this);
                if (n == 0) {
                    try {
                        SingleConcatenatedFileInputDialog.this.urlTextField.setText(xJFileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setUrlString(String string) {
        this.urlTextField.setText(string);
    }

    public String getUrlString() {
        return this.urlTextField.getText();
    }

    public String getEncoding() {
        return this.encodingTextField.getText();
    }

    public void setEncoding(String string) {
        this.encodingTextField.setText(string);
    }

    public String getDocumentRootElement() {
        return this.documentRootElementTextField.getText();
    }

    public void setDocumentRootElement(String string) {
        this.documentRootElementTextField.setText(string);
    }

    public String getDocumentNamePrefix() {
        return this.documentNamePrefixTextField.getText();
    }

    public void setDocumentNamePrefix(String string) {
        this.documentNamePrefixTextField.setText(string);
    }

    public DocType getDocumentType() {
        return (DocType)((Object)this.documentTypeComboBox.getSelectedItem());
    }

    public void setDocumentType(DocType docType) {
        this.documentTypeComboBox.setSelectedItem((Object)docType);
    }

    public int getNumOfDocumentsToFetch() {
        if (this.numOfDocumentsToFetchTextField.getText().trim().length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(this.numOfDocumentsToFetchTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void setNumOfDocumentsToFetch(int n) {
        this.numOfDocumentsToFetchTextField.setText("" + n);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Gate.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Foo");
        SingleConcatenatedFileInputDialog singleConcatenatedFileInputDialog = new SingleConcatenatedFileInputDialog();
        jFrame.getContentPane().add(singleConcatenatedFileInputDialog);
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }
}

