/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.util.GateRuntimeException;
import java.util.List;

public class ParameterDisjunction
implements CreoleListener {
    int selectedIndex;
    String[] names;
    String[] comments;
    String[] types;
    Object[] values;
    Boolean[] required;
    Parameter[] params;
    Resource resource;

    public ParameterDisjunction(Resource resource, List list) {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.resource = resource;
        this.params = new Parameter[list.size()];
        this.names = new String[list.size()];
        this.values = new Object[list.size()];
        this.comments = new String[list.size()];
        this.types = new String[list.size()];
        this.required = new Boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.params[i] = (Parameter)list.get(i);
            this.names[i] = this.params[i].getName();
            this.comments[i] = this.params[i].getComment();
            this.types[i] = this.params[i].getTypeName();
            try {
                Object object = this.values[i] = resource == null ? null : resource.getParameterValue(this.params[i].getName());
                if (this.values[i] == null) {
                    this.values[i] = this.params[i].getDefaultValue();
                }
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                throw new GateRuntimeException("Could not get read accessor method for \"" + this.names[i] + "\"property of " + resource.getClass().getName());
            }
            catch (ParameterException parameterException) {
                throw new GateRuntimeException("Could not get default value for \"" + this.names[i] + "\"property of " + resource.getClass().getName());
            }
            this.required[i] = new Boolean(!this.params[i].isOptional());
        }
        this.setSelectedIndex(0);
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int size() {
        return this.params.length;
    }

    public Boolean isRequired() {
        return this.required[this.selectedIndex];
    }

    public String getName() {
        return this.names[this.selectedIndex];
    }

    public String getComment() {
        return this.comments[this.selectedIndex];
    }

    public String getType() {
        return this.types[this.selectedIndex];
    }

    public String[] getNames() {
        return this.names;
    }

    public void setValue(Object object) {
        this.values[this.selectedIndex] = object;
    }

    public Object getValue() {
        return this.values[this.selectedIndex];
    }

    public Parameter[] getParameters() {
        return this.params;
    }

    public Parameter getParameter() {
        return this.params[this.selectedIndex];
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.resource = null;
    }

    void removeCreoleListenerLink() {
        Gate.getCreoleRegister().removeCreoleListener(this);
    }

    protected void updateValues(Resource resource) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != resource) continue;
            this.values[i] = null;
            try {
                Object object = this.values[i] = this.resource == null ? null : this.resource.getParameterValue(this.params[i].getName());
                if (this.values[i] != null) continue;
                this.values[i] = this.params[i].getDefaultValue();
                continue;
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                throw new GateRuntimeException("Could not get read accessor method for \"" + this.names[i] + "\"property of " + this.resource.getClass().getName());
            }
            catch (ParameterException parameterException) {
                throw new GateRuntimeException("Could not get default value for \"" + this.names[i] + "\"property of " + this.resource.getClass().getName());
            }
        }
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
        this.updateValues(null);
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        this.updateValues(creoleEvent.getResource());
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
        this.updateValues(resource);
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }
}

