/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.gui.ParameterDisjunction;
import gate.gui.ResourceParametersEditor;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

@CreoleResource(name="Initialisation Parameters", guiType=GuiType.LARGE, resourceDisplayed="gate.Resource", mainViewer=true)
public class PRViewer
extends AbstractVisualResource {
    protected ResourceParametersEditor editor;

    public Resource init() throws ResourceInstantiationException {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.editor = new ResourceParametersEditor();
        this.editor.setEditable(false);
        this.editor.setAutoResizeMode(3);
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setAlignmentY(0.0f);
        this.add((Component)jScrollPane, "Center");
    }

    protected void initListeners() {
        this.editor.addMouseListener(new MouseAdapter(){

            private void handleMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = PRViewer.this.editor.rowAtPoint(mouseEvent.getPoint());
                    int n2 = PRViewer.this.editor.columnAtPoint(mouseEvent.getPoint());
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(new CopyValueAction(n, n2));
                    jPopupMenu.show(PRViewer.this.editor, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }
        });
    }

    public void cleanup() {
        super.cleanup();
        this.editor.cleanup();
    }

    public void setTarget(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof Resource)) {
            throw new GateRuntimeException(this.getClass().getName() + " can only be used to display " + Resource.class.getName() + "\n" + object.getClass().getName() + " is not a " + Resource.class.getName() + "!");
        }
        if (object != null) {
            Resource resource = (Resource)object;
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName());
            if (resourceData != null) {
                this.editor.init(resource, resourceData.getParameterList().getInitimeParameters());
            } else {
                this.editor.init(resource, null);
            }
        } else {
            this.editor.init(null, null);
        }
        this.editor.removeCreoleListenerLink();
    }

    protected class CopyValueAction
    extends AbstractAction {
        private int row;
        private int column;

        public CopyValueAction(int n, int n2) {
            super("Copy value");
            this.putValue("ShortDescription", "Copies the value of the cell to the clipboard.");
            this.row = n;
            this.column = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object object = PRViewer.this.editor.getValueAt(this.row, this.column);
            String string = object instanceof ParameterDisjunction ? ((ParameterDisjunction)object).getName() : (object instanceof Boolean ? ((Boolean)object != false ? "Required parameter" : "Optional parameter") : object.toString());
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
    }
}

