/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import com.ontotext.gate.hmm.agent.AlternativeHMMAgent;
import com.ontotext.gate.hmm.agent.SaveAsAction;
import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.TextualDocument;
import gate.VisualResource;
import gate.corpora.DocumentStaxUtils;
import gate.creole.AbstractResource;
import gate.creole.AnnotationSchema;
import gate.creole.ConditionalController;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.ir.DefaultIndexDefinition;
import gate.creole.ir.DocumentContentReader;
import gate.creole.ir.FeatureReader;
import gate.creole.ir.IREngine;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexField;
import gate.creole.ir.IndexedCorpus;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.AccessRightsDialog;
import gate.gui.ActionsPublisher;
import gate.gui.CorpusFillerComponent;
import gate.gui.CreateIndexDialog;
import gate.gui.CreateIndexGUI;
import gate.gui.DocumentEditor;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.OkCancelDialog;
import gate.gui.SingleConcatenatedFileInputDialog;
import gate.persist.LuceneDataStoreImpl;
import gate.persist.PersistenceException;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.security.User;
import gate.swing.XJFileChooser;
import gate.swing.XJMenuItem;
import gate.swing.XJPopupMenu;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.NameBearer;
import gate.util.Out;
import gate.util.ant.packager.PackageGappTask;
import gate.util.persistence.PersistenceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBearerHandle
implements Handle,
StatusListener,
ProgressListener,
CreoleListener {
    String tooltipText;
    NameBearer target;
    protected List<ActionsPublisher> actionPublishers;
    protected List<XJMenuItem> staticPopupItems;
    Window window;
    ResourceData rData;
    Icon icon;
    JComponent smallView;
    JComponent largeView;
    protected boolean viewsBuilt = false;
    protected CorpusFillerComponent corpusFiller;
    protected SingleConcatenatedFileInputDialog scfInputDialog;
    StatusListener sListenerProxy;
    private transient Vector<ProgressListener> progressListeners;
    private transient Vector<StatusListener> statusListeners;

    public NameBearerHandle(NameBearer nameBearer, Window window) {
        this.target = nameBearer;
        this.window = window;
        this.actionPublishers = new ArrayList<ActionsPublisher>();
        this.sListenerProxy = new ProxyStatusListener();
        String string = null;
        if (nameBearer instanceof Resource) {
            this.rData = (ResourceData)Gate.getCreoleRegister().get(nameBearer.getClass().getName());
            if (this.rData != null) {
                string = this.rData.getIcon();
                if (string == null) {
                    if (nameBearer instanceof Controller) {
                        string = "application";
                    } else if (nameBearer instanceof LanguageResource) {
                        string = "lr";
                    } else if (nameBearer instanceof ProcessingResource) {
                        string = "pr";
                    }
                }
                if (nameBearer instanceof Controller && nameBearer.getName().startsWith("ANNIE")) {
                    string = "annie-application";
                }
                this.tooltipText = "<HTML> <b>" + this.rData.getComment() + "</b><br>(<i>" + this.rData.getClassName() + "</i>)</HTML>";
            } else {
                string = "lr";
            }
        } else if (nameBearer instanceof DataStore) {
            string = ((DataStore)nameBearer).getIconName();
            this.tooltipText = ((DataStore)nameBearer).getComment();
        }
        this.icon = MainFrame.getIcon(string);
        Gate.getCreoleRegister().addCreoleListener(this);
        if (nameBearer instanceof ActionsPublisher) {
            this.actionPublishers.add((ActionsPublisher)((Object)nameBearer));
        }
        this.buildStaticPopupItems();
        this.viewsBuilt = false;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getTitle() {
        return this.target == null ? null : this.target.getName();
    }

    @Override
    public boolean viewsBuilt() {
        return this.viewsBuilt;
    }

    @Override
    public JComponent getSmallView() {
        if (!this.viewsBuilt) {
            this.buildViews();
        }
        return this.smallView;
    }

    @Override
    public JComponent getLargeView() {
        if (!this.viewsBuilt) {
            this.buildViews();
        }
        return this.largeView;
    }

    @Override
    public JPopupMenu getPopup() {
        XJPopupMenu xJPopupMenu = new XJPopupMenu();
        for (JMenuItem object : this.staticPopupItems) {
            if (object == null) {
                xJPopupMenu.addSeparator();
                continue;
            }
            xJPopupMenu.add(object);
        }
        for (ActionsPublisher actionsPublisher : this.actionPublishers) {
            if (actionsPublisher.getActions() == null) continue;
            for (Action action : actionsPublisher.getActions()) {
                if (action == null) {
                    xJPopupMenu.addSeparator();
                    continue;
                }
                xJPopupMenu.add(new XJMenuItem(action, this.sListenerProxy));
            }
        }
        return xJPopupMenu;
    }

    @Override
    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String string) {
        this.tooltipText = string;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public Action getCloseAction() {
        return new CloseAction();
    }

    public Action getCloseRecursivelyAction() {
        return new CloseRecursivelyAction();
    }

    private void fillHMMActions(List<XJMenuItem> list) {
        AlternativeHMMAgent alternativeHMMAgent = (AlternativeHMMAgent)this.target;
        list.add(null);
        com.ontotext.gate.hmm.agent.SaveAction saveAction = new com.ontotext.gate.hmm.agent.SaveAction(alternativeHMMAgent);
        saveAction.putValue("ShortDescription", "Save trained HMM model into PR URL file");
        list.add(new XJMenuItem((Action)saveAction, this.sListenerProxy));
        saveAction = new SaveAsAction(alternativeHMMAgent);
        saveAction.putValue("ShortDescription", "Save trained HMM model into new file");
        list.add(new XJMenuItem((Action)saveAction, this.sListenerProxy));
    }

    protected void buildStaticPopupItems() {
        this.staticPopupItems = new ArrayList<XJMenuItem>();
        if (this.target instanceof ProcessingResource && !(this.target instanceof Controller)) {
            this.staticPopupItems.add(null);
            this.staticPopupItems.add(new XJMenuItem(new ReloadAction(), this.sListenerProxy));
            if (this.target instanceof AlternativeHMMAgent) {
                this.fillHMMActions(this.staticPopupItems);
            }
        } else if (this.target instanceof LanguageResource) {
            this.staticPopupItems.add(null);
            if (this.target instanceof Document) {
                this.staticPopupItems.add(new XJMenuItem(new CreateCorpusForDocAction(), this.sListenerProxy));
            }
            if (this.target instanceof TextualDocument) {
                XJMenuItem xJMenuItem = new XJMenuItem(new SaveAsXmlAction(), this.sListenerProxy);
                this.staticPopupItems.add(null);
                this.staticPopupItems.add(xJMenuItem);
            } else if (this.target instanceof Corpus) {
                IndexedCorpus indexedCorpus;
                this.corpusFiller = new CorpusFillerComponent();
                this.scfInputDialog = new SingleConcatenatedFileInputDialog();
                this.staticPopupItems.add(new XJMenuItem(new PopulateCorpusAction(), this.sListenerProxy));
                this.staticPopupItems.add(new XJMenuItem(new PopulateCorpusFromSingleConcatenatedFileAction(), this.sListenerProxy));
                this.staticPopupItems.add(null);
                this.staticPopupItems.add(new XJMenuItem(new SaveCorpusAsXmlAction(false), this.sListenerProxy));
                if (this.target instanceof IndexedCorpus && ((indexedCorpus = (IndexedCorpus)this.target).getDataStore() == null || !(indexedCorpus.getDataStore() instanceof LuceneDataStoreImpl))) {
                    this.staticPopupItems.add(new XJMenuItem(new CreateIndexAction(), this.sListenerProxy));
                    this.staticPopupItems.add(new XJMenuItem(new OptimizeIndexAction(), this.sListenerProxy));
                    this.staticPopupItems.add(new XJMenuItem(new DeleteIndexAction(), this.sListenerProxy));
                }
            }
            if (((LanguageResource)this.target).getDataStore() != null) {
                this.staticPopupItems.add(new XJMenuItem(new SaveAction(), this.sListenerProxy));
            }
            if (!(this.target instanceof AnnotationSchema)) {
                this.staticPopupItems.add(new XJMenuItem(new SaveToAction(), this.sListenerProxy));
            }
        }
        if (this.target instanceof Controller) {
            this.staticPopupItems.add(null);
            this.staticPopupItems.add(new XJMenuItem(new DumpToFileAction(), this.sListenerProxy));
            this.staticPopupItems.add(new XJMenuItem(new ExportApplicationAction(), this.sListenerProxy));
        }
    }

    protected void buildViews() {
        Object object;
        FeatureMap featureMap;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        this.viewsBuilt = true;
        this.fireStatusChanged("Building views...");
        List<String> list = Gate.getCreoleRegister().getLargeVRsForResource(this.target.getClass().getName());
        if (list != null && !list.isEmpty()) {
            this.largeView = new JTabbedPane(3);
            object4 = list.iterator();
            while (object4.hasNext()) {
                try {
                    iterator = (String)object4.next();
                    object3 = (ResourceData)Gate.getCreoleRegister().get(iterator);
                    object2 = Factory.newFeatureMap();
                    featureMap = Factory.newFeatureMap();
                    Gate.setHiddenAttribute(featureMap, true);
                    object = (VisualResource)Factory.createResource(iterator, (FeatureMap)object2, featureMap);
                    object.setTarget(this.target);
                    object.setHandle(this);
                    ((JTabbedPane)this.largeView).add((Component)object, ((ResourceData)object3).getName());
                    if (!(object instanceof ActionsPublisher)) continue;
                    this.actionPublishers.add((ActionsPublisher)object);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                }
            }
            if (list.size() == 1) {
                this.largeView = (JComponent)((JTabbedPane)this.largeView).getComponentAt(0);
            } else {
                ((JTabbedPane)this.largeView).setSelectedIndex(0);
            }
        }
        if ((object4 = Gate.getCreoleRegister().getSmallVRsForResource(this.target.getClass().getName())) != null && !object4.isEmpty()) {
            this.smallView = new JTabbedPane(3);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                try {
                    object3 = (String)iterator.next();
                    object2 = (ResourceData)Gate.getCreoleRegister().get(object3);
                    featureMap = Factory.newFeatureMap();
                    object = Factory.newFeatureMap();
                    Gate.setHiddenAttribute((FeatureMap)object, true);
                    VisualResource visualResource = (VisualResource)Factory.createResource((String)object3, featureMap, (FeatureMap)object);
                    visualResource.setTarget(this.target);
                    visualResource.setHandle(this);
                    ((JTabbedPane)this.smallView).add((Component)((Object)visualResource), ((ResourceData)object2).getName());
                    if (!(visualResource instanceof ActionsPublisher)) continue;
                    this.actionPublishers.add((ActionsPublisher)((Object)visualResource));
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                }
            }
            if (object4.size() == 1) {
                this.smallView = (JComponent)((JTabbedPane)this.smallView).getComponentAt(0);
            } else {
                ((JTabbedPane)this.smallView).setSelectedIndex(0);
            }
        }
        this.fireStatusChanged("Views built!");
        iterator = this.getLargeView();
        if (iterator != null) {
            ((JComponent)((Object)iterator)).getActionMap().put("Close resource", new CloseAction());
            if (this.target instanceof Controller) {
                ((JComponent)((Object)iterator)).getActionMap().put("Close recursively", new CloseRecursivelyAction());
            }
            if (this.target instanceof TextualDocument) {
                ((JComponent)((Object)iterator)).getActionMap().put("Save As XML", new SaveAsXmlAction());
            }
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    @Override
    public void removeViews() {
        int n;
        Component[] componentArray;
        if (this.largeView != null) {
            if (this.largeView instanceof VisualResource) {
                if (this.largeView instanceof ActionsPublisher) {
                    this.actionPublishers.remove(this.largeView);
                }
                Factory.deleteResource((VisualResource)((Object)this.largeView));
            } else {
                componentArray = ((JTabbedPane)this.largeView).getComponents();
                for (n = 0; n < componentArray.length; ++n) {
                    if (!(componentArray[n] instanceof VisualResource)) continue;
                    if (componentArray[n] instanceof ActionsPublisher) {
                        this.actionPublishers.remove(componentArray[n]);
                    }
                    Factory.deleteResource((VisualResource)((Object)componentArray[n]));
                }
            }
            this.largeView = null;
        }
        if (this.smallView != null) {
            if (this.smallView instanceof VisualResource) {
                if (this.smallView instanceof ActionsPublisher) {
                    this.actionPublishers.remove(this.smallView);
                }
                Factory.deleteResource((VisualResource)((Object)this.smallView));
            } else {
                componentArray = ((JTabbedPane)this.smallView).getComponents();
                for (n = 0; n < componentArray.length; ++n) {
                    if (!(componentArray[n] instanceof VisualResource)) continue;
                    if (componentArray[n] instanceof ActionsPublisher) {
                        this.actionPublishers.remove(componentArray[n]);
                    }
                    Factory.deleteResource((VisualResource)((Object)componentArray[n]));
                }
            }
            this.smallView = null;
        }
        this.viewsBuilt = false;
    }

    @Override
    public void cleanup() {
        this.removeViews();
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.target = null;
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector<ProgressListener> vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                vector.elementAt(i).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).processFinished();
            }
        }
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector<StatusListener> vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).statusChanged(string);
            }
        }
    }

    @Override
    public void statusChanged(String string) {
        this.fireStatusChanged(string);
    }

    @Override
    public void progressChanged(int n) {
        this.fireProgressChanged(n);
    }

    @Override
    public void processFinished() {
        this.fireProcessFinished();
    }

    @Override
    public Window getWindow() {
        return this.window;
    }

    @Override
    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
    }

    @Override
    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    @Override
    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    @Override
    public void datastoreClosed(CreoleEvent creoleEvent) {
        if (this.getTarget() == creoleEvent.getDatastore()) {
            this.cleanup();
        }
    }

    class ProxyStatusListener
    implements StatusListener {
        ProxyStatusListener() {
        }

        public void statusChanged(String string) {
            NameBearerHandle.this.fireStatusChanged(string);
        }
    }

    class CreateCorpusForDocAction
    extends AbstractAction {
        private static final long serialVersionUID = -3698451324578510407L;

        public CreateCorpusForDocAction() {
            super("New Corpus with this Document");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Corpus corpus = Factory.newCorpus("Corpus for " + NameBearerHandle.this.target.getName());
                corpus.add(NameBearerHandle.this.target);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                Err.println("Exception creating corpus");
                resourceInstantiationException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class DeleteIndexAction
    extends AbstractAction {
        private static final long serialVersionUID = 6121632107964572415L;

        DeleteIndexAction() {
            super("Delete Index");
            this.putValue("ShortDescription", "Delete existing index");
        }

        public boolean isEnabled() {
            return ((IndexedCorpus)NameBearerHandle.this.target).getIndexDefinition() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showOptionDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Do you want to delete index?", "Gate", 0, 3, null, null, null);
            if (n == 0) {
                try {
                    IndexedCorpus indexedCorpus = (IndexedCorpus)NameBearerHandle.this.target;
                    if (indexedCorpus.getIndexManager() != null) {
                        indexedCorpus.getIndexManager().deleteIndex();
                        indexedCorpus.getFeatures().remove("Index_definition_feature_key");
                    } else {
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "There is no index to delete!", "GATE", -1);
                    }
                }
                catch (IndexException indexException) {
                    indexException.printStackTrace();
                }
            }
        }
    }

    class OptimizeIndexAction
    extends AbstractAction {
        private static final long serialVersionUID = 261845730081082766L;

        OptimizeIndexAction() {
            super("Optimize Index");
            this.putValue("ShortDescription", "Optimize existing index");
        }

        public boolean isEnabled() {
            return ((IndexedCorpus)NameBearerHandle.this.target).getIndexDefinition() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        try {
                            NameBearerHandle.this.fireProgressChanged(1);
                            NameBearerHandle.this.fireStatusChanged("Optimising index...");
                            long l = System.currentTimeMillis();
                            ((IndexedCorpus)NameBearerHandle.this.target).getIndexManager().optimizeIndex();
                            NameBearerHandle.this.fireStatusChanged("Index optimised in " + NumberFormat.getInstance().format((double)(System.currentTimeMillis() - l) / 1000.0) + " seconds");
                            NameBearerHandle.this.fireProcessFinished();
                        }
                        catch (IndexException indexException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Errors during optimisation!", "GATE", -1);
                            indexException.printStackTrace(Err.getPrintWriter());
                            Object var4_4 = null;
                            NameBearerHandle.this.fireProcessFinished();
                        }
                        Object var4_3 = null;
                        NameBearerHandle.this.fireProcessFinished();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        NameBearerHandle.this.fireProcessFinished();
                        throw throwable;
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
    }

    class CreateIndexAction
    extends AbstractAction {
        private static final long serialVersionUID = -292879296310753260L;
        CreateIndexGUI createIndexGui;

        CreateIndexAction() {
            super("Index Corpus");
            this.putValue("ShortDescription", "Create index with documents from the corpus");
            this.createIndexGui = new CreateIndexGUI();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = OkCancelDialog.showDialog(NameBearerHandle.this.largeView, this.createIndexGui, "Index \"" + NameBearerHandle.this.target.getName() + "\" corpus");
            if (bl) {
                Object object2;
                DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
                IREngine iREngine = this.createIndexGui.getIREngine();
                defaultIndexDefinition.setIrEngineClassName(iREngine.getClass().getName());
                defaultIndexDefinition.setIndexLocation(this.createIndexGui.getIndexLocation().toString());
                if (this.createIndexGui.getUseDocumentContent()) {
                    defaultIndexDefinition.addIndexField(new IndexField("body", new DocumentContentReader(), false));
                }
                for (Object object2 : this.createIndexGui.getFeaturesList()) {
                    defaultIndexDefinition.addIndexField(new IndexField((String)object2, new FeatureReader((String)object2), false));
                }
                ((IndexedCorpus)NameBearerHandle.this.target).setIndexDefinition(defaultIndexDefinition);
                object2 = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            try {
                                NameBearerHandle.this.fireProgressChanged(1);
                                NameBearerHandle.this.fireStatusChanged("Indexing corpus...");
                                long l = System.currentTimeMillis();
                                ((IndexedCorpus)NameBearerHandle.this.target).getIndexManager().deleteIndex();
                                NameBearerHandle.this.fireProgressChanged(10);
                                ((IndexedCorpus)NameBearerHandle.this.target).getIndexManager().createIndex();
                                NameBearerHandle.this.fireProgressChanged(100);
                                NameBearerHandle.this.fireProcessFinished();
                                NameBearerHandle.this.fireStatusChanged("Corpus indexed in " + NumberFormat.getInstance().format((double)(System.currentTimeMillis() - l) / 1000.0) + " seconds");
                            }
                            catch (IndexException indexException) {
                                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Could not create index!\n See \"Messages\" tab for details!", "GATE", 0);
                                indexException.printStackTrace(Err.getPrintWriter());
                                Object var4_4 = null;
                                NameBearerHandle.this.fireProcessFinished();
                            }
                            Object var4_3 = null;
                            NameBearerHandle.this.fireProcessFinished();
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            NameBearerHandle.this.fireProcessFinished();
                            throw throwable;
                        }
                    }
                });
                ((Thread)object2).setPriority(1);
                ((Thread)object2).start();
            }
        }
    }

    class CreateIndexAction1
    extends AbstractAction {
        private static final long serialVersionUID = -3951091972912846869L;

        CreateIndexAction1() {
            super("Create Index");
            this.putValue("ShortDescription", "Create index with documents from a corpus");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Dialog dialog = null;
            if (NameBearerHandle.this.getWindow() instanceof Frame) {
                dialog = new CreateIndexDialog((Frame)NameBearerHandle.this.getWindow(), (IndexedCorpus)NameBearerHandle.this.target);
            }
            if (NameBearerHandle.this.getWindow() instanceof Dialog) {
                dialog = new CreateIndexDialog((Dialog)NameBearerHandle.this.getWindow(), (IndexedCorpus)NameBearerHandle.this.target);
            }
            dialog.setVisible(true);
        }
    }

    class PopulateCorpusFromSingleConcatenatedFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 2342321851865139492L;

        PopulateCorpusFromSingleConcatenatedFileAction() {
            super("Populate from Single Concatenated File");
            this.putValue("ShortDescription", "Fills this corpus by extracting multiple documents from a single file");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NameBearerHandle.this.scfInputDialog.setEncoding("");
            final boolean bl = OkCancelDialog.showDialog(NameBearerHandle.this.window, NameBearerHandle.this.scfInputDialog, "Select a trecweb file");
            Runnable runnable = new Runnable(){

                public void run() {
                    if (bl) {
                        String string = null;
                        if (NameBearerHandle.this.scfInputDialog.getUrlString().trim().length() == 0) {
                            string = "file URL cannot be empty";
                        } else if (NameBearerHandle.this.scfInputDialog.getDocumentRootElement().trim().length() == 0) {
                            string = "document root element cannot be empty";
                        }
                        if (string != null) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), string, "GATE", 0);
                            return;
                        }
                        long l = System.currentTimeMillis();
                        URL uRL = null;
                        try {
                            uRL = new URL(NameBearerHandle.this.scfInputDialog.getUrlString());
                            ((Corpus)NameBearerHandle.this.target).populate(uRL, NameBearerHandle.this.scfInputDialog.getDocumentRootElement(), NameBearerHandle.this.scfInputDialog.getEncoding(), NameBearerHandle.this.scfInputDialog.getNumOfDocumentsToFetch(), NameBearerHandle.this.scfInputDialog.getDocumentNamePrefix(), NameBearerHandle.this.scfInputDialog.getDocumentType());
                            if (((Corpus)NameBearerHandle.this.target).getDataStore() != null) {
                                ((LanguageResource)NameBearerHandle.this.target).getDataStore().sync((LanguageResource)NameBearerHandle.this.target);
                            }
                            long l2 = System.currentTimeMillis();
                            NameBearerHandle.this.fireStatusChanged("Corpus populated in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds!");
                        }
                        catch (MalformedURLException malformedURLException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Invalid URL!\n See \"Messages\" tab for details!", "GATE", 0);
                            malformedURLException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "I/O error!\n See \"Messages\" tab for details!", "GATE", 0);
                            iOException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Could not create document!\n See \"Messages\" tab for details!", "GATE", 0);
                            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (PersistenceException persistenceException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                            persistenceException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (SecurityException securityException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                            securityException.printStackTrace(Err.getPrintWriter());
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "PopulateCorpusFromSingleConcatenatedFileAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class PopulateCorpusAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        PopulateCorpusAction() {
            super("Populate");
            this.putValue("ShortDescription", "Fills this corpus with documents from a directory");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NameBearerHandle.this.corpusFiller.setExtensions(new ArrayList());
            NameBearerHandle.this.corpusFiller.setEncoding("");
            final boolean bl = OkCancelDialog.showDialog(NameBearerHandle.this.window, NameBearerHandle.this.corpusFiller, "Select a directory and allowed extensions");
            Runnable runnable = new Runnable(){

                public void run() {
                    if (bl) {
                        long l = System.currentTimeMillis();
                        try {
                            String string;
                            Object object;
                            ExtensionFileFilter extensionFileFilter;
                            URL uRL = new URL(NameBearerHandle.this.corpusFiller.getUrlString());
                            List list = NameBearerHandle.this.corpusFiller.getExtensions();
                            if (list == null || list.isEmpty()) {
                                extensionFileFilter = null;
                            } else {
                                extensionFileFilter = new ExtensionFileFilter();
                                object = NameBearerHandle.this.corpusFiller.getExtensions().iterator();
                                while (object.hasNext()) {
                                    extensionFileFilter.addExtension((String)object.next());
                                }
                            }
                            object = NameBearerHandle.this.corpusFiller.getEncoding();
                            if (object != null && ((String)object).trim().length() == 0) {
                                object = null;
                            }
                            if ((string = NameBearerHandle.this.corpusFiller.getMimeType()) != null && string.trim().length() == 0) {
                                string = null;
                            }
                            ((Corpus)NameBearerHandle.this.target).populate(uRL, extensionFileFilter, (String)object, string, NameBearerHandle.this.corpusFiller.isRecurseDirectories());
                            if (((Corpus)NameBearerHandle.this.target).getDataStore() != null) {
                                ((LanguageResource)NameBearerHandle.this.target).getDataStore().sync((LanguageResource)NameBearerHandle.this.target);
                            }
                            long l2 = System.currentTimeMillis();
                            NameBearerHandle.this.fireStatusChanged("Corpus populated in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds!");
                        }
                        catch (MalformedURLException malformedURLException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Invalid URL!\n See \"Messages\" tab for details!", "GATE", 0);
                            malformedURLException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "I/O error!\n See \"Messages\" tab for details!", "GATE", 0);
                            iOException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Could not create document!\n See \"Messages\" tab for details!", "GATE", 0);
                            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (PersistenceException persistenceException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                            persistenceException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (SecurityException securityException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Corpus couldn't be synchronized!\n See \"Messages\" tab for details!", "GATE", 0);
                            securityException.printStackTrace(Err.getPrintWriter());
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "PopulateCorpusAction");
            thread.setPriority(1);
            thread.start();
        }
    }

    class ReloadAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ReloadAction() {
            super("Reinitialise");
            this.putValue("ShortDescription", "Reloads this resource");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (!(NameBearerHandle.this.target instanceof ProcessingResource)) {
                        return;
                    }
                    if (NameBearerHandle.this.target instanceof Controller) {
                        return;
                    }
                    try {
                        long l = System.currentTimeMillis();
                        NameBearerHandle.this.fireStatusChanged("Reinitialising " + NameBearerHandle.this.target.getName());
                        HashMap<String, EventListener> hashMap = new HashMap<String, EventListener>();
                        StatusListener statusListener = new StatusListener(){

                            public void statusChanged(String string) {
                                NameBearerHandle.this.fireStatusChanged(string);
                            }
                        };
                        hashMap.put("gate.event.StatusListener", statusListener);
                        ProgressListener progressListener = new ProgressListener(){

                            public void progressChanged(int n) {
                                NameBearerHandle.this.fireProgressChanged(n);
                            }

                            public void processFinished() {
                                NameBearerHandle.this.fireProcessFinished();
                            }
                        };
                        hashMap.put("gate.event.ProgressListener", progressListener);
                        ProcessingResource processingResource = (ProcessingResource)NameBearerHandle.this.target;
                        try {
                            AbstractResource.setResourceListeners(processingResource, hashMap);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Err.getPrintWriter());
                        }
                        NameBearerHandle.this.fireProgressChanged(0);
                        processingResource.reInit();
                        try {
                            AbstractResource.removeResourceListeners(processingResource, hashMap);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Err.getPrintWriter());
                        }
                        long l2 = System.currentTimeMillis();
                        NameBearerHandle.this.fireStatusChanged(NameBearerHandle.this.target.getName() + " reinitialised in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                        NameBearerHandle.this.fireProcessFinished();
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        NameBearerHandle.this.fireStatusChanged("reinitialisation failed");
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Reload failed!\n See \"Messages\" tab for details!", "GATE", 0);
                        NameBearerHandle.this.fireProcessFinished();
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "DefaultResourceHandle1");
            thread.setPriority(1);
            thread.start();
        }
    }

    class SaveToAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveToAction() {
            super("Save to Datastore...");
            this.putValue("ShortDescription", "Save this resource to a datastore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block25: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        try {
                                            try {
                                                Object object;
                                                Object object2;
                                                ArrayList arrayList2;
                                                DataStoreRegister dataStoreRegister = Gate.getDataStoreRegister();
                                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                                for (ArrayList arrayList2 : dataStoreRegister) {
                                                    object2 = arrayList2.getName();
                                                    if (object2 == null) {
                                                        object2 = arrayList2.getStorageUrl();
                                                        try {
                                                            object = new URL((String)object2);
                                                            object2 = ((URL)object).getFile();
                                                        }
                                                        catch (MalformedURLException malformedURLException) {
                                                            throw new GateRuntimeException();
                                                        }
                                                    }
                                                    hashMap.put((String)object2, arrayList2);
                                                }
                                                arrayList2 = new ArrayList(hashMap.keySet());
                                                if (arrayList2.isEmpty()) {
                                                    JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "There are no open datastores!\n Please open a datastore first!", "GATE", 0);
                                                    break block25;
                                                }
                                                object2 = JOptionPane.showInputDialog(NameBearerHandle.this.getLargeView(), "Select the datastore", "GATE", 3, null, arrayList2.toArray(), arrayList2.get(0));
                                                if (object2 == null) {
                                                    Object var21_10 = null;
                                                    break block26;
                                                }
                                                object = (DataStore)hashMap.get(object2);
                                                if (object == null) {
                                                    Err.prln("The datastore does not exists. Saving procedure has FAILED! This should never happen again!");
                                                    break block27;
                                                }
                                                DataStore dataStore = ((LanguageResource)NameBearerHandle.this.target).getDataStore();
                                                if (object == dataStore) {
                                                    MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                                    StatusListener statusListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                                                    if (statusListener != null) {
                                                        statusListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                                    }
                                                    double d = System.currentTimeMillis();
                                                    object.sync((LanguageResource)NameBearerHandle.this.target);
                                                    double d2 = System.currentTimeMillis();
                                                    if (statusListener != null) {
                                                        statusListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((d2 - d) / 1000.0) + " seconds");
                                                    }
                                                    break block25;
                                                }
                                                FeatureMap featureMap = (FeatureMap)DataStoreRegister.getSecurityData((DataStore)object);
                                                SecurityInfo securityInfo = null;
                                                if (featureMap != null) {
                                                    if (!AccessRightsDialog.showDialog(NameBearerHandle.this.window)) {
                                                        break block28;
                                                    }
                                                    int n = AccessRightsDialog.getSelectedMode();
                                                    if (n < 0) {
                                                        break block29;
                                                    }
                                                    securityInfo = new SecurityInfo(n, (User)featureMap.get("user"), (Group)featureMap.get("group"));
                                                }
                                                StatusListener statusListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                                                MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                                if (statusListener != null) {
                                                    statusListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                                }
                                                double d = System.currentTimeMillis();
                                                LanguageResource languageResource = object.adopt((LanguageResource)NameBearerHandle.this.target, securityInfo);
                                                object.sync(languageResource);
                                                if (object instanceof LuceneDataStoreImpl && languageResource instanceof IndexedCorpus) {
                                                    Object object3 = languageResource.getLRPersistenceId();
                                                    String string = languageResource.getClass().getName();
                                                    String string2 = languageResource.getName();
                                                    Factory.deleteResource(languageResource);
                                                    FeatureMap featureMap2 = Factory.newFeatureMap();
                                                    featureMap2.put("DataStore", object);
                                                    featureMap2.put("LRPersistenceId", object3);
                                                    FeatureMap featureMap3 = Factory.newFeatureMap();
                                                    try {
                                                        languageResource = (LanguageResource)Factory.createResource(string, featureMap2, featureMap3, string2);
                                                    }
                                                    catch (ResourceInstantiationException resourceInstantiationException) {
                                                        throw new GateRuntimeException("Could not load the corpus", resourceInstantiationException);
                                                    }
                                                }
                                                double d3 = System.currentTimeMillis();
                                                if (statusListener != null) {
                                                    statusListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((d3 - d) / 1000.0) + " seconds");
                                                }
                                                if (languageResource != NameBearerHandle.this.target) {
                                                    Factory.deleteResource((LanguageResource)NameBearerHandle.this.target);
                                                }
                                                break block25;
                                            }
                                            catch (PersistenceException persistenceException) {
                                                MainFrame.unlockGUI();
                                                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + persistenceException.toString(), "GATE", 0);
                                                Object var21_15 = null;
                                                MainFrame.unlockGUI();
                                                return;
                                            }
                                            catch (SecurityException securityException) {
                                                MainFrame.unlockGUI();
                                                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + securityException.toString(), "GATE", 0);
                                                Object var21_16 = null;
                                                MainFrame.unlockGUI();
                                                return;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var21_17 = null;
                                            MainFrame.unlockGUI();
                                            throw throwable;
                                        }
                                    }
                                    MainFrame.unlockGUI();
                                    return;
                                }
                                Object var21_11 = null;
                                MainFrame.unlockGUI();
                                return;
                            }
                            Object var21_12 = null;
                            MainFrame.unlockGUI();
                            return;
                        }
                        Object var21_13 = null;
                        MainFrame.unlockGUI();
                        return;
                    }
                    Object var21_14 = null;
                    MainFrame.unlockGUI();
                }
            };
            new Thread(runnable).start();
        }
    }

    class ExportApplicationAction
    extends AbstractAction {
        private Logger log;
        private static final long serialVersionUID = 1L;

        public ExportApplicationAction() {
            super("Export for GATECloud.net");
            this.log = Logger.getLogger((String)"gate.gui.ExportApplicationAction");
            this.putValue("ShortDescription", "Saves the resources of this application in a ZIP file");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("ZIP file", "zip");
            xJFileChooser.addChoosableFileFilter(extensionFileFilter);
            xJFileChooser.setDialogTitle("Select a file where to save the application " + (NameBearerHandle.this.target instanceof CorpusController && ((CorpusController)NameBearerHandle.this.target).getCorpus() != null ? "WITH" : "WITHOUT") + " corpus.");
            xJFileChooser.setFileSelectionMode(2);
            xJFileChooser.setResource("application.zip." + NameBearerHandle.this.target.getName());
            if (xJFileChooser.showSaveDialog(NameBearerHandle.this.largeView) == 0) {
                final File file = xJFileChooser.getSelectedFile();
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                Project project = new Project();
                                ExporterBuildListener exporterBuildListener = new ExporterBuildListener();
                                Gate.setExecutable(exporterBuildListener);
                                project.addBuildListener((BuildListener)exporterBuildListener);
                                project.init();
                                MainFrame.lockGUI("Exporting application...");
                                File file4 = File.createTempFile("gapp-packager", "", null);
                                if (!file4.delete()) throw new IOException("Unable to create temporary directory.\n" + file4.getCanonicalPath());
                                if (!file4.mkdir()) {
                                    throw new IOException("Unable to create temporary directory.\n" + file4.getCanonicalPath());
                                }
                                file4 = file4.getCanonicalFile();
                                File file2 = new File(file4, "original.xgapp");
                                File file3 = new File(file4, "application.xgapp");
                                PersistenceManager.saveObjectToFile(NameBearerHandle.this.target, file2, false, true);
                                PackageGappTask packageGappTask = new PackageGappTask();
                                packageGappTask.setProject(project);
                                packageGappTask.setSrc(file2);
                                packageGappTask.setDestFile(file3);
                                packageGappTask.setCopyPlugins(true);
                                packageGappTask.setCopyResourceDirs(true);
                                packageGappTask.setOnUnresolved(PackageGappTask.UnresolvedAction.recover);
                                packageGappTask.init();
                                packageGappTask.perform();
                                Zip zip = new Zip();
                                zip.setProject(project);
                                zip.setDestFile(file);
                                FileSet fileSet = new FileSet();
                                fileSet.setProject(project);
                                zip.addFileset(fileSet);
                                fileSet.setDir(file4);
                                fileSet.setExcludes("original.xgapp");
                                zip.perform();
                                Delete delete = new Delete();
                                delete.setProject(project);
                                delete.setDir(file4);
                                delete.perform();
                            }
                            catch (Exception exception) {
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Error!\n" + exception.toString(), "GATE", 0);
                                exception.printStackTrace(Err.getPrintWriter());
                                Object var11_12 = null;
                                MainFrame.unlockGUI();
                                Gate.setExecutable(null);
                                return;
                            }
                            Object var11_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            MainFrame.unlockGUI();
                            Gate.setExecutable(null);
                            throw throwable;
                        }
                        MainFrame.unlockGUI();
                        Gate.setExecutable(null);
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                thread.start();
            }
        }

        class ExporterBuildListener
        implements BuildListener,
        Executable {
            private boolean interrupted = false;

            ExporterBuildListener() {
            }

            public boolean isInterrupted() {
                return this.interrupted;
            }

            public void interrupt() {
                this.interrupted = true;
            }

            public void taskFinished(BuildEvent buildEvent) {
                if (buildEvent.getException() != null) {
                    NameBearerHandle.this.statusChanged("Error exporting application");
                } else {
                    NameBearerHandle.this.statusChanged("Export complete");
                }
            }

            public void messageLogged(BuildEvent buildEvent) {
                if (this.interrupted) {
                    this.interrupted = false;
                    throw new BuildException("Export interrupted");
                }
                if (buildEvent.getPriority() <= 2) {
                    NameBearerHandle.this.statusChanged(buildEvent.getMessage());
                }
                ExportApplicationAction.this.log.debug((Object)(buildEvent.getPriority() + ": " + buildEvent.getMessage()));
            }

            public void buildStarted(BuildEvent buildEvent) {
            }

            public void buildFinished(BuildEvent buildEvent) {
            }

            public void targetStarted(BuildEvent buildEvent) {
            }

            public void targetFinished(BuildEvent buildEvent) {
            }

            public void taskStarted(BuildEvent buildEvent) {
            }

            public void execute() {
            }
        }
    }

    class DumpToFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DumpToFileAction() {
            super("Save Application State");
            this.putValue("ShortDescription", "Saves the data needed to recreate this application");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("GATE Application files", "gapp");
            xJFileChooser.addChoosableFileFilter(extensionFileFilter);
            xJFileChooser.setDialogTitle("Select a file where to save the application " + (NameBearerHandle.this.target instanceof CorpusController && ((CorpusController)NameBearerHandle.this.target).getCorpus() != null ? "WITH" : "WITHOUT") + " corpus.");
            xJFileChooser.setFileSelectionMode(2);
            xJFileChooser.setResource("application." + NameBearerHandle.this.target.getName());
            if (xJFileChooser.showSaveDialog(NameBearerHandle.this.largeView) == 0) {
                final File file = xJFileChooser.getSelectedFile();
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            Map<String, String> map = xJFileChooser.getLocations();
                            PersistenceManager.saveObjectToFile(NameBearerHandle.this.target, file, true, true);
                            map.put("lastapplication", file.getCanonicalPath());
                            String string = map.get("applications");
                            if (string == null) {
                                string = "";
                            }
                            string = string.replaceFirst("\\Q" + NameBearerHandle.this.target.getName() + "\\E(;|$)", "");
                            string = NameBearerHandle.this.target.getName() + ";" + string;
                            map.put("applications", string);
                            xJFileChooser.setLocations(map);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Error!\n" + exception.toString(), "GATE", 0);
                            exception.printStackTrace(Err.getPrintWriter());
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                thread.start();
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            super("Save to its Datastore");
            this.putValue("ShortDescription", "Save back to its datastore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    DataStore dataStore = ((LanguageResource)NameBearerHandle.this.target).getDataStore();
                    if (dataStore == null) {
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "This resource has not been loaded from a datastore.\nPlease use the \"Save to Datastore...\" option.\n", "GATE", 0);
                        return;
                    }
                    try {
                        block7: {
                            try {
                                MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                StatusListener statusListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                                if (statusListener != null) {
                                    statusListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                }
                                double d = System.currentTimeMillis();
                                ((LanguageResource)NameBearerHandle.this.target).getDataStore().sync((LanguageResource)NameBearerHandle.this.target);
                                double d2 = System.currentTimeMillis();
                                if (statusListener == null) break block7;
                                statusListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((d2 - d) / 1000.0) + " seconds");
                            }
                            catch (PersistenceException persistenceException) {
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + persistenceException.toString(), "GATE", 0);
                                Object var8_8 = null;
                                MainFrame.unlockGUI();
                                return;
                            }
                            catch (SecurityException securityException) {
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + securityException.toString(), "GATE", 0);
                                Object var8_9 = null;
                                MainFrame.unlockGUI();
                                return;
                            }
                        }
                        Object var8_7 = null;
                        MainFrame.unlockGUI();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        MainFrame.unlockGUI();
                        throw throwable;
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    class ReloadClassAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ReloadClassAction() {
            super("Reload Resource Class");
            this.putValue("ShortDescription", "Reloads the java class for this resource");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showOptionDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "This is an advanced option!\nYou should not use this unless your name is Hamish.\nAre you sure you want to do this?", "GATE", 0, 2, null, null, null);
            if (n == 0) {
                try {
                    String string = NameBearerHandle.this.target.getClass().getName();
                    Gate.getClassLoader().reloadClass(string);
                    NameBearerHandle.this.fireStatusChanged("Class " + string + " reloaded!");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Look what you've done: \n" + exception.toString() + "\nI told you not to do it...", "GATE", 0);
                    exception.printStackTrace(Err.getPrintWriter());
                }
            }
        }
    }

    class SaveCorpusAsXmlAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private boolean preserveFormat;

        public SaveCorpusAsXmlAction(boolean bl) {
            super("Save as XML...");
            this.putValue("ShortDescription", "Saves each document in GATE XML format");
            this.preserveFormat = bl;
            if (bl) {
                this.putValue("Name", "Save Preserving Format...");
                this.putValue("ShortDescription", "Saves each document preserving its format");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block24: {
                        block25: {
                            if (SaveCorpusAsXmlAction.this.preserveFormat) {
                                System.out.println("Preserve option set!");
                            }
                            try {
                                XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                                xJFileChooser.setDialogTitle("Select the directory that will contain the corpus");
                                xJFileChooser.setFileSelectionMode(1);
                                if (xJFileChooser.showDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Select") != 0) break block24;
                                File file = xJFileChooser.getSelectedFile();
                                if (!file.exists() && !file.mkdirs()) {
                                    JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Could not create top directory!", "GATE", 0);
                                    Object var21_3 = null;
                                    break block25;
                                }
                                MainFrame.lockGUI("Saving...");
                                Corpus corpus = (Corpus)NameBearerHandle.this.target;
                                Iterator iterator = corpus.iterator();
                                boolean bl = false;
                                int n = corpus.size();
                                int n2 = 0;
                                while (iterator.hasNext()) {
                                    Object[] objectArray;
                                    boolean bl2 = corpus.isDocumentLoaded(n2);
                                    Document document = (Document)iterator.next();
                                    URL uRL = document.getSourceUrl();
                                    String string = null;
                                    if (uRL != null) {
                                        string = uRL.getFile();
                                        string = Files.getLastPathComponent(string);
                                    }
                                    if (string == null || string.length() == 0) {
                                        string = document.getName();
                                    }
                                    if (!(string = string.replaceAll("[\\/:\\*\\?\"<>|]", "_")).toLowerCase().endsWith(".xml")) {
                                        string = string + ".xml";
                                    }
                                    File file2 = null;
                                    boolean bl3 = false;
                                    do {
                                        if ((file2 = new File(file, string)).exists() && !bl) {
                                            objectArray = new Object[]{"Yes", "All", "No", "Cancel"};
                                            MainFrame.unlockGUI();
                                            int n3 = JOptionPane.showOptionDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "File " + file2.getName() + " already exists!\n" + "Overwrite?", "GATE", -1, 2, null, objectArray, objectArray[2]);
                                            MainFrame.lockGUI("Saving...");
                                            switch (n3) {
                                                case 0: {
                                                    bl3 = true;
                                                    break;
                                                }
                                                case 1: {
                                                    bl3 = true;
                                                    bl = true;
                                                    break;
                                                }
                                                case 2: {
                                                    MainFrame.unlockGUI();
                                                    string = (String)JOptionPane.showInputDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Please provide an alternative file name", "GATE", 3, null, null, string);
                                                    if (string == null) {
                                                        NameBearerHandle.this.fireProcessFinished();
                                                        Object var21_4 = null;
                                                        MainFrame.unlockGUI();
                                                        return;
                                                    }
                                                    MainFrame.lockGUI("Saving");
                                                    break;
                                                }
                                                case 3: {
                                                    NameBearerHandle.this.fireProcessFinished();
                                                    Object var21_5 = null;
                                                    MainFrame.unlockGUI();
                                                    return;
                                                }
                                            }
                                            continue;
                                        }
                                        bl3 = true;
                                    } while (!bl3);
                                    try {
                                        objectArray = "";
                                        if (SaveCorpusAsXmlAction.this.preserveFormat) {
                                            Serializable serializable;
                                            Set set = null;
                                            if (NameBearerHandle.this.largeView instanceof JTabbedPane && (serializable = ((JTabbedPane)NameBearerHandle.this.largeView).getSelectedComponent()) instanceof DocumentEditor) {
                                                set = ((DocumentEditor)serializable).getDisplayedAnnotations();
                                            }
                                            serializable = Gate.getUserConfig().getBoolean("Save_features_when_preserving_format");
                                            boolean bl4 = true;
                                            if (serializable != null) {
                                                bl4 = (Boolean)serializable;
                                            }
                                            objectArray = document.toXml(set, bl4);
                                            String string2 = ((TextualDocument)document).getEncoding();
                                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string2);
                                            outputStreamWriter.write((String)objectArray);
                                            outputStreamWriter.flush();
                                            outputStreamWriter.close();
                                        } else {
                                            DocumentStaxUtils.writeDocument(document, file2);
                                        }
                                    }
                                    catch (Exception exception) {
                                        MainFrame.unlockGUI();
                                        JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Could not create write file:" + exception.toString(), "GATE", 0);
                                        exception.printStackTrace(Err.getPrintWriter());
                                        Object var21_6 = null;
                                        MainFrame.unlockGUI();
                                        return;
                                    }
                                    NameBearerHandle.this.fireStatusChanged(document.getName() + " saved");
                                    if (!bl2) {
                                        corpus.unloadDocument(document);
                                        Factory.deleteResource(document);
                                    }
                                    NameBearerHandle.this.fireProgressChanged(100 * n2++ / n);
                                }
                                NameBearerHandle.this.fireStatusChanged("Corpus saved");
                                NameBearerHandle.this.fireProcessFinished();
                                break block24;
                            }
                            catch (Throwable throwable) {
                                Object var21_8 = null;
                                MainFrame.unlockGUI();
                                throw throwable;
                            }
                        }
                        MainFrame.unlockGUI();
                        return;
                    }
                    Object var21_7 = null;
                    MainFrame.unlockGUI();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Corpus XML dumper");
            thread.setPriority(1);
            thread.start();
        }
    }

    class SaveAsXmlAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAsXmlAction() {
            super("Save as XML...");
            this.putValue("ShortDescription", "Saves this resource in GATE XML format");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    int n;
                    File file;
                    XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                    ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("XML files", "xml", "gml");
                    xJFileChooser.addChoosableFileFilter(extensionFileFilter);
                    xJFileChooser.setMultiSelectionEnabled(false);
                    xJFileChooser.setFileSelectionMode(0);
                    xJFileChooser.setDialogTitle("Select document to save ...");
                    Document document = (Document)NameBearerHandle.this.target;
                    if (document.getSourceUrl() != null) {
                        String string = "";
                        try {
                            string = document.getSourceUrl().toURI().getPath().trim();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            string = document.getSourceUrl().getPath().trim();
                        }
                        if (string.equals("") || string.equals("/")) {
                            if (document.getNamedAnnotationSets().containsKey("Original markups") && !document.getAnnotations("Original markups").get("title").isEmpty()) {
                                try {
                                    string = document.getContent().getContent(document.getAnnotations("Original markups").get("title").firstNode().getOffset(), document.getAnnotations("Original markups").get("title").lastNode().getOffset()).toString();
                                }
                                catch (InvalidOffsetException invalidOffsetException) {
                                    invalidOffsetException.printStackTrace();
                                }
                            } else {
                                string = document.getSourceUrl().toString();
                            }
                            string = string.replaceAll("/", "_");
                        } else {
                            string = string.replaceAll("\\.[a-zA-Z]{1,4}$", ".xml");
                        }
                        string = string.replaceAll("[^/a-zA-Z0-9._-]", "_");
                        string = string.replaceAll("__+", "_");
                        if (!string.endsWith(".xml")) {
                            string = string + ".xml";
                        }
                        file = new File(string);
                        xJFileChooser.ensureFileIsVisible(file);
                        xJFileChooser.setSelectedFile(file);
                    }
                    int n2 = NameBearerHandle.this.getLargeView() != null ? xJFileChooser.showSaveDialog(NameBearerHandle.this.getLargeView()) : (n = NameBearerHandle.this.getSmallView() != null ? xJFileChooser.showSaveDialog(NameBearerHandle.this.getSmallView()) : xJFileChooser.showSaveDialog(null));
                    if (n == 0) {
                        long l;
                        block16: {
                            file = xJFileChooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            l = System.currentTimeMillis();
                            NameBearerHandle.this.statusChanged("Saving as XML to " + file.toString() + "...");
                            try {
                                try {
                                    MainFrame.lockGUI("Saving...");
                                    DocumentStaxUtils.writeDocument((Document)NameBearerHandle.this.target, file);
                                    ((Document)NameBearerHandle.this.target).setSourceUrl(file.toURI().toURL());
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace(Out.getPrintWriter());
                                    Object var10_11 = null;
                                    MainFrame.unlockGUI();
                                    break block16;
                                }
                                Object var10_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                MainFrame.unlockGUI();
                                throw throwable;
                            }
                            MainFrame.unlockGUI();
                        }
                        long l2 = System.currentTimeMillis() - l;
                        NameBearerHandle.this.statusChanged("Finished saving as xml into  the file: " + file.toString() + " in " + (double)l2 / 1000.0 + " s");
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseRecursivelyAction
    extends AbstractAction {
        public CloseRecursivelyAction() {
            super("Close Recursively");
            this.putValue("ShortDescription", "Close this application and recursively all contained resources");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift F4"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Factory.deleteResource((Resource)NameBearerHandle.this.target);
            NameBearerHandle.this.statusListeners.clear();
            NameBearerHandle.this.progressListeners.clear();
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
            this.putValue("ShortDescription", "Close this resource");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F4"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NameBearerHandle.this.target instanceof Controller) {
                ((Controller)NameBearerHandle.this.target).setPRs(Collections.emptyList());
                if (NameBearerHandle.this.target instanceof ConditionalController) {
                    ((ConditionalController)NameBearerHandle.this.target).setRunningStrategies(Collections.emptyList());
                }
            }
            if (NameBearerHandle.this.target instanceof Resource) {
                Factory.deleteResource((Resource)NameBearerHandle.this.target);
            } else if (NameBearerHandle.this.target instanceof DataStore) {
                try {
                    ((DataStore)NameBearerHandle.this.target).close();
                }
                catch (PersistenceException persistenceException) {
                    JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Error!\n" + persistenceException.toString(), "GATE", 0);
                }
            }
            NameBearerHandle.this.statusListeners.clear();
            NameBearerHandle.this.progressListeners.clear();
        }
    }
}

