/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.test;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.ProcessingResource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.SerialAnalyserController;
import gate.creole.metadata.CreoleResource;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DynamicRegistrationTest
extends TestCase {
    public void testDynamicRegistration() throws Exception {
        Gate.getCreoleRegister().registerComponent(TestResource.class);
        SerialAnalyserController serialAnalyserController = (SerialAnalyserController)Factory.createResource("gate.creole.SerialAnalyserController", Factory.newFeatureMap(), Factory.newFeatureMap(), "basicRun");
        ProcessingResource processingResource = (ProcessingResource)Factory.createResource(TestResource.class.getName());
        serialAnalyserController.add(processingResource);
        Corpus corpus = Factory.newCorpus("basicTestCorpus");
        String string = "This is the cereal shot from gnus.";
        Document document = Factory.newDocument(string);
        corpus.add(document);
        serialAnalyserController.setCorpus(corpus);
        serialAnalyserController.setDocument(document);
        serialAnalyserController.execute();
    }

    public static Test suite() {
        return new TestSuite(DynamicRegistrationTest.class);
    }

    @CreoleResource(name="This is a test")
    public static class TestResource
    extends AbstractLanguageAnalyser {
        private static final long serialVersionUID = 1L;

        public void execute() throws ExecutionException {
        }
    }
}

