/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.orthomatcher.AnnotationOrthography;
import gate.creole.orthomatcher.BasicAnnotationOrthography;
import gate.creole.orthomatcher.MatchRule0;
import gate.creole.orthomatcher.MatchRule1;
import gate.creole.orthomatcher.MatchRule10;
import gate.creole.orthomatcher.MatchRule11;
import gate.creole.orthomatcher.MatchRule12;
import gate.creole.orthomatcher.MatchRule13;
import gate.creole.orthomatcher.MatchRule14;
import gate.creole.orthomatcher.MatchRule15;
import gate.creole.orthomatcher.MatchRule16;
import gate.creole.orthomatcher.MatchRule17;
import gate.creole.orthomatcher.MatchRule2;
import gate.creole.orthomatcher.MatchRule3;
import gate.creole.orthomatcher.MatchRule4;
import gate.creole.orthomatcher.MatchRule5;
import gate.creole.orthomatcher.MatchRule6;
import gate.creole.orthomatcher.MatchRule7;
import gate.creole.orthomatcher.MatchRule8;
import gate.creole.orthomatcher.MatchRule9;
import gate.creole.orthomatcher.OrthoMatcherHelper;
import gate.creole.orthomatcher.OrthoMatcherRule;
import gate.util.BomStrippingInputStreamReader;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import gate.util.Out;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrthoMatcher
extends AbstractLanguageAnalyser {
    protected static final Logger log = Logger.getLogger(OrthoMatcher.class);
    public static final boolean DEBUG = false;
    public static final String OM_DOCUMENT_PARAMETER_NAME = "document";
    public static final String OM_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String OM_CASE_SENSITIVE_PARAMETER_NAME = "caseSensitive";
    public static final String OM_ANN_TYPES_PARAMETER_NAME = "annotationTypes";
    public static final String OM_ORG_TYPE_PARAMETER_NAME = "organizationType";
    public static final String OM_PERSON_TYPE_PARAMETER_NAME = "personType";
    public static final String OM_EXT_LISTS_PARAMETER_NAME = "extLists";
    protected static final String CDGLISTNAME = "cdg";
    protected static final String ALIASLISTNAME = "alias";
    protected static final String ARTLISTNAME = "def_art";
    protected static final String PREPLISTNAME = "prepos";
    protected static final String CONNECTORLISTNAME = "connector";
    protected static final String SPURLISTNAME = "spur_match";
    protected static final String PUNCTUATION_VALUE = "punctuation";
    protected static final String THE_VALUE = "The";
    protected String annotationSetName;
    protected List annotationTypes = new ArrayList(10);
    protected String organizationType = "Organization";
    protected String personType = "Person";
    protected String unknownType = "Unknown";
    protected boolean extLists = true;
    protected Boolean highPrecisionOrgs = false;
    protected boolean matchingUnknowns = true;
    protected boolean allMatchingNeeded = false;
    protected boolean caseSensitive = false;
    protected HashMap alias = new HashMap(100);
    protected HashSet cdg = new HashSet();
    protected HashMap spur_match = new HashMap(100);
    protected HashMap def_art = new HashMap(20);
    protected HashMap connector = new HashMap(20);
    protected HashMap prepos = new HashMap(30);
    protected AnnotationSet nameAllAnnots = null;
    protected HashMap processedAnnots = new HashMap(150);
    protected HashMap annots2Remove = new HashMap(75);
    protected List matchesDocFeature = new ArrayList();
    protected HashMap tokensMap = new HashMap(150);
    protected HashMap normalizedTokensMap = new HashMap(150);
    protected Annotation shortAnnot;
    protected Annotation longAnnot;
    protected ArrayList<Annotation> tokensLongAnnot;
    protected ArrayList<Annotation> tokensShortAnnot;
    protected ArrayList<Annotation> normalizedTokensLongAnnot;
    protected ArrayList<Annotation> normalizedTokensShortAnnot;
    private URL definitionFileURL;
    private Double minimumNicknameLikelihood;
    private String encoding;
    private Map<Integer, OrthoMatcherRule> rules = new HashMap<Integer, OrthoMatcherRule>();
    private AnnotationOrthography orthoAnnotation;
    static Pattern periodPat = Pattern.compile("[\\.]+");
    static Pattern punctPat = Pattern.compile("[\\p{Punct}]+");
    static Pattern badMiddleTokens = Pattern.compile("[\u201c\u201d\u2018\u2019'\\(\\)\"]+|^de$|^von$");

    public HashMap getTokensMap() {
        return this.tokensMap;
    }

    public OrthoMatcher() {
        this.annotationTypes.add(this.organizationType);
        this.annotationTypes.add(this.personType);
        this.annotationTypes.add("Location");
        this.annotationTypes.add("Date");
    }

    private void initRules() {
        this.rules.put(0, new MatchRule0(this));
        this.rules.put(1, new MatchRule1(this));
        this.rules.put(2, new MatchRule2(this));
        this.rules.put(3, new MatchRule3(this));
        this.rules.put(4, new MatchRule4(this));
        this.rules.put(5, new MatchRule5(this));
        this.rules.put(6, new MatchRule6(this));
        this.rules.put(7, new MatchRule7(this));
        this.rules.put(8, new MatchRule8(this));
        this.rules.put(9, new MatchRule9(this));
        this.rules.put(10, new MatchRule10(this));
        this.rules.put(11, new MatchRule11(this));
        this.rules.put(12, new MatchRule12(this));
        this.rules.put(13, new MatchRule13(this));
        this.rules.put(14, new MatchRule14(this));
        this.rules.put(15, new MatchRule15(this));
        this.rules.put(16, new MatchRule16(this));
        this.rules.put(17, new MatchRule17(this));
    }

    protected void modifyRules(Map<Integer, OrthoMatcherRule> map) {
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        if (this.definitionFileURL == null) {
            throw new ResourceInstantiationException("No URL provided for the definition file!");
        }
        String string = null;
        try {
            BomStrippingInputStreamReader bomStrippingInputStreamReader = new BomStrippingInputStreamReader(this.definitionFileURL.openStream(), this.encoding);
            String string2 = null;
            while ((string2 = ((BufferedReader)bomStrippingInputStreamReader).readLine()) != null) {
                int n = string2.indexOf(":");
                if (n == -1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1, string2.length());
                if (string4.equals("nickname")) {
                    if (this.minimumNicknameLikelihood == null) {
                        throw new ResourceInstantiationException("No value for the required parameter minimumNicknameLikelihood!");
                    }
                    string = string3;
                    continue;
                }
                this.createAnnotList(string3, string4);
            }
            ((BufferedReader)bomStrippingInputStreamReader).close();
            URL uRL = null;
            if (string != null) {
                uRL = new URL(this.definitionFileURL, string);
            }
            this.orthoAnnotation = new BasicAnnotationOrthography(this.personType, this.extLists, this.unknownType, uRL, this.minimumNicknameLikelihood, this.encoding);
            this.initRules();
            this.modifyRules(this.rules);
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ExecutionException {
        try {
            if (this.document == null) {
                throw new ExecutionException("No document for namematch!");
            }
            this.fireStatusChanged("OrthoMatcher processing: " + this.document.getName());
            this.nameAllAnnots = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
            if (this.nameAllAnnots == null || this.nameAllAnnots.isEmpty()) {
                Out.prln("OrthoMatcher Warning: No annotations found for processing");
                Object var3_1 = null;
                this.nameAllAnnots = null;
                this.processedAnnots.clear();
                this.annots2Remove.clear();
                this.tokensMap.clear();
                this.normalizedTokensMap.clear();
                this.matchesDocFeature = new ArrayList();
                this.longAnnot = null;
                this.shortAnnot = null;
                this.tokensLongAnnot = null;
                this.tokensShortAnnot = null;
                return;
            }
            this.docCleanup();
            HashMap<String, List> hashMap = (HashMap<String, List>)this.document.getFeatures().get("MatchesAnnots");
            if (!this.extLists) {
                this.cdg = this.orthoAnnotation.buildTables(this.nameAllAnnots);
            }
            this.matchNameAnnotations();
            if (!this.matchesDocFeature.isEmpty()) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, List>();
                }
                hashMap.put(this.nameAllAnnots.getName(), this.matchesDocFeature);
                this.document.getFeatures().put("MatchesAnnots", hashMap);
                this.matchesDocFeature = new ArrayList();
                this.fireStatusChanged("OrthoMatcher completed");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.nameAllAnnots = null;
            this.processedAnnots.clear();
            this.annots2Remove.clear();
            this.tokensMap.clear();
            this.normalizedTokensMap.clear();
            this.matchesDocFeature = new ArrayList();
            this.longAnnot = null;
            this.shortAnnot = null;
            this.tokensLongAnnot = null;
            this.tokensShortAnnot = null;
            throw throwable;
        }
        Object var3_2 = null;
        this.nameAllAnnots = null;
        this.processedAnnots.clear();
        this.annots2Remove.clear();
        this.tokensMap.clear();
        this.normalizedTokensMap.clear();
        this.matchesDocFeature = new ArrayList();
        this.longAnnot = null;
        this.shortAnnot = null;
        this.tokensLongAnnot = null;
        this.tokensShortAnnot = null;
    }

    protected void matchNameAnnotations() throws ExecutionException {
        for (String string : this.annotationTypes) {
            AnnotationSet annotationSet;
            AnnotationSet annotationSet2 = this.nameAllAnnots.get(string);
            if (annotationSet2.isEmpty() || (annotationSet = this.nameAllAnnots.get("Token")).isEmpty()) continue;
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet2);
            Collections.sort(arrayList, new OffsetComparator());
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayList<Annotation> arrayList2;
                Annotation annotation = arrayList.get(i);
                Annotation annotation2 = this.nameAllAnnots.get(annotation.getId());
                Integer n = annotation2.getId();
                String string2 = this.orthoAnnotation.getStringForAnnotation(annotation2, this.document);
                if (!this.caseSensitive) {
                    string2 = string2.toLowerCase();
                }
                if ((arrayList2 = new ArrayList<Annotation>(annotationSet.getContained(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()))).isEmpty()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Didn't find any tokens for the following annotation.  We will be unable to perform coref on this annotation.  \n String:  " + this.orthoAnnotation.getStringForAnnotation(annotation2, this.document) + " Id: " + annotation2.getId() + " Type: " + annotation2.getType()));
                    continue;
                }
                Collections.sort(arrayList2, new OffsetComparator());
                this.tokensMap.put(annotation2.getId(), arrayList2);
                this.normalizedTokensMap.put(annotation2.getId(), new ArrayList<Annotation>(arrayList2));
                if (this.processedAnnots.containsValue(string2) && (!annotation2.getType().equals(this.personType) || arrayList2.size() != 1)) {
                    Annotation annotation3 = this.orthoAnnotation.updateMatches(annotation2, string2, this.processedAnnots, this.nameAllAnnots, this.matchesDocFeature);
                    if (annotation3 != null) {
                        this.processedAnnots.put(annotation2.getId(), string2);
                        continue;
                    }
                } else if (this.processedAnnots.isEmpty()) {
                    this.processedAnnots.put(annotation2.getId(), string2);
                    continue;
                }
                if (annotation2.getType().equals(this.personType)) {
                    string2 = this.orthoAnnotation.stripPersonTitle(string2, annotation2, this.document, this.tokensMap, this.normalizedTokensMap, this.nameAllAnnots);
                    this.normalizePersonName(annotation2);
                } else if (annotation2.getType().equals(this.organizationType)) {
                    string2 = this.normalizeOrganizationName(string2, annotation2);
                }
                if (null == string2 || "".equals(string2) || arrayList2.isEmpty()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Annotation ID " + annotation2.getId() + " of type" + annotation2.getType() + " refers to a null or empty string or one with no tokens after normalization.  Unable to process further."));
                    continue;
                }
                this.matchWithPrevious(annotation2, string2, arrayList, i);
                this.processedAnnots.put(annotation2.getId(), string2);
            }
            if (!this.matchingUnknowns) continue;
            this.matchUnknown(arrayList);
        }
    }

    protected void matchUnknown(ArrayList<Annotation> arrayList) throws ExecutionException {
        Comparable<Integer> comparable;
        Serializable serializable;
        AnnotationSet annotationSet = this.nameAllAnnots.get(this.unknownType);
        this.annots2Remove.clear();
        if (annotationSet.isEmpty()) {
            return;
        }
        AnnotationSet annotationSet2 = this.nameAllAnnots.get("Token");
        if (annotationSet2.isEmpty()) {
            return;
        }
        Iterator<Annotation> iterator = annotationSet.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            Object object = this.orthoAnnotation.getStringForAnnotation(annotation, this.document);
            if (!this.caseSensitive) {
                object = ((String)object).toLowerCase();
            }
            if ((serializable = new ArrayList<Annotation>(annotationSet2.getContained(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()))).isEmpty()) continue;
            Collections.sort(serializable, new OffsetComparator());
            this.tokensMap.put(annotation.getId(), serializable);
            this.normalizedTokensMap.put(annotation.getId(), serializable);
            if (this.processedAnnots.containsValue(object)) {
                comparable = this.orthoAnnotation.updateMatches(annotation, (String)object, this.processedAnnots, this.nameAllAnnots, this.matchesDocFeature);
                if (comparable == null) {
                    log.info((Object)("Orthomatcher: Unable to find the annotation: " + this.orthoAnnotation.getStringForAnnotation(annotation, this.document) + " in matchUnknown"));
                } else {
                    if (comparable.getType().equals(this.unknownType)) {
                        this.annots2Remove.put(annotation.getId(), this.annots2Remove.get(comparable.getId()));
                    } else {
                        this.annots2Remove.put(annotation.getId(), comparable.getType());
                    }
                    this.processedAnnots.put(annotation.getId(), object);
                    annotation.getFeatures().put("NMRule", this.unknownType);
                    continue;
                }
            }
            if (serializable.size() == 1 && "hyphen".equals(annotation.getFeatures().get("kind")) && this.matchHyphenatedUnknowns(annotation, (String)object, iterator)) continue;
            this.matchWithPrevious(annotation, (String)object, arrayList, arrayList.size() - 1);
        }
        if (!this.annots2Remove.isEmpty()) {
            for (Object object : this.annots2Remove.keySet()) {
                serializable = this.nameAllAnnots.get((Integer)object);
                comparable = this.nameAllAnnots.add(serializable.getStartNode(), serializable.getEndNode(), (String)this.annots2Remove.get(object), serializable.getFeatures());
                this.nameAllAnnots.remove(serializable);
                List list = (List)serializable.getFeatures().get("matches");
                list.remove(object);
                list.add(comparable);
            }
        }
    }

    private boolean matchHyphenatedUnknowns(Annotation annotation, String string, Iterator iterator) {
        boolean bl = false;
        int n = string.indexOf("-");
        if (this.processedAnnots.containsValue(string = string.substring(0, n))) {
            bl = true;
            Annotation annotation2 = this.orthoAnnotation.updateMatches(annotation, string, this.processedAnnots, this.nameAllAnnots, this.matchesDocFeature);
            iterator.remove();
            String string2 = annotation2.getType().equals(this.unknownType) ? (String)this.annots2Remove.get(annotation2.getId()) : annotation2.getType();
            Integer n2 = new Integer(-1);
            try {
                n2 = this.nameAllAnnots.add(annotation.getStartNode().getOffset(), new Long(annotation.getStartNode().getOffset() + (long)n), string2, annotation.getFeatures());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException.getMessage());
            }
            this.nameAllAnnots.remove(annotation);
            List list = (List)annotation.getFeatures().get("matches");
            list.remove(annotation.getId());
            list.add(n2);
        }
        return bl;
    }

    protected void matchWithPrevious(Annotation annotation, String string, ArrayList<Annotation> arrayList, int n) {
        boolean bl = false;
        for (int i = n - 1; i >= 0; --i) {
            Integer n2 = arrayList.get(i).getId();
            Annotation annotation2 = this.nameAllAnnots.get(n2);
            if (annotation2 == null || !annotation2.getType().equals(annotation.getType()) && !annotation.getType().equals(this.unknownType) || annotation.getType().equals(this.unknownType) && annotation2.getType().equals(this.unknownType) || this.orthoAnnotation.matchedAlready(annotation, annotation2, this.matchesDocFeature, this.nameAllAnnots)) continue;
            if (annotation2.getType().equals(this.personType)) {
                String string2 = (String)annotation2.getFeatures().get("gender");
                String string3 = (String)annotation.getFeatures().get("gender");
                if (string2 != null && string3 != null && (string3.equalsIgnoreCase("female") && string2.equalsIgnoreCase("male") || string2.equalsIgnoreCase("female") && string3.equalsIgnoreCase("male"))) continue;
            }
            boolean bl2 = annotation2.getFeatures().containsKey("matchedWithLonger");
            if (!this.matchAnnotations(annotation, string, annotation2)) continue;
            this.orthoAnnotation.updateMatches(annotation, annotation2, this.matchesDocFeature, this.nameAllAnnots);
            if (!bl2 && annotation2.getFeatures().containsKey("matchedWithLonger")) {
                this.propagatePropertyToExactMatchingMatches(annotation2, "matchedWithLonger", true);
            }
            if (!annotation.getType().equals(this.unknownType)) break;
            bl = true;
            if (annotation2.getType().equals(this.unknownType)) {
                this.annots2Remove.put(annotation.getId(), this.annots2Remove.get(annotation2.getId()));
            } else {
                this.annots2Remove.put(annotation.getId(), annotation2.getType());
            }
            annotation.getFeatures().put("NMRule", this.unknownType);
            break;
        }
        if (bl) {
            this.processedAnnots.put(annotation.getId(), string);
        }
    }

    protected void propagatePropertyToExactMatchingMatches(Annotation annotation, String string, Object object) {
        try {
            List list = (List)annotation.getFeatures().get("matches");
            if (list == null || list.isEmpty()) {
                return;
            }
            String string2 = this.orthoAnnotation.getStringForAnnotation(annotation, this.document).toLowerCase();
            for (Integer n : list) {
                Annotation annotation2 = this.nameAllAnnots.get(n);
                if (!this.orthoAnnotation.fuzzyMatch(this.orthoAnnotation.getStringForAnnotation(annotation2, this.document), string2)) continue;
                annotation2.getFeatures().put(string, object);
            }
        }
        catch (Exception exception) {
            log.error((Object)"Error in propogatePropertyToExactMatchingMatches", (Throwable)exception);
        }
    }

    protected boolean matchAnnotations(Annotation annotation, String string, Annotation annotation2) {
        Serializable serializable;
        Object object;
        if (annotation.overlaps(annotation2)) {
            return false;
        }
        String string2 = (String)this.processedAnnots.get(annotation2.getId());
        if (string2 == null) {
            return false;
        }
        String string3 = string2;
        String string4 = string;
        this.longAnnot = annotation2;
        this.shortAnnot = annotation;
        boolean bl = true;
        if (string4.length() > string3.length()) {
            object = string3;
            string3 = string4;
            string4 = object;
            serializable = this.longAnnot;
            this.longAnnot = this.shortAnnot;
            this.shortAnnot = serializable;
            bl = false;
        }
        this.tokensLongAnnot = (ArrayList)this.tokensMap.get(this.longAnnot.getId());
        this.normalizedTokensLongAnnot = (ArrayList)this.normalizedTokensMap.get(this.longAnnot.getId());
        this.tokensShortAnnot = (ArrayList)this.tokensMap.get(this.shortAnnot.getId());
        this.normalizedTokensShortAnnot = (ArrayList)this.normalizedTokensMap.get(this.shortAnnot.getId());
        object = (List)annotation2.getFeatures().get("matches");
        if (object == null || object.isEmpty()) {
            return this.apply_rules_namematch(annotation2.getType(), string4, string3, annotation2, annotation, bl);
        }
        if (this.apply_rules_namematch(annotation2.getType(), string4, string3, annotation2, annotation, bl)) {
            if (this.allMatchingNeeded) {
                this.allMatchingNeeded = false;
                serializable = new ArrayList(object);
                serializable.remove(annotation2.getId());
                return this.matchOtherAnnots((List)((Object)serializable), annotation, string);
            }
            return true;
        }
        return false;
    }

    protected boolean matchOtherAnnots(List list, Annotation annotation, String string) {
        if (list.isEmpty()) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; bl && i < list.size(); ++i) {
            Annotation annotation2 = this.nameAllAnnots.get((Integer)list.get(i));
            String string2 = (String)this.processedAnnots.get(annotation2.getId());
            if (string2 == null) {
                try {
                    string2 = this.document.getContent().getContent(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toString();
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    return false;
                }
            }
            String string3 = string2;
            String string4 = string;
            this.longAnnot = annotation2;
            this.shortAnnot = annotation;
            boolean bl2 = true;
            if (string4.length() >= string3.length()) {
                String string5 = string3;
                string3 = string4;
                string4 = string5;
                Annotation annotation3 = this.longAnnot;
                this.longAnnot = this.shortAnnot;
                this.shortAnnot = annotation3;
                bl2 = false;
            }
            this.tokensLongAnnot = (ArrayList)this.tokensMap.get(this.longAnnot.getId());
            this.normalizedTokensLongAnnot = (ArrayList)this.normalizedTokensMap.get(this.longAnnot.getId());
            this.tokensShortAnnot = (ArrayList)this.tokensMap.get(this.shortAnnot.getId());
            this.normalizedTokensShortAnnot = (ArrayList)this.normalizedTokensMap.get(this.shortAnnot.getId());
            bl = this.apply_rules_namematch(annotation2.getType(), string4, string3, annotation2, annotation, bl2);
        }
        return bl;
    }

    protected void docCleanup() {
        Object v = this.document.getFeatures().get("MatchesAnnots");
        if (v != null && v instanceof Map) {
            ((Map)v).remove(this.nameAllAnnots.getName());
        } else if (v != null) {
            this.document.getFeatures().put("MatchesAnnots", new HashMap());
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("matches");
        AnnotationSet annotationSet = this.nameAllAnnots.get(null, hashSet);
        if (annotationSet == null || annotationSet.isEmpty()) {
            return;
        }
        Iterator<Annotation> iterator = annotationSet.iterator();
        while (iterator.hasNext()) {
            while (iterator.hasNext()) {
                iterator.next().getFeatures().remove("matches");
            }
        }
    }

    protected void normalizePersonName(Annotation annotation) throws ExecutionException {
        ArrayList arrayList = (ArrayList)this.normalizedTokensMap.get(annotation.getId());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            String string = (String)((Annotation)arrayList.get(i)).getFeatures().get("string");
            String string2 = (String)((Annotation)arrayList.get(i)).getFeatures().get("kind");
            String string3 = (String)((Annotation)arrayList.get(i)).getFeatures().get("category");
            if (!this.caseSensitive) {
                string = string.toLowerCase();
            }
            if (!string2.equals(PUNCTUATION_VALUE)) continue;
            ((Annotation)arrayList.get(i)).getFeatures().put("ortho_stop", true);
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            if (!((Annotation)arrayList2.get(i)).getFeatures().containsKey("ortho_stop")) continue;
            arrayList2.remove(i);
        }
        this.normalizedTokensMap.put(annotation.getId(), arrayList2);
    }

    protected String normalizeOrganizationName(String string, Annotation annotation) {
        Object object;
        ArrayList arrayList = (ArrayList)this.tokensMap.get(annotation.getId());
        if (((String)((Annotation)arrayList.get(0)).getFeatures().get("string")).equalsIgnoreCase(THE_VALUE)) {
            arrayList.remove(0);
        }
        if (arrayList.size() > 0) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                String string2 = (String)((Annotation)arrayList.get(i)).getFeatures().get("string");
                String string3 = (String)((Annotation)arrayList.get(i)).getFeatures().get("kind");
                String string4 = (String)((Annotation)arrayList.get(i)).getFeatures().get("category");
                if (!this.caseSensitive) {
                    string2 = string2.toLowerCase();
                }
                if (!string3.equals(PUNCTUATION_VALUE) && (string4 == null || !string4.equals("DT") && !string4.equals("IN")) && !this.cdg.contains(string2)) continue;
                ((Annotation)arrayList.get(i)).getFeatures().put("ortho_stop", true);
            }
            object = (String)((Annotation)arrayList.get(arrayList.size() - 1)).getFeatures().get("string");
            if (!this.caseSensitive) {
                object = ((String)object).toLowerCase();
            }
            if (this.cdg.contains(object)) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        object = new ArrayList(arrayList);
        for (int i = ((ArrayList)object).size() - 1; i >= 0; --i) {
            if (!((Annotation)((ArrayList)object).get(i)).getFeatures().containsKey("ortho_stop")) continue;
            ((ArrayList)object).remove(i);
        }
        this.normalizedTokensMap.put(annotation.getId(), object);
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append((String)((Annotation)arrayList.get(i)).getFeatures().get("string"));
            if (i == arrayList.size() - 1) continue;
            stringBuffer.append(" ");
        }
        if (this.caseSensitive) {
            return stringBuffer.toString();
        }
        return stringBuffer.toString().toLowerCase();
    }

    protected void createAnnotList(String string, String string2) throws IOException {
        URL uRL = new URL(this.definitionFileURL, string);
        BomStrippingInputStreamReader bomStrippingInputStreamReader = new BomStrippingInputStreamReader(uRL.openStream(), this.encoding);
        String string3 = null;
        while ((string3 = ((BufferedReader)bomStrippingInputStreamReader).readLine()) != null) {
            if (string2.compareTo(CDGLISTNAME) == 0) {
                Matcher matcher = punctPat.matcher(string3.toLowerCase().trim());
                string3 = matcher.replaceAll(" ").trim();
                if (this.caseSensitive) {
                    this.cdg.add(string3);
                    continue;
                }
                this.cdg.add(string3.toLowerCase());
                continue;
            }
            int n = string3.indexOf("\u00a3");
            if (n == -1) continue;
            String string4 = string3.substring(0, n);
            if (!this.caseSensitive) {
                string4 = string4.toLowerCase();
            }
            String string5 = string3.substring(n + 1, string3.length());
            if (string2.equals(ALIASLISTNAME)) {
                this.alias.put(string4, string5);
                continue;
            }
            if (string2.equals(ARTLISTNAME)) {
                this.def_art.put(string4, string5);
                continue;
            }
            if (string2.equals(PREPLISTNAME)) {
                this.prepos.put(string4, string5);
                continue;
            }
            if (string2.equals(CONNECTORLISTNAME)) {
                this.connector.put(string4, string5);
                continue;
            }
            if (!string2.equals(SPURLISTNAME)) continue;
            this.spur_match.put(string4, string5);
        }
    }

    private boolean pairwise_person_name_match(String string, String string2) {
        String string3;
        String string4;
        if (string.length() > string2.length()) {
            string4 = string;
            string3 = string2;
        } else {
            string4 = string2;
            string3 = string;
        }
        if (this.rules.get(0).value(string4, string3)) {
            return false;
        }
        if (string4.equals(string3) || this.rules.get(2).value(string4, string3) || this.rules.get(3).value(string4, string3)) {
            return true;
        }
        return this.rules.get(0).value(string4, string3);
    }

    private boolean basic_person_match_criteria(String string, String string2, boolean[] blArray) {
        return OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{1, 5, 6, 13, 15, 16}, string2, string, blArray);
    }

    private boolean apply_rules_namematch(String string, String string2, String string3, Annotation annotation, Annotation annotation2, boolean bl) {
        boolean[] blArray = new boolean[this.rules.size()];
        if (this.rules.get(0).value(string3, string2)) {
            return false;
        }
        if (OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{2, 3}, string3, string2, blArray) || (string.equals(this.organizationType) || string.equals("Facility")) && (!this.highPrecisionOrgs.booleanValue() && OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{4, 6, 7, 8, 9, 10, 11, 12, 14}, string3, string2, blArray) || this.highPrecisionOrgs.booleanValue() && OrthoMatcherHelper.executeDisjunction(this.rules, new int[]{7, 8, 10, 11, 17}, string3, string2, blArray))) {
            return true;
        }
        if (string.equals(this.personType)) {
            if (this.noMatchRule1(string3, string2, annotation, bl) || this.noMatchRule2(string3, string2)) {
                return false;
            }
            if (this.basic_person_match_criteria(string2, string3, blArray)) {
                if (string3.length() != string2.length() && (blArray[4] || blArray[5] || blArray[14] || blArray[15])) {
                    if (bl) {
                        annotation2.getFeatures().put("matchedWithLonger", true);
                    } else {
                        annotation.getFeatures().put("matchedWithLonger", true);
                    }
                } else if (string3.length() == string2.length() && blArray[1] && annotation.getFeatures().containsKey("matchedWithLonger")) {
                    annotation2.getFeatures().put("matchedWithLonger", true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void setExtLists(Boolean bl) {
        this.extLists = bl;
    }

    public void setCaseSensitive(Boolean bl) {
        this.caseSensitive = bl;
    }

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public void setAnnotationTypes(List list) {
        this.annotationTypes = list;
    }

    public void setProcessUnknown(Boolean bl) {
        this.matchingUnknowns = bl;
    }

    public void setOrganizationType(String string) {
        this.organizationType = string;
    }

    public void setPersonType(String string) {
        this.personType = string;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public List getAnnotationTypes() {
        return this.annotationTypes;
    }

    public String getOrganizationType() {
        return this.organizationType;
    }

    public String getPersonType() {
        return this.personType;
    }

    public Boolean getExtLists() {
        return new Boolean(this.extLists);
    }

    public Boolean getCaseSensitive() {
        return new Boolean(this.caseSensitive);
    }

    public Boolean getProcessUnknown() {
        return new Boolean(this.matchingUnknowns);
    }

    public boolean noMatchRule1(String string, String string2, Annotation annotation, boolean bl) {
        return !bl && annotation.getFeatures().containsKey("matchedWithLonger");
    }

    private boolean detectBadMiddleTokens(ArrayList<Annotation> arrayList) {
        for (int i = 1; i < arrayList.size() - 1; ++i) {
            String string = (String)arrayList.get(i).getFeatures().get("string");
            Matcher matcher = badMiddleTokens.matcher(string.toLowerCase().trim());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public boolean noMatchRule2(String string, String string2) {
        block4: {
            boolean bl;
            block6: {
                block5: {
                    if (this.normalizedTokensLongAnnot.size() <= 2 || this.normalizedTokensShortAnnot.size() <= 2) break block4;
                    bl = false;
                    if (this.normalizedTokensLongAnnot.size() == this.normalizedTokensShortAnnot.size()) break block5;
                    String string3 = (String)this.normalizedTokensLongAnnot.get(0).getFeatures().get("string");
                    String string4 = (String)this.normalizedTokensShortAnnot.get(0).getFeatures().get("string");
                    String string5 = (String)this.normalizedTokensLongAnnot.get(this.normalizedTokensLongAnnot.size() - 1).getFeatures().get("string");
                    String string6 = (String)this.normalizedTokensShortAnnot.get(this.normalizedTokensShortAnnot.size() - 1).getFeatures().get("string");
                    if (!this.rules.get(1).value(string3, string4) || !this.rules.get(1).value(string5, string6)) break block6;
                    if (this.detectBadMiddleTokens(this.tokensLongAnnot) || this.detectBadMiddleTokens(this.tokensShortAnnot)) {
                        return false;
                    }
                    bl = true;
                    break block6;
                }
                for (int i = 1; i < this.normalizedTokensLongAnnot.size() - 1; ++i) {
                    String string7 = (String)this.normalizedTokensLongAnnot.get(i).getFeatures().get("string");
                    String string8 = (String)this.normalizedTokensShortAnnot.get(i).getFeatures().get("string");
                    if (!this.caseSensitive) {
                        string7 = string7.toLowerCase();
                        string8 = string8.toLowerCase();
                    }
                    if (this.rules.get(1).value(string7, string8) || OrthoMatcherHelper.initialMatch(string7, string8)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl || log.isDebugEnabled()) {
                // empty if block
            }
            return bl;
        }
        return false;
    }

    public void setDefinitionFileURL(URL uRL) {
        this.definitionFileURL = uRL;
    }

    public URL getDefinitionFileURL() {
        return this.definitionFileURL;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Double getMinimumNicknameLikelihood() {
        return this.minimumNicknameLikelihood;
    }

    public void setMinimumNicknameLikelihood(Double d) {
        this.minimumNicknameLikelihood = d;
    }

    public Boolean getHighPrecisionOrgs() {
        return this.highPrecisionOrgs;
    }

    public void setHighPrecisionOrgs(Boolean bl) {
        this.highPrecisionOrgs = bl;
    }

    public void setOrthography(AnnotationOrthography annotationOrthography) {
        this.orthoAnnotation = annotationOrthography;
    }

    public AnnotationOrthography getOrthography() {
        return this.orthoAnnotation;
    }
}

