/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.morph;

import gate.creole.ResourceInstantiationException;
import gate.creole.morph.CharMap;
import gate.creole.morph.CharacterRange;
import gate.creole.morph.CharacterSet;
import gate.creole.morph.FSMState;
import gate.creole.morph.MorphFunctions;
import gate.creole.morph.ParsingFunctions;
import gate.creole.morph.PatternPart;
import gate.creole.morph.RHS;
import gate.creole.morph.ReadFile;
import gate.creole.morph.Storage;
import gate.creole.morph.StringSet;
import gate.creole.morph.Variable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class Interpret {
    private ReadFile file;
    private boolean isDefineVarSession;
    private boolean isDefineRulesSession;
    private Storage variables;
    private Method[] methods;
    private String affix;
    private Pattern vPat;
    private Pattern nPat;
    MorphFunctions morphInst;
    ArrayList patterns = new ArrayList();
    ArrayList fsms = new ArrayList();
    protected FSMState initialState;
    protected HashSet lastStates;
    protected int patternIndex = -1;
    protected boolean foundRule = false;

    public void init(URL uRL) throws ResourceInstantiationException {
        RHS.patIndex = 0;
        this.vPat = Pattern.compile("((VB)[DGNPZ]?)|(MD)");
        this.nPat = Pattern.compile("(NN)(S)*");
        this.variables = new Storage();
        this.prepareListOfMorphMethods();
        this.file = new ReadFile(uRL);
        this.affix = null;
        this.isDefineRulesSession = false;
        this.isDefineVarSession = false;
        this.morphInst = new MorphFunctions();
        this.readProgram();
        this.initialState = new FSMState(-1);
        this.lastStates = new HashSet();
        this.interpretProgram();
        this.variables = null;
        this.file = null;
        this.lastStates = null;
    }

    public void addState(char c, FSMState fSMState, int n) {
        if (n == this.fsms.size()) {
            this.fsms.add(new ArrayList());
        }
        ArrayList arrayList = (ArrayList)this.fsms.get(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            CharClass charClass = (CharClass)arrayList.get(i);
            if (charClass.ch != c) continue;
            return;
        }
        CharClass charClass = new CharClass();
        charClass.ch = c;
        charClass.st = fSMState;
        arrayList.add(charClass);
    }

    public FSMState getState(char c, int n) {
        if (n >= this.fsms.size()) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.fsms.get(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            CharClass charClass = (CharClass)arrayList.get(i);
            if (charClass.ch != c) continue;
            return charClass.st;
        }
        return null;
    }

    private HashSet getStates(char c, HashSet hashSet) {
        HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
        for (FSMState fSMState : hashSet) {
            FSMState fSMState2;
            FSMState fSMState3 = fSMState.next(c, (byte)0);
            if (fSMState3 != null) {
                hashSet2.add(fSMState3);
            }
            if ((fSMState2 = fSMState.next(c, (byte)1)) == null) continue;
            hashSet2.add(fSMState2);
        }
        return hashSet2;
    }

    private boolean validCategory(String string) {
        if (string.equals("*")) {
            return true;
        }
        if (this.vPat.matcher(string).matches()) {
            return true;
        }
        return this.nPat.matcher(string).matches();
    }

    public String runMorpher(String string, String string2) {
        this.affix = null;
        if (!this.validCategory(string2)) {
            return string;
        }
        this.foundRule = false;
        HashSet hashSet = new HashSet();
        hashSet.add(this.initialState);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            hashSet = this.getStates(c, hashSet);
            if (!hashSet.isEmpty()) continue;
            return string;
        }
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                RHS rHS = (RHS)object;
                RHS rHS2 = (RHS)object2;
                return rHS.getPatternIndex() - rHS2.getPatternIndex();
            }
        });
        for (FSMState fSMState : hashSet) {
            treeSet.addAll(fSMState.getRHSes());
        }
        if (treeSet.isEmpty()) {
            return string;
        }
        return this.executeRHSes(treeSet, string, string2);
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }

    protected String executeRHSes(TreeSet treeSet, String string, String string2) {
        this.foundRule = false;
        for (RHS rHS : treeSet) {
            String string3 = this.executeRHS(string, string2, rHS);
            if (!this.foundRule) continue;
            this.patternIndex = rHS.getPatternIndex();
            return string3;
        }
        return string;
    }

    protected String executeRHS(String string, String string2, RHS rHS) {
        if (string2.equals("*")) {
            return this.executeRule(string, rHS);
        }
        if (rHS.isVerb() && this.vPat.matcher(string2).matches()) {
            return this.executeRule(string, rHS);
        }
        if (rHS.isNoun() && this.nPat.matcher(string2).matches()) {
            return this.executeRule(string, rHS);
        }
        return string;
    }

    private String executeRule(String string, RHS rHS) {
        Pattern pattern = (Pattern)this.patterns.get(rHS.getPatternIndex());
        short s = rHS.getMethodIndex();
        if (!pattern.matcher(string).matches()) {
            this.foundRule = false;
            return string;
        }
        String[] stringArray = rHS.getParameters();
        this.morphInst.setInput(string);
        String string2 = null;
        switch (s) {
            case 0: {
                string2 = this.morphInst.irreg_stem(stringArray[0], stringArray[1]);
                break;
            }
            case 1: {
                string2 = this.morphInst.null_stem();
                break;
            }
            case 2: {
                string2 = this.morphInst.semi_reg_stem(Integer.parseInt(stringArray[0]), stringArray[1]);
                break;
            }
            case 3: {
                string2 = this.morphInst.stem(Integer.parseInt(stringArray[0]), stringArray[1], stringArray[2]);
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            this.affix = this.morphInst.getAffix();
            this.foundRule = true;
            return string2;
        }
        this.foundRule = false;
        return string;
    }

    private void prepareListOfMorphMethods() throws ResourceInstantiationException {
        this.methods = MorphFunctions.class.getDeclaredMethods();
    }

    private void readProgram() throws ResourceInstantiationException {
        boolean bl = this.file.read();
        if (!bl) {
            this.generateError("Some errors reading program file.. please check theprogram and try again");
        }
    }

    private void interpretProgram() throws ResourceInstantiationException {
        block7: while (this.file.hasNext()) {
            String string = this.file.getNext();
            if (string == null || string.trim().length() == 0) continue;
            string = string.trim();
            int n = this.findCommandType(string);
            switch (n) {
                case -1: {
                    continue block7;
                }
                case 0: {
                    this.defineVarsCommand();
                    continue block7;
                }
                case 1: {
                    this.defineRulesCommand();
                    continue block7;
                }
                case 2: {
                    this.variableDeclarationCommand(string);
                    continue block7;
                }
                case 3: {
                    this.ruleDeclarationCommand(string);
                    continue block7;
                }
            }
            this.generateError("Syntax Error at line " + this.file.getPointer() + " : " + string);
        }
    }

    private int findCommandType(String string) {
        if (string.substring(0, 2).equals("//") || string.charAt(0) == '#') {
            return -1;
        }
        if (string.equals("defineVars")) {
            return 0;
        }
        if (string.equals("defineRules")) {
            return 1;
        }
        if (this.isDefineVarSession && string.split("==>").length == 2) {
            return 2;
        }
        if (this.isDefineRulesSession && string.charAt(0) == '<' && string.split("==>").length == 2) {
            return 3;
        }
        return -4;
    }

    private void defineVarsCommand() throws ResourceInstantiationException {
        if (this.isDefineVarSession) {
            this.generateError("Variable Section already defined - see line " + this.file.getPointer());
        } else if (this.isDefineRulesSession) {
            this.generateError("Variable section must be declared before the Rule Section - see line " + this.file.getPointer());
        } else {
            this.isDefineVarSession = true;
        }
    }

    private void defineRulesCommand() throws ResourceInstantiationException {
        if (this.isDefineRulesSession) {
            this.generateError("Rule Section already defined - see line " + this.file.getPointer());
        } else {
            this.isDefineVarSession = false;
            this.isDefineRulesSession = true;
        }
    }

    private void variableDeclarationCommand(String string) throws ResourceInstantiationException {
        String string2 = string.split("==>")[0].trim();
        String string3 = string.split("==>")[1].trim();
        int n = ParsingFunctions.findVariableType(string3.trim());
        if (n == -4) {
            this.generateError(string2 + " - Variable Syntax Error - see " + "line" + this.file.getPointer() + " : " + string);
        }
        Variable variable = null;
        switch (n) {
            case 1: {
                variable = new CharacterRange();
                break;
            }
            case 2: {
                variable = new CharacterSet();
                break;
            }
            case 0: {
                variable = new StringSet();
            }
        }
        if (!variable.set(string2, string3)) {
            this.generateError(string2 + " - Syntax Error while assigning value to the " + "variable - see line" + this.file.getPointer() + " : " + string);
        }
        if (!this.variables.add(string2, variable.getPattern())) {
            this.generateError(string2.trim() + " - Variable already defined - see " + "line " + this.file.getPointer() + " : " + string);
        }
        variable.resetPointer();
    }

    private void ruleDeclarationCommand(String string) throws ResourceInstantiationException {
        int n;
        String string2;
        String[] stringArray = string.split("==>");
        if (stringArray.length != 2) {
            this.generateError("Error in declaring rule at line : " + this.file.getPointer() + " : " + string);
        }
        if (!this.isMethodAvailable(string2 = stringArray[1].trim())) {
            this.generateError("Syntax error - method does not exists - see line " + this.file.getPointer() + " : " + string);
        }
        String string3 = "";
        for (n = 1; n < stringArray[0].length() && stringArray[0].charAt(n) != '>'; ++n) {
            string3 = string3 + stringArray[0].charAt(n);
        }
        if (n >= stringArray[0].length()) {
            this.generateError("Syntax error - pattern not written properly - see line " + this.file.getPointer() + " : " + string);
        }
        RHS rHS = new RHS(stringArray[1], string3);
        stringArray[0] = stringArray[0].substring(n + 1, stringArray[0].length()).trim();
        String string4 = ParsingFunctions.convertToRegExp(stringArray[0], this.variables);
        this.patterns.add(Pattern.compile(string4));
        String[] stringArray2 = ParsingFunctions.normlizePattern(string4);
        for (int i = 0; i < stringArray2.length; ++i) {
            HashSet hashSet = new HashSet();
            hashSet.clear();
            HashSet<FSMState> hashSet2 = new HashSet<FSMState>();
            hashSet2.add(this.initialState);
            hashSet.add(hashSet2);
            PatternPart[] patternPartArray = ParsingFunctions.getPatternParts(stringArray2[i].trim());
            for (int j = 0; j < patternPartArray.length; ++j) {
                hashSet = ParsingFunctions.createFSMs(patternPartArray[j].getPartString(), patternPartArray[j].getType(), hashSet, this);
            }
            for (HashSet hashSet3 : hashSet) {
                for (FSMState fSMState : hashSet3) {
                    fSMState.addRHS(rHS);
                }
            }
        }
    }

    private HashSet intersect(HashSet hashSet, HashSet hashSet2) {
        HashSet<FSMState> hashSet3 = new HashSet<FSMState>();
        for (FSMState fSMState : hashSet) {
            if (!hashSet2.contains(fSMState)) continue;
            hashSet3.add(fSMState);
        }
        return hashSet3;
    }

    private void drawFSM() {
        System.out.println("Initial:");
        String string = "";
        this.drawFSM(this.initialState, string);
    }

    private void drawFSM(FSMState fSMState, String string) {
        int n;
        CharMap charMap = fSMState.getTransitionFunction();
        char[] cArray = charMap.getItemsKeys();
        if (cArray != null) {
            System.out.println(string + "Child:");
            for (n = 0; n < cArray.length; ++n) {
                System.out.println(string + "'" + cArray[n] + "':");
                this.drawFSM(charMap.get(cArray[n], (byte)0), string + "  ");
            }
        }
        if ((cArray = charMap.getAdjitemsKeys()) != null) {
            System.out.println("ADJ:");
            for (n = 0; n < cArray.length; ++n) {
                System.out.println(string + "'" + cArray[n] + "' :");
            }
        }
    }

    private boolean isMethodAvailable(String string) {
        int n;
        int[] nArray;
        String[] stringArray;
        int n2 = string.indexOf("(");
        if (n2 == -1 || n2 == 0 || string.charAt(string.length() - 1) != ')') {
            return false;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1, string.length() - 1);
        if (string3 == null || string3.trim().length() == 0) {
            stringArray = null;
            nArray = null;
        } else {
            stringArray = string.substring(n2 + 1, string.length() - 1).split(",");
            nArray = new int[stringArray.length];
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].startsWith("\"") && stringArray[n].endsWith("\"")) {
                    nArray[n] = 7;
                    stringArray[n] = "java.lang.String";
                    continue;
                }
                if (ParsingFunctions.isBoolean(stringArray[n])) {
                    nArray[n] = 6;
                    stringArray[n] = "boolean";
                    continue;
                }
                if (ParsingFunctions.isInteger(stringArray[n])) {
                    nArray[n] = 2;
                    stringArray[n] = "int";
                    continue;
                }
                return false;
            }
        }
        for (n = 0; n < this.methods.length; ++n) {
            if (!this.methods[n].getName().equals(string2)) continue;
            Class<?>[] classArray = this.methods[n].getParameterTypes();
            if (this.methods[n].getName().equals("null_stem")) {
                return true;
            }
            if (classArray.length != stringArray.length) continue;
            int[] nArray2 = new int[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getName().equals("java.lang.String")) {
                    nArray2[i] = 7;
                    continue;
                }
                if (classArray[i].getName().equals("boolean")) {
                    nArray2[i] = 6;
                    continue;
                }
                if (classArray[i].getName().equals("int")) {
                    nArray2[i] = 2;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void generateError(String string) throws ResourceInstantiationException {
        System.out.println("\n\n" + string);
        System.out.println("Program terminated...");
        throw new ResourceInstantiationException("\n\n" + string);
    }

    public static void main(String[] stringArray) throws ResourceInstantiationException {
        if (stringArray == null || stringArray.length < 3) {
            System.out.println("Usage : Interpret <Rules fileName> <word> <POS>");
            System.exit(-1);
        }
        Interpret interpret = new Interpret();
        try {
            interpret.init(new URL(stringArray[0]));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        String string = interpret.runMorpher(stringArray[1], stringArray[2]);
        String string2 = interpret.getAffix();
        System.out.println("Root : " + string);
        System.out.println("affix : " + string2);
    }

    public String getAffix() {
        return this.affix;
    }

    public FSMState getInitialState() {
        return this.initialState;
    }

    class CharClass {
        char ch;
        FSMState st;

        CharClass() {
        }
    }
}

