/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ir.lucene;

import gate.creole.ir.IndexException;
import gate.creole.ir.IndexedCorpus;
import gate.creole.ir.QueryResult;
import gate.creole.ir.QueryResultList;
import gate.creole.ir.Search;
import gate.creole.ir.SearchException;
import gate.creole.ir.Term;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class LuceneSearch
implements Search {
    private static int DEFAULTMAXRESULTS = 1000000;
    private IndexedCorpus indexedCorpus;

    public void setCorpus(IndexedCorpus indexedCorpus) {
        this.indexedCorpus = indexedCorpus;
    }

    public QueryResultList search(String string) throws IndexException, SearchException {
        return this.search(string, DEFAULTMAXRESULTS);
    }

    public QueryResultList search(String string, int n) throws IndexException, SearchException {
        return this.search(string, n, null);
    }

    public QueryResultList search(String string, List list) throws IndexException, SearchException {
        return this.search(string, DEFAULTMAXRESULTS, list);
    }

    public QueryResultList search(String string, int n, List list) throws IndexException, SearchException {
        Vector<QueryResult> vector = new Vector<QueryResult>();
        try {
            IndexSearcher indexSearcher = new IndexSearcher((Directory)FSDirectory.open((File)new File(this.indexedCorpus.getIndexDefinition().getIndexLocation())), true);
            QueryParser queryParser = new QueryParser(Version.LUCENE_29, "body", (Analyzer)new SimpleAnalyzer());
            Query query = queryParser.parse(string);
            TopDocs topDocs = indexSearcher.search(query, n);
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            int n2 = scoreDocArray.length;
            Vector<Term> vector2 = null;
            for (int i = 0; i < n2; ++i) {
                if (list != null) {
                    vector2 = new Vector<Term>();
                    for (int j = 0; j < list.size(); ++j) {
                        vector2.add(new Term(list.get(j).toString(), indexSearcher.doc(scoreDocArray[i].doc).get(list.get(j).toString())));
                    }
                }
                vector.add(new QueryResult(indexSearcher.doc(scoreDocArray[i].doc).get("DOCUMENT_ID"), scoreDocArray[i].score, vector2));
            }
            indexSearcher.close();
            return new QueryResultList(string, this.indexedCorpus, vector);
        }
        catch (IOException iOException) {
            throw new IndexException(iOException.getMessage());
        }
        catch (ParseException parseException) {
            throw new SearchException(parseException.getMessage());
        }
    }
}

