/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.store.InputStream;
import java.io.IOException;

final class SegmentTermEnum
extends TermEnum
implements Cloneable {
    private InputStream input;
    FieldInfos fieldInfos;
    long size;
    long position = -1L;
    private Term term = new Term("", "", "");
    private TermInfo termInfo = new TermInfo();
    private int format;
    private boolean isIndex = false;
    long indexPointer = 0L;
    int indexInterval;
    int skipInterval;
    private int formatM1SkipInterval;
    Term prev;
    private char[] buffer = new char[0];

    SegmentTermEnum(InputStream inputStream, FieldInfos fieldInfos, boolean bl) throws IOException {
        this.input = inputStream;
        this.fieldInfos = fieldInfos;
        this.isIndex = bl;
        int n = this.input.readInt();
        if (n >= 0) {
            this.format = 0;
            this.size = n;
            this.indexInterval = 128;
            this.skipInterval = Integer.MAX_VALUE;
        } else {
            this.format = n;
            if (this.format < -2) {
                throw new IOException("Unknown format version:" + this.format);
            }
            this.size = this.input.readLong();
            if (this.format == -1) {
                if (!this.isIndex) {
                    this.indexInterval = this.input.readInt();
                    this.formatM1SkipInterval = this.input.readInt();
                }
                this.skipInterval = Integer.MAX_VALUE;
            } else {
                this.indexInterval = this.input.readInt();
                this.skipInterval = this.input.readInt();
            }
        }
    }

    protected Object clone() {
        SegmentTermEnum segmentTermEnum = null;
        try {
            segmentTermEnum = (SegmentTermEnum)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        segmentTermEnum.input = (InputStream)this.input.clone();
        segmentTermEnum.termInfo = new TermInfo(this.termInfo);
        if (this.term != null) {
            segmentTermEnum.growBuffer(this.term.text.length());
        }
        return segmentTermEnum;
    }

    final void seek(long l, int n, Term term, TermInfo termInfo) throws IOException {
        this.input.seek(l);
        this.position = n;
        this.term = term;
        this.prev = null;
        this.termInfo.set(termInfo);
        this.growBuffer(this.term.text.length());
    }

    public final boolean next() throws IOException {
        if (this.position++ >= this.size - 1L) {
            this.term = null;
            return false;
        }
        this.prev = this.term;
        this.term = this.readTerm();
        this.termInfo.docFreq = this.input.readVInt();
        this.termInfo.freqPointer += this.input.readVLong();
        this.termInfo.proxPointer += this.input.readVLong();
        if (this.format == -1) {
            if (!this.isIndex && this.termInfo.docFreq > this.formatM1SkipInterval) {
                this.termInfo.skipOffset = this.input.readVInt();
            }
        } else if (this.termInfo.docFreq >= this.skipInterval) {
            this.termInfo.skipOffset = this.input.readVInt();
        }
        if (this.isIndex) {
            this.indexPointer += this.input.readVLong();
        }
        return true;
    }

    private final Term readTerm() throws IOException {
        int n = this.input.readVInt();
        if (this.buffer.length < n) {
            this.growBuffer(n);
        }
        this.input.readChars(this.buffer, 0, n);
        String string = new String(this.buffer, 0, n);
        int n2 = this.input.readVInt();
        if (this.buffer.length < n2) {
            this.growBuffer(n2);
        }
        this.input.readChars(this.buffer, 0, n2);
        int n3 = this.input.readVInt();
        return new Term(this.fieldInfos.fieldName(n3), string, new String(this.buffer, 0, n2), false);
    }

    private final void growBuffer(int n) {
        this.buffer = new char[n];
        for (int i = 0; i < this.term.text.length(); ++i) {
            this.buffer[i] = this.term.text.charAt(i);
        }
    }

    public final Term term() {
        return this.term;
    }

    final TermInfo termInfo() {
        return new TermInfo(this.termInfo);
    }

    final void termInfo(TermInfo termInfo) {
        termInfo.set(this.termInfo);
    }

    public final int docFreq() {
        return this.termInfo.docFreq;
    }

    final long freqPointer() {
        return this.termInfo.freqPointer;
    }

    final long proxPointer() {
        return this.termInfo.proxPointer;
    }

    public final void close() throws IOException {
        this.input.close();
    }
}

