/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermPositions;
import java.io.IOException;

final class SegmentMergeInfo {
    Term term;
    int base;
    TermEnum termEnum;
    IndexReader reader;
    TermPositions postings;
    int[] docMap = null;

    SegmentMergeInfo(int n, TermEnum termEnum, IndexReader indexReader) throws IOException {
        this.base = n;
        this.reader = indexReader;
        this.termEnum = termEnum;
        this.term = termEnum.term();
        this.postings = this.reader.termPositions();
        if (this.reader.hasDeletions()) {
            int n2 = this.reader.maxDoc();
            this.docMap = new int[n2];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                this.docMap[i] = this.reader.isDeleted(i) ? -1 : n3++;
            }
        }
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        this.termEnum.close();
        this.postings.close();
    }
}

