/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Gate;
import gate.creole.CreoleAnnotationHandler;
import gate.util.GateException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestCreoleAnnotationHandler
extends TestCase {
    private SAXBuilder jdomBuilder = new SAXBuilder();
    private DOMOutputter jdom2dom = new DOMOutputter();
    private DocumentBuilderFactory jaxpFactory = DocumentBuilderFactory.newInstance();

    public TestCreoleAnnotationHandler(String string) throws GateException {
        super(string);
    }

    public void setUp() throws Exception {
        Gate.init();
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
    }

    public void testCreoleAnnotationHandler() throws Exception {
        URL uRL = Gate.getUrl("tests/creole-annotation-handler/initial-creole.xml");
        Document document = this.jdomBuilder.build(uRL.openStream());
        CreoleAnnotationHandler creoleAnnotationHandler = new CreoleAnnotationHandler(uRL);
        creoleAnnotationHandler.processAnnotations(document);
        URL uRL2 = Gate.getUrl("tests/creole-annotation-handler/expected-creole.xml");
        DocumentBuilder documentBuilder = this.jaxpFactory.newDocumentBuilder();
        org.w3c.dom.Document document2 = documentBuilder.parse(uRL2.openStream());
        org.w3c.dom.Document document3 = this.jdom2dom.output(document);
        Diff diff = XMLUnit.compareXML((org.w3c.dom.Document)document2, (org.w3c.dom.Document)document3);
        diff.overrideElementQualifier((ElementQualifier)new ElementNameQualifier(){

            public boolean qualifyForComparison(Element element, Element element2) {
                if ("PARAMETER".equals(element.getTagName()) && "PARAMETER".equals(element2.getTagName())) {
                    return element.getAttribute("NAME").equals(element2.getAttribute("NAME"));
                }
                if ("RESOURCE".equals(element.getTagName()) && "RESOURCE".equals(element2.getTagName())) {
                    String string = this.findClass(element);
                    String string2 = this.findClass(element2);
                    return string == null ? string2 == null : string.equals(string2);
                }
                return super.qualifyForComparison(element, element2);
            }

            private String findClass(Element element) {
                Node node;
                for (node = element.getFirstChild(); node != null && !"CLASS".equals(node.getNodeName()); node = node.getNextSibling()) {
                }
                if (node != null) {
                    return node.getTextContent();
                }
                return null;
            }
        });
        boolean bl = diff.similar();
        if (!bl) {
            new XMLOutputter(Format.getPrettyFormat()).output(document, (OutputStream)System.err);
        }
        TestCreoleAnnotationHandler.assertTrue((String)("XML produced by annotation handler does not match expected: " + diff), (boolean)bl);
    }

    public static Test suite() {
        return new TestSuite(TestCreoleAnnotationHandler.class);
    }
}

